/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.common.impl.krms;

import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.coeus.common.framework.krms.KcKrmsFactBuilderService;
import org.kuali.coeus.sys.api.model.ScaleTwoDecimal;
import org.kuali.coeus.sys.framework.service.KcServiceLocator;
import org.kuali.rice.core.api.exception.RiceRuntimeException;
import org.kuali.rice.core.api.util.xml.XmlHelper;
import org.kuali.rice.kew.rule.xmlrouting.XPathHelper;
import org.kuali.rice.krms.api.engine.Facts;
import org.kuali.rice.krms.api.repository.category.CategoryDefinition;
import org.kuali.rice.krms.api.repository.term.TermRepositoryService;
import org.kuali.rice.krms.api.repository.term.TermSpecificationDefinition;
import org.w3c.dom.Document;

public abstract class KcKrmsFactBuilderServiceHelper
implements KcKrmsFactBuilderService {
    protected final Logger LOG = LogManager.getLogger(KcKrmsFactBuilderServiceHelper.class);

    protected String getElementValue(String docContent, String xpathExpression) {
        try {
            Document document = XmlHelper.trimXml((InputStream)new ByteArrayInputStream(docContent.getBytes()));
            XPath xpath = XPathHelper.newXPath();
            String value = (String)xpath.evaluate(xpathExpression, document, XPathConstants.STRING);
            return value;
        }
        catch (Exception e) {
            throw new RiceRuntimeException((Throwable)e);
        }
    }

    public void addObjectMembersAsFacts(Facts.Builder factsBuilder, Object factsObject, String contextId, String factTermNS) {
        TermRepositoryService termRepositoryService = (TermRepositoryService)KcServiceLocator.getService("termRepositoryService");
        List termSpecs = termRepositoryService.findAllTermSpecificationsByContextId(contextId);
        for (TermSpecificationDefinition termSpecificationDefinition : termSpecs) {
            String termNS;
            if (!this.isPropertyType(termSpecificationDefinition) || !(termNS = termSpecificationDefinition.getNamespace()).equals(factTermNS)) continue;
            String factKey = termSpecificationDefinition.getName();
            if (factsObject != null) {
                Class<?> factsClazz = factsObject.getClass();
                PropertyDescriptor propDescriptor = null;
                try {
                    propDescriptor = PropertyUtils.getPropertyDescriptor((Object)factsObject, (String)factKey);
                    if (propDescriptor == null) continue;
                    Object propertyValue = null;
                    Method readMethod = propDescriptor.getReadMethod();
                    if (readMethod != null) {
                        propertyValue = propDescriptor.getReadMethod().invoke(factsObject, new Object[0]);
                    }
                    if (propertyValue != null && propertyValue.getClass().isAssignableFrom(ScaleTwoDecimal.class)) {
                        propertyValue = ((ScaleTwoDecimal)propertyValue).bigDecimalValue();
                    }
                    factsBuilder.addFact(factKey, propertyValue);
                }
                catch (IllegalArgumentException e) {
                    this.LOG.error("KRMS Fact for " + factKey + " has not been added to fact builder", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    this.LOG.error("KRMS Fact for " + factKey + " has not been added to fact builder", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    this.LOG.error("KRMS Fact for " + factKey + " has not been added to fact builder", (Throwable)e);
                }
                catch (NoSuchMethodException e) {
                    this.LOG.error("KRMS Fact for " + factKey + " has not been added to fact builder", (Throwable)e);
                }
                continue;
            }
            factsBuilder.addFact(factKey, null);
        }
    }

    private boolean isPropertyType(TermSpecificationDefinition termSpecificationDefinition) {
        List catgories = termSpecificationDefinition.getCategories();
        for (CategoryDefinition categoryDefinition : catgories) {
            if (!categoryDefinition.getName().equals("Property")) continue;
            return true;
        }
        return false;
    }
}

