/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.rice.core.api.reflect.DataDefinition;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.util.ClassLoaderUtils;
import org.kuali.rice.core.framework.resourceloader.ObjectDefinitionResolver;
import org.kuali.rice.kew.actionrequest.ActionRequestValue;
import org.kuali.rice.kew.actions.AcknowledgeAction;
import org.kuali.rice.kew.actions.ActionRegistry;
import org.kuali.rice.kew.actions.ActionTakenEvent;
import org.kuali.rice.kew.actions.AdHocAction;
import org.kuali.rice.kew.actions.ApproveAction;
import org.kuali.rice.kew.actions.BlanketApproveAction;
import org.kuali.rice.kew.actions.CancelAction;
import org.kuali.rice.kew.actions.ClearFYIAction;
import org.kuali.rice.kew.actions.CompleteAction;
import org.kuali.rice.kew.actions.DisapproveAction;
import org.kuali.rice.kew.actions.LogDocumentActionAction;
import org.kuali.rice.kew.actions.MoveDocumentAction;
import org.kuali.rice.kew.actions.RecallAction;
import org.kuali.rice.kew.actions.ReleaseWorkgroupAuthority;
import org.kuali.rice.kew.actions.ReturnToPreviousNodeAction;
import org.kuali.rice.kew.actions.RevokeAdHocAction;
import org.kuali.rice.kew.actions.RouteDocumentAction;
import org.kuali.rice.kew.actions.SaveActionEvent;
import org.kuali.rice.kew.actions.SuperUserActionRequestApproveEvent;
import org.kuali.rice.kew.actions.SuperUserApproveEvent;
import org.kuali.rice.kew.actions.SuperUserCancelEvent;
import org.kuali.rice.kew.actions.SuperUserDisapproveEvent;
import org.kuali.rice.kew.actions.SuperUserNodeApproveEvent;
import org.kuali.rice.kew.actions.SuperUserReturnToPreviousNodeAction;
import org.kuali.rice.kew.actions.TakeWorkgroupAuthority;
import org.kuali.rice.kew.api.WorkflowRuntimeException;
import org.kuali.rice.kew.api.action.ActionRequestStatus;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.action.ValidActions;
import org.kuali.rice.kew.api.exception.ResourceUnavailableException;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kim.api.identity.principal.PrincipalContract;

public class ActionRegistryImpl
implements ActionRegistry {
    private static final Logger LOG = LogManager.getLogger(ActionRegistryImpl.class);
    private static Map<String, String> actionMap = new HashMap<String, String>();

    @Override
    public void registerAction(String actionCode, String actionClass) {
        if (actionClass == null) {
            throw new IllegalArgumentException("Action Code '" + actionCode + "' cannot be registered with a null action class.");
        }
        if (actionMap.containsKey(actionCode)) {
            throw new WorkflowRuntimeException("Action Code is already in use.  [" + actionCode + ", " + actionClass + "].  Please unregister the existing implementation first.");
        }
        actionMap.put(actionCode, actionClass);
    }

    @Override
    public void unregisterAction(String actionCode) {
        actionMap.remove(actionCode);
    }

    @Override
    public Map getActionMap() {
        return Collections.unmodifiableMap(actionMap);
    }

    @Override
    public ActionTakenEvent createAction(String actionCode, List<DataDefinition> parameters) throws ResourceUnavailableException {
        String actionClassName = actionMap.get(actionCode);
        if (actionClassName == null) {
            throw new IllegalArgumentException("No action has been registered for the given action code of '" + actionCode + "'.");
        }
        ObjectDefinition actionDefinition = new ObjectDefinition(actionClassName);
        if (parameters != null && !parameters.isEmpty()) {
            actionDefinition.setConstructorParameters(parameters);
        }
        try {
            ActionTakenEvent actionTaken = (ActionTakenEvent)ObjectDefinitionResolver.createObject((ObjectDefinition)actionDefinition, (ClassLoader)ClassLoaderUtils.getDefaultClassLoader(), (boolean)false);
            if (actionTaken == null) {
                throw new ResourceUnavailableException("Could not locate action taken class '" + actionClassName + "'");
            }
            return actionTaken;
        }
        catch (Exception e) {
            LOG.debug("createAction() Exception thrown while working with action class name '" + actionClassName + "'");
            if (e instanceof ResourceUnavailableException) {
                throw (ResourceUnavailableException)e;
            }
            throw new ResourceUnavailableException((Throwable)e);
        }
    }

    @Override
    public ValidActions getValidActions(PrincipalContract principal, DocumentRouteHeaderValue document) {
        try {
            ValidActions.Builder builder = ValidActions.Builder.create();
            ArrayList<ActionRequestValue> activeRequests = new ArrayList<ActionRequestValue>();
            for (ActionRequestValue ar : document.getActionRequests()) {
                if (ar.getCurrentIndicator() == null || !ar.getCurrentIndicator().booleanValue() || !StringUtils.equals((String)ar.getStatus(), (String)ActionRequestStatus.ACTIVATED.getCode())) continue;
                activeRequests.add(ar);
            }
            for (String actionTakenCode : actionMap.keySet()) {
                ArrayList<DataDefinition> parameters = new ArrayList<DataDefinition>();
                parameters.add(new DataDefinition((Object)document));
                parameters.add(new DataDefinition((Object)principal));
                ActionTakenEvent actionEvent = this.createAction(actionTakenCode, parameters);
                if (!StringUtils.isEmpty((String)actionEvent.validateActionRules(activeRequests))) continue;
                builder.addValidAction(ActionType.fromCode((String)actionTakenCode));
            }
            return builder.build();
        }
        catch (ResourceUnavailableException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isValidAction(String actionTypeCode, PrincipalContract principal, DocumentRouteHeaderValue document) {
        boolean validAction = false;
        try {
            ArrayList<ActionRequestValue> activeRequests = new ArrayList<ActionRequestValue>();
            for (ActionRequestValue ar : document.getActionRequests()) {
                if (ar.getCurrentIndicator() == null || !ar.getCurrentIndicator().booleanValue() || !StringUtils.equals((String)ar.getStatus(), (String)ActionRequestStatus.ACTIVATED.getCode())) continue;
                activeRequests.add(ar);
            }
            ArrayList<DataDefinition> parameters = new ArrayList<DataDefinition>();
            parameters.add(new DataDefinition((Object)document));
            parameters.add(new DataDefinition((Object)principal));
            ActionTakenEvent actionEvent = this.createAction(actionTypeCode, parameters);
            if (StringUtils.isEmpty((String)actionEvent.validateActionRules(activeRequests))) {
                validAction = true;
            }
        }
        catch (ResourceUnavailableException e) {
            throw new WorkflowRuntimeException((Throwable)e);
        }
        return validAction;
    }

    static {
        actionMap.put("K", AcknowledgeAction.class.getName());
        actionMap.put("H", AdHocAction.class.getName());
        actionMap.put("V", RevokeAdHocAction.class.getName());
        actionMap.put("A", ApproveAction.class.getName());
        actionMap.put("B", BlanketApproveAction.class.getName());
        actionMap.put("X", CancelAction.class.getName());
        actionMap.put("C", CompleteAction.class.getName());
        actionMap.put("O", RouteDocumentAction.class.getName());
        actionMap.put("D", DisapproveAction.class.getName());
        actionMap.put("F", ClearFYIAction.class.getName());
        actionMap.put("R", LogDocumentActionAction.class.getName());
        actionMap.put("M", MoveDocumentAction.class.getName());
        actionMap.put("w", TakeWorkgroupAuthority.class.getName());
        actionMap.put("y", ReleaseWorkgroupAuthority.class.getName());
        actionMap.put("Z", ReturnToPreviousNodeAction.class.getName());
        actionMap.put("S", SaveActionEvent.class.getName());
        actionMap.put("v", SuperUserActionRequestApproveEvent.class.getName());
        actionMap.put("a", SuperUserApproveEvent.class.getName());
        actionMap.put("c", SuperUserCancelEvent.class.getName());
        actionMap.put("d", SuperUserDisapproveEvent.class.getName());
        actionMap.put("z", SuperUserReturnToPreviousNodeAction.class.getName());
        actionMap.put("r", SuperUserNodeApproveEvent.class.getName());
        actionMap.put(ActionType.RECALL.getCode(), RecallAction.class.getName());
    }
}

