/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.location.impl.county;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.criteria.QueryResults;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.krad.data.CompoundKey;
import org.kuali.rice.krad.data.DataObjectService;
import org.kuali.rice.location.api.county.County;
import org.kuali.rice.location.api.county.CountyContract;
import org.kuali.rice.location.api.county.CountyQueryResults;
import org.kuali.rice.location.api.county.CountyService;
import org.kuali.rice.location.impl.county.CountyBo;
import org.springframework.beans.factory.annotation.Required;

public class CountyServiceImpl
implements CountyService {
    private DataObjectService dataObjectService;

    public County getCounty(String countryCode, String stateCode, String code) {
        if (StringUtils.isBlank((String)countryCode)) {
            throw new RiceIllegalArgumentException("countryCode is null");
        }
        if (StringUtils.isBlank((String)code)) {
            throw new RiceIllegalArgumentException("code is null");
        }
        if (StringUtils.isBlank((String)stateCode)) {
            throw new RiceIllegalArgumentException("stateCode is null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("countryCode", countryCode);
        map.put("stateCode", stateCode);
        map.put("code", code);
        return CountyBo.to((CountyBo)((Object)this.getDataObjectService().find(CountyBo.class, (Object)new CompoundKey(map))));
    }

    public List<County> findAllCountiesInCountryAndState(String countryCode, String stateCode) {
        if (StringUtils.isBlank((String)countryCode)) {
            throw new RiceIllegalArgumentException("countryCode is null");
        }
        if (StringUtils.isBlank((String)stateCode)) {
            throw new RiceIllegalArgumentException("stateCode is null");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("countryCode", countryCode);
        map.put("stateCode", stateCode);
        map.put("active", Boolean.TRUE);
        QueryResults countyBos = this.getDataObjectService().findMatching(CountyBo.class, QueryByCriteria.Builder.andAttributes(map).build());
        if (countyBos == null) {
            return Collections.emptyList();
        }
        ArrayList<County> toReturn = new ArrayList<County>();
        List countyBoList = countyBos.getResults();
        for (CountyBo countyBo : countyBoList) {
            if (countyBo == null || !countyBo.isActive()) continue;
            toReturn.add(CountyBo.to(countyBo));
        }
        return Collections.unmodifiableList(toReturn);
    }

    public CountyQueryResults findCounties(QueryByCriteria queryByCriteria) throws RiceIllegalArgumentException {
        this.incomingParamCheck(queryByCriteria, "queryByCriteria");
        QueryResults results = this.getDataObjectService().findMatching(CountyBo.class, queryByCriteria);
        CountyQueryResults.Builder builder = CountyQueryResults.Builder.create();
        builder.setMoreResultsAvailable(results.isMoreResultsAvailable());
        builder.setTotalRowCount(results.getTotalRowCount());
        ArrayList<County.Builder> ims = new ArrayList<County.Builder>();
        for (CountyBo bo : results.getResults()) {
            ims.add(County.Builder.create((CountyContract)bo));
        }
        builder.setResults(ims);
        return builder.build();
    }

    private void incomingParamCheck(Object object, String name) {
        if (object == null) {
            throw new RiceIllegalArgumentException(name + " was null");
        }
        if (object instanceof String && StringUtils.isBlank((String)((String)object))) {
            throw new RiceIllegalArgumentException(name + " was blank");
        }
    }

    public DataObjectService getDataObjectService() {
        return this.dataObjectService;
    }

    @Required
    public void setDataObjectService(DataObjectService dataObjectService) {
        this.dataObjectService = dataObjectService;
    }
}

