/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.coeus.propdev.impl.s2s.map;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.kuali.coeus.propdev.impl.s2s.map.Address;
import org.kuali.coeus.propdev.impl.s2s.map.PersonName;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"name", "address", "email", "phoneNumber", "faxNumber", "signature", "title", "nsfId", "submittedDate"})
public class KeyPerson {
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="The name of a person.")
    private PersonName name;
    @JsonProperty(value="address")
    @JsonPropertyDescription(value="An address object as used by Grants.gov.")
    private Address address;
    @JsonProperty(value="email")
    @JsonPropertyDescription(value="The key person's email address.")
    private String email;
    @JsonProperty(value="phoneNumber")
    @JsonPropertyDescription(value="The key person's phone number.")
    private String phoneNumber;
    @JsonProperty(value="faxNumber")
    @JsonPropertyDescription(value="The key person's fax number.")
    private String faxNumber;
    @JsonProperty(value="signature")
    @JsonPropertyDescription(value="Derived from the key person's full name.  For example \"lastName, firstName middleName\"")
    private String signature;
    @JsonProperty(value="title")
    @JsonPropertyDescription(value="The key person's title within the organization or project.")
    private String title;
    @JsonProperty(value="nsfId")
    @JsonPropertyDescription(value="The id assigned to this person's organization by the NSF.")
    private String nsfId;
    @JsonProperty(value="submittedDate")
    @JsonPropertyDescription(value="The date this representative was authorized?")
    private Date submittedDate;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="name")
    public PersonName getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(PersonName name) {
        this.name = name;
    }

    @JsonProperty(value="address")
    public Address getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    public void setAddress(Address address) {
        this.address = address;
    }

    @JsonProperty(value="email")
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="phoneNumber")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @JsonProperty(value="faxNumber")
    public String getFaxNumber() {
        return this.faxNumber;
    }

    @JsonProperty(value="faxNumber")
    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    @JsonProperty(value="signature")
    public String getSignature() {
        return this.signature;
    }

    @JsonProperty(value="signature")
    public void setSignature(String signature) {
        this.signature = signature;
    }

    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="nsfId")
    public String getNsfId() {
        return this.nsfId;
    }

    @JsonProperty(value="nsfId")
    public void setNsfId(String nsfId) {
        this.nsfId = nsfId;
    }

    @JsonProperty(value="submittedDate")
    public Date getSubmittedDate() {
        return this.submittedDate;
    }

    @JsonProperty(value="submittedDate")
    public void setSubmittedDate(Date submittedDate) {
        this.submittedDate = submittedDate;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(KeyPerson.class.getName()).append('@').append(Integer.toHexString(System.identityHashCode(this))).append('[');
        sb.append("name");
        sb.append('=');
        sb.append(this.name == null ? "<null>" : this.name);
        sb.append(',');
        sb.append("address");
        sb.append('=');
        sb.append(this.address == null ? "<null>" : this.address);
        sb.append(',');
        sb.append("email");
        sb.append('=');
        sb.append(this.email == null ? "<null>" : this.email);
        sb.append(',');
        sb.append("phoneNumber");
        sb.append('=');
        sb.append(this.phoneNumber == null ? "<null>" : this.phoneNumber);
        sb.append(',');
        sb.append("faxNumber");
        sb.append('=');
        sb.append(this.faxNumber == null ? "<null>" : this.faxNumber);
        sb.append(',');
        sb.append("signature");
        sb.append('=');
        sb.append(this.signature == null ? "<null>" : this.signature);
        sb.append(',');
        sb.append("title");
        sb.append('=');
        sb.append(this.title == null ? "<null>" : this.title);
        sb.append(',');
        sb.append("nsfId");
        sb.append('=');
        sb.append(this.nsfId == null ? "<null>" : this.nsfId);
        sb.append(',');
        sb.append("submittedDate");
        sb.append('=');
        sb.append(this.submittedDate == null ? "<null>" : this.submittedDate);
        sb.append(',');
        sb.append("additionalProperties");
        sb.append('=');
        sb.append(this.additionalProperties == null ? "<null>" : this.additionalProperties);
        sb.append(',');
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setCharAt(sb.length() - 1, ']');
        } else {
            sb.append(']');
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = result * 31 + (this.address == null ? 0 : this.address.hashCode());
        result = result * 31 + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        result = result * 31 + (this.signature == null ? 0 : this.signature.hashCode());
        result = result * 31 + (this.name == null ? 0 : this.name.hashCode());
        result = result * 31 + (this.faxNumber == null ? 0 : this.faxNumber.hashCode());
        result = result * 31 + (this.additionalProperties == null ? 0 : this.additionalProperties.hashCode());
        result = result * 31 + (this.title == null ? 0 : this.title.hashCode());
        result = result * 31 + (this.submittedDate == null ? 0 : this.submittedDate.hashCode());
        result = result * 31 + (this.email == null ? 0 : this.email.hashCode());
        result = result * 31 + (this.nsfId == null ? 0 : this.nsfId.hashCode());
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof KeyPerson)) {
            return false;
        }
        KeyPerson rhs = (KeyPerson)other;
        return (this.address == rhs.address || this.address != null && this.address.equals(rhs.address)) && (this.phoneNumber == rhs.phoneNumber || this.phoneNumber != null && this.phoneNumber.equals(rhs.phoneNumber)) && (this.signature == rhs.signature || this.signature != null && this.signature.equals(rhs.signature)) && (this.name == rhs.name || this.name != null && this.name.equals(rhs.name)) && (this.faxNumber == rhs.faxNumber || this.faxNumber != null && this.faxNumber.equals(rhs.faxNumber)) && (this.additionalProperties == rhs.additionalProperties || this.additionalProperties != null && this.additionalProperties.equals(rhs.additionalProperties)) && (this.title == rhs.title || this.title != null && this.title.equals(rhs.title)) && (this.submittedDate == rhs.submittedDate || this.submittedDate != null && this.submittedDate.equals(rhs.submittedDate)) && (this.email == rhs.email || this.email != null && this.email.equals(rhs.email)) && (this.nsfId == rhs.nsfId || this.nsfId != null && this.nsfId.equals(rhs.nsfId));
    }
}

