<%--
  #%L
  %%
  Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp" %>
<c:set var="readOnly" value="true" scope="request"/>
<c:set var="action" value="institutionalProposalSummary"/>
<kul:documentPage
        showDocumentInfo="true"
        htmlFormAction="${action}"
        documentTypeName="InstitutionalProposalDocument"
        renderMultipart="false"
        showTabButtons="true"
        auditCount="0"
        headerDispatch="${KualiForm.headerDispatch}"
        headerTabActive="summary">

    <div align="right">
            ${summaryHeader.headerTabDisplayName}
        <kra:shortUrl shortUrl="${KualiForm.shortUrl}"/>
        <kul:help documentTypeName="${KualiForm.documentTypeName}" pageName="Summary" />
    </div>

    <jsp:useBean id="KualiForm" scope="request"
                 type="org.kuali.kra.institutionalproposal.web.struts.form.InstitutionalProposalForm"/>
    <div id="workarea">
        <c:if test="${not empty KualiForm.versions}">
            <div>
                <span>Compare to Version</span>
                <html:select style="width: 150px; margin: 10px;" property="compareToVersionNumber" title="Compare To Version">
                    <c:choose>
                        <c:when test="${KualiForm.compareToVersionNumber eq null}">
                            <option label="select" value="" selected="selected"/>
                        </c:when>
                        <c:otherwise>
                            <option label="select" value=""/>
                        </c:otherwise>
                    </c:choose>

                    <c:forEach var="version" items="${KualiForm.versions}" varStatus="status">
                        <c:if test="${version.version lt KualiForm.document.institutionalProposal.sequenceNumber}">
                            <c:choose>
                                <c:when test="${version.version eq KualiForm.compareToVersionNumber}">
                                    <option label="${version.version} - ${version.status}" value="${version.version}" selected="selected"/>
                                </c:when>
                                <c:otherwise>
                                    <option label="${version.version} - ${version.status}" value="${version.version}"/>
                                </c:otherwise>
                            </c:choose>
                        </c:if>
                    </c:forEach>
                </html:select>
                <html:image property="methodToCall.compareToVersion" alt="Compare To Version"
                            src="${ConfigProperties.kra.externalizable.images.url}tinybutton-go.gif" styleClass="tinybutton"/>
                <html:image property="methodToCall.clearCompareToVersion" alt="Clear"
                            src="${ConfigProperties.kra.externalizable.images.url}tinybutton-clear1.gif" styleClass="tinybutton"/>
            </div>
        </c:if>

        <c:set var="currentObject" value="${KualiForm.document.institutionalProposalList[0]}" />
        <c:set var="currentPath" value="document.institutionalProposalList[0]" />
        <c:set var="currentSuffix" value="Current Version ${currentObject.sequenceNumber}" />

        <c:set var="compareToObject" value="${KualiForm.compareToVersion}" />
        <c:set var="compareToPath" value="compareToVersion" />
        <c:set var="compareToSuffix" value="Prior Version ${compareToObject.sequenceNumber}" />

        <c:choose>
            <c:when test="${compareToObject ne null}">
                <kra-ip:institutionalProposalSummaryProposalSummary
                        institutionalProposalObject="${currentObject}"
                        institutionalProposalPath="${currentPath}"
                        tabSuffix="${currentSuffix}"
                />

                <kra-ip:institutionalProposalSummaryProposalSummary
                        institutionalProposalObject="${compareToObject}"
                        institutionalProposalPath="${compareToPath}"
                        tabSuffix="${compareToSuffix}"
                />
            </c:when>
            <c:otherwise>
                <kra-ip:institutionalProposalSummaryProposalSummary
                        institutionalProposalObject="${currentObject}"
                        institutionalProposalPath="${currentPath}"
                        tabSuffix=""
                />
            </c:otherwise>
        </c:choose>

        <c:choose>
            <c:when test="${compareToObject ne null}">
                <kra-ip:institutionalProposalSummaryTeam
                        institutionalProposalObject="${currentObject}"
                        institutionalProposalPath="${currentPath}"
                        tabSuffix="${currentSuffix}"
                />

                <kra-ip:institutionalProposalSummaryTeam
                        institutionalProposalObject="${compareToObject}"
                        institutionalProposalPath="${compareToPath}"
                        tabSuffix="${compareToSuffix}"
                />
            </c:when>
            <c:otherwise>
                <kra-ip:institutionalProposalSummaryTeam
                        institutionalProposalObject="${currentObject}"
                        institutionalProposalPath="${currentPath}"
                        tabSuffix=""
                />
            </c:otherwise>
        </c:choose>

        <c:choose>
            <c:when test="${compareToObject ne null}">
                <kra-customdata:customDataTabSpecific
                        customAttributeGroups="${KualiForm.summaryViewCustomDataHelper.customAttributeGroups}"
                        customDataList="${KualiForm.summaryViewCustomDataHelper.customDataList}"
                        customDataListPrefix="summaryViewCustomDataHelper.customDataList"
                        tabSuffix="${currentSuffix}"
                />
                <kra-customdata:customDataTabSpecific
                        customAttributeGroups="${KualiForm.compareToVersionSummaryViewCustomDataHelper.customAttributeGroups}"
                        customDataList="${KualiForm.compareToVersionSummaryViewCustomDataHelper.customDataList}"
                        customDataListPrefix="compareToVersionSummaryViewCustomDataHelper.customDataList"
                        tabSuffix="${compareToSuffix}"
                />
            </c:when>
            <c:otherwise>
                <kra-customdata:customDataTabSpecific
                        customAttributeGroups="${KualiForm.summaryViewCustomDataHelper.customAttributeGroups}"
                        customDataList="${KualiForm.summaryViewCustomDataHelper.customDataList}"
                        customDataListPrefix="summaryViewCustomDataHelper.customDataList"
                />
            </c:otherwise>
        </c:choose>

        <c:if test="${KualiForm.ipAttachmentsEnabled}" >
            <c:choose>
                <c:when test="${compareToObject ne null}">
                    <kra-ip:institutionalProposalAttachments
                            readOnlyView="${true}"
                            filterAttachmentTypeCodes="${krafn:getParameterValues('KC-IP', 'Document', 'SummaryViewAttachmentTypes', [])}"
                            institutionalProposalObject="${currentObject}"
                            institutionalProposalPath="${currentPath}"
                            tabSuffix="${currentSuffix}"
                            defaultOpen="false"
                    />

                    <kra-ip:institutionalProposalAttachments
                            readOnlyView="${true}"
                            filterAttachmentTypeCodes="${krafn:getParameterValues('KC-IP', 'Document', 'SummaryViewAttachmentTypes', [])}"
                            institutionalProposalObject="${compareToObject}"
                            institutionalProposalPath="${compareToPath}"
                            tabSuffix="${compareToSuffix}"
                            defaultOpen="false"
                    />
                </c:when>
                <c:otherwise>
                    <kra-ip:institutionalProposalAttachments
                            readOnlyView="${true}"
                            filterAttachmentTypeCodes="${krafn:getParameterValues('KC-IP', 'Document', 'SummaryViewAttachmentTypes', [])}"
                            institutionalProposalObject="${currentObject}"
                            institutionalProposalPath="${currentPath}"
                            tabSuffix=""
                            defaultOpen="false"
                    />
                </c:otherwise>
            </c:choose>

        </c:if>

        <c:choose>
            <c:when test="${compareToObject ne null}">
                <kra-ip:institutionalProposalSummarySystem
                        filterPreproposalApplicationIds="${krafn:getParameterValues('KC-IP', 'Document', 'SummaryViewPreproposalApplicationIds', [])}"
                        institutionalProposalObject="${currentObject}"
                        institutionalProposalPath="${currentPath}"
                        tabSuffix="${currentSuffix}"
                        />

                <kra-ip:institutionalProposalSummarySystem
                        filterPreproposalApplicationIds="${krafn:getParameterValues('KC-IP', 'Document', 'SummaryViewPreproposalApplicationIds', [])}"
                        institutionalProposalObject="${compareToObject}"
                        institutionalProposalPath="${compareToPath}"
                        tabSuffix="${compareToSuffix}"
                        />
            </c:when>
            <c:otherwise>
                <kra-ip:institutionalProposalSummarySystem
                        filterPreproposalApplicationIds="${krafn:getParameterValues('KC-IP', 'Document', 'SummaryViewPreproposalApplicationIds', [])}"
                        institutionalProposalObject="${currentObject}"
                        institutionalProposalPath="${currentPath}"
                        tabSuffix=""
                        />
            </c:otherwise>
        </c:choose>
    </div>

    <div id="globalbuttons" class="globalbuttons">
        <html:image src="${ConfigProperties.kr.externalizable.images.url}buttonsmall_reload.gif" styleClass="globalbuttons" property="methodToCall.reload" title="reload" alt="reload" onclick="excludeSubmitRestriction=true"/>
        <c:if test="${!empty KualiForm.documentActions[Constants.KUALI_ACTION_CAN_CLOSE]}">
            <html:image src="${ConfigProperties.kr.externalizable.images.url}buttonsmall_close.gif" styleClass="globalbuttons" property="methodToCall.close" title="close" alt="close"/>
        </c:if>
    </div>
</kul:documentPage>




