<#--
 #%L
 %%
 Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#macro disable control type>

    <#if control.disabledConditionJs?has_content && control.disabledConditionControlNames?has_content>
        <#list control.disabledConditionControlNames as cName>
            <@krad.script value="var condition = function(){return (${control.disabledConditionJs});};
                  setupDisabledCheck('${cName?js_string}', '${control.id}', '${type}', condition,
                  ${control.evaluateDisabledOnKeyUp?string});"/>
        </#list>
    </#if>

    <#if control.disabledWhenChangedPropertyNames?has_content>
        <#list control.disabledWhenChangedPropertyNames as cName>
            <@krad.script value="
                  setupDisabledCheck('${cName?js_string}', '${control.id}', '${type}', function(){return true;},
                  ${control.evaluateDisabledOnKeyUp?string});"/>
        </#list>
    </#if>

    <#if control.enabledWhenChangedPropertyNames?has_content>
        <#list control.enabledWhenChangedPropertyNames as cName>
            <@krad.script value="
                  setupDisabledCheck('${cName?js_string}', '${control.id}', '${type}', function(){return false;},
                  ${control.evaluateDisabledOnKeyUp?string});"/>
        </#list>
    </#if>

</#macro>
