<%--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>
<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<%@ attribute name="defaultOpen" required="false" description="Whether the tab for the notes is rendered as open." %>

<c:set var="documentNotes" value="${KualiForm.boNotes}" />
<c:set var="tabTitle" value="Notes and Attachments" />
<c:set var="preserveWhitespace" value="true" />

<c:if test="${kfunc:canViewInquiryNoteAttachment()}">
    <kul:tab tabTitle="${tabTitle}" defaultOpen="${!empty documentNotes or (not empty defaultOpen and defaultOpen)}" tabErrorKey="${Constants.DOCUMENT_NOTES_ERRORS},attachmentFile" tabItemCount="${fn:length(documentNotes)}" transparentBackground="false" >
        <c:set var="notesAttributes" value="${DataDictionary.Note.attributes}" />
        <div class="tab-container" align=center id="G4">
        <p align=left><jsp:doBody/>
        <h3>${tabTitle}</h3>
        <table cellpadding="0" cellspacing="0" class="datatable" summary="view notes and attachments">
            <tbody>
                <tr>
                    <kul:htmlAttributeHeaderCell literalLabel="&nbsp;" scope="col" align="left"/>
                    <kul:htmlAttributeHeaderCell attributeEntry="${notesAttributes.notePostedTimestamp}" hideRequiredAsterisk="true" scope="col" align="left"/>
                    <kul:htmlAttributeHeaderCell attributeEntry="${notesAttributes.authorUniversalIdentifier}" hideRequiredAsterisk="true" scope="col" align="left"/>
                    <kul:htmlAttributeHeaderCell attributeEntry="${notesAttributes.noteText}" hideRequiredAsterisk="true" scope="col" align="left"/>
                    <kul:htmlAttributeHeaderCell attributeEntry="${notesAttributes.attachment}" hideRequiredAsterisk="true" scope="col" align="left"/>
                </tr>
                <c:forEach var="note" items="${documentNotes}" varStatus="status">
                <tr>
                    <kul:htmlAttributeHeaderCell literalLabel="${status.index + 1}" scope="row"/>
                    <td class="datacell center"><bean:write name="KualiForm" property="boNotes[${status.index}].notePostedTimestamp"/></td>
                    <td class="datacell center"><bean:write name="KualiForm" property="boNotes[${status.index}].authorUniversal.name"/></td>
                    <td class="datacell center">
                        <c:if test="${empty preserveWhitespace or preserveWhitespace}">
                            <kul:preserveWhitespace><bean:write name="KualiForm" property="boNotes[${status.index}].noteText" /></kul:preserveWhitespace>
                        </c:if>
                        <c:if test="${not empty preserveWhitespace and not preserveWhitespace}">
                            <bean:write name="KualiForm" property="boNotes[${status.index}].noteText" />
                        </c:if>
                    </td>
                    <td class="datacell center">
                        <c:if test="${(!empty note.attachment) and (note.attachment.complete)}">
                            <c:set var="mimeTypeCode" value="${note.attachment.attachmentMimeTypeCode}" />
                            <html:image property="methodToCall.downloadBOAttachment.attachment[${status.index}]" src="${ConfigProperties.kr.externalizable.images.url}${kfunc:getAttachmentImageForUrl(mimeTypeCode)}" title="download attachment" alt="download attachment" style="padding:5px" onclick="excludeSubmitRestriction=true"/>
                            <bean:write name="KualiForm" property="boNotes[${status.index}].attachment.attachmentFileName"/>

                            <span style="white-space: nowrap">
                                <kul:fileSize byteSize="${note.attachment.attachmentFileSize}">
                                    (<c:out value="${fileSize} ${fileSizeUnits}" />,  <bean:write name="KualiForm" property="boNotes[${status.index}].attachment.attachmentMimeTypeCode"/>)
                                </kul:fileSize>
                            </span>
                        </c:if>
                    </td>
                </tr>
                </c:forEach>
            </tbody>
        </table>
    </kul:tab>
</c:if>
