<%--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<c:set var="subAwardNotesAttributes" value="${DataDictionary.SubAwardNotepad.attributes}" />
<c:set var="subAwardAdmin" value="true" />
<c:set var="tabItemCount" value="0" />
<c:forEach var="subAwardNotepad" items="${KualiForm.document.subAward.subAwardNotepads}" varStatus="status">
        <c:set var="tabItemCount" value="${tabItemCount+1}" />
</c:forEach>


<kul:tab tabTitle="Notes" tabItemCount="${tabItemCount}" defaultOpen="false" tabErrorKey="subAwardNotepadBean.*"
	auditCluster="notesKrmsErrors,notesKrmsWarnings"
	tabAuditKey="document.subAwardList[0].subAwardNotepad*"
	useRiceAuditMode="true">
	<div class="tab-container" align="center">
    	<h3>
    		<span class="subhead-left">Notes</span>
    		<span class="subhead-right">
    			<kul:help parameterNamespace="KC-SUBAWARD" parameterDetailType="Document" parameterName="subAwardNotesHelp" altText="help"/>
			</span>
        </h3>
        <table cellpadding="0" cellspacing="0" summary="Notes">
			<tr>
				<th scope="row">&nbsp;</th>
				<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${subAwardNotesAttributes.createUser}" useShortLabel="true" noColon="true" /></div></th>
				<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${subAwardNotesAttributes.updateUser}" useShortLabel="true" noColon="true" /></div></th>
				<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${subAwardNotesAttributes.noteTopic}" useShortLabel="true" noColon="true"/></div></th>
				<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${subAwardNotesAttributes.comments}" useShortLabel="true" noColon="true"/></div></th>
				<th><div align="center"><kul:htmlAttributeLabel attributeEntry="${subAwardNotesAttributes.restrictedView}" useShortLabel="true" noColon="true"/></div></th>
				<th><div align="center">Actions</div></th>
			</tr>
			
			<c:if test="${!readOnly}">
			<tbody class="addline">
			<tr>
            	<th align="center" valign="middle" class="infoline"><div align="center">Add:</div></th>
            	<td align="left" valign="middle" class="infoline">
					<div align="left">&nbsp;</div>
            	</td>
	            <td align="left" valign="middle" class="infoline">
					<div align="left">&nbsp;</div>
	            </td>
	            <td width="150" class="infoline">
	            	<div align="center">
            	    	<kul:htmlControlAttribute property="subAwardNotepadBean.newSubAwardNotepad.noteTopic" attributeEntry="${subAwardNotesAttributes.noteTopic}"/>
            	  	</div>
	            </td>
	            <td align="left" valign="middle" class="infoline">
	            	<div align="center">
            	    	<kul:htmlControlAttribute property="subAwardNotepadBean.newSubAwardNotepad.comments" attributeEntry="${subAwardNotesAttributes.comments}"/>
            	  	</div>
	            </td>
	            <td align="left" valign="middle" class="infoline">
	            	<div align="center" class="ignoreMeFromWarningOnAddRow">
            	   	 	<kul:htmlControlAttribute property="subAwardNotepadBean.newSubAwardNotepad.restrictedView" attributeEntry="${subAwardNotesAttributes.restrictedView}"/>
            	  	</div>
	            </td>
	            <td align="left" valign="middle" class="infoline">
	            	<div align="center">
						<html:image property="methodToCall.addNote.anchor${tabKey}"
						src='${ConfigProperties.kra.externalizable.images.url}tinybutton-add1.gif' styleClass="tinybutton addButton"/>
					</div>
	            </td>
          	</tr>
          	</tbody>
          	</c:if>
          	
         <c:forEach var="subAwardNotepad" items="${KualiForm.document.subAward.subAwardNotepads}" varStatus="status">
		     <kra-sub:noteLineItem statusIndex="${status.index}" noteParmeterString="document.subAward.subAwardNotepads[${status.index}]"
		         viewRestrictedNotes="true" noteObject="${subAwardNotepad}" modifyPermission="${modifyPermission}"
		         hasAdministratorRole="${subAwardAdmin}" action="subAwardNotesAndAttachments" showUpdate="true" isAddLine="${false}" />
	    	</c:forEach> 
        </table>
   </div>
</kul:tab>
