<%--
  #%L
  %%
  Copyright (C) 2005 - 2020 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:set var="inquiry" scope="request" value="${KualiForm.inquiry}" />
<c:set var="readOnly" scope="request" value="${!KualiForm.documentActions[Constants.KUALI_ACTION_CAN_EDIT] || inquiry}" />
<c:set var="readOnlyEntity" scope="request" value="${!KualiForm.canModifyEntity || readOnly}" />

<c:set var="formAction" value="identityManagementPersonDocument" />
<c:if test="${inquiry}">
    <c:set var="formAction" value="identityManagementPersonInquiry" />
</c:if>

<kul:documentPage
    showDocumentInfo="${!inquiry}"
    htmlFormAction="${formAction}"
	documentTypeName="IdentityManagementPersonDocument"
	renderMultipart="${inquiry}"
	showTabButtons="true"
	auditCount="0">

    <c:if test="${!inquiry}">
 	    <kul:hiddenDocumentFields />
	    <kul:documentOverview editingMode="${KualiForm.editingMode}" />
	</c:if>
    <c:if test="${inquiry}">
        <div id="workarea">
    </c:if>
	<kim:personOverview />
	<kim:personContact />
	<kim:personPrivacy />
	<kim:personMembership />

    <c:if test="${!inquiry}">    		
		<kul:adHocRecipients />
		<kul:routeLog />
	</c:if>
	<kul:superUserActions />
	<kul:panelFooter />
    <c:if test="${inquiry}">
        </div>
    </c:if>
    <c:choose>
        <c:when test="${!inquiry}">
            <kul:documentControls transactionalDocument="false" />
        </c:when>
        <c:otherwise>
            <kul:inquiryControls />
            <input type="hidden" name="principalId" value="${KualiForm.document.principalId}" />
        </c:otherwise>
    </c:choose>

</kul:documentPage>
