<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core" %>
<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

 

<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<kul:documentPage
	showDocumentInfo="true"
	htmlFormAction="subAwardActions"
	documentTypeName="SubAwardDocument"
	renderMultipart="false"
	showTabButtons="true"
	auditCount="0"
  	headerDispatch="${KualiForm.headerDispatch}"
  	headerTabActive="subAwardActions">
<c:set var="extraButtons" value="${KualiForm.extraActionsButtons}" scope="request" />
	<div align="right">
       <kra:shortUrl shortUrl="${KualiForm.shortUrl}"/>
       <kul:help parameterNamespace="KC-SUBAWARD" parameterDetailType="Document" parameterName="subAwardActionsHelpUrl" altText="help"/></div>
	<script type="text/javascript" src="scripts/kuali_application.js"></script>

	<div id="workarea">
<kra-sub:subAwardDataValidation />
<kra-sub:subAwardCopy />
<c:if test="${krafn:getParameterValueAsBoolean('KC-SUBAWARD', 'All', 'ENABLE_FORM_PRINTING')}">
	<kra-sub:subAwardPrintPdf/>
</c:if>

<kul:adHocRecipients />
<kul:routeLog />
<kra-sub:subAwardNotifications />
<kul:panelFooter />
</div>
<kul:documentControls transactionalDocument="true" viewOnly="${KualiForm.editingMode['viewOnly']}" suppressCancelButton="true" extraButtons="${extraButtons}" />

</kul:documentPage>
