<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.

  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/WEB-INF/jsp/award/awardTldHeader.jsp" %>

<c:set var="activityTypeAttributes" value="${DataDictionary.ActivityType.attributes}" />
<c:set var="awardAttributes" value="${DataDictionary.Award.attributes}" />
<c:set var="awardAlternateNumberAttributes" value="${DataDictionary.AwardAlternateNumber.attributes}" />
<c:set var="awardAlternateNumberTypeAttributes" value="${DataDictionary.AwardAlternateNumberType.attributes}" />


<kul:tab tabTitle="Additional Document Numbers and Related Accounts" defaultOpen="false" tabErrorKey="document.awardList[0].alternateIds*,awardAlternateNumberBean*">
	<div class="tab-container" align="right">

			<h3>
				<span class="subhead-left">Add Document Numbers & Related Accounts</span>
	    		<span class="subhead-right">
    				<kul:help parameterNamespace="KC-AWARD" parameterDetailType="Document" parameterName="awardHelp" altText="help"/>
				</span>
			</h3>
			<table id="altAccountIdAddTable" cellpadding="0" cellspacing="0" summary="Add Alternate Account Id">
			     <tr>
			     <th></th>
			          <th><div align="center"><kul:htmlAttributeLabel attributeEntry="${awardAlternateNumberAttributes.description}" /></div></th>
			          <th><div align="center"><kul:htmlAttributeLabel attributeEntry="${awardAlternateNumberAttributes.number}" /></div></th>
			          <th><div align="center"><kul:htmlAttributeLabel attributeEntry="${awardAlternateNumberAttributes.showOnInvoice}" /></div></th>
			          <th><div align="center"><kul:htmlAttributeLabel attributeEntry="${awardAlternateNumberTypeAttributes.description}" /></div></th>
			          <th>Actions</th>

			     </tr>
				<c:if test="${!readOnly}">
				<tr>
			          <th align="center" scope="row"><div align="right">Add:</div></th>

			    	<td class="infoline">
			    	  	<div align="center">

			    	  	 	<kul:htmlControlAttribute property="awardAlternateNumberBean.newAwardAlternateNumber.description"
			    	  	 								attributeEntry="${awardAlternateNumberAttributes.description}"
			    	  	 								readOnly="false" />

			    	 	</div>
			    	</td>
			    	<td class="infoline">
			    	  	<div align="center">

			    	  	 	<kul:htmlControlAttribute property="awardAlternateNumberBean.newAwardAlternateNumber.number"
			    	  	 								attributeEntry="${awardAlternateNumberAttributes.number}"
			    	  	 								readOnly="false" />

			    	 	</div>
			    	</td>
			    	<td class="infoline">
			    	<div align="center">

			    	  	 	<kul:htmlControlAttribute property="awardAlternateNumberBean.newAwardAlternateNumber.showOnInvoice"
			    	  	 								attributeEntry="${awardAlternateNumberAttributes.showOnInvoice}"
			    	  	 								readOnly="false" />

			    	 	</div>
			    	</td>

			    	<td class="infoline">
			    	   <div align="center">
			    	    	${KualiForm.valueFinderResultDoNotCache}
			    	    	<kul:htmlControlAttribute property="awardAlternateNumberBean.newAwardAlternateNumber.awardAlternateNumberTypeCode"
			    	    							  attributeEntry="${awardAlternateNumberTypeAttributes.awardAlternateNumberTypeCode}"
			    	    							  readOnly="false" />
			    	     </div>
			    	</td>

			        <td class="infoline">
			        	<div align="center">
							<html:image property="methodToCall.addAlternateAwardNumber.anchor${tabKey}"
							src='${ConfigProperties.kra.externalizable.images.url}tinybutton-add1.gif' styleClass="tinybutton"
							title="add" alt="add"/>
						</div>
			        </td>
			  	</tr>
			  	</c:if>

 			  	<c:forEach var="awardAltNumber" items="${KualiForm.document.award.awardAlternateNumbers}" varStatus="status">
	             <tr>
					<th class="infoline">
						<c:out value="${status.index+1}" />
					</th>
	                <td valign="middle">
					    <div align="center">
						${KualiForm.document.award.awardAlternateNumbers[status.index].description}&nbsp;
						</div>
					</td>
	                <td valign="middle">
					    <div align="center">
						${KualiForm.document.award.awardAlternateNumbers[status.index].number}&nbsp;
						</div>
	                </td>
	                <td valign="middle">
					    <div align="center">
						${KualiForm.document.award.awardAlternateNumbers[status.index].showOnInvoice}&nbsp;
				 	    </div>
					</td>
	                <td valign="middle">
					    <div align="center">
						${KualiForm.document.award.awardAlternateNumbers[status.index].awardAlternateNumberType.description}&nbsp;
						</div>
					</td>
	                <td width="10%">
					<div align="center">&nbsp;
					   <c:if test="${!readOnly}">
						<html:image property="methodToCall.deleteAlternateAwardNumber.line${status.index}.anchor${currentTabIndex}"
						src='${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif' styleClass="tinybutton"
						title="delete" alt="delete"/>
					   </c:if>
					</div>
	                </td>
	            </tr>
        	</c:forEach>
		  	</table>



	</div>
</kul:tab>
