<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.

  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%-- member of AwardContacts.jsp --%>

<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<c:set var="awardCentralAdminAttributes" value="${DataDictionary.AwardCentralAdminContact.attributes}" />
<c:set var="awardContactAttributes" value="${DataDictionary.AwardContact.attributes}" />
<c:set var="award" value="${KualiForm.document.award}" />

<kul:tab defaultOpen="false"
		 tabItemCount="${fn:length(KualiForm.awardDocument.award.awardCentralAdminContacts)}"
		 tabTitle="Central Administration Contacts"
		 tabErrorKey="centralAdminContactsBean.newAwardContact.*,centralAdminContactsBean.centralAdminContact.unitAdministratorTypeCode,document.awardList[0].awardCentralAdminContacts*"
		 auditCluster="centralAdminContactsKrmsErrors,centralAdminContactsKrmsWarnings"
		 tabAuditKey="document.awardList[0].awardCentralAdminContacts*" useRiceAuditMode="true">
	<div class="tab-container" align="center">
		<h3>
			<span class="subhead-left">Central Administration Contacts</span>
	      	<span class="subhead-right"><kul:help parameterNamespace="KC-AWARD" parameterDetailType="Document" parameterName="awardCentralAdminContactsHelpUrl" altText="help"/></span>
		</h3>
	    <table id="central-admin-table" cellpadding="0" cellspacing="0" summary="Central Admin Contacts">
			<tr>
				<th scope="row" width="5%">&nbsp;</th>
				<th width="15%">Person</th>
				<th width="15%">Unit</th>
				<th width="20%">Project Role</th>
				<th width="15%">Office Phone</th>
				<th width="15%">Email</th>
				<th width="15%">
					<div align="center">Actions</div>
				</th>
			</tr>

			<c:if test="${!readOnly && !award.syncCentralAdminContacts}">
				<tbody class="addline">
					<tr>
						<th class="infoline" scope="row">Add</th>
						<td nowrap class="grid" class="infoline">
							<label for="centralAdminContactsBean.newAwardContact.fullName">Employee User Name:</label>
							<kul:htmlControlAttribute
								property="centralAdminContactsBean.newAwardContact.fullName"
								attributeEntry="${awardContactAttributes.fullName}"
								onblur="loadContactPersonName('centralAdminContactsBean.newAwardContact.fullName',
	                               				 			'cac.fullName.div',
	                	        				     		'cac.unitNumber',
	                	        				  			'cac.phoneNumber',
           	        							  			'cac.emailAddress',
           	        							  			'cac.personId');"
								readOnly="${readOnly}"/>
							<c:if test="${!readOnly}">
								<kul:lookup boClassName="org.kuali.coeus.common.framework.person.KcPerson"
											fieldConversions="personId:centralAdminContactsBean.personId"
											lookupParameters="centralAdminContactsBean.personId:personId"
											anchor="${tabKey}"/>
							</c:if>
							<c:if test="${readOnly}">
								<html:hidden styleId="cac.fullName.div" property="centralAdminContactsBean.newAwardContact.fullName"/>
							</c:if>

							${kfunc:registerEditableProperty(KualiForm, "centralAdminContactsBean.personId")}
							<html:hidden styleId="cac.personId" property="centralAdminContactsBean.personId"/>

							<div id="cac.fullName.div">&nbsp;
								<c:if test="${!empty KualiForm.centralAdminContactsBean.newAwardContact.contact}">
									<c:choose>
										<c:when test="${empty KualiForm.centralAdminContactsBean.newAwardContact.contact}">
											<span style='color: red;'>not found</span>
										</c:when>
										<c:otherwise>
											<c:out value="${KualiForm.centralAdminContactsBean.newAwardContact.contact.fullName}"/>
										</c:otherwise>
									</c:choose>
								</c:if>
							</div>
						</td>
						<td id="cac.unitNumber" class="infoline">
							<c:out value="${KualiForm.centralAdminContactsBean.newAwardContact.unitAdministratorUnitNumber}" />&nbsp;
						</td>
						<td class="infoline" style="font-size: 80%">
							<div align="center" class="defaultData" data-emptyvalues='["3"]'>
								<kul:htmlControlAttribute
										property="centralAdminContactsBean.centralAdminContact.unitAdministratorTypeCode"
										attributeEntry="${awardCentralAdminAttributes.unitAdministratorTypeCode}"/>
							</div>
						</td>
						<td id="cac.phoneNumber" class="infoline">
							<c:out value="${KualiForm.centralAdminContactsBean.newAwardContact.contact.phoneNumber}"/>&nbsp;
						</td>
						<td id="cac.emailAddress" class="infoline">
							<c:out value="${KualiForm.centralAdminContactsBean.newAwardContact.contact.emailAddress}"/>&nbsp;
						</td>
						<td class="infoline">
							<div align="center">
								<html:image
										property="methodToCall.addCentralAdminContact"
										src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
										title="Add Contact" alt="Add Contact" styleClass="tinybutton addButton"/>
							</div>
						</td>
					</tr>
				</tbody>
			</c:if>

			<c:forEach var="awardContact" items="${KualiForm.awardDocument.award.awardCentralAdminContacts}" varStatus="awardContactRowStatus">
				<tr>
					<th class="infoline" scope="row">
						<c:out value="${awardContactRowStatus.index + 1}" />
					</th>
	                <td valign="middle">
	                	<div align="center">
	                		<input type="hidden" name="admin_contact.identifier_${awardContactRowStatus.index}" value="${awardContact.contact.identifier}" />
	                		${awardContact.fullName}&nbsp;
	                		<kul:directInquiry boClassName="org.kuali.coeus.common.framework.person.KcPerson" inquiryParameters="admin_contact.identifier_${awardContactRowStatus.index}:personId" anchor="${tabKey}" />
						</div>
					</td>
	                <td valign="middle">
	                	<div align="center">
	                		<input type="hidden" name="admin_contact.orgNumber_${awardContactRowStatus.index}" value="${awardContact.organizationIdentifier}" />
							${awardContact.unitNumberForDisplay}&nbsp;
							<kul:directInquiry boClassName="org.kuali.coeus.common.framework.unit.Unit" inquiryParameters="admin_contact.orgNumber_${awardContactRowStatus.index}:unitNumber" anchor="${tabKey}" />
						</div>
					</td>
	                <td valign="middle">
	                	<div align="center">
							<kul:htmlControlAttribute
									property="centralAdminContactsBean.centralAdminContacts[${awardContactRowStatus.index}].unitAdministratorTypeCode"
									attributeEntry="${awardCentralAdminAttributes.unitAdministratorTypeCode}"
									readOnlyAlternateDisplay="${awardContact.unitAdministratorType.description}"
									readOnly="true" />
	                	</div>
					</td>
					<td valign="middle">
						<div align="center">
	                		${awardContact.phoneNumber}&nbsp;
	                	</div>
					</td>
	                <td valign="middle">
	                	<div align="center">
							${awardContact.emailAddress}&nbsp;
						</div>
					</td>
					<td>
						<div align="center">
							<c:if test="${!readOnly && !award.syncCentralAdminContacts &&
								(!awardContact.defaultUnitContact || krafn:getParameterValueAsBoolean('KC-AWARD', 'Document', 'ALLOW_DELETE_DEFAULT_CENTRAL_ADMIN_CONTACTS'))}">
								<html:image
										property="methodToCall.deleteCentralAdminContact.line${awardContactRowStatus.index}.anchor${currentTabIndex}"
										src='${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif'
										styleClass="tinybutton" />
							</c:if>
						</div>
					</td>
	            </tr>
    		</c:forEach>
			<tr>
				<th colspan="7" align="center" scope="row">
					<div align="center">
						<c:if test="${!readOnly}">
							<c:if test="${!award.syncCentralAdminContacts}">
								<kul:kualiButton
									label="Enable Auto-Sync"
									title="Enable Auto-Sync"
									src="${ConfigProperties.kra.externalizable.images.url}tinybutton-enablesync.gif"
									property="methodToCall.toggleCentralAdminContactsAutoSync.anchor${tabKey}"
									styleClass="tinybutton small" />
								<kul:kualiButton
									label="Sync to Lead Unit"
									title="Sync to Lead Unit"
									src="${ConfigProperties.kra.externalizable.images.url}tinybutton-sync_lead_unit.jpg"
									property="methodToCall.syncDefaultCentralAdminContactsToLeadUnit.anchor${tabKey}"
									styleClass="tinybutton small" />
							</c:if>
							<c:if test="${award.syncCentralAdminContacts}">
								<kul:kualiButton
									label="Disable Auto-Sync"
									title="Disable Auto-Sync"
									src="${ConfigProperties.kra.externalizable.images.url}tinybutton-disablesync.gif"
									property="methodToCall.toggleCentralAdminContactsAutoSync.anchor${tabKey}"
									styleClass="tinybutton small" />
							</c:if>
						</c:if>
						<c:if test="${readOnly}">&nbsp;</c:if>
					</div>
				</th>
			</tr>
    	</table>
	</div>
</kul:tab>
