<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<c:set var="tmPostHistory" value="${KualiForm.tmPostHistory}" />
<c:set var="postIntegrationActive" value="${KualiForm.isTMPostRestIntegrationOn()}"/>

<kul:tab tabTitle="Time and Money Post History" tabItemCount="${fn:length(tmPostHistory)}" defaultOpen="${param.command eq 'displayDocSearchView' ? true : false}" >
    <div class="tab-container" align="left">
        <h3>
            <span class="subhead-left">Time and Money Post History</span>
        </h3>
        <table cellpadding=0 cellspacing=0 summary="">
            <tr>
                <c:if test="${!postIntegrationActive}">
                <th>
                    <div align="center">
                        Data retrieved
                    </div>
                </th>
                </c:if>
                <c:if test="${postIntegrationActive}">
                    <th>
                        <div align="center">
                            Post Status
                        </div>
                    </th>
                    <th>
                        <div align="center">
                            Post Details
                        </div>
                    </th>
                </c:if>
                <th>
                    <div align="center"	>
                        Posted date
                    </div>
                </th>
                <th>
                    <div align="center"	>
                        Username
                    </div>
                </th>
                <th>
                    <div align="center"	>
                        Name
                    </div>
                </th>
                <th>
                    <div align="center"	>
                        Document
                    </div>
                </th>
                <c:if test="${postIntegrationActive}">
                    <th>
                        <div align="center"	>
                            Actions
                        </div>
                    </th>
                </c:if>
            </tr>
            <c:set var="fieldCount" value="0" />
            <c:forEach items="${tmPostHistory}" var="tmPostHistory">
                <c:set var="fieldCount" value="${fieldCount + 1}" />

                <tr>
                    <c:if test="${!postIntegrationActive}">
                        <td class="infoline">
                            <div align="center">
                                <c:out value="${!tmPostHistory.active}" />
                            </div>
                        </td>
                    </c:if>
                    <c:if test="${postIntegrationActive}">
                        <td class="infoline">
                            <div align="center">
                                <c:out value="${tmPostHistory.postStatus}" />
                            </div>
                        </td>
                        <td class="infoline">
                            <div align="center">
                                <c:out value="${tmPostHistory.postDetails}" />
                            </div>
                        </td>
                    </c:if>
                    <td class="infoline">
                        <div align="center">
                            <fmt:formatDate value="${tmPostHistory.updateTimestamp}" pattern="MM/dd/yyyy HH:mm:ss" />
                        </div>
                    </td>
                    <td class="infoline">
                        <div align="center">
                            <c:out value="${tmPostHistory.updateUser}" />
                        </div>
                    </td>
                    <td class="infoline">
                        <div align="center">
                            <c:out value="${tmPostHistory.lastName}, ${tmPostHistory.firstName}" />
                        </div>
                    </td>
                    <td class="infoline">
                        <div align="center">
                            <a href="${ConfigProperties.application.url}/kew/DocHandler.do?command=displayDocSearchView&amp;docId=${tmPostHistory.documentNumber}"
                               target="_self" style="color:#068acd;" title="open award">${tmPostHistory.documentNumber}</a>
                        </div>
                    </td>
                    <c:if test = "${postIntegrationActive && fieldCount==1}" >
                        <kra:section permission="createAwardAccount">

                            <%--  need an onclick yes/no dialog if last post was successful and award is unchanged since then ... --%>
                            <td class="infoline">
                                <div align="center">
                                    <html:image property="methodToCall.resendTimeAndMoneyPost.timeAndMoneyDocNumber${tmPostHistory.documentNumber}" src="${ConfigProperties.kra.externalizable.images.url}tinybutton-repost.gif" title="resend time and money account" alt="retry send time and money to account" styleClass="tinybutton"/>
                                </div>
                            </td>
                        </kra:section>
                    </c:if>
                </tr>
            </c:forEach>
        </table>
    </div>
</kul:tab>

