<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>


<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>

<c:set var="budgetCostShareAttributes" value="${DataDictionary.BudgetCostShare.attributes}" />

<kul:tabTop 
		tabTitle="Cost Sharing (${KualiForm.document.budget.budgetCostShareCount})" 
		defaultOpen="false" 
		tabErrorKey="newCostShare*,document.budget.budgetCostShare*,newBudgetCostShare*"
		auditCluster="budgetCostShareAuditErrors" 
		tabAuditKey="document.budget.budgetCostShare*"
		>
	<div class="tab-container" align="center">
		<c:choose>
			<c:when test="${KualiForm.costSharingEditFormVisible}">
			<div id="costSharingAvailable">
		    	<h3>
		    	 <span class="subhead-left">Cost Sharing Distribution List</span>
	        	<div align="right"><kul:help parameterNamespace="KC-AB" parameterDetailType="Document" parameterName="awardBudgetCostShareHelpUrl" altText="help"/></div>
		    	</h3>
				<div align="center">
					<table id="budget-cost-sharing-table" cellpadding="0" cellspacing="0" summary="Budget Cost Shares">
		
						<tr>
							<th width="5%"><div align="left">&nbsp;</div></th>
							<th width="17%"><div align="center">${KualiForm.projectPeriodLabel}</div></th>
							<th width="17%"><div align="center">Percentage</div></th>
							<th width="29%"><div align="center">Source Account</div></th>
							<th width="17%"><div align="center">Amount</div></th>
							<th width="17%"><div align="center">Unit Name</div></th>
							<th width="17%"><div align="center">Unit</div></th>
							<th width="15%"><div align="center">Actions</div></th>	
						</tr>
						
						<kra:section permission="modifyBudgets">
						<tr class="addline">
			            	<th width="50" align="right"><div align="right">Add:</div></th>
							<td class="infoline"><div align="center">
			        			<kul:htmlControlAttribute property="newBudgetCostShare.projectPeriod" attributeEntry="${budgetCostShareAttributes.projectPeriod}" />
			        		</div></td>
			        		<td class="infoline"><div align="center">
								<kul:htmlControlAttribute property="newBudgetCostShare.sharePercentage" attributeEntry="${budgetCostShareAttributes.sharePercentage}" styleClass="amount" />						
			    			</div></td>
			    			<td class="infoline"><div align="center">
			        			<kul:htmlControlAttribute property="newBudgetCostShare.sourceAccount" attributeEntry="${budgetCostShareAttributes.sourceAccount}" />
			        		</div></td>
			        		<td class="infoline"><div align="center">
			        			<kul:htmlControlAttribute property="newBudgetCostShare.shareAmount" attributeEntry="${budgetCostShareAttributes.shareAmount}" styleClass="amount" />
			        		</div></td>
							<td class="infoline">
								<html:hidden property="newBudgetCostShare.unitName" />
								<div align="center">
									<c:choose>
										<c:when test="${empty KualiForm.newBudgetCostShare.unitName}">
											(select)
										</c:when>
										<c:otherwise>
											${KualiForm.newBudgetCostShare.unitName}
										</c:otherwise>
									</c:choose>
									&nbsp; <kul:lookup boClassName="org.kuali.coeus.common.framework.unit.Unit"
													   fieldConversions="unitNumber:newBudgetCostShare.unitNumber,unitName:newBudgetCostShare.unitName" />
									<kul:directInquiry boClassName="org.kuali.coeus.common.framework.unit.Unit" inquiryParameters="newBudgetCostShare.unitNumber:unitNumber"
													   anchor="${tabKey}" />
								</div></td>
							<td class="infoline"><div align="center">
								<kul:htmlControlAttribute property="newBudgetCostShare.unitNumber" attributeEntry="${budgetCostShareAttributes.unitNumber}" />
							</div></td>
							<td class="infoline">
			            		<div align=center>
			            			<html:image property="methodToCall.addCostShare" src='${ConfigProperties.kra.externalizable.images.url}tinybutton-add1.gif' styleClass="tinybutton addButton"/>
								</div>
							</td>
			          	</tr>
			          	</kra:section>
					          	
			  			<c:forEach var="budgetCostShare" items="${KualiForm.document.budget.budgetCostShares}" varStatus="status">
							<input type="hidden" name="budget_cost_share_unit.identifier_${status.index}" value="${budgetCostShare.unitNumber}" />
							<tr>
			          			<th><div align="right">${status.index + 1}</div></th>		            		
			            		<td><div align="center">
									<kul:htmlControlAttribute property="document.budget.budgetCostShares[${status.index}].projectPeriod" attributeEntry="${budgetCostShareAttributes.projectPeriod}" />

			        			</div></td>
			        			
			            		<td><div align="center">
			            			<kul:htmlControlAttribute property="document.budget.budgetCostShares[${status.index}].sharePercentage" attributeEntry="${budgetCostShareAttributes.sharePercentage}"
															  styleClass="amount" />
			    				</div></td>
			            		
			            		<td><div align="center">
			        				<kul:htmlControlAttribute property="document.budget.budgetCostShares[${status.index}].sourceAccount" attributeEntry="${budgetCostShareAttributes.sourceAccount}" />
			        			</div></td>
			            		
			            		<td><div align="center">
			            			<kul:htmlControlAttribute property="document.budget.budgetCostShares[${status.index}].shareAmount" attributeEntry="${budgetCostShareAttributes.shareAmount}" styleClass="amount" />
			        			</div></td>

								<td>
									<html:hidden property="document.budget.budgetCostShares[${status.index}].unitName" />
									<div align="center">
										<c:choose>
											<c:when test="${empty budgetCostShare.unitName}">
												(select)
											</c:when>
											<c:otherwise>
												${budgetCostShare.unitName}
											</c:otherwise>
										</c:choose>
										&nbsp; <kul:lookup boClassName="org.kuali.coeus.common.framework.unit.Unit"
														   fieldConversions="unitNumber:document.budget.budgetCostShares[${status.index}].unitNumber,unitName:document.budget.budgetCostShares[${status.index}].unitName" />
										<kul:directInquiry boClassName="org.kuali.coeus.common.framework.unit.Unit" inquiryParameters="budget_cost_share_unit.identifier_${status.index}:unitNumber"
														   anchor="${tabKey}" />
									</div></td>

								<td><div align="center">
									<kul:htmlControlAttribute property="document.budget.budgetCostShares[${status.index}].unitNumber" attributeEntry="${budgetCostShareAttributes.unitNumber}" />
								</div></td>
			            		<td>
			            			<div align=center>
			            				<c:if test="${!viewOnly and fn:length(KualiForm.document.budget.budgetCostShares) > 0}">
										  	<html:image property="methodToCall.deleteCostShare.line${status.index}" src='${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif' title="Delete a Cost Share" alt="Delete a Cost Share" styleClass="tinybutton" />
										</c:if>
									</div>
			            		</td>
			         		</tr>
			         		
			          	</c:forEach>
			          	<tr>
			          		<th colspan="4" class="infoline"><div align="right">Total Allocated:</div></th>
						    <td><div align="right">
						    	<span class="amount">
						    		<fmt:formatNumber value="${KualiForm.document.budget.allocatedCostSharing}" type="currency" currencySymbol="$" maxFractionDigits="2" />
						    	</span>
						    </div></td></td>
						    <th>&nbsp;</th>	          		
			          	</tr>
			          	<tr>
			          		<th colspan="4" class="infoline"><div align="right">Unallocated:</div></th>
						    <td><div align="right">
						    	<span class="amount">
						    		<fmt:formatNumber value="${KualiForm.document.budget.unallocatedCostSharing}" type="currency" currencySymbol="$" maxFractionDigits="2" />
						    	</span></div></td>
						    <th>&nbsp;</th>
			          	</tr>
			        </table>
				</div>			
			    
				<h3>Cost Sharing Summary</h3>
			
				<div align="center">
					<table id="budget-cost-sharing-summary-table" cellpadding="0" cellspacing="0" summary="Cost Sharing Amounts to be Allocated">
			    		<c:forEach var="budgetPeriod" items="${KualiForm.document.budget.budgetPeriods}" varStatus="status">
							<tr>
						    	<th width="68.5%"><div align="right">Period ${status.index + 1}: ${budgetPeriod.dateRangeLabel}:</div></th>
						    	<td width="17%"><div align="right"><span class="amount"><fmt:formatNumber value="${budgetPeriod.costSharingAmount}" type="currency" currencySymbol="$" maxFractionDigits="2" /></span></div></td>
						    	<th width="14.5%">&nbsp;</th>
						    </tr>
					    </c:forEach>
					    <tr>
	                        <th width="68.5%"><div align="right">Total Cost Sharing:</div></th>
	                        <td width="17%"><div align="right"><span class="amount"><fmt:formatNumber value="${KualiForm.document.budget.availableCostSharing}" type="currency" currencySymbol="$" maxFractionDigits="2" /></span></div></td>
	                        <th width="14.5%">&nbsp;</th>
                        </tr>
					</table>

					<div align="center" style="padding-top: 2em;">&nbsp;
						<kra:section permission="modifyBudgets">
							<html:image property="methodToCall.resetCostSharingToDefault" src='${ConfigProperties.kra.externalizable.images.url}tinybutton-resettodefault.gif' styleClass="tinybutton"/>
							<html:image property="methodToCall.refreshTotals" src='${ConfigProperties.kra.externalizable.images.url}tinybutton-recalculate.gif' styleClass="tinybutton"/>
						</kra:section>
					</div>
				</div>
			</div>
			</c:when>
			<c:otherwise>
				<div align="center">Cost Sharing doesn't apply or is not available</div>
			</c:otherwise>
		</c:choose>
	</div>	
</kul:tabTop>
