<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>

<c:set var="roleAttributes" value="${DataDictionary.RoleBo.attributes}" />
<c:set var="roleTypeAttributes" value="${DataDictionary.KimTypeBo.attributes}" />

<kul:tab tabTitle="Overview" defaultOpen="true" transparentBackground="${inquiry}" tabErrorKey="document.role*,document.active">

<div class="tab-container" align="center">
	<table cellpadding="0" cellspacing="0" summary=""> 
	 	<tr>
			<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${roleAttributes.id}" labelFor="document.roleId" /></div></th>
	 		<td><kul:htmlControlAttribute property="document.roleId" attributeEntry="${roleAttributes.id}" readOnly="true" /></td>
    		<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${roleTypeAttributes.name}" labelFor="document.roleTypeName" /></div></th>
	 		<td><kul:htmlControlAttribute property="document.roleTypeName" attributeEntry="${roleTypeAttributes.name}" readOnly="true" /></td>
	 		<html:hidden property="document.roleTypeId" />
	 	</tr>
	 	<tr>
    		<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${roleAttributes.namespaceCode}" labelFor="document.roleNamespace" /></div></th>
	 		<td>
	 			<kul:htmlControlAttribute property="document.roleNamespace" attributeEntry="${roleAttributes.namespaceCode}" readOnly="${readOnly || editingDocument}" onchange="namespaceChanged( this.form );" />
	 			<c:if test="${!inquiry && !readOnly && !editingDocument}">
	 		        <noscript>
	 		   	        <html:image tabindex="0" property="methodToCall.changeNamespace" src="${ConfigProperties.kr.externalizable.images.url}tinybutton-refresh.gif" styleClass="tinybutton" title="Click to refresh the page after changing the namespace." alt="Click to refresh the page after changing the namespace." />
	 		        </noscript>
	 		    </c:if>
	 		</td>
    		<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${roleAttributes.name}" labelFor="document.roleName" /></div></th>
	 		<td><kul:htmlControlAttribute property="document.roleName" attributeEntry="${roleAttributes.name}" readOnly="${readOnly}" /></td>
	 	</tr>
	 	<tr>
			<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${roleAttributes.active}" labelFor="document.active" /></div></th>
	 		<td><kul:htmlControlAttribute property="document.active" attributeEntry="${roleAttributes.active}" readOnly="${readOnly}" /></td>
			<th><div align="right"><kul:htmlAttributeLabel attributeEntry="${roleAttributes.description}" labelFor="document.roleDescription" /></div></th>
	 		<td><kul:htmlControlAttribute property="document.roleDescription" attributeEntry="${roleAttributes.description}" readOnly="${readOnly}" /></td>
	 	</tr>
	</table> 

</div>
</kul:tab>
