<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/kr/WEB-INF/jsp/tldHeader.jsp"%>
<c:set var="showSaveReminder" value="${requestScope.saveReminder}" />
<kul:page headerTitle="Workflow Preferences" lookup="false"
  headerMenuBar="" transactionalDocument="false" showDocumentInfo="false"
  htmlFormAction="Preferences" docTitle="Workflow Preferences" errorKey="*">

<table width="100%" border="0" cellpadding="0" cellspacing="0" class="t3" summary="">
  <tbody>
    <tr>
      <td><img src="images/pixel_clear.gif" alt="" width="12" height="12" class="tl3"></td>
      <td align="right"><img src="images/pixel_clear.gif" alt="" width="12" height="12" class="tr3"></td>
    </tr>
  </tbody>
</table>

<html-el:hidden property="returnMapping"/>
<div id="workarea" >
  <div class="tab-container" align="center">
    <table width="100%" class="datatable-80" align="center" cellspacing="0">
	    <tbody id="G" style="display: none;"></tbody>
        <tbody id="G448" style="display: none;"></tbody>
        <tbody id="G449" style="display: none;"></tbody>
        <tbody id="G2449" style="display: none;"></tbody>
        <tbody id="G55" style="display: none;"></tbody>
        <tbody id="G56" style="display: none;"></tbody>
        <tbody id="G57" style="display: none;"></tbody>
        <tbody id="G58" style="display: none;"></tbody>
        <tbody id="G538" style="display: none;"></tbody>
        <tr>
		  <td colspan="2" class="subhead" >General</td>
	    </tr>
	    <tr>
            <th><div align="right"><label for="preferences.refreshRate">Automatic Refresh Rate:</label></div></th>
          <td class="datacell"><html-el:text property="preferences.refreshRate" styleId="preferences.refreshRate" title="Automatic Refresh Rate" size="3" />
            <kul:checkErrors keyMatch="preferences.refreshRate" />
            <c:if test="${hasErrors}">
              <kul:fieldShowErrorIcon />
            </c:if>
             in whole minutes - 0 is no automatic refresh.</td>
	    </tr>
        <tr>
            <th width="50%"><div align="right"><label for="preferences.pageSize">Action List Page Size</label></div></th>
          <td class="datacell">
            <html-el:text property="preferences.pageSize" styleId="preferences.pageSize" title="Action List Page Size" size="3" />
            <kul:checkErrors keyMatch="preferences.pageSize" />
            <c:if test="${hasErrors}">
              <kul:fieldShowErrorIcon />
            </c:if>
          </td>
        </tr>
        <tr>
            <th width="50%"><div align="right"><label for="preferences.delegatorFilter">Delegator Filter</label></div></th>
          <td class="datacell">
				<html-el:select property="preferences.delegatorFilter" styleId="preferences.delegatorFilter" title="Delegator Filter">
				  <html-el:options collection="delegatorFilter" labelProperty="value" property="key"/>
				</html-el:select>
          </td>
        </tr>
        <tr>
            <th width="50%"><div align="right"><label for="preferences.primaryDelegateFilter">Primary Delegate Filter</label></div></th>
          <td class="datacell">
				<html-el:select property="preferences.primaryDelegateFilter" styleId="preferences.primaryDelegateFilter" title="Primary Delegate Filter">
				  <html-el:options collection="primaryDelegateFilter" labelProperty="value" property="key"/>
				</html-el:select>
          </td>
        </tr>
        <tr>
           <td colspan="2" class="subhead" >Fields Displayed In Action List</td>
        </tr>

        <tr>
            <th ><div align="right"><label for="preferences.showDocType">Document Type</label></div></th>
          <td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.showDocType" styleId="preferences.showDocType" title="Document Type" value="${Constants.PREFERENCES_YES_VAL }"/></td>
        </tr>

        <tr>
          <th ><div align="right"><label for="preferences.showDocTitle">Title</label></div></th>
          <td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.showDocTitle" styleId="preferences.showDocTitle" title="Title" value="${Constants.PREFERENCES_YES_VAL }"/></td>
        </tr>

        <tr>
          <th ><div align="right"><label for="preferences.showActionRequested">Action Requested</label></div></th>
          <td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.showActionRequested" styleId="preferences.showActionRequested" title="Action Requested" value="${Constants.PREFERENCES_YES_VAL }"/></td>
        </tr>

        <tr>
          <th ><div align="right"><label for="preferences.showInitiator">Initiator</label></div></th>
			<td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.showInitiator" styleId="preferences.showInitiator" title="Initiator" value="${Constants.PREFERENCES_YES_VAL }"/>
          </td>
        </tr>

        <tr>
          <th ><div align="right"><label for="preferences.showDelegator">Delegator</label></div></th>
			<td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.showDelegator" styleId="preferences.showDelegator" title="Delegator" value="${Constants.PREFERENCES_YES_VAL }"/>
          </td>
        </tr>

        <tr>
            <th ><div align="right"><label for="preferences.showDateCreated">Date Created</label></div></th>
          <td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.showDateCreated" styleId="preferences.showDateCreated" title="Date Created" value="${Constants.PREFERENCES_YES_VAL }"/>
          </td>
        </tr>
		<tr>
            <th ><div align="right"><label for="preferences.showDateApproved">Date Approved</label></div></th>
          <td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.showDateApproved" styleId="preferences.showDateApproved" title="Date Approved" value="${Constants.PREFERENCES_YES_VAL }"/>
          </td>
        </tr>
        <tr>
            <th ><div align="right"><label for="preferences.showCurrentNode">Current Route Node(s)</label></div></th>
			<td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.showCurrentNode" styleId="preferences.showCurrentNode" title="Current Route Node(s)" value="${Constants.PREFERENCES_YES_VAL }"/>
          		</td>
        </tr>
        <tr>
            <th ><div align="right"><label for="preferences.showWorkgroupRequest">WorkGroup Request</label></div></th>
			<td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.showWorkgroupRequest" styleId="preferences.showWorkgroupRequest" title="WorkGroup Request" value="${Constants.PREFERENCES_YES_VAL }"/>          </td>
        </tr>

        <tr>
            <th ><div align="right"><label for="preferences.showDocumentStatus">Document Route Status</label></div></th>
          <td class="datacell"> <html-el:checkbox styleClass="nobord" property="preferences.showDocumentStatus" styleId="preferences.showDocumentStatus" title="Document Route Status" value="${Constants.PREFERENCES_YES_VAL }"/>          </td>
        </tr>


        <tr>
            <th ><div align="right"><label for="preferences.showClearFyi">Clear FYI</label></div></th>
          <td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.showClearFyi" styleId="preferences.showClearFyi" title="Clear FYI" value="${Constants.PREFERENCES_YES_VAL }"/>
    		</td>
        </tr>

		<c:if test="${KualiForm.showOutbox }">
	        <tr>
                <th ><div align="right"><label for="preferences.useOutbox">Use Outbox</label></div></th>
	          <td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.useOutbox" styleId="preferences.useOutbox" title="Use Outbox" value="${Constants.PREFERENCES_YES_VAL }"/>	          </td>
	        </tr>
        </c:if>

        <tr>
            <td colspan="2" class="subhead"><label>Document Route Status Colors for Actionlist Entries</label></td>
        </tr>
		<tr>
			<th class="thnormal"><div align="right">Saved</div></th>
			<td>
			  <table style="border:none">
			    <tbody><tr>
                  <c:forEach items="${Constants.ACTION_LIST_COLOR_PALETTE}" var="colorType">
		            <td bgcolor='<c:out value="${colorType.value}"/>' style=" border:none; background-color:${colorType.value}"><div align="center"><html-el:radio styleClass="nobord" property="preferences.colorSaved" value="${colorType.key}" title="${colorType.value}"/></div></td>
                  </c:forEach>
				</tr>
			  </tbody>
			 </table>
			</td>
		</tr>

		<tr>
		  <th class="thnormal"><div align="right"><label>Initiated</label></div></th>
		  <td>
		    <table style="border:none">
              <tbody>
			    <tr>
                  <c:forEach items="${Constants.ACTION_LIST_COLOR_PALETTE}" var="colorType">
		            <td bgcolor='<c:out value="${colorType.value}"/>' style=" border:none; background-color:${colorType.value}"><div align="center"><html-el:radio styleClass="nobord" property="preferences.colorInitiated" value="${colorType.key}" title="${colorType.value}"/></div></td>
                  </c:forEach>
			    </tr>
              </tbody>
			</table>
	  	  </td>
		</tr>

		<tr>
		  <th class="thnormal"><div align="right"><label>Disapproved</label></div></th>
		  <td>
			<table style="border:none">
              <tbody>
			    <tr>
                  <c:forEach items="${Constants.ACTION_LIST_COLOR_PALETTE}" var="colorType">
		            <td bgcolor='<c:out value="${colorType.value}"/>' style=" border:none; background-color:${colorType.value}"><div align="center"><html-el:radio  styleClass="nobord" property="preferences.colorDisapproved" value="${colorType.key}" title="${colorType.value}"/></div></td>
                  </c:forEach>
			    </tr>
              </tbody>
		    </table>
	      </td>
		</tr>
		<tr>
			<th class="thnormal"><div align="right"><label>Enroute</label></div></th>
			<td>
			  <table style="border:none">
                <tbody>
			    <tr>
                  <c:forEach items="${Constants.ACTION_LIST_COLOR_PALETTE}" var="colorType">
		            <td bgcolor='<c:out value="${colorType.value}"/>' style=" border:none; background-color:${colorType.value}"><div align="center"><html-el:radio styleClass="nobord" property="preferences.colorEnroute" value="${colorType.key}" title="${colorType.value}"/></div></td>
                  </c:forEach>
				</tr>
                </tbody>
			  </table>
			</td>
		</tr>
		<tr>
			<th class="thnormal"><div align="right"><label>Approved</label></div></th>
			<td>
			  <table style="border:none">
                <tbody>
			    <tr>
                  <c:forEach items="${Constants.ACTION_LIST_COLOR_PALETTE}" var="colorType">
		            <td bgcolor='<c:out value="${colorType.value}"/>' style=" border:none; background-color:${colorType.value}"><div align="center"><html-el:radio styleClass="nobord" property="preferences.colorApproved" value="${colorType.key}" title="${colorType.value}"/></div></td>
                  </c:forEach>
				</tr>
                </tbody>
			  </table>
			</td>
		</tr>
		<tr>
			<th class="thnormal"><div align="right"><label>Final</label></div></th>
			<td>
			  <table style="border:none">
                <tbody>
			    <tr>
                  <c:forEach items="${Constants.ACTION_LIST_COLOR_PALETTE}" var="colorType">
		            <td bgcolor='<c:out value="${colorType.value}"/>' style=" border:none; background-color:${colorType.value}"><div align="center"><html-el:radio styleClass="nobord" property="preferences.colorFinal" value="${colorType.key}" title="${colorType.value}"/></div></td>
                  </c:forEach>
				</tr>
                </tbody>
			  </table>
			</td>
		</tr>
		<tr>
			<th class="thnormal"><div align="right"><label>Processed</label></div></th>
			<td>
			  <table style="border:none">
                <tbody>
			    <tr>
                  <c:forEach items="${Constants.ACTION_LIST_COLOR_PALETTE}" var="colorType">
		            <td bgcolor='<c:out value="${colorType.value}"/>' style=" border:none; background-color:${colorType.value}"><div align="center"><html-el:radio styleClass="nobord" property="preferences.colorProcessed" value="${colorType.key}" title="${colorType.value}"/></div></td>
                  </c:forEach>
				</tr>
                </tbody>
			  </table>
			</td>
		</tr>
		<tr>
			<th class="thnormal"><div align="right"><label>Exception</label></div></th>
			<td>
			  <table style="border:none">
                <tbody>
			    <tr>
                  <c:forEach items="${Constants.ACTION_LIST_COLOR_PALETTE}" var="colorType">
		            <td bgcolor='<c:out value="${colorType.value}"/>' style=" border:none; background-color:${colorType.value}"><div align="center"><html-el:radio styleClass="nobord" property="preferences.colorException" value="${colorType.key}" title="${colorType.value}"/></div></td>
                  </c:forEach>
				</tr>
                </tbody>
			  </table>
			</td>
		</tr>
		<tr>
			<th class="thnormal"><div align="right"><label>Canceled</label></div></th>
			<td>
			  <table style="border:none">
                <tbody>
			    <tr>
                  <c:forEach items="${Constants.ACTION_LIST_COLOR_PALETTE}" var="colorType">
		            <td bgcolor='<c:out value="${colorType.value}"/>' style=" border:none; background-color:${colorType.value}"><div align="center"><html-el:radio styleClass="nobord" property="preferences.colorCanceled" value="${colorType.key}" title="${colorType.value}"/></div></td>
                  </c:forEach>
				</tr>
                </tbody>
			  </table>
			</td>
		</tr>
		<tr>
			<td colspan="2" class="subhead">Email Notification Preferences</td>
		</tr>
		<tr>
            <th><div align="right"><label for="preferences.notifyPrimaryDelegation">Receive Primary Delegate Emails</label></div></th>
          <td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.notifyPrimaryDelegation" styleId="preferences.notifyPrimaryDelegation" title="Receive Primary Delegate Emails" value="${Constants.PREFERENCES_YES_VAL}"/></td>
        </tr>
        <tr>
            <th><div align="right"><label for="preferences.notifySecondaryDelegation">Receive Secondary Delegate Emails</label></div></th>
           <td class="datacell"><html-el:checkbox styleClass="nobord" property="preferences.notifySecondaryDelegation" styleId="preferences.notifySecondaryDelegation" title="Receive Secondary Delegate Emails" value="${Constants.PREFERENCES_YES_VAL}"/></td>
        </tr>
		<tr>
            <th><div align="right"><label for="preferences.emailNotification">Default Email Notification</label></div></th>
          <td class="datacell">
            <html-el:select property="preferences.emailNotification" styleId="preferences.emailNotification" title="Default Email Notification">
              <html-el:option value="${Constants.EMAIL_RMNDR_NO_VAL}">None</html-el:option>
              <html-el:option value="${Constants.EMAIL_RMNDR_DAY_VAL}">Daily</html-el:option>
              <html-el:option value="${Constants.EMAIL_RMNDR_WEEK_VAL}">Weekly</html-el:option>
              <html-el:option value="${Constants.EMAIL_RMNDR_IMMEDIATE}">Immediate</html-el:option>
            </html-el:select>
          </td>
        </tr>
        <tr>
          <th><div align="right">Document Type Notifications</div></th>
          <td class="datacell">
            <c:if test="${showSaveReminder}">
            <div style="color: red; font-weight: bold;"><bean:message key="docType.preference.save.reminder" /></div>
            </c:if>
            <table>
              <tr>
                  <th><label for="documentTypePreferenceName">Document Type</label></th>
                  <th><label for="documentTypePreferenceValue">Notification Preference</label></th>
                <th><label>Actions</label></th>
              </tr>
              <logic:iterate name="KualiForm" property="preferences.documentTypeNotificationPreferences" id="entry" indexId="status">
              <tr>
                <td>
                  <c:set var="documentType"><bean:write name="entry" property="key" /></c:set>
                  ${documentType}
                  <html-el:hidden name="KualiForm" property="preferences.documentTypeNotificationPreference(${fn:replace(documentType, '.', Constants.DOCUMENT_TYPE_NOTIFICATION_DELIMITER)})" />
                </td>
                <td>
                  <c:set var="preferenceValue"><bean:write name="entry" property="value" /></c:set>
                  <c:choose>
                  	<c:when test="${preferenceValue == Constants.EMAIL_RMNDR_NO_VAL}">None</c:when>
                  	<c:when test="${preferenceValue == Constants.EMAIL_RMNDR_DAY_VAL}">Daily</c:when>
                  	<c:when test="${preferenceValue == Constants.EMAIL_RMNDR_WEEK_VAL}">Weekly</c:when>
                  	<c:when test="${preferenceValue == Constants.EMAIL_RMNDR_IMMEDIATE}">Immediate</c:when>
                  </c:choose>
                </td>
                <td>
                    <kul:kualiButton property="methodToCall.deleteNotificationPreference.${documentType}"
                                     src="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete1.gif"
                                     disabledSrc="${ConfigProperties.kr.externalizable.images.url}tinybutton-delete2.gif"
                                     label="Delete" title="Delete Notification Preference" styleClass="tinybutton small outline" />
                </td>
              </tr>
              </logic:iterate>
              <tr>
                <td>
                  <html-el:text name="KualiForm" property="documentTypePreferenceName" styleId="documentTypePreferenceName" title="Document Type"/>
                  <kul:checkErrors keyMatch="documentTypePreferenceName" />
            	  <c:if test="${hasErrors}">
                    <br/><kul:fieldShowErrorIcon />
            	  </c:if>
            	  <kul:lookup boClassName="org.kuali.rice.kew.doctype.bo.DocumentType" fieldConversions="name:documentTypePreferenceName"/>
                </td>
                <td>
                  <html-el:select name="KualiForm" property="documentTypePreferenceValue" styleId="documentTypePreferenceValue" title="Notification Preference">
                    <html-el:option value="${Constants.EMAIL_RMNDR_NO_VAL}">None</html-el:option>
                    <html-el:option value="${Constants.EMAIL_RMNDR_DAY_VAL}">Daily</html-el:option>
                    <html-el:option value="${Constants.EMAIL_RMNDR_WEEK_VAL}">Weekly</html-el:option>
                    <html-el:option value="${Constants.EMAIL_RMNDR_IMMEDIATE}">Immediate</html-el:option>
                  </html-el:select>
                </td>
                <td>
                  <kul:kualiButton property="methodToCall.addNotificationPreference"
                                   src="${ConfigProperties.kr.externalizable.images.url}tinybutton-add1.gif"
                                   label="Add" title="Add Notification Preference" styleClass="tinybutton small outline"/>
                </td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
            <th><div align="right"><label>Send Email Notifications For</label></div></th>
          <td class="datacell">
            <ul style="padding-left: 0;">
              <li style="list-style-type: none;"><html-el:checkbox styleClass="nobord" property="preferences.notifyComplete" styleId="preferences.notifyComplete" title="Complete" value="${Constants.PREFERENCES_YES_VAL}"/><label for="preferences.notifyComplete">Complete</label></li>
              <li style="list-style-type: none;"><html-el:checkbox styleClass="nobord" property="preferences.notifyApprove" styleId="preferences.notifyApprove" title="Approve" value="${Constants.PREFERENCES_YES_VAL}"/><label for="preferences.notifyApprove">Approve</label></li>
              <li style="list-style-type: none;"><html-el:checkbox styleClass="nobord" property="preferences.notifyAcknowledge" styleId="preferences.notifyAcknowledge" title="Acknowledge" value="${Constants.PREFERENCES_YES_VAL}"/><label for="preferences.notifyAcknowledge">Acknowledge</label></li>
              <li style="list-style-type: none;"><html-el:checkbox styleClass="nobord" property="preferences.notifyFYI" styleId="preferences.notifyFYI" title="FYI" value="${Constants.PREFERENCES_YES_VAL}"/><label for="preferences.notifyFYI">FYI</label></li>
            </ul>
          </td>
        </tr>
	  </table>
    </div><!-- End tab-container -->
    <table width="100%" border="0" cellpadding="0" cellspacing="0" class="b3" summary="">
      <tr>
        <td align="left" class="footer"><img src="images/pixel_clear.gif" alt="" width="12" height="14" class="bl3"></td>
        <td align="right" class="footer-right"><img src="images/pixel_clear.gif" alt="" width="12" height="14" class="br3"></td>
      </tr>
    </table>
	<div class="globalbuttons">
	    <html-el:hidden property="backLocation" />
        <kul:kualiButton label="Save" src="images/buttonsmall_save.gif" property="methodToCall.save" styleClass="no-border" />
        <kul:kualiButton label="Reset" src="images/buttonsmall_reset.gif" property="reset" onclick="document.forms[0].reset(); return false;" styleClass="no-border" />
        <kul:kualiButton label="Cancel" src="images/buttonsmall_cancel.gif" property="cancel" onclick="window.location = 'ActionList.do?methodToCall=start'; return false;" styleClass="no-border" />
    </div>
  </div> <!-- End workarea -->
</kul:page>
