<#--
 #%L
 %%
 Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#macro uif_numberedPager element>

    <@krad.wrap component=element renderAs="ul">
        <#if element.currentPage == 1>
            <#local prevClass="class='disabled'"/>
        </#if>

        <#if element.renderFirstLast>
            <li ${prevClass!}>
                <a data-onclick="${element.linkScript}" data-num="first" class="uif-pageFirst"
                   href="#" data-role="Action">${element.firstText}</a>
            </li>
        </#if>

        <#if element.renderPrevNext>
            <li ${prevClass!}>
                <a data-onclick="${element.linkScript}" data-num="prev" class="uif-pagePrev"
                   href="#" data-role="Action">${element.prevText}</a>
            </li>
        </#if>

        <#list element.pagesStart..element.pagesEnd as pageNum>
            <#local liClass=""/>
            <#if element.currentPage == pageNum>
                <#local liClass="class='active'"/>
            </#if>

            <li ${liClass!}>
                <a data-onclick="${element.linkScript}" data-num="${pageNum}"
                   href="#" data-role="Action">${pageNum}</a>
            </li>
        </#list>

        <#if element.currentPage == element.numberOfPages>
            <#local nextClass="class='disabled'"/>
        </#if>

        <#if element.renderPrevNext>
            <li ${nextClass!}>
                <a data-onclick="${element.linkScript}" data-num="next" class="uif-pageNext"
                   href="#" data-role="Action">${element.nextText}</a>
            </li>
        </#if>

        <#if element.renderFirstLast>
            <li ${nextClass!}>
                <a data-onclick="${element.linkScript}" data-num="last" class="uif-pageLast"
                   href="#" data-role="Action">${element.lastText}</a>
            </li>
        </#if>
    </@krad.wrap>

</#macro>
