/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

var Kc = Kc || {};
Kc.Wizard = Kc.Wizard || {};
(function(namespace, $) {

    namespace.returnToFirstResultsPage = function() {
        $('.modal-body').find('a.first').click();
    };

    namespace.submitOnEnter = function(event, inputField) {
        if (event && event.keyCode === 13) {
            if ($(inputField).find('input').val()) {
                $('.modal-footer[data-parent="PropDev-PersonnelPage-Wizard"]').find('button.btn-primary').click();
            }
        }
    }
    namespace.focusableElementsString = 'a[href], area[href], input:not([disabled]), select:not([disabled]), textarea:not([disabled]), button:not([disabled]), iframe, object, embed, [tabindex="0"], [contenteditable]';

    namespace.focusOnFirstElement = function(modal) {
    	var focusableItems = $(modal).find(namespace.focusableElementsString)
    	focusableItems.first().focus()
    }
       
    var priorFocusItem = {}
    namespace.handleWizardOpen = function(modal) {
    	priorFocusItem[$(modal).attr('id')] = document.activeElement
    	var focusableItems = $(modal).find(namespace.focusableElementsString)
    	var firstTabStop = focusableItems.first().get(0)
    	var lastTabStop = focusableItems.last().get(0)
    	$(modal).on(kradVariables.EVENTS.UPDATE_CONTENT, function () {
    		namespace.focusOnFirstElement(this)
    		focusableItems = $(modal).find(namespace.focusableElementsString)
        	firstTabStop = focusableItems.first().get(0)
        	lastTabStop = focusableItems.last().get(0)
    	})
    	modal.addEventListener('keydown', function (e) {
    	    if (e.keyCode === 9) { //TAB
    	      if (e.shiftKey) {
    	        if (document.activeElement === firstTabStop) {
    	          e.preventDefault();
    	          lastTabStop.focus();
    	        }
    	
    	      // TAB
    	      } else {
    	        if (document.activeElement === lastTabStop) {
    	          e.preventDefault();
    	          firstTabStop.focus();
    	        }
    	      }
    	    }    	
    	})
    	namespace.focusOnFirstElement(modal)
    }
    namespace.handleWizardClose = function(modal) {
    	var priorElement = priorFocusItem[$(modal).attr('id')]
    	if (priorElement) {
    		priorElement.focus()
    		delete priorFocusItem[$(modal).attr('id')]
    	}
    }
})(Kc.Wizard, jQuery);

