<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="/WEB-INF/jsp/kraTldHeader.jsp"%>
<script>
  //have jquery give up $ so dwr code used within this tag can have it
  $.noConflict();
</script>
<%@ attribute name="index" description="Index" required="true" %>
<%@ attribute name="reportClassKey" description="Report Class Key" required="true" %>
<%@ attribute name="reportClassLabel" description="Report Class Key" required="true" %>
<%@ attribute name="reportCodeLabel" description="This string will be displayed above the report code select box" required="true" %>
<%@ attribute name="defaultOpenForTab" description="Default Open For Tab" required="false" %>
<%@ attribute name="noShowHideButton" description="Do not show show hide button in the following inner tab" required="false" %>

<c:set var="awardReportTermAttributes" value="${DataDictionary.AwardReportTerm.attributes}" />

<jsp:useBean id="paramMap1" class="java.util.HashMap"/>
<jsp:useBean id="paramMap2" class="java.util.HashMap"/>
<jsp:useBean id="paramMap3" class="java.util.HashMap"/>
<c:set target="${paramMap1}" property="reportClassCode" value="${reportClassKey}" />
<c:set target="${paramMap2}" property="reportClassCode" value="${reportClassKey}" />

<%-- Cache option values based on their keys for reuse throughout the request --%>
<jsp:useBean id="reportClassCodeValues" class="java.util.HashMap" scope="request"/>
<c:if test="${!reportClassCodeValues.containsKey(reportClassKey)}">
	<c:set target="${reportClassCodeValues}" property="${reportClassKey}" value="${krafn:getOptionList('org.kuali.kra.award.lookup.keyvalue.ReportCodeValuesFinder', paramMap1)}" />
</c:if>
<jsp:useBean id="frequencyCodeValues" class="java.util.HashMap" scope="request"/>
<jsp:useBean id="frequencyBaseCodeValues" class="java.util.HashMap" scope="request"/>

<%-- The logic in the updateBaseDateDisplay function is duplicated in ReportTrackingServiceImpl.calculateBaseDate.
If you update one, please update the other. --%>
<script>
jQuery().ready(function() {
	jQuery("select[name$='frequencyBaseCode']").each(function(i) {updateBaseDateDisplay(jQuery(this))});
});
function updateBaseDateDisplay(selectBox) {
	var defaultBaseDate = "MM/DD/YYYY";
	var baseDate = defaultBaseDate;
	if (jQuery(selectBox).val() == 1) {
		baseDate = "<fmt:formatDate value='${KualiForm.document.award.awardExecutionDate}' pattern='MM/dd/yyyy' />";
	} else if (jQuery(selectBox).val() == 2) {
		baseDate = "<fmt:formatDate value='${KualiForm.document.award.awardEffectiveDate}' pattern='MM/dd/yyyy' />";
	} else if (jQuery(selectBox).val() == 3) {
		baseDate = "<fmt:formatDate value='${KualiForm.document.award.lastAwardAmountInfo.obligationExpirationDate}' pattern='MM/dd/yyyy' />";
	} else if (jQuery(selectBox).val() == 4) {
		baseDate = "<fmt:formatDate value='${KualiForm.document.award.lastAwardAmountInfo.finalExpirationDate}' pattern='MM/dd/yyyy' />";
	} else if (jQuery(selectBox).val() == 5) {
		baseDate = "<fmt:formatDate value='${KualiForm.document.award.lastAwardAmountInfo.currentFundEffectiveDate}' pattern='MM/dd/yyyy' />";
	} else if (jQuery(selectBox).val() == 6) {
		baseDate = "As Required";
	}
	if (baseDate.length < 1) {
		baseDate = "Unavailable";
	}
	jQuery(selectBox).parent().find("div.baseDateDisplay span").html(baseDate);
}
</script>

<c:set var="tabErrorKeyString" value=""  />
<c:set var="tabItemCount" value="0"  />
<c:set var="readOnly" value="${not KualiForm.canEditAwardReportClass(reportClassKey)}" scope="request" />
<c:forEach var="awardReportTerm" items="${KualiForm.document.award.awardReportTermItems}" varStatus="status">        		 
    <c:if test="${awardReportTerm.reportClassCode == reportClassKey }" >
    		<c:set var="tabItemCount" value="${tabItemCount+1}"  />
        	<c:choose>
        	    <c:when test="${empty tabErrorKeyString}" >	            	
                    <c:set var="tabErrorKeyString" value="document.awardList[0].awardReportTermItems[${status.index}].reportCode,document.awardList[0].awardReportTermItems[${status.index}].frequencyCode,document.awardList[0].awardReportTermItems[${status.index}].frequencyBaseCode,document.awardList[0].awardReportTermItems[${status.index}].ospDistributionCode,document.awardList[0].awardReportTermItems[${status.index}].dueDate"  />
                </c:when>
                <c:otherwise >
                     <c:set var="tabErrorKeyString" value="${tabErrorKeyString},document.awardList[0].awardReportTermItems[${status.index}].reportCode,document.awardList[0].awardReportTermItems[${status.index}].frequencyCode,document.awardList[0].awardReportTermItems[${status.index}].frequencyBaseCode,document.awardList[0].awardReportTermItems[${status.index}].ospDistributionCode,document.awardList[0].awardReportTermItems[${status.index}].dueDate"  />
                 </c:otherwise>
             </c:choose>
    </c:if>
</c:forEach>

<c:if test="${empty defaultOpenForTab}">
	<c:set var="defaultOpenForTab" value="false" />
</c:if>

<c:if test="${empty noShowHideButton}">
	<c:set var="noShowHideButton" value="false" />
</c:if>

<kul:innerTab parentTab="Report Classes" tabItemCount="${tabItemCount}" defaultOpen="${defaultOpenForTab}" tabTitle="${reportClassLabel}" tabErrorKey="awardReportsBean.newAwardReportTerms[${index}]*,${tabErrorKeyString}" noShowHideButton="${noShowHideButton}" >
    <table border="0" cellpadding="0" cellspacing="0" summary="">
        <tr>
            <th width="6%"><div align="center">&nbsp;</div></th>          	
            <%-- The label for the first row is read from ${reportCodeLabel}, all others are htmlAttributeLabels --%>
          	<th width="18%"><div align="center">${reportCodeLabel}</div></th>
          	<th width="18%"><div align="center"><kul:htmlAttributeLabel attributeEntry="${awardReportTermAttributes.frequencyCode}" noColon="true" /></div></th>
          	<th width="18%"><div align="center"><kul:htmlAttributeLabel attributeEntry="${awardReportTermAttributes.frequencyBaseCode}" noColon="true" /></div></th>
          	<th width="18%"><div align="center"><kul:htmlAttributeLabel attributeEntry="${awardReportTermAttributes.ospDistributionCode}" noColon="true" /></div></th>
          	<th width="18%"><div align="center"><kul:htmlAttributeLabel attributeEntry="${awardReportTermAttributes.dueDate}" noColon="true" /></div></th>
          	<kul:htmlAttributeHeaderCell literalLabel="Action" scope="col"/>
        </tr>
        <c:if test="${!readOnly}">
        <tbody class="addline">
        <tr>        	
		    <th width="6%" class="infoline">
			    <c:out value="Add:" />
			</th>
            <td nowrap width="5%" valign="middle" class="infoline">

            <div align="center">                        
                <html:select property="awardReportsBean.newAwardReportTerms[${index}].reportCode" tabindex="0" styleId="awardReportsBean.newAwardReportTerms[${index}].reportCode" title="${reportCodeLabel}"
                onchange="javascript: loadFrequencyCode('${reportClassKey}', 'awardReportsBean.newAwardReportTerms[${index}].reportCode','awardReportsBean.newAwardReportTerms[${index}].frequencyCode');return false" >                                              
                <c:forEach items="${reportClassCodeValues[reportClassKey]}" var="option">
	                <c:choose>                    	
	                	<c:when test="${KualiForm.awardReportsBean.newAwardReportTerms[index].reportCode == option.key}">
	                        <option value="${option.key}" selected>${option.value}</option>
	                    </c:when>
	                    <c:otherwise>
	                        <c:out value="${option.value}"/>
	                        <option value="${option.key}">${option.value}</option>
	                    </c:otherwise>
	                </c:choose>         
	            </c:forEach>
	            </html:select>
                <kul:checkErrors keyMatch="awardReportsBean.newAwardReportTerms[${index}].reportCode" auditMatch="awardReportsBean.newAwardReportTerms[${index}].reportCode"/>
                <c:if test="${hasErrors}">
                    <kul:fieldShowErrorIcon />
                </c:if>
	            <html:image property="methodToCall.refreshPulldownOptions" styleClass="tinybutton" 
	            	src='${ConfigProperties.kra.externalizable.images.url}arrow_refresh.png'/>
            </div>
			</td>
			<c:set target="${paramMap2}" property="reportCode" value="${KualiForm.awardReportsBean.newAwardReportTerms[index].reportCode}" />
			<c:set var="frequencyCodeKey" value="${reportClassKey}~${paramMap2.reportCode}" />
			<c:if test="${!frequencyCodeValues.containsKey(frequencyCodeKey)}">
				<c:set target="${frequencyCodeValues}" property="${frequencyCodeKey}" value="${krafn:getOptionList('org.kuali.kra.award.lookup.keyvalue.FrequencyCodeValuesFinder', paramMap2)}" />
			</c:if>
            <td nowrap width="5%" valign="middle" class="infoline">
            <div align="center">                
                <html:select property="awardReportsBean.newAwardReportTerms[${index}].frequencyCode" tabindex="0" styleId="awardReportsBean.newAwardReportTerms[${index}].frequencyCode" title="${awardReportTermAttributes.frequencyCode.label}"
                onchange="javascript: loadFrequencyBaseCode('awardReportsBean.newAwardReportTerms[${index}].frequencyCode','awardReportsBean.newAwardReportTerms[${index}].frequencyBaseCode');return false" >                
                <c:forEach items="${frequencyCodeValues[frequencyCodeKey]}" var="option">
	                <c:choose>                    	
	                	<c:when test="${KualiForm.awardReportsBean.newAwardReportTerms[index].frequencyCode == option.key}">
	                        <option value="${option.key}" selected>${option.value}</option>
	                    </c:when>
	                    <c:otherwise>
	                        <c:out value="${option.value}"/>
	                        <option value="${option.key}">${option.value}</option>
	                    </c:otherwise>
	                </c:choose>         
	            </c:forEach>
	            </html:select>
                <kul:checkErrors keyMatch="awardReportsBean.newAwardReportTerms[${index}].frequencyCode" auditMatch="awardReportsBean.newAwardReportTerms[${index}].frequencyCode"/>
                <c:if test="${hasErrors}">
                    <kul:fieldShowErrorIcon />
                </c:if>
	            <html:image property="methodToCall.refreshPulldownOptions" styleClass="tinybutton" 
	            	src='${ConfigProperties.kra.externalizable.images.url}arrow_refresh.png'/>	            	
            </div>
			</td>
            <td nowrap width="5%" valign="middle" class="infoline">
            <c:set target="${paramMap3}" property="frequencyCode" value="${KualiForm.awardReportsBean.newAwardReportTerms[index].frequencyCode}" />
			<c:set var="frequencyBaseCodeKey" value="~${paramMap3.frequencyCode}~" />
			<c:if test="${!frequencyBaseCodeValues.containsKey(frequencyBaseCodeKey)}">
				<c:set target="${frequencyBaseCodeValues}" property="${frequencyBaseCodeKey}" value="${krafn:getOptionList('org.kuali.kra.award.lookup.keyvalue.FrequencyBaseCodeValuesFinder', paramMap3)}" />
			</c:if>
            <div align="center">
                <html:select property="awardReportsBean.newAwardReportTerms[${index}].frequencyBaseCode" styleId="awardReportsBean.newAwardReportTerms[${index}].frequencyBaseCode" title="${awardReportTermAttributes.frequencyBaseCode.label}" tabindex="0" onchange="updateBaseDateDisplay(this);">
                <c:forEach items="${frequencyBaseCodeValues[frequencyBaseCodeKey]}" var="option">
	                <c:choose>                    	
	                	<c:when test="${KualiForm.awardReportsBean.newAwardReportTerms[index].frequencyBaseCode == option.key}">
	                        <option value="${option.key}" selected>${option.value}</option>
	                    </c:when>
	                    <c:otherwise>
	                        <c:out value="${option.value}"/>
	                        <option value="${option.key}">${option.value}</option>
	                    </c:otherwise>
	                </c:choose>         
	            </c:forEach>
	            </html:select>
                <kul:checkErrors keyMatch="awardReportsBean.newAwardReportTerms[${index}].frequencyBaseCode" auditMatch="awardReportsBean.newAwardReportTerms[${index}].frequencyBaseCode"/>
                <c:if test="${hasErrors}">
                    <kul:fieldShowErrorIcon />
                </c:if>
				<div class="baseDateDisplay fineprint">Base Date: <span>MM/DD/YYYY</span></div>                
            </div>
			</td>
            <td nowrap width="5%" valign="middle" class="infoline">
            <div align="center">
                <kul:htmlControlAttribute property="awardReportsBean.newAwardReportTerms[${index}].ospDistributionCode" attributeEntry="${awardReportTermAttributes.ospDistributionCode}" />
            </div>
			</td>                
            <td nowrap width="13%" valign="middle" class="infoline">
            <div align="center">
                <kul:htmlControlAttribute property="awardReportsBean.newAwardReportTerms[${index}].dueDate" attributeEntry="${awardReportTermAttributes.dueDate}"  />
            </div>
			</td>                
			<td class="infoline">
			<div align="center">
			    <html:image property="methodToCall.addAwardReportTerm.reportClass${reportClassKey}.reportClassIndex${index}.anchor${tabKey}"
			        src='${ConfigProperties.kra.externalizable.images.url}tinybutton-add1.gif' styleClass="tinybutton addButton"/>
			</div>
            </td>
        </tr>  
        </tbody>
        </c:if>      

        <c:forEach var="awardReportTerm" items="${krafn:copy(KualiForm.document.award.awardReportTermItems)}" varStatus="status">
	        <c:if test="${awardReportTerm.reportClassCode == reportClassKey }" >
	        <c:set var="counterReport" value="${counterReport + 1}" />
	    <tr>
		    <th width="5%" class="infoline" rowspan="2">
			    <c:out value="${counterReport}" />
			</th>			                
	        <td nowrap width="5%" valign="middle">	        
			<div align="center">
				<kul:checkErrors keyMatch="document.awardList[0].awardReportTermItems[${status.index}].reportCode" auditMatch="${property}"/>				
				<c:if test="${hasErrors==true}" >
    				<c:set var="textStyle" value="background-color:#FFD5D5"/>
  				</c:if>                
                <html:select property="document.awardList[0].awardReportTermItems[${status.index}].reportCode" styleId="document.awardList[0].awardReportTermItems[${status.index}].reportCode" title="${awardReportTermAttributes.reportCode.label}" tabindex="0" style="${textStyle}"
                             onchange="javascript: loadFrequencyCode('${reportClassKey}', 'document.awardList[0].awardReportTermItems[${status.index}].reportCode','document.awardList[0].awardReportTermItems[${status.index}].frequencyCode');return false" disabled="${readOnly}">                                             
                <c:forEach items="${reportClassCodeValues[reportClassKey]}" var="option">
	                <c:choose>                    	
	                	<c:when test="${KualiForm.document.awardList[0].awardReportTermItems[status.index].reportCode == option.key}">
	                        <option value="${option.key}" selected>${option.value}</option>
	                    </c:when>
	                    <c:otherwise>
	                        <c:out value="${option.value}"/>
	                        <option value="${option.key}">${option.value}</option>
	                    </c:otherwise>
	                </c:choose>                    
	            </c:forEach>
	            </html:select>
	            <html:image property="methodToCall.refreshPulldownOptions" styleClass="tinybutton" 
	            	src='${ConfigProperties.kra.externalizable.images.url}arrow_refresh.png'/>
	            <c:set var="textStyle" value=""/>
			</div>
			</td>
			<c:set target="${paramMap2}" property="reportCode" value="${KualiForm.document.awardList[0].awardReportTermItems[status.index].reportCode}" />
			<c:set var="frequencyCodeKey" value="${reportClassKey}~${paramMap2.reportCode}" />
			<c:if test="${!frequencyCodeValues.containsKey(frequencyCodeKey)}">
				<c:set target="${frequencyCodeValues}" property="${frequencyCodeKey}" value="${krafn:getOptionList('org.kuali.kra.award.lookup.keyvalue.FrequencyCodeValuesFinder', paramMap2)}" />
			</c:if>
	        <td nowrap width="5%" valign="middle">
			<div align="center">
				<kul:checkErrors keyMatch="document.awardList[0].awardReportTermItems[${status.index}].frequencyCode" auditMatch="${property}"/>				
				<c:if test="${hasErrors==true}" >
    				<c:set var="textStyle" value="background-color:#FFD5D5"/>
  				</c:if> 
                <html:select property="document.awardList[0].awardReportTermItems[${status.index}].frequencyCode" styleId="document.awardList[0].awardReportTermItems[${status.index}].frequencyCode" title="${awardReportTermAttributes.frequencyCode.label}" tabindex="0" style="${textStyle}"
                	onchange="javascript: loadFrequencyBaseCode('document.awardList[0].awardReportTermItems[${status.index}].frequencyCode','document.awardList[0].awardReportTermItems[${status.index}].frequencyBaseCode');return false" disabled="${readOnly}">                
                <c:forEach items="${frequencyCodeValues[frequencyCodeKey]}" var="option">
	                <c:choose>                    	
	                	<c:when test="${KualiForm.document.awardList[0].awardReportTermItems[status.index].frequencyCode == option.key}">
	                        <option value="${option.key}" selected>${option.value}</option>
	                    </c:when>
	                    <c:otherwise>
	                        <c:out value="${option.value}"/>
	                        <option value="${option.key}">${option.value}</option>
	                    </c:otherwise>
	                </c:choose>                    
	            </c:forEach>
	            </html:select>
	            <html:image property="methodToCall.refreshPulldownOptions" styleClass="tinybutton" 
	            	src='${ConfigProperties.kra.externalizable.images.url}arrow_refresh.png'/>
	            <c:set var="textStyle" value=""/>
			</div>
			</td>
			<c:set target="${paramMap3}" property="frequencyCode" value="${KualiForm.document.awardList[0].awardReportTermItems[status.index].frequencyCode}" />
			<c:set var="frequencyBaseCodeKey" value="~${paramMap3.frequencyCode}~" />
			<c:if test="${!frequencyBaseCodeValues.containsKey(frequencyBaseCodeKey)}">
				<c:set target="${frequencyBaseCodeValues}" property="${frequencyBaseCodeKey}" value="${krafn:getOptionList('org.kuali.kra.award.lookup.keyvalue.FrequencyBaseCodeValuesFinder', paramMap3)}" />
			</c:if>
	        <td nowrap width="5%" valign="middle">
			<div align="center">
				<kul:checkErrors keyMatch="document.awardList[0].awardReportTermItems[${status.index}].frequencyBaseCode" auditMatch="${property}"/>				
				<c:if test="${hasErrors==true}" >
    				<c:set var="textStyle" value="background-color:#FFD5D5"/>
  				</c:if>                 
                <html:select property="document.awardList[0].awardReportTermItems[${status.index}].frequencyBaseCode" styleId="document.awardList[0].awardReportTermItems[${status.index}].frequencyBaseCode" title="${awardReportTermAttributes.frequencyBaseCode.label}" tabindex="0" style="${textStyle}" disabled="${readOnly}" onchange="updateBaseDateDisplay(this);">
                <c:forEach items="${frequencyBaseCodeValues[frequencyBaseCodeKey]}" var="option">
	                <c:choose>                    	
	                	<c:when test="${KualiForm.document.awardList[0].awardReportTermItems[status.index].frequencyBaseCode == option.key}">
	                        <option value="${option.key}" selected>${option.value}</option>
	                    </c:when>
	                    <c:otherwise>
	                        <c:out value="${option.value}"/>
	                        <option value="${option.key}">${option.value}</option>
	                    </c:otherwise>
	                </c:choose>         
	            </c:forEach>
	            </html:select>
	            <c:set var="textStyle" value=""/>
	            <div class="baseDateDisplay fineprint">Base Date: <span>MM/DD/YYYY</span></div>
			</div>
			</td>
	        <td nowrap width="13%" valign="middle">
			<div align="center">
                <kul:htmlControlAttribute property="document.awardList[0].awardReportTermItems[${status.index}].ospDistributionCode" attributeEntry="${awardReportTermAttributes.ospDistributionCode}" />
			</div>
			</td>	                
	        <td nowrap width="10%" valign="middle">
			<div align="center">
                <kul:htmlControlAttribute property="document.awardList[0].awardReportTermItems[${status.index}].dueDate" attributeEntry="${awardReportTermAttributes.dueDate}"  />
			</div>
			</td>
			</td>
			<td valign="middle">
			<div align="center">
			 <c:if test="${!readOnly}">
			    <html:image property="methodToCall.deleteAwardReportTerm.line${status.index}.anchor${currentTabIndex}"
			        src='${ConfigProperties.kra.externalizable.images.url}tinybutton-delete1.gif' styleClass="tinybutton"/>
				<c:if test="${KualiForm.syncMode}">
					<html:image property="methodToCall.syncAwardReportTerm.line${status.index}.anchor${currentTabIndex}"
						src='${ConfigProperties.kra.externalizable.images.url}tinybutton-sync.gif' alt="sync" styleClass="tinybutton" disabled="${readOnly}"/>
				</c:if>
			 </c:if>
			 <c:if test="${readOnly}">&nbsp;</c:if>
			</div>            
			</td>
	    </tr>
	    <tr>
	        <td colspan="6">
	            ${KualiForm.valueFinderResultCache}
	            <kra-a:awardReportRecipients innerTabParent="${reportClassLabel}" index="${status.index}" />
	        	${KualiForm.valueFinderResultDoNotCache}
	            <c:if test="${KualiForm.reportClassForPaymentsAndInvoices.reportClassCode != reportClassKey}" >
	            	<kra-a:reportTracking innerTabParent="${reportClassLabel}" index="${status.index}" reportClassKey="${reportClassKey}" />
	            </c:if>		    
	        </td>
	    </tr>
	    	</c:if>                   	
	    </c:forEach> 
    </table>
</kul:innerTab>	
