<%--
  #%L
  %%
  Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
  %%
  You may use and modify this code under the terms of the Kuali, Inc.
  Pre-Release License Agreement. You may not distribute it.
  
  You should have received a copy of the Kuali, Inc. Pre-Release License
  Agreement with this file. If not, please write to license@kuali.co.
  #L%
  --%>

<%@ include file="../Include.jsp"%>

<select id="channelName" name="channelName">
    <option value="___NONE___">None</option>
    <c:forEach var="channel" items="${channels}">
        <c:choose>
            <c:when test="${f:length(channel.subscriptions) == 1}">
                <c:set var="subscribers" value="1 subscriber"/>
            </c:when>
            <c:otherwise>
                <c:set var="subscribers" value="${f:length(channel.subscriptions)} subscribers"/>
            </c:otherwise>
        </c:choose>
        <c:choose>
            <c:when test="${f:length(channel.recipientLists) == 1}">
                <c:set var="dflt_recipients" value="1 default recipient"/>
            </c:when>
            <c:otherwise>
                <c:set var="dflt_recipients" value="${f:length(channel.recipientLists)} default recipients"/>
            </c:otherwise>
        </c:choose>
        <c:choose>
            <c:when test="${channel.name eq channelName}">
                <option value="${channel.name}" selected="selected">${channel.name} (${subscribers}, ${dflt_recipients})</option>
            </c:when>
            <c:otherwise>
                <option value="${channel.name}">${channel.name} (${subscribers}, ${dflt_recipients})</option>
            </c:otherwise>
        </c:choose>
    </c:forEach>
</select>
