<#--
 #%L
 %%
 Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#--
    Standard HTML Link

 -->

<#macro uif_link element body=''>

    <#if element.skipInTabOrder>
        <#local tabindex="tabindex=-1"/>
    <#else>
        <#local tabIndex=""/>
    </#if>

    <#if !body?trim?has_content>
        <#local body="${element.linkText!}"/>
    </#if>

    <#if element.iconClass??>
        <#if element.linkIconPlacement == 'ICON_ONLY'>
        <#-- no span necessary, icon class is on the link -->
        <a id="${element.id}" href="${element.href!}" target="${element.target!}"
        ${krad.attrBuild(element)} ${tabindex!} ${element.simpleDataAttributes!}></a>
        <#elseif element.linkIconPlacement == 'LEFT'>
        <a id="${element.id}" href="${element.href!}" target="${element.target!}"
        ${krad.attrBuild(element)} ${tabindex!} ${element.simpleDataAttributes!}><span
                class="${element.iconClass}"></span>${body!}</a>
        <#elseif element.linkIconPlacement == 'RIGHT'>
        <a id="${element.id}" href="${element.href!}" target="${element.target!}"
        ${krad.attrBuild(element)} ${tabindex!} ${element.simpleDataAttributes!}>${body!}<span
                class="${element.iconClass}"></span></a>
        </#if>
    <#else>
    <a id="${element.id}" href="${element.href!}" target="${element.target!}"
    ${krad.attrBuild(element)} ${tabindex!} ${element.simpleDataAttributes!}>${body!}</a>
    </#if>

</#macro>
