<#--
 #%L
 %%
 Copyright (C) 2005 - 2021 Kuali, Inc. - All Rights Reserved
 %%
 You may use and modify this code under the terms of the Kuali, Inc.
 Pre-Release License Agreement. You may not distribute it.
 
 You should have received a copy of the Kuali, Inc. Pre-Release License
 Agreement with this file. If not, please write to license@kuali.co.
 #L%
-->

<#--
Create pre tags containing the text to highlight adding the css class used by the plugin

-->
<#macro uif_syntaxHighlighter widget >

<div id="${widget.id}">
    <#if widget.header?has_content>
        <@krad.template component=widget.header/>
    </#if>
    <div class="uif-syntaxHighlighter">
        <#if widget.allowCopy>
            <a class="uif-copyPaste" id="${widget.id}_syntaxHighlightCopy"></a>
        </#if>
        <pre class="${widget.pluginCssClass}">
            <#if widget.sourceCode?has_content>
                    ${widget.sourceCode}
                </#if>
        </pre>
    </div>
    <#if widget.sourceCode?has_content>
        <div id="${widget.id}_syntaxOriginalText" style="display: none;">${widget.sourceCode}</div>
    </#if>
</div>

    <@krad.script value="prettyPrint();"/>
    <#if widget.allowCopy>
        <@krad.script value="createCopyToClipboard('${widget.id}', '${widget.id}_syntaxHighlightCopy',
            '${widget.id}_syntaxOriginalText', ${widget.showCopyConfirmation?string})" />
    </#if>
</#macro>


