/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.commons.beanutils.MethodUtils;

class IntrospectorUtils {
    private IntrospectorUtils() {
        throw new UnsupportedOperationException("do not call");
    }

    static void setNonSyntheticReadWriteMethods(Class beanClass, PropertyDescriptor[] descriptors) throws NoSuchMethodException, IntrospectionException {
        if (beanClass == null || descriptors == null) {
            return;
        }
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i] == null) continue;
            PropertyDescriptor descriptor = descriptors[i];
            Method read = descriptor.getReadMethod();
            Method write = descriptor.getWriteMethod();
            descriptor.setReadMethod(null);
            descriptor.setWriteMethod(null);
            if (MethodUtils.isSynthetic(read) || MethodUtils.isBridge(read)) {
                read = IntrospectorUtils.findReadMethodNonSynPreference(beanClass, read.getName());
            }
            if (MethodUtils.isSynthetic(write) || MethodUtils.isBridge(write)) {
                if (read != null) {
                    write = beanClass.getMethod(write.getName(), read.getReturnType());
                } else {
                    Method searchedWrite = IntrospectorUtils.findWriteMethodNonSynPreference(beanClass, write.getName());
                    if (searchedWrite != null) {
                        write = searchedWrite;
                    }
                }
            }
            descriptor.setReadMethod(read);
            descriptor.setWriteMethod(write);
        }
    }

    private static Method findWriteMethodNonSynPreference(Class beanClass, String methodName) {
        return IntrospectorUtils.findMethodNonSynPreference(beanClass, methodName, 1);
    }

    private static Method findReadMethodNonSynPreference(Class beanClass, String methodName) {
        return IntrospectorUtils.findMethodNonSynPreference(beanClass, methodName, 0);
    }

    private static Method findMethodNonSynPreference(Class beanClass, String methodName, int argNum) {
        Method[] methods = beanClass.getMethods();
        Method fallback = null;
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!methodName.equals(m.getName()) || m.getParameterTypes().length != argNum || IntrospectorUtils.isPrivate(m)) continue;
            if (!MethodUtils.isSynthetic(m) && !MethodUtils.isBridge(m)) {
                return m;
            }
            fallback = m;
        }
        return fallback;
    }

    private static boolean isPrivate(Method m) {
        return (m.getModifiers() & 2) != 0;
    }
}

