/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.kuali.kfs.coa.service.OrganizationService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrganizationReports;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPullup;
import org.kuali.kfs.module.bc.report.ReportControlListBuildHelper;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.fixture.UserNameFixture;

@ConfigureContext(session=UserNameFixture.khuntley)
public class ReportControlListBuildHelperTest
extends KualiTestBase {
    private Collection<BudgetConstructionPullup> arrayListSuperSetOfForTest = new ArrayList<BudgetConstructionPullup>(4);
    private Collection<BudgetConstructionPullup> arrayListForTest = new ArrayList<BudgetConstructionPullup>(3);
    private Collection<BudgetConstructionPullup> hashSetMatchingArrayList = new HashSet<BudgetConstructionPullup>(3);
    private Collection<BudgetConstructionPullup> arrayListForTestDifferentObjects = new ArrayList<BudgetConstructionPullup>(3);
    private Collection<BudgetConstructionPullup> hashSetForTest = new HashSet<BudgetConstructionPullup>(3);
    private Collection<BudgetConstructionPullup> sameHashSetDataDifferentObjects = new HashSet<BudgetConstructionPullup>(3);
    private ReportControlListBuildHelper.BuildState currentState = null;
    private ReportControlListBuildHelper.BuildState requestedState = null;
    private String firstPointOfView = null;
    private String secondPointOfView = null;
    private String userIdString = new String("1234567890");
    private boolean testDataValid;
    private BusinessObjectService businessObjectService;
    private OrganizationService organizationService;
    private Integer pullupFlag = new Integer(0);
    private Long versionNumber = new Long(0L);
    StringBuilder messageBuffer = new StringBuilder("Testing ReportControlListBuilder.isBuildNeeded: ");

    public void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.organizationService = (OrganizationService)SpringContext.getBean(OrganizationService.class);
        String[] rootOrganization = this.organizationService.getRootOrganizationCode();
        this.firstPointOfView = this.setUpAPointOfView(rootOrganization[0], rootOrganization[1]);
        this.testDataValid = this.setUpTestOrganizations();
    }

    public void testAdequateData() {
        ReportControlListBuildHelperTest.assertTrue((String)this.ourAssertMessage("insufficient test data exists"), (boolean)this.testDataValid);
    }

    public void testUniitializedCall() {
        ReportControlListBuildHelper buildHelper = new ReportControlListBuildHelper();
        ReportControlListBuildHelperTest.assertFalse((String)this.ourAssertMessage("the control list builder is not initialized from the database"), (boolean)buildHelper.isBuildNeeded());
    }

    public void testFirstCall() {
        ReportControlListBuildHelper buildHelper;
        ReportControlListBuildHelper reportControlListBuildHelper = buildHelper = new ReportControlListBuildHelper();
        reportControlListBuildHelper.getClass();
        this.requestedState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper, this.firstPointOfView, this.arrayListForTest, BCConstants.Report.BuildMode.PBGL);
        buildHelper.setRequestedState(this.requestedState);
        ReportControlListBuildHelperTest.assertTrue((String)this.ourAssertMessage("first call with a null current state and a valid requested state"), (boolean)buildHelper.isBuildNeeded());
    }

    public void testSameCallDifferentDBObjectsInHashSets() {
        ReportControlListBuildHelper buildHelper;
        ReportControlListBuildHelper reportControlListBuildHelper = buildHelper = new ReportControlListBuildHelper();
        reportControlListBuildHelper.getClass();
        this.requestedState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper, this.firstPointOfView, this.hashSetForTest, BCConstants.Report.BuildMode.PBGL);
        buildHelper.setRequestedState(this.requestedState);
        ReportControlListBuildHelper reportControlListBuildHelper2 = buildHelper;
        reportControlListBuildHelper2.getClass();
        this.currentState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper2, this.firstPointOfView, this.sameHashSetDataDifferentObjects, BCConstants.Report.BuildMode.PBGL);
        buildHelper.setCurrentState(this.currentState);
        ReportControlListBuildHelperTest.assertFalse((String)this.ourAssertMessage("same content in two different sets of DB objects--two hashSets"), (boolean)buildHelper.isBuildNeeded());
    }

    public void testSameCallDifferentDBObjectsInArrayLists() {
        ReportControlListBuildHelper buildHelper;
        ReportControlListBuildHelper reportControlListBuildHelper = buildHelper = new ReportControlListBuildHelper();
        reportControlListBuildHelper.getClass();
        this.requestedState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper, this.secondPointOfView, this.arrayListForTestDifferentObjects, BCConstants.Report.BuildMode.BCAF);
        buildHelper.setRequestedState(this.requestedState);
        ReportControlListBuildHelper reportControlListBuildHelper2 = buildHelper;
        reportControlListBuildHelper2.getClass();
        this.currentState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper2, this.secondPointOfView, this.arrayListForTest, BCConstants.Report.BuildMode.BCAF);
        buildHelper.setCurrentState(this.currentState);
        ReportControlListBuildHelperTest.assertFalse((String)this.ourAssertMessage("same content in two different sets of DB objects--two arrayLists"), (boolean)buildHelper.isBuildNeeded());
    }

    public void testDifferentPointOfView() {
        ReportControlListBuildHelper buildHelper;
        ReportControlListBuildHelper reportControlListBuildHelper = buildHelper = new ReportControlListBuildHelper();
        reportControlListBuildHelper.getClass();
        this.requestedState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper, this.secondPointOfView, this.hashSetForTest, BCConstants.Report.BuildMode.PBGL);
        buildHelper.setRequestedState(this.requestedState);
        ReportControlListBuildHelper reportControlListBuildHelper2 = buildHelper;
        reportControlListBuildHelper2.getClass();
        this.currentState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper2, this.firstPointOfView, this.sameHashSetDataDifferentObjects, BCConstants.Report.BuildMode.PBGL);
        buildHelper.setCurrentState(this.currentState);
        ReportControlListBuildHelperTest.assertTrue((String)this.ourAssertMessage("same content in two different sets of DB objects, but a different point of view"), (boolean)buildHelper.isBuildNeeded());
    }

    public void testDifferentBuildMode() {
        ReportControlListBuildHelper buildHelper;
        ReportControlListBuildHelper reportControlListBuildHelper = buildHelper = new ReportControlListBuildHelper();
        reportControlListBuildHelper.getClass();
        this.requestedState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper, this.firstPointOfView, this.hashSetForTest, BCConstants.Report.BuildMode.MONTH);
        buildHelper.setRequestedState(this.requestedState);
        ReportControlListBuildHelper reportControlListBuildHelper2 = buildHelper;
        reportControlListBuildHelper2.getClass();
        this.currentState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper2, this.firstPointOfView, this.sameHashSetDataDifferentObjects, BCConstants.Report.BuildMode.PBGL);
        buildHelper.setCurrentState(this.currentState);
        ReportControlListBuildHelperTest.assertTrue((String)this.ourAssertMessage("same content in two different sets of DB objects, but a different build mode"), (boolean)buildHelper.isBuildNeeded());
    }

    public void testDifferentCollectionFormats() {
        ReportControlListBuildHelper buildHelper;
        ReportControlListBuildHelper reportControlListBuildHelper = buildHelper = new ReportControlListBuildHelper();
        reportControlListBuildHelper.getClass();
        this.requestedState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper, this.firstPointOfView, this.arrayListForTest, BCConstants.Report.BuildMode.BCAF);
        buildHelper.setRequestedState(this.requestedState);
        ReportControlListBuildHelper reportControlListBuildHelper2 = buildHelper;
        reportControlListBuildHelper2.getClass();
        this.currentState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper2, this.firstPointOfView, this.hashSetMatchingArrayList, BCConstants.Report.BuildMode.BCAF);
        buildHelper.setCurrentState(this.currentState);
        ReportControlListBuildHelperTest.assertFalse((String)this.ourAssertMessage("same content in collections with different formats--hash Set vs. arrayList"), (boolean)buildHelper.isBuildNeeded());
    }

    public void testDifferentReportsSameCollectionFormat() {
        ReportControlListBuildHelper buildHelper;
        ReportControlListBuildHelper reportControlListBuildHelper = buildHelper = new ReportControlListBuildHelper();
        reportControlListBuildHelper.getClass();
        this.requestedState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper, this.firstPointOfView, this.hashSetForTest, BCConstants.Report.BuildMode.BCAF);
        buildHelper.setRequestedState(this.requestedState);
        ReportControlListBuildHelper reportControlListBuildHelper2 = buildHelper;
        reportControlListBuildHelper2.getClass();
        this.currentState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper2, this.firstPointOfView, this.hashSetMatchingArrayList, BCConstants.Report.BuildMode.BCAF);
        buildHelper.setCurrentState(this.currentState);
        ReportControlListBuildHelperTest.assertTrue((String)this.ourAssertMessage("same collection format but different data content"), (boolean)buildHelper.isBuildNeeded());
    }

    public void testDifferentReportsDifferentCollectionFormats() {
        ReportControlListBuildHelper buildHelper;
        ReportControlListBuildHelper reportControlListBuildHelper = buildHelper = new ReportControlListBuildHelper();
        reportControlListBuildHelper.getClass();
        this.requestedState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper, this.firstPointOfView, this.hashSetForTest, BCConstants.Report.BuildMode.BCAF);
        buildHelper.setRequestedState(this.requestedState);
        ReportControlListBuildHelper reportControlListBuildHelper2 = buildHelper;
        reportControlListBuildHelper2.getClass();
        this.currentState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper2, this.firstPointOfView, this.arrayListForTest, BCConstants.Report.BuildMode.BCAF);
        buildHelper.setCurrentState(this.currentState);
        ReportControlListBuildHelperTest.assertTrue((String)this.ourAssertMessage("different data content and different collection formats"), (boolean)buildHelper.isBuildNeeded());
    }

    public void testCurrentStateSuperSetOfRequestState() {
        ReportControlListBuildHelper buildHelper;
        ReportControlListBuildHelper reportControlListBuildHelper = buildHelper = new ReportControlListBuildHelper();
        reportControlListBuildHelper.getClass();
        this.requestedState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper, this.firstPointOfView, this.arrayListForTest, BCConstants.Report.BuildMode.BCAF);
        buildHelper.setRequestedState(this.requestedState);
        ReportControlListBuildHelper reportControlListBuildHelper2 = buildHelper;
        reportControlListBuildHelper2.getClass();
        this.currentState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper2, this.firstPointOfView, this.arrayListSuperSetOfForTest, BCConstants.Report.BuildMode.BCAF);
        buildHelper.setCurrentState(this.currentState);
        ReportControlListBuildHelperTest.assertTrue((String)this.ourAssertMessage("current state is a superset of the requested state"), (boolean)buildHelper.isBuildNeeded());
    }

    public void testRequestStateSuperSetOfCurrentState() {
        ReportControlListBuildHelper buildHelper;
        ReportControlListBuildHelper reportControlListBuildHelper = buildHelper = new ReportControlListBuildHelper();
        reportControlListBuildHelper.getClass();
        this.requestedState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper, this.firstPointOfView, this.arrayListSuperSetOfForTest, BCConstants.Report.BuildMode.BCAF);
        buildHelper.setRequestedState(this.requestedState);
        ReportControlListBuildHelper reportControlListBuildHelper2 = buildHelper;
        reportControlListBuildHelper2.getClass();
        this.currentState = new ReportControlListBuildHelper.BuildState(reportControlListBuildHelper2, this.firstPointOfView, this.arrayListForTest, BCConstants.Report.BuildMode.BCAF);
        buildHelper.setCurrentState(this.currentState);
        ReportControlListBuildHelperTest.assertTrue((String)this.ourAssertMessage("requested state is a superset of the current state"), (boolean)buildHelper.isBuildNeeded());
    }

    private String ourAssertMessage(String messageToDisplay) {
        StringBuilder msg = new StringBuilder(this.messageBuffer);
        msg.append(messageToDisplay);
        return msg.toString();
    }

    private BudgetConstructionPullup newBudgetConstructionPullup(BudgetConstructionOrganizationReports organizationReports) {
        BudgetConstructionPullup newMember = new BudgetConstructionPullup();
        newMember.setChartOfAccountsCode(organizationReports.getChartOfAccountsCode());
        newMember.setOrganizationCode(organizationReports.getOrganizationCode());
        newMember.setReportsToChartOfAccountsCode(organizationReports.getReportsToChartOfAccountsCode());
        newMember.setReportsToOrganizationCode(organizationReports.getReportsToOrganizationCode());
        newMember.setPullFlag(this.pullupFlag);
        newMember.setPrincipalId(this.userIdString);
        newMember.setVersionNumber(this.versionNumber);
        newMember.setObjectId(organizationReports.getObjectId());
        return newMember;
    }

    private void setUpAHashSet(BudgetConstructionOrganizationReports organizationReports) {
        this.hashSetForTest.add(this.newBudgetConstructionPullup(organizationReports));
        this.sameHashSetDataDifferentObjects.add(this.newBudgetConstructionPullup(organizationReports));
    }

    private void setUpAnArrayList(BudgetConstructionOrganizationReports organizationReports) {
        BudgetConstructionPullup pullUpElement = this.newBudgetConstructionPullup(organizationReports);
        this.arrayListForTest.add(pullUpElement);
        this.hashSetMatchingArrayList.add(pullUpElement);
        this.arrayListSuperSetOfForTest.add(pullUpElement);
        BudgetConstructionPullup pullUpElementWithNewID = this.newBudgetConstructionPullup(organizationReports);
        this.arrayListForTestDifferentObjects.add(pullUpElementWithNewID);
    }

    private String setUpAPointOfView(String chartOfAccounts, String organizationCode) {
        return chartOfAccounts + "-" + organizationCode;
    }

    private void setUpExtraArrayListRow(BudgetConstructionOrganizationReports organizationReports) {
        BudgetConstructionPullup pullUpElement = this.newBudgetConstructionPullup(organizationReports);
        this.arrayListSuperSetOfForTest.add(pullUpElement);
    }

    private boolean setUpTestOrganizations() {
        BudgetConstructionOrganizationReports organizationReports;
        Collection sourceData = this.businessObjectService.findAll(BudgetConstructionOrganizationReports.class);
        if (sourceData.size() < 6) {
            return false;
        }
        int elementsSeen = 0;
        Iterator reportSet = sourceData.iterator();
        if (reportSet.hasNext()) {
            ++elementsSeen;
            organizationReports = (BudgetConstructionOrganizationReports)reportSet.next();
            this.secondPointOfView = this.setUpAPointOfView(organizationReports.getChartOfAccountsCode(), organizationReports.getOrganizationCode());
            this.setUpAnArrayList(organizationReports);
            this.setUpAHashSet(organizationReports);
        }
        while (reportSet.hasNext()) {
            organizationReports = (BudgetConstructionOrganizationReports)reportSet.next();
            if (++elementsSeen > 6) continue;
            if (elementsSeen < 4) {
                this.setUpAnArrayList(organizationReports);
                continue;
            }
            if (elementsSeen < 6) {
                this.setUpAHashSet(organizationReports);
                continue;
            }
            this.setUpExtraArrayListRow(organizationReports);
        }
        return elementsSeen >= 6;
    }
}

