/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.businessobject;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.coa.businessobject.ResponsibilityCenter;
import org.kuali.kfs.krad.bo.PersistableBusinessObjectBase;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPositionSelect;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFundingAware;
import org.kuali.kfs.module.bc.businessobject.Position;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class BudgetConstructionPosition
extends PersistableBusinessObjectBase
implements PendingBudgetConstructionAppointmentFundingAware,
Position,
MutableInactivatable {
    private String positionNumber;
    private Integer universityFiscalYear;
    private Date positionEffectiveDate;
    private String positionEffectiveStatus;
    private String positionStatus;
    private boolean budgetedPosition;
    private boolean confidentialPosition;
    private BigDecimal positionStandardHoursDefault;
    private String positionRegularTemporary;
    private BigDecimal positionFullTimeEquivalency;
    private Integer iuNormalWorkMonths;
    private Integer iuPayMonths;
    private String positionDescription;
    private String setidDepartment;
    private String positionDepartmentIdentifier;
    private String responsibilityCenterCode;
    private String positionUnionCode;
    private String positionSalaryPlanDefault;
    private String positionGradeDefault;
    private String setidJobCode;
    private String jobCode;
    private String jobCodeDescription;
    private String setidSalary;
    private String iuDefaultObjectCode;
    private String iuPositionType;
    private String positionLockUserIdentifier;
    private boolean active = true;
    private SystemOptions universityFiscal;
    private List<PendingBudgetConstructionAppointmentFunding> pendingBudgetConstructionAppointmentFunding;
    private List<BudgetConstructionPositionSelect> budgetConstructionPositionSelect = new ArrayList<BudgetConstructionPositionSelect>();
    private ResponsibilityCenter responsibilityCenter;
    private Person positionLockUser;

    public BudgetConstructionPosition() {
        this.pendingBudgetConstructionAppointmentFunding = new ArrayList<PendingBudgetConstructionAppointmentFunding>();
    }

    public static BigDecimal getCalculatedBCPositionFTE(BigDecimal positionStandardHoursDefault, Integer iuNormalWorkMonths, Integer iuPayMonths) {
        if (iuPayMonths > 0) {
            BigDecimal temp1 = positionStandardHoursDefault.divide(BudgetParameterFinder.getWeeklyWorkingHoursAsDecimal(), 4, 4);
            BigDecimal temp2 = new BigDecimal(iuNormalWorkMonths).divide(new BigDecimal(iuPayMonths), 4, 4);
            BigDecimal result = temp1.multiply(temp2);
            result = result.setScale(2, 4);
            return result;
        }
        return BigDecimal.ZERO;
    }

    @Override
    public String getPositionNumber() {
        return this.positionNumber;
    }

    @Override
    public void setPositionNumber(String positionNumber) {
        this.positionNumber = positionNumber;
    }

    @Override
    public Integer getUniversityFiscalYear() {
        return this.universityFiscalYear;
    }

    @Override
    public void setUniversityFiscalYear(Integer universityFiscalYear) {
        this.universityFiscalYear = universityFiscalYear;
    }

    @Override
    public Date getPositionEffectiveDate() {
        return this.positionEffectiveDate;
    }

    @Override
    public void setPositionEffectiveDate(Date positionEffectiveDate) {
        this.positionEffectiveDate = positionEffectiveDate;
    }

    @Override
    public String getPositionEffectiveStatus() {
        return this.active ? "A" : "I";
    }

    @Override
    public void setPositionEffectiveStatus(String positionEffectiveStatus) {
        this.active = "A".indexOf(positionEffectiveStatus) >= 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public String getPositionStatus() {
        return this.positionStatus;
    }

    @Override
    public void setPositionStatus(String positionStatus) {
        this.positionStatus = positionStatus;
    }

    @Override
    public boolean isBudgetedPosition() {
        return this.budgetedPosition;
    }

    @Override
    public void setBudgetedPosition(boolean budgetedPosition) {
        this.budgetedPosition = budgetedPosition;
    }

    @Override
    public boolean isConfidentialPosition() {
        return this.confidentialPosition;
    }

    @Override
    public void setConfidentialPosition(boolean confidentialPosition) {
        this.confidentialPosition = confidentialPosition;
    }

    @Override
    public BigDecimal getPositionStandardHoursDefault() {
        return this.positionStandardHoursDefault;
    }

    @Override
    public void setPositionStandardHoursDefault(BigDecimal positionStandardHoursDefault) {
        this.positionStandardHoursDefault = positionStandardHoursDefault;
    }

    @Override
    public String getPositionRegularTemporary() {
        return this.positionRegularTemporary;
    }

    @Override
    public void setPositionRegularTemporary(String positionRegularTemporary) {
        this.positionRegularTemporary = positionRegularTemporary;
    }

    @Override
    public BigDecimal getPositionFullTimeEquivalency() {
        return this.positionFullTimeEquivalency;
    }

    @Override
    public void setPositionFullTimeEquivalency(BigDecimal positionFullTimeEquivalency) {
        this.positionFullTimeEquivalency = positionFullTimeEquivalency;
    }

    @Override
    public Integer getIuNormalWorkMonths() {
        return this.iuNormalWorkMonths;
    }

    @Override
    public void setIuNormalWorkMonths(Integer iuNormalWorkMonths) {
        this.iuNormalWorkMonths = iuNormalWorkMonths;
    }

    @Override
    public Integer getIuPayMonths() {
        return this.iuPayMonths;
    }

    @Override
    public void setIuPayMonths(Integer iuPayMonths) {
        this.iuPayMonths = iuPayMonths;
    }

    @Override
    public String getPositionDescription() {
        return this.positionDescription;
    }

    @Override
    public void setPositionDescription(String positionDescription) {
        this.positionDescription = positionDescription;
    }

    @Override
    public String getSetidDepartment() {
        return this.setidDepartment;
    }

    @Override
    public void setSetidDepartment(String setidDepartment) {
        this.setidDepartment = setidDepartment;
    }

    @Override
    public String getPositionDepartmentIdentifier() {
        return this.positionDepartmentIdentifier;
    }

    @Override
    public void setPositionDepartmentIdentifier(String positionDepartmentIdentifier) {
        this.positionDepartmentIdentifier = positionDepartmentIdentifier;
    }

    @Override
    public String getResponsibilityCenterCode() {
        return this.responsibilityCenterCode;
    }

    @Override
    public void setResponsibilityCenterCode(String responsibilityCenterCode) {
        this.responsibilityCenterCode = responsibilityCenterCode;
    }

    @Override
    public String getPositionUnionCode() {
        return this.positionUnionCode;
    }

    @Override
    public void setPositionUnionCode(String positionUnionCode) {
        this.positionUnionCode = positionUnionCode;
    }

    @Override
    public String getPositionSalaryPlanDefault() {
        return this.positionSalaryPlanDefault;
    }

    @Override
    public void setPositionSalaryPlanDefault(String positionSalaryPlanDefault) {
        this.positionSalaryPlanDefault = positionSalaryPlanDefault;
    }

    @Override
    public String getPositionGradeDefault() {
        return this.positionGradeDefault;
    }

    @Override
    public void setPositionGradeDefault(String positionGradeDefault) {
        this.positionGradeDefault = positionGradeDefault;
    }

    @Override
    public String getSetidJobCode() {
        return this.setidJobCode;
    }

    @Override
    public void setSetidJobCode(String setidJobCode) {
        this.setidJobCode = setidJobCode;
    }

    @Override
    public String getJobCode() {
        return this.jobCode;
    }

    @Override
    public void setJobCode(String jobCode) {
        this.jobCode = jobCode;
    }

    @Override
    public String getJobCodeDescription() {
        return this.jobCodeDescription;
    }

    @Override
    public void setJobCodeDescription(String jobCodeDescription) {
        this.jobCodeDescription = jobCodeDescription;
    }

    @Override
    public String getSetidSalary() {
        return this.setidSalary;
    }

    @Override
    public void setSetidSalary(String setidSalary) {
        this.setidSalary = setidSalary;
    }

    @Override
    public String getIuDefaultObjectCode() {
        return this.iuDefaultObjectCode;
    }

    @Override
    public void setIuDefaultObjectCode(String iuDefaultObjectCode) {
        this.iuDefaultObjectCode = iuDefaultObjectCode;
    }

    @Override
    public String getIuPositionType() {
        return this.iuPositionType;
    }

    @Override
    public void setIuPositionType(String iuPositionType) {
        this.iuPositionType = iuPositionType;
    }

    @Override
    public String getPositionLockUserIdentifier() {
        return this.positionLockUserIdentifier;
    }

    @Override
    public void setPositionLockUserIdentifier(String positionLockUserIdentifier) {
        this.positionLockUserIdentifier = positionLockUserIdentifier;
    }

    public ResponsibilityCenter getResponsibilityCenter() {
        return this.responsibilityCenter;
    }

    public void setResponsibilityCenter(ResponsibilityCenter responsibilityCenter) {
        this.responsibilityCenter = responsibilityCenter;
    }

    public Person getPositionLockUser() {
        if (this.positionLockUserIdentifier != null) {
            this.positionLockUser = ((PersonService)SpringContext.getBean(PersonService.class)).updatePersonIfNecessary(this.positionLockUserIdentifier, this.positionLockUser);
        }
        return this.positionLockUser;
    }

    public void setPositionLockUser(Person positionLockUser) {
        this.positionLockUser = positionLockUser;
    }

    public SystemOptions getUniversityFiscal() {
        return this.universityFiscal;
    }

    public void setUniversityFiscal(SystemOptions universityFiscal) {
        this.universityFiscal = universityFiscal;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.getPendingBudgetConstructionAppointmentFunding());
        return managedLists;
    }

    public Map getValuesMap() {
        HashMap<String, Object> simpleValues = new HashMap<String, Object>();
        simpleValues.put("positionNumber", this.getPositionNumber());
        simpleValues.put("universityFiscalYear", this.getUniversityFiscalYear());
        return simpleValues;
    }

    protected LinkedHashMap toStringMapper_RICE20_REFACTORME() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        m.put("positionNumber", this.positionNumber);
        if (this.universityFiscalYear != null) {
            m.put("universityFiscalYear", this.universityFiscalYear.toString());
        }
        return m;
    }

    @Override
    public boolean isEffective() {
        return !"I".equals(this.getPositionEffectiveStatus());
    }

    @Override
    public List<PendingBudgetConstructionAppointmentFunding> getPendingBudgetConstructionAppointmentFunding() {
        return this.pendingBudgetConstructionAppointmentFunding;
    }

    @Deprecated
    public void setPendingBudgetConstructionAppointmentFunding(List<PendingBudgetConstructionAppointmentFunding> pendingBudgetConstructionAppointmentFunding) {
        this.pendingBudgetConstructionAppointmentFunding = pendingBudgetConstructionAppointmentFunding;
    }

    public List<BudgetConstructionPositionSelect> getBudgetConstructionPositionSelect() {
        return this.budgetConstructionPositionSelect;
    }

    @Deprecated
    public void setBudgetConstructionPositionSelect(List<BudgetConstructionPositionSelect> budgetConstructionPositionSelect) {
        this.budgetConstructionPositionSelect = budgetConstructionPositionSelect;
    }
}

