/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.dataaccess.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountOrganizationHierarchy;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountReports;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionFundingLock;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrganizationReports;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPullup;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionDao;
import org.kuali.kfs.sys.util.TransactionalServiceUtils;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class BudgetConstructionDaoOjb
extends PlatformAwareDaoBaseOjb
implements BudgetConstructionDao {
    @Override
    public BudgetConstructionHeader getByCandidateKey(String chartOfAccountsCode, String accountNumber, String subAccountNumber, Integer fiscalYear) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("accountNumber", (Object)accountNumber);
        criteria.addEqualTo("subAccountNumber", (Object)subAccountNumber);
        criteria.addEqualTo("universityFiscalYear", (Object)fiscalYear);
        return (BudgetConstructionHeader)((Object)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery(BudgetConstructionHeader.class, (Criteria)criteria)));
    }

    @Override
    public void deleteBudgetConstructionFundingLock(BudgetConstructionFundingLock budgetConstructionFundingLock) {
        this.getPersistenceBrokerTemplate().delete((Object)budgetConstructionFundingLock);
    }

    @Override
    public Collection<BudgetConstructionFundingLock> getFlocksForAccount(String chartOfAccountsCode, String accountNumber, String subAccountNumber, Integer fiscalYear) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("accountNumber", (Object)accountNumber);
        criteria.addEqualTo("subAccountNumber", (Object)subAccountNumber);
        criteria.addEqualTo("universityFiscalYear", (Object)fiscalYear);
        Collection fundingLocks = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(BudgetConstructionFundingLock.class, (Criteria)criteria));
        for (BudgetConstructionFundingLock fundingLock : fundingLocks) {
            fundingLock.setPositionNumber(this.getPositionAssociatedWithFundingLock(fundingLock));
        }
        return fundingLocks;
    }

    @Override
    public String getPositionAssociatedWithFundingLock(BudgetConstructionFundingLock budgetConstructionFundingLock) {
        Object[] objs;
        String positionNumber = "NotFnd";
        Criteria criteria = new Criteria();
        criteria.addEqualTo("pendingBudgetConstructionAppointmentFunding.chartOfAccountsCode", (Object)budgetConstructionFundingLock.getChartOfAccountsCode());
        criteria.addEqualTo("pendingBudgetConstructionAppointmentFunding.accountNumber", (Object)budgetConstructionFundingLock.getAccountNumber());
        criteria.addEqualTo("pendingBudgetConstructionAppointmentFunding.subAccountNumber", (Object)budgetConstructionFundingLock.getSubAccountNumber());
        criteria.addEqualTo("pendingBudgetConstructionAppointmentFunding.universityFiscalYear", (Object)budgetConstructionFundingLock.getUniversityFiscalYear());
        criteria.addEqualTo("positionLockUserIdentifier", (Object)budgetConstructionFundingLock.getAppointmentFundingLockUserId());
        String[] columns = new String[]{"positionNumber"};
        ReportQueryByCriteria q = QueryFactory.newReportQuery(BudgetConstructionPosition.class, (String[])columns, (Criteria)criteria, (boolean)true);
        PersistenceBroker pb = this.getPersistenceBroker(true);
        Iterator iter = pb.getReportQueryIteratorByQuery((Query)q);
        if (iter.hasNext() && (objs = (Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)iter))[0] != null) {
            positionNumber = (String)objs[0];
        }
        return positionNumber;
    }

    @Override
    public void deleteBudgetConstructionPullupByUserId(String principalName) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("principalId", (Object)principalName);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)QueryFactory.newQuery(BudgetConstructionPullup.class, (Criteria)criteria));
    }

    @Override
    public List<BudgetConstructionPullup> getBudgetConstructionPullupFlagSetByUserId(String principalName) {
        List<BudgetConstructionPullup> orgs = new ArrayList();
        Criteria criteria = new Criteria();
        criteria.addEqualTo("principalId", (Object)principalName);
        criteria.addGreaterThan((Object)"pullFlag", (Object)BCConstants.OrgSelControlOption.NO.getKey());
        orgs = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(BudgetConstructionPullup.class, (Criteria)criteria));
        if (orgs.isEmpty() || orgs.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return orgs;
    }

    @Override
    public List<BudgetConstructionPullup> getBudgetConstructionPullupChildOrgs(String principalId, String chartOfAccountsCode, String organizationCode) {
        List<BudgetConstructionPullup> orgs = new ArrayList();
        Criteria cycleCheckCriteria = new Criteria();
        cycleCheckCriteria.addEqualToField("chartOfAccountsCode", "reportsToChartOfAccountsCode");
        cycleCheckCriteria.addEqualToField("organizationCode", "reportsToOrganizationCode");
        cycleCheckCriteria.setEmbraced(true);
        cycleCheckCriteria.setNegative(true);
        Criteria criteria = new Criteria();
        criteria.addEqualTo("reportsToChartOfAccountsCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("reportsToOrganizationCode", (Object)organizationCode);
        criteria.addEqualTo("principalId", (Object)principalId);
        criteria.addAndCriteria(cycleCheckCriteria);
        QueryByCriteria query = QueryFactory.newQuery(BudgetConstructionPullup.class, (Criteria)criteria);
        query.addOrderByAscending("organization.organizationName");
        orgs = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        if (orgs.isEmpty() || orgs.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return orgs;
    }

    @Override
    public KualiInteger getPendingBudgetConstructionAppointmentFundingRequestSum(PendingBudgetConstructionGeneralLedger salaryDetailLine) {
        Object[] objs;
        KualiInteger salarySum = KualiInteger.ZERO;
        Criteria criteria = new Criteria();
        criteria.addEqualTo("universityFiscalYear", (Object)salaryDetailLine.getUniversityFiscalYear());
        criteria.addEqualTo("chartOfAccountsCode", (Object)salaryDetailLine.getChartOfAccountsCode());
        criteria.addEqualTo("accountNumber", (Object)salaryDetailLine.getAccountNumber());
        criteria.addEqualTo("subAccountNumber", (Object)salaryDetailLine.getSubAccountNumber());
        criteria.addEqualTo("financialObjectCode", (Object)salaryDetailLine.getFinancialObjectCode());
        criteria.addEqualTo("financialSubObjectCode", (Object)salaryDetailLine.getFinancialSubObjectCode());
        String[] columns = new String[]{"financialObjectCode", "financialSubObjectCode", "sum(appointmentRequestedAmount)"};
        ReportQueryByCriteria q = QueryFactory.newReportQuery(PendingBudgetConstructionAppointmentFunding.class, (String[])columns, (Criteria)criteria, (boolean)true);
        q.addGroupBy(new String[]{"financialObjectCode", "financialSubObjectCode"});
        PersistenceBroker pb = this.getPersistenceBroker(true);
        Iterator iter = pb.getReportQueryIteratorByQuery((Query)q);
        if (iter.hasNext() && (objs = (Object[])TransactionalServiceUtils.retrieveFirstAndExhaustIterator((Iterator)iter))[2] != null) {
            salarySum = new KualiInteger((BigDecimal)objs[2]);
        }
        return salarySum;
    }

    @Override
    public List getDocumentPBGLFringeLines(String documentNumber, List fringeObjects) {
        List documentPBGLfringeLines = new ArrayList();
        this.getPersistenceBrokerTemplate().clearCache();
        Criteria criteria = new Criteria();
        criteria.addEqualTo("documentNumber", (Object)documentNumber);
        criteria.addIn("financialObjectCode", (Collection)fringeObjects);
        QueryByCriteria query = QueryFactory.newQuery(PendingBudgetConstructionGeneralLedger.class, (Criteria)criteria);
        query.addOrderByAscending("financialObjectCode");
        documentPBGLfringeLines = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        return documentPBGLfringeLines;
    }

    @Override
    public List<BudgetConstructionAccountOrganizationHierarchy> getAccountOrgHierForAccount(String chartOfAccountsCode, String accountNumber, Integer universityFiscalYear) {
        ArrayList<BudgetConstructionAccountOrganizationHierarchy> accountOrgHier = new ArrayList();
        Criteria criteria = new Criteria();
        criteria.addEqualTo("universityFiscalYear", (Object)universityFiscalYear);
        criteria.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("accountNumber", (Object)accountNumber);
        QueryByCriteria query = QueryFactory.newQuery(BudgetConstructionAccountOrganizationHierarchy.class, (Criteria)criteria);
        query.addOrderByAscending("organizationLevelCode");
        accountOrgHier = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        return accountOrgHier;
    }

    @Override
    public BudgetConstructionAccountReports getAccountReports(String chartOfAccountsCode, String accountNumber) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("accountNumber", (Object)accountNumber);
        return (BudgetConstructionAccountReports)((Object)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery(BudgetConstructionAccountReports.class, (Criteria)criteria)));
    }

    @Override
    public BudgetConstructionOrganizationReports getOrganizationReports(String chartOfAccountsCode, String organizationCode) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("organizationCode", (Object)organizationCode);
        return (BudgetConstructionOrganizationReports)((Object)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery(BudgetConstructionOrganizationReports.class, (Criteria)criteria)));
    }

    @Override
    public boolean insertAccountIntoAccountOrganizationHierarchy(String rootChart, String rootOrganization, Integer universityFiscalYear, String chartOfAccountsCode, String accountNumber, Integer currentLevelCode, String organizationChartOfAccountsCode, String organizationCode) {
        boolean overFlow = false;
        BudgetConstructionAccountOrganizationHierarchy accountOrganizationHierarchy = new BudgetConstructionAccountOrganizationHierarchy();
        accountOrganizationHierarchy.setUniversityFiscalYear(universityFiscalYear);
        accountOrganizationHierarchy.setChartOfAccountsCode(chartOfAccountsCode);
        accountOrganizationHierarchy.setAccountNumber(accountNumber);
        accountOrganizationHierarchy.setOrganizationLevelCode(currentLevelCode);
        accountOrganizationHierarchy.setOrganizationChartOfAccountsCode(organizationChartOfAccountsCode);
        accountOrganizationHierarchy.setOrganizationCode(organizationCode);
        this.getPersistenceBrokerTemplate().store((Object)accountOrganizationHierarchy);
        if (!rootChart.equalsIgnoreCase(organizationChartOfAccountsCode) || !rootOrganization.equalsIgnoreCase(organizationCode)) {
            if (currentLevelCode < BCConstants.MAXIMUM_ORGANIZATION_TREE_DEPTH) {
                BudgetConstructionOrganizationReports organizationReports = this.getOrganizationReports(organizationChartOfAccountsCode, organizationCode);
                if (organizationReports != null) {
                    Integer n = currentLevelCode;
                    Integer n2 = currentLevelCode = Integer.valueOf(currentLevelCode + 1);
                    overFlow = this.insertAccountIntoAccountOrganizationHierarchy(rootChart, rootOrganization, universityFiscalYear, chartOfAccountsCode, accountNumber, currentLevelCode, organizationReports.getReportsToChartOfAccountsCode(), organizationReports.getReportsToOrganizationCode());
                }
            } else {
                overFlow = true;
            }
        }
        return overFlow;
    }

    @Override
    public void deleteExistingAccountOrganizationHierarchy(Integer universityFiscalYear, String chartOfAccountsCode, String accountNumber) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("universityFiscalYear", (Object)universityFiscalYear);
        criteria.addEqualTo("chartOfAccountsCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("accountNumber", (Object)accountNumber);
        this.getPersistenceBrokerTemplate().deleteByQuery((Query)QueryFactory.newQuery(BudgetConstructionAccountOrganizationHierarchy.class, (Criteria)criteria));
    }

    @Override
    public List getPBGLSalarySettingRows(String documentNumber, List salarySettingObjects) {
        List pbglSalarySettingRows = new ArrayList();
        this.getPersistenceBrokerTemplate().clearCache();
        Criteria criteria = new Criteria();
        criteria.addEqualTo("documentNumber", (Object)documentNumber);
        criteria.addIn("financialObjectCode", (Collection)salarySettingObjects);
        QueryByCriteria query = QueryFactory.newQuery(PendingBudgetConstructionGeneralLedger.class, (Criteria)criteria);
        pbglSalarySettingRows = (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        return pbglSalarySettingRows;
    }

    @Override
    public List<PendingBudgetConstructionAppointmentFunding> getAllFundingForPosition(Integer universityFiscalYear, String positionNumber) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("universityFiscalYear", (Object)universityFiscalYear);
        criteria.addEqualTo("positionNumber", (Object)positionNumber);
        QueryByCriteria query = QueryFactory.newQuery(PendingBudgetConstructionAppointmentFunding.class, (Criteria)criteria);
        return (List)this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }
}

