/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.dataaccess.impl;

import java.math.BigDecimal;
import java.util.Iterator;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPayRateHolding;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.dataaccess.PayrateExportDao;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class PayrateExportDaoOjb
extends PlatformAwareDaoBaseOjb
implements PayrateExportDao {
    @Override
    public boolean isValidPositionUnionCode(String positionUnionCode) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("positionUnionCode", (Object)positionUnionCode);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)QueryFactory.newQuery(BudgetConstructionPosition.class, (Criteria)criteria)).size() != 0;
    }

    @Override
    public Integer buildPayRateHoldingRows(Integer budgetYear, String positionUnionCode, String principalId) {
        Integer rowsSaved = 0;
        Iterator payRateRows = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)this.queryForPayrateHoldingRecords(budgetYear, positionUnionCode));
        while (payRateRows.hasNext()) {
            Object[] payRateRow = (Object[])payRateRows.next();
            BudgetConstructionPayRateHolding payRateHolder = new BudgetConstructionPayRateHolding();
            payRateHolder.setAppointmentRequestedPayRate(new BigDecimal(0));
            payRateHolder.setEmplid((String)payRateRow[0]);
            payRateHolder.setPositionNumber((String)payRateRow[1]);
            payRateHolder.setName((String)payRateRow[2]);
            payRateHolder.setSetidSalary((String)payRateRow[3]);
            payRateHolder.setSalaryAdministrationPlan((String)payRateRow[4]);
            payRateHolder.setGrade((String)payRateRow[5]);
            payRateHolder.setUnionCode((String)payRateRow[6]);
            payRateHolder.setPrincipalId(principalId);
            this.getPersistenceBrokerTemplate().store((Object)payRateHolder);
            rowsSaved = rowsSaved + 1;
        }
        return rowsSaved;
    }

    protected ReportQueryByCriteria queryForPayrateHoldingRecords(Integer budgetYear, String positionUnionCode) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("universityFiscalYear", (Object)budgetYear);
        criteria.addNotEqualTo((Object)"emplid", (Object)"VACANT");
        criteria.addEqualTo("active", (Object)"Y");
        criteria.addEqualTo("budgetConstructionPosition.positionUnionCode", (Object)positionUnionCode);
        criteria.addEqualTo("budgetConstructionPosition.confidentialPosition", (Object)"N");
        ReportQueryByCriteria queryId = new ReportQueryByCriteria(PendingBudgetConstructionAppointmentFunding.class, criteria, true);
        String[] selectList = new String[]{"emplid", "positionNumber", "budgetConstructionIntendedIncumbent.name", "budgetConstructionPosition.setidSalary", "budgetConstructionPosition.positionSalaryPlanDefault", "budgetConstructionPosition.positionGradeDefault", "budgetConstructionPosition.positionUnionCode"};
        queryId.setAttributes(selectList);
        return queryId;
    }
}

