/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import org.kuali.kfs.module.bc.document.dataaccess.BenefitsCalculationDao;
import org.kuali.kfs.module.bc.document.service.BenefitsCalculationService;
import org.kuali.kfs.module.bc.util.BudgetConstructionUtils;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BenefitsCalculationServiceImpl
implements BenefitsCalculationService {
    protected ConfigurationService kualiConfigurationService;
    protected BenefitsCalculationDao benefitsCalculationDao;
    protected OptionsService optionsService;

    @Override
    public boolean isBenefitsCalculationDisabled() {
        return false;
    }

    @Override
    public void calculateAnnualBudgetConstructionGeneralLedgerBenefits(String documentNumber, Integer fiscalYear, String chartOfAccounts, String accountNumber, String subAccountNumber, String laborBenefitRateCategoryCode) {
        if (this.isBenefitsCalculationDisabled()) {
            return;
        }
        String finObjTypeExpenditureexpCd = this.optionsService.getOptions(fiscalYear).getFinObjTypeExpenditureexpCd();
        String expenditureINList = BudgetConstructionUtils.getExpenditureINList();
        this.benefitsCalculationDao.calculateAnnualBudgetConstructionGeneralLedgerBenefits(documentNumber, fiscalYear, chartOfAccounts, accountNumber, subAccountNumber, finObjTypeExpenditureexpCd, expenditureINList, laborBenefitRateCategoryCode);
    }

    @Override
    public void calculateAnnualBudgetConstructionGeneralLedgerBenefits(String documentNumber, Integer fiscalYear, String chartOfAccounts, String accountNumber, String subAccountNumber) {
        if (this.isBenefitsCalculationDisabled()) {
            return;
        }
        String finObjTypeExpenditureexpCd = this.optionsService.getOptions(fiscalYear).getFinObjTypeExpenditureexpCd();
        String expenditureINList = BudgetConstructionUtils.getExpenditureINList();
        this.benefitsCalculationDao.calculateAnnualBudgetConstructionGeneralLedgerBenefits(documentNumber, fiscalYear, chartOfAccounts, accountNumber, subAccountNumber, finObjTypeExpenditureexpCd, expenditureINList);
    }

    @Override
    public void calculateMonthlyBudgetConstructionGeneralLedgerBenefits(String documentNumber, Integer fiscalYear, String chartOfAccounts, String accountNumber, String subAccountNumber) {
        if (this.isBenefitsCalculationDisabled()) {
            return;
        }
        String finObjTypeExpenditureexpCd = this.optionsService.getOptions(fiscalYear).getFinObjTypeExpenditureexpCd();
        this.benefitsCalculationDao.calculateMonthlyBudgetConstructionGeneralLedgerBenefits(documentNumber, fiscalYear, chartOfAccounts, accountNumber, subAccountNumber, finObjTypeExpenditureexpCd);
    }

    @Override
    public void calculateMonthlyBudgetConstructionGeneralLedgerBenefits(String documentNumber, Integer fiscalYear, String chartOfAccounts, String accountNumber, String subAccountNumber, String laborBenefitRateCategoryCode) {
        if (this.isBenefitsCalculationDisabled()) {
            return;
        }
        String finObjTypeExpenditureexpCd = this.optionsService.getOptions(fiscalYear).getFinObjTypeExpenditureexpCd();
        this.benefitsCalculationDao.calculateMonthlyBudgetConstructionGeneralLedgerBenefits(documentNumber, fiscalYear, chartOfAccounts, accountNumber, subAccountNumber, finObjTypeExpenditureexpCd, laborBenefitRateCategoryCode);
    }

    @Override
    public void calculateAllBudgetConstructionGeneralLedgerBenefits(String documentNumber, Integer fiscalYear, String chartOfAccounts, String accountNumber, String subAccountNumber) {
        if (this.isBenefitsCalculationDisabled()) {
            return;
        }
        String finObjTypeExpenditureexpCd = this.optionsService.getOptions(fiscalYear).getFinObjTypeExpenditureexpCd();
        String expenditureINList = BudgetConstructionUtils.getExpenditureINList();
        this.benefitsCalculationDao.calculateAnnualBudgetConstructionGeneralLedgerBenefits(documentNumber, fiscalYear, chartOfAccounts, accountNumber, subAccountNumber, finObjTypeExpenditureexpCd, expenditureINList);
        this.benefitsCalculationDao.calculateMonthlyBudgetConstructionGeneralLedgerBenefits(documentNumber, fiscalYear, chartOfAccounts, accountNumber, subAccountNumber, finObjTypeExpenditureexpCd);
    }

    @Override
    public void calculateAllBudgetConstructionGeneralLedgerBenefits(String documentNumber, Integer fiscalYear, String chartOfAccounts, String accountNumber, String subAccountNumber, String laborBenefitRateCategoryCode) {
        if (this.isBenefitsCalculationDisabled()) {
            return;
        }
        String finObjTypeExpenditureexpCd = this.optionsService.getOptions(fiscalYear).getFinObjTypeExpenditureexpCd();
        String expenditureINList = BudgetConstructionUtils.getExpenditureINList();
        this.benefitsCalculationDao.calculateAnnualBudgetConstructionGeneralLedgerBenefits(documentNumber, fiscalYear, chartOfAccounts, accountNumber, subAccountNumber, finObjTypeExpenditureexpCd, expenditureINList, laborBenefitRateCategoryCode);
        this.benefitsCalculationDao.calculateMonthlyBudgetConstructionGeneralLedgerBenefits(documentNumber, fiscalYear, chartOfAccounts, accountNumber, subAccountNumber, finObjTypeExpenditureexpCd, laborBenefitRateCategoryCode);
    }

    public ConfigurationService getConfigurationService() {
        return this.kualiConfigurationService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setBenefitsCalculationDao(BenefitsCalculationDao benefitsCalculationDao) {
        this.benefitsCalculationDao = benefitsCalculationDao;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }
}

