/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAccountBalance;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgAccountObjectDetailReport;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgAccountObjectDetailReportTotal;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionAccountObjectDetailReportDao;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionAccountObjectDetailReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionOrganizationReportsService;
import org.kuali.kfs.module.bc.report.BudgetConstructionReportHelper;
import org.kuali.kfs.module.bc.util.BudgetConstructionUtils;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BudgetConstructionAccountObjectDetailReportServiceImpl
implements BudgetConstructionAccountObjectDetailReportService {
    protected BudgetConstructionAccountObjectDetailReportDao budgetConstructionAccountObjectDetailReportDao;
    protected ConfigurationService kualiConfigurationService;
    protected BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService;
    protected BusinessObjectService businessObjectService;
    protected PersistenceService persistenceServiceOjb;

    @Override
    public void updateAccountObjectDetailReport(String principalName, boolean consolidated) {
        String expenditureINList = BudgetConstructionUtils.getExpenditureINList();
        String revenueINList = BudgetConstructionUtils.getRevenueINList();
        if (consolidated) {
            this.budgetConstructionAccountObjectDetailReportDao.updateReportsAccountObjectConsolidatedTable(principalName, expenditureINList, revenueINList);
        } else {
            this.budgetConstructionAccountObjectDetailReportDao.updateReportsAccountObjectDetailTable(principalName, expenditureINList, revenueINList);
        }
    }

    @Override
    public Collection<BudgetConstructionOrgAccountObjectDetailReport> buildReports(Integer universityFiscalYear, String principalName, boolean consolidated) {
        ArrayList<BudgetConstructionOrgAccountObjectDetailReport> reportSet = new ArrayList<BudgetConstructionOrgAccountObjectDetailReport>();
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("principalId", principalName);
        this.persistenceServiceOjb.clearCache();
        List<String> orderList = this.buildOrderByList();
        List accountObjectDetailList = this.budgetConstructionOrganizationReportsService.getBySearchCriteriaOrderByList(BudgetConstructionAccountBalance.class, searchCriteria, orderList);
        List listForCalculateObject = BudgetConstructionReportHelper.deleteDuplicated(accountObjectDetailList, this.fieldsForObject());
        List listForCalculateLevel = BudgetConstructionReportHelper.deleteDuplicated(accountObjectDetailList, this.fieldsForLevel());
        List listForCalculateGexpAndType = BudgetConstructionReportHelper.deleteDuplicated(accountObjectDetailList, this.fieldsForGexpAndType());
        List listForCalculateAccountTotal = BudgetConstructionReportHelper.deleteDuplicated(accountObjectDetailList, this.fieldsForAccountTotal());
        List listForCalculateSubFundTotal = BudgetConstructionReportHelper.deleteDuplicated(accountObjectDetailList, this.fieldsForSubFundTotal());
        List accountObjectDetailTotalObjectList = this.calculateObjectTotal(accountObjectDetailList, listForCalculateObject);
        List accountObjectDetailTotalLevelList = this.calculateLevelTotal(accountObjectDetailList, listForCalculateLevel);
        List accountObjectDetailTotalGexpAndTypeList = this.calculateGexpAndTypeTotal(accountObjectDetailList, listForCalculateGexpAndType);
        List accountObjectDetailAccountTotalList = this.calculateAccountTotal(accountObjectDetailList, listForCalculateAccountTotal);
        List accountObjectDetailSubFundTotalList = this.calculateSubFundTotal(accountObjectDetailList, listForCalculateSubFundTotal);
        for (BudgetConstructionAccountBalance accountObjectDetailEntry : accountObjectDetailList) {
            BudgetConstructionOrgAccountObjectDetailReport accountObjectDetailReport = new BudgetConstructionOrgAccountObjectDetailReport();
            this.buildReportsHeader(universityFiscalYear, accountObjectDetailReport, accountObjectDetailEntry, consolidated);
            this.buildReportsBody(universityFiscalYear, accountObjectDetailReport, accountObjectDetailEntry);
            this.buildReportsTotal(accountObjectDetailReport, accountObjectDetailEntry, accountObjectDetailTotalObjectList, accountObjectDetailTotalLevelList, accountObjectDetailTotalGexpAndTypeList, accountObjectDetailAccountTotalList, accountObjectDetailSubFundTotalList);
            reportSet.add(accountObjectDetailReport);
        }
        return reportSet;
    }

    protected void buildReportsHeader(Integer universityFiscalYear, BudgetConstructionOrgAccountObjectDetailReport orgAccountObjectDetailReportEntry, BudgetConstructionAccountBalance accountBalance, boolean consolidated) {
        String orgChartDesc = accountBalance.getOrganizationChartOfAccounts().getFinChartOfAccountDescription();
        String chartDesc = accountBalance.getChartOfAccounts().getFinChartOfAccountDescription();
        String orgName = "";
        try {
            orgName = accountBalance.getOrganization().getOrganizationName();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
        String reportChartDesc = accountBalance.getChartOfAccounts().getReportsToChartOfAccounts().getFinChartOfAccountDescription();
        String subFundGroupName = accountBalance.getSubFundGroup().getSubFundGroupCode();
        String subFundGroupDes = accountBalance.getSubFundGroup().getSubFundGroupDescription();
        String fundGroupName = accountBalance.getSubFundGroup().getFundGroupCode();
        String fundGroupDes = accountBalance.getSubFundGroup().getFundGroup().getName();
        Integer prevFiscalyear = universityFiscalYear - 1;
        orgAccountObjectDetailReportEntry.setFiscalYear(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4));
        orgAccountObjectDetailReportEntry.setOrgChartOfAccountsCode(accountBalance.getOrganizationChartOfAccountsCode());
        if (orgChartDesc == null) {
            orgAccountObjectDetailReportEntry.setOrgChartOfAccountDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription"));
        } else {
            orgAccountObjectDetailReportEntry.setOrgChartOfAccountDescription(orgChartDesc);
        }
        orgAccountObjectDetailReportEntry.setOrganizationCode(accountBalance.getOrganizationCode());
        if (orgName == null) {
            orgAccountObjectDetailReportEntry.setOrganizationName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingOrganizationName"));
        } else {
            orgAccountObjectDetailReportEntry.setOrganizationName(orgName);
        }
        orgAccountObjectDetailReportEntry.setChartOfAccountsCode(accountBalance.getChartOfAccountsCode());
        if (chartDesc == null) {
            orgAccountObjectDetailReportEntry.setChartOfAccountDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription"));
        } else {
            orgAccountObjectDetailReportEntry.setChartOfAccountDescription(chartDesc);
        }
        orgAccountObjectDetailReportEntry.setFundGroupCode(accountBalance.getSubFundGroup().getFundGroupCode());
        if (fundGroupDes == null) {
            orgAccountObjectDetailReportEntry.setFundGroupName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingFundGroupName"));
        } else {
            orgAccountObjectDetailReportEntry.setFundGroupName(fundGroupDes);
        }
        orgAccountObjectDetailReportEntry.setSubFundGroupCode(accountBalance.getSubFundGroupCode());
        if (subFundGroupDes == null) {
            orgAccountObjectDetailReportEntry.setSubFundGroupDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingSubFundGroupDescription"));
        } else {
            orgAccountObjectDetailReportEntry.setSubFundGroupDescription(subFundGroupDes);
        }
        Integer prevPrevFiscalyear = prevFiscalyear - 1;
        orgAccountObjectDetailReportEntry.setBaseFy(prevPrevFiscalyear.toString() + "-" + prevFiscalyear.toString().substring(2, 4) + " Base");
        orgAccountObjectDetailReportEntry.setReqFy(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4) + " Request");
        if (consolidated) {
            orgAccountObjectDetailReportEntry.setConsHdr("Consolidated");
        } else {
            orgAccountObjectDetailReportEntry.setConsHdr("");
        }
        orgAccountObjectDetailReportEntry.setAccountNumber(accountBalance.getAccountNumber());
        String accountName = accountBalance.getAccount().getAccountName();
        if (accountName == null) {
            orgAccountObjectDetailReportEntry.setAccountName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingAccountDescription"));
        } else {
            orgAccountObjectDetailReportEntry.setAccountName(accountName);
        }
        orgAccountObjectDetailReportEntry.setSubAccountNumber(accountBalance.getSubAccountNumber());
        String subAccountName = "";
        String subAccountNumberAndName = "";
        String divider = "";
        if (accountBalance.getAccount() != null) {
            orgAccountObjectDetailReportEntry.setAccountNumberAndName(accountBalance.getAccountNumber() + " " + accountBalance.getAccount().getAccountName());
            orgAccountObjectDetailReportEntry.setAccountName(accountBalance.getAccount().getAccountName());
        }
        if (!accountBalance.getSubAccountNumber().equals(KFSConstants.getDashSubAccountNumber())) {
            divider = "/";
            try {
                subAccountName = accountBalance.getSubAccount().getSubAccountName();
                subAccountNumberAndName = accountBalance.getSubAccount().getSubAccountNumber() + " " + accountBalance.getSubAccount().getSubAccountName();
            }
            catch (PersistenceBrokerException e) {
                subAccountNumberAndName = subAccountName = this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingSubAccountDescription");
            }
        }
        orgAccountObjectDetailReportEntry.setSubAccountName(subAccountName);
        orgAccountObjectDetailReportEntry.setSubAccountNumberAndName(subAccountNumberAndName);
        orgAccountObjectDetailReportEntry.setDivider(divider);
        orgAccountObjectDetailReportEntry.setSubAccountNumber(accountBalance.getSubAccountNumber() + accountBalance.getAccountNumber());
        orgAccountObjectDetailReportEntry.setFinancialObjectCode(accountBalance.getFinancialObjectCode());
        orgAccountObjectDetailReportEntry.setFinancialSubObjectCode(accountBalance.getFinancialSubObjectCode());
        orgAccountObjectDetailReportEntry.setIncomeExpenseCode(accountBalance.getIncomeExpenseCode());
        orgAccountObjectDetailReportEntry.setFinancialLevelSortCode(accountBalance.getFinancialLevelSortCode());
        orgAccountObjectDetailReportEntry.setPageBreak(accountBalance.getOrganizationChartOfAccountsCode() + accountBalance.getOrganizationCode() + accountBalance.getSubFundGroupCode());
    }

    protected void buildReportsBody(Integer universityFiscalYear, BudgetConstructionOrgAccountObjectDetailReport orgAccountObjectDetailReportEntry, BudgetConstructionAccountBalance accountBalance) {
        if (accountBalance.getFinancialSubObjectCode().equals(KFSConstants.getDashFinancialSubObjectCode())) {
            orgAccountObjectDetailReportEntry.setFinancialObjectName(accountBalance.getFinancialObject().getFinancialObjectCodeName());
        } else {
            orgAccountObjectDetailReportEntry.setFinancialObjectName(accountBalance.getFinancialSubObject().getFinancialSubObjectCodeName());
        }
        orgAccountObjectDetailReportEntry.setPositionCsfLeaveFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(accountBalance.getPositionCsfLeaveFteQuantity(), 2, true));
        orgAccountObjectDetailReportEntry.setPositionFullTimeEquivalencyQuantity(BudgetConstructionReportHelper.setDecimalDigit(accountBalance.getPositionFullTimeEquivalencyQuantity(), 2, true));
        orgAccountObjectDetailReportEntry.setAppointmentRequestedCsfFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(accountBalance.getAppointmentRequestedCsfFteQuantity(), 2, true));
        orgAccountObjectDetailReportEntry.setAppointmentRequestedFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(accountBalance.getAppointmentRequestedFteQuantity(), 2, true));
        orgAccountObjectDetailReportEntry.setAccountLineAnnualBalanceAmount(accountBalance.getAccountLineAnnualBalanceAmount());
        orgAccountObjectDetailReportEntry.setFinancialBeginningBalanceLineAmount(accountBalance.getFinancialBeginningBalanceLineAmount());
        orgAccountObjectDetailReportEntry.setAmountChange(accountBalance.getAccountLineAnnualBalanceAmount().subtract(accountBalance.getFinancialBeginningBalanceLineAmount()));
        orgAccountObjectDetailReportEntry.setPercentChange(BudgetConstructionReportHelper.calculatePercent(orgAccountObjectDetailReportEntry.getAmountChange(), orgAccountObjectDetailReportEntry.getFinancialBeginningBalanceLineAmount()));
    }

    protected void buildReportsTotal(BudgetConstructionOrgAccountObjectDetailReport orgObjectSummaryReportEntry, BudgetConstructionAccountBalance accountBalance, List<BudgetConstructionOrgAccountObjectDetailReportTotal> accountObjectDetailTotalObjectList, List<BudgetConstructionOrgAccountObjectDetailReportTotal> accountObjectDetailTotalLevelList, List<BudgetConstructionOrgAccountObjectDetailReportTotal> accountObjectDetailTotalGexpAndTypeList, List<BudgetConstructionOrgAccountObjectDetailReportTotal> accountObjectDetailAccountTotalList, List<BudgetConstructionOrgAccountObjectDetailReportTotal> accountObjectDetailSubFundTotalList) {
        for (BudgetConstructionOrgAccountObjectDetailReportTotal objectTotal : accountObjectDetailTotalObjectList) {
            if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)accountBalance, (BusinessObject)objectTotal.getBudgetConstructionAccountBalance(), this.fieldsForObject())) continue;
            orgObjectSummaryReportEntry.setTotalObjectDescription(accountBalance.getFinancialObject().getFinancialObjectCodeName());
            orgObjectSummaryReportEntry.setTotalObjectPositionCsfLeaveFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(objectTotal.getTotalObjectPositionCsfLeaveFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setTotalObjectPositionFullTimeEquivalencyQuantity(BudgetConstructionReportHelper.setDecimalDigit(objectTotal.getTotalObjectPositionFullTimeEquivalencyQuantity(), 2, true));
            orgObjectSummaryReportEntry.setTotalObjectFinancialBeginningBalanceLineAmount(objectTotal.getTotalObjectFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setTotalObjectAppointmentRequestedCsfFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(objectTotal.getTotalObjectAppointmentRequestedCsfFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setTotalObjectAppointmentRequestedFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(objectTotal.getTotalObjectAppointmentRequestedFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setTotalObjectAccountLineAnnualBalanceAmount(objectTotal.getTotalObjectAccountLineAnnualBalanceAmount());
            KualiInteger totalObjectAmountChange = objectTotal.getTotalObjectAccountLineAnnualBalanceAmount().subtract(objectTotal.getTotalObjectFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setTotalObjectAmountChange(totalObjectAmountChange);
            orgObjectSummaryReportEntry.setTotalObjectPercentChange(BudgetConstructionReportHelper.calculatePercent(totalObjectAmountChange, objectTotal.getTotalObjectFinancialBeginningBalanceLineAmount()));
        }
        for (BudgetConstructionOrgAccountObjectDetailReportTotal levelTotal : accountObjectDetailTotalLevelList) {
            if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)accountBalance, (BusinessObject)levelTotal.getBudgetConstructionAccountBalance(), this.fieldsForLevel())) continue;
            orgObjectSummaryReportEntry.setTotalLevelDescription(accountBalance.getFinancialObjectLevel().getFinancialObjectLevelName());
            orgObjectSummaryReportEntry.setTotalLevelPositionCsfLeaveFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(levelTotal.getTotalLevelPositionCsfLeaveFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setTotalLevelPositionFullTimeEquivalencyQuantity(BudgetConstructionReportHelper.setDecimalDigit(levelTotal.getTotalLevelPositionFullTimeEquivalencyQuantity(), 2, true));
            orgObjectSummaryReportEntry.setTotalLevelFinancialBeginningBalanceLineAmount(levelTotal.getTotalLevelFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setTotalLevelAppointmentRequestedCsfFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(levelTotal.getTotalLevelAppointmentRequestedCsfFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setTotalLevelAppointmentRequestedFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(levelTotal.getTotalLevelAppointmentRequestedFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setTotalLevelAccountLineAnnualBalanceAmount(levelTotal.getTotalLevelAccountLineAnnualBalanceAmount());
            KualiInteger totalLevelAmountChange = levelTotal.getTotalLevelAccountLineAnnualBalanceAmount().subtract(levelTotal.getTotalLevelFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setTotalLevelAmountChange(totalLevelAmountChange);
            orgObjectSummaryReportEntry.setTotalLevelPercentChange(BudgetConstructionReportHelper.calculatePercent(totalLevelAmountChange, levelTotal.getTotalLevelFinancialBeginningBalanceLineAmount()));
        }
        for (BudgetConstructionOrgAccountObjectDetailReportTotal gexpAndTypeTotal : accountObjectDetailTotalGexpAndTypeList) {
            if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)accountBalance, (BusinessObject)gexpAndTypeTotal.getBudgetConstructionAccountBalance(), this.fieldsForGexpAndType())) continue;
            orgObjectSummaryReportEntry.setGrossFinancialBeginningBalanceLineAmount(gexpAndTypeTotal.getGrossFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setGrossAccountLineAnnualBalanceAmount(gexpAndTypeTotal.getGrossAccountLineAnnualBalanceAmount());
            KualiInteger grossAmountChange = gexpAndTypeTotal.getGrossAccountLineAnnualBalanceAmount().subtract(gexpAndTypeTotal.getGrossFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setGrossAmountChange(grossAmountChange);
            orgObjectSummaryReportEntry.setGrossPercentChange(BudgetConstructionReportHelper.calculatePercent(grossAmountChange, gexpAndTypeTotal.getGrossFinancialBeginningBalanceLineAmount()));
            if (accountBalance.getIncomeExpenseCode().equals("A")) {
                orgObjectSummaryReportEntry.setTypeDesc(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.incomeExpDescUppercaseRevenue"));
            } else {
                orgObjectSummaryReportEntry.setTypeDesc(this.kualiConfigurationService.getPropertyValueAsString("message.budget.report.incomeExpDescExpenditureNetTrnfr"));
            }
            orgObjectSummaryReportEntry.setTypePositionCsfLeaveFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(gexpAndTypeTotal.getTypePositionCsfLeaveFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setTypePositionFullTimeEquivalencyQuantity(BudgetConstructionReportHelper.setDecimalDigit(gexpAndTypeTotal.getTypePositionFullTimeEquivalencyQuantity(), 2, true));
            orgObjectSummaryReportEntry.setTypeFinancialBeginningBalanceLineAmount(gexpAndTypeTotal.getTypeFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setTypeAppointmentRequestedCsfFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(gexpAndTypeTotal.getTypeAppointmentRequestedCsfFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setTypeAppointmentRequestedFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(gexpAndTypeTotal.getTypeAppointmentRequestedFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setTypeAccountLineAnnualBalanceAmount(gexpAndTypeTotal.getTypeAccountLineAnnualBalanceAmount());
            KualiInteger typeAmountChange = gexpAndTypeTotal.getTypeAccountLineAnnualBalanceAmount().subtract(gexpAndTypeTotal.getTypeFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setTypeAmountChange(typeAmountChange);
            orgObjectSummaryReportEntry.setTypePercentChange(BudgetConstructionReportHelper.calculatePercent(typeAmountChange, gexpAndTypeTotal.getTypeFinancialBeginningBalanceLineAmount()));
        }
        for (BudgetConstructionOrgAccountObjectDetailReportTotal accountTotal : accountObjectDetailAccountTotalList) {
            if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)accountBalance, (BusinessObject)accountTotal.getBudgetConstructionAccountBalance(), this.fieldsForAccountTotal())) continue;
            if (orgObjectSummaryReportEntry.getSubAccountName().equals("")) {
                orgObjectSummaryReportEntry.setAccountNameForAccountTotal(orgObjectSummaryReportEntry.getAccountName());
            } else {
                orgObjectSummaryReportEntry.setAccountNameForAccountTotal(orgObjectSummaryReportEntry.getSubAccountName());
            }
            orgObjectSummaryReportEntry.setAccountPositionCsfLeaveFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(accountTotal.getAccountPositionCsfLeaveFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setAccountPositionFullTimeEquivalencyQuantity(BudgetConstructionReportHelper.setDecimalDigit(accountTotal.getAccountPositionFullTimeEquivalencyQuantity(), 2, true));
            orgObjectSummaryReportEntry.setAccountAppointmentRequestedCsfFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(accountTotal.getAccountAppointmentRequestedCsfFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setAccountAppointmentRequestedFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(accountTotal.getAccountAppointmentRequestedFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setAccountRevenueFinancialBeginningBalanceLineAmount(accountTotal.getAccountRevenueFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setAccountRevenueAccountLineAnnualBalanceAmount(accountTotal.getAccountRevenueAccountLineAnnualBalanceAmount());
            KualiInteger accountRevenueAmountChange = accountTotal.getAccountRevenueAccountLineAnnualBalanceAmount().subtract(accountTotal.getAccountRevenueFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setAccountRevenueAmountChange(accountRevenueAmountChange);
            orgObjectSummaryReportEntry.setAccountRevenuePercentChange(BudgetConstructionReportHelper.calculatePercent(accountRevenueAmountChange, accountTotal.getAccountRevenueFinancialBeginningBalanceLineAmount()));
            KualiInteger accountGrossFinancialBeginningBalanceLineAmount = accountTotal.getAccountExpenditureFinancialBeginningBalanceLineAmount().subtract(accountTotal.getAccountTrnfrInFinancialBeginningBalanceLineAmount());
            KualiInteger accountGrossAccountLineAnnualBalanceAmount = accountTotal.getAccountExpenditureAccountLineAnnualBalanceAmount().subtract(accountTotal.getAccountTrnfrInAccountLineAnnualBalanceAmount());
            orgObjectSummaryReportEntry.setAccountGrossFinancialBeginningBalanceLineAmount(accountGrossFinancialBeginningBalanceLineAmount);
            orgObjectSummaryReportEntry.setAccountGrossAccountLineAnnualBalanceAmount(accountGrossAccountLineAnnualBalanceAmount);
            KualiInteger accountGrossAmountChange = accountGrossAccountLineAnnualBalanceAmount.subtract(accountGrossFinancialBeginningBalanceLineAmount);
            orgObjectSummaryReportEntry.setAccountGrossAmountChange(accountGrossAmountChange);
            orgObjectSummaryReportEntry.setAccountGrossPercentChange(BudgetConstructionReportHelper.calculatePercent(accountGrossAmountChange, accountGrossFinancialBeginningBalanceLineAmount));
            orgObjectSummaryReportEntry.setAccountTrnfrInFinancialBeginningBalanceLineAmount(accountTotal.getAccountTrnfrInFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setAccountTrnfrInAccountLineAnnualBalanceAmount(accountTotal.getAccountTrnfrInAccountLineAnnualBalanceAmount());
            KualiInteger accountTrnfrInAmountChange = accountTotal.getAccountTrnfrInAccountLineAnnualBalanceAmount().subtract(accountTotal.getAccountTrnfrInFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setAccountTrnfrInAmountChange(accountTrnfrInAmountChange);
            orgObjectSummaryReportEntry.setAccountTrnfrInPercentChange(BudgetConstructionReportHelper.calculatePercent(accountTrnfrInAmountChange, accountTotal.getAccountTrnfrInFinancialBeginningBalanceLineAmount()));
            orgObjectSummaryReportEntry.setAccountExpenditureFinancialBeginningBalanceLineAmount(accountTotal.getAccountExpenditureFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setAccountExpenditureAccountLineAnnualBalanceAmount(accountTotal.getAccountExpenditureAccountLineAnnualBalanceAmount());
            KualiInteger accountExpenditureAmountChange = accountTotal.getAccountExpenditureAccountLineAnnualBalanceAmount().subtract(accountTotal.getAccountExpenditureFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setAccountExpenditureAmountChange(accountExpenditureAmountChange);
            orgObjectSummaryReportEntry.setAccountExpenditurePercentChange(BudgetConstructionReportHelper.calculatePercent(accountExpenditureAmountChange, accountTotal.getAccountExpenditureFinancialBeginningBalanceLineAmount()));
            KualiInteger accountDifferenceFinancialBeginningBalanceLineAmount = accountTotal.getAccountRevenueFinancialBeginningBalanceLineAmount().subtract(accountTotal.getAccountExpenditureFinancialBeginningBalanceLineAmount());
            KualiInteger accountDifferenceAccountLineAnnualBalanceAmount = accountTotal.getAccountRevenueAccountLineAnnualBalanceAmount().subtract(accountTotal.getAccountExpenditureAccountLineAnnualBalanceAmount());
            orgObjectSummaryReportEntry.setAccountDifferenceFinancialBeginningBalanceLineAmount(accountDifferenceFinancialBeginningBalanceLineAmount);
            orgObjectSummaryReportEntry.setAccountDifferenceAccountLineAnnualBalanceAmount(accountDifferenceAccountLineAnnualBalanceAmount);
            orgObjectSummaryReportEntry.setAccountDifferenceFinancialBeginningBalanceLineAmount(accountDifferenceFinancialBeginningBalanceLineAmount);
            orgObjectSummaryReportEntry.setAccountDifferenceAccountLineAnnualBalanceAmount(accountDifferenceAccountLineAnnualBalanceAmount);
            KualiInteger accountDifferenceAmountChange = accountDifferenceAccountLineAnnualBalanceAmount.subtract(accountDifferenceFinancialBeginningBalanceLineAmount);
            orgObjectSummaryReportEntry.setAccountDifferenceAmountChange(accountDifferenceAmountChange);
            orgObjectSummaryReportEntry.setAccountDifferencePercentChange(BudgetConstructionReportHelper.calculatePercent(accountDifferenceAmountChange, accountDifferenceFinancialBeginningBalanceLineAmount));
        }
        for (BudgetConstructionOrgAccountObjectDetailReportTotal subFundTotal : accountObjectDetailSubFundTotalList) {
            if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)accountBalance, (BusinessObject)subFundTotal.getBudgetConstructionAccountBalance(), this.fieldsForSubFundTotal())) continue;
            orgObjectSummaryReportEntry.setSubFundPositionCsfLeaveFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(subFundTotal.getSubFundPositionCsfLeaveFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setSubFundPositionFullTimeEquivalencyQuantity(BudgetConstructionReportHelper.setDecimalDigit(subFundTotal.getSubFundPositionFullTimeEquivalencyQuantity(), 2, true));
            orgObjectSummaryReportEntry.setSubFundAppointmentRequestedCsfFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(subFundTotal.getSubFundAppointmentRequestedCsfFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setSubFundAppointmentRequestedFteQuantity(BudgetConstructionReportHelper.setDecimalDigit(subFundTotal.getSubFundAppointmentRequestedFteQuantity(), 2, true));
            orgObjectSummaryReportEntry.setSubFundRevenueFinancialBeginningBalanceLineAmount(subFundTotal.getSubFundRevenueFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setSubFundRevenueAccountLineAnnualBalanceAmount(subFundTotal.getSubFundRevenueAccountLineAnnualBalanceAmount());
            KualiInteger subFundRevenueAmountChange = subFundTotal.getSubFundRevenueAccountLineAnnualBalanceAmount().subtract(subFundTotal.getSubFundRevenueFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setSubFundRevenueAmountChange(subFundRevenueAmountChange);
            orgObjectSummaryReportEntry.setSubFundRevenuePercentChange(BudgetConstructionReportHelper.calculatePercent(subFundRevenueAmountChange, subFundTotal.getSubFundRevenueFinancialBeginningBalanceLineAmount()));
            KualiInteger subFundGrossFinancialBeginningBalanceLineAmount = subFundTotal.getSubFundExpenditureFinancialBeginningBalanceLineAmount().subtract(subFundTotal.getSubFundTrnfrInFinancialBeginningBalanceLineAmount());
            KualiInteger subFundGrossAccountLineAnnualBalanceAmount = subFundTotal.getSubFundExpenditureAccountLineAnnualBalanceAmount().subtract(subFundTotal.getSubFundTrnfrInAccountLineAnnualBalanceAmount());
            orgObjectSummaryReportEntry.setSubFundGrossFinancialBeginningBalanceLineAmount(subFundGrossFinancialBeginningBalanceLineAmount);
            orgObjectSummaryReportEntry.setSubFundGrossAccountLineAnnualBalanceAmount(subFundGrossAccountLineAnnualBalanceAmount);
            KualiInteger subFundGrossAmountChange = subFundGrossAccountLineAnnualBalanceAmount.subtract(subFundGrossFinancialBeginningBalanceLineAmount);
            orgObjectSummaryReportEntry.setSubFundGrossAmountChange(subFundGrossAmountChange);
            orgObjectSummaryReportEntry.setSubFundGrossPercentChange(BudgetConstructionReportHelper.calculatePercent(subFundGrossAmountChange, subFundGrossFinancialBeginningBalanceLineAmount));
            orgObjectSummaryReportEntry.setSubFundTrnfrInFinancialBeginningBalanceLineAmount(subFundTotal.getSubFundTrnfrInFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setSubFundTrnfrInAccountLineAnnualBalanceAmount(subFundTotal.getSubFundTrnfrInAccountLineAnnualBalanceAmount());
            KualiInteger subFundTrnfrInAmountChange = subFundTotal.getSubFundTrnfrInAccountLineAnnualBalanceAmount().subtract(subFundTotal.getSubFundTrnfrInFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setSubFundTrnfrInAmountChange(subFundTrnfrInAmountChange);
            orgObjectSummaryReportEntry.setSubFundTrnfrInPercentChange(BudgetConstructionReportHelper.calculatePercent(subFundTrnfrInAmountChange, subFundTotal.getSubFundTrnfrInFinancialBeginningBalanceLineAmount()));
            orgObjectSummaryReportEntry.setSubFundExpenditureFinancialBeginningBalanceLineAmount(subFundTotal.getSubFundExpenditureFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setSubFundExpenditureAccountLineAnnualBalanceAmount(subFundTotal.getSubFundExpenditureAccountLineAnnualBalanceAmount());
            KualiInteger subFundExpenditureAmountChange = subFundTotal.getSubFundExpenditureAccountLineAnnualBalanceAmount().subtract(subFundTotal.getSubFundExpenditureFinancialBeginningBalanceLineAmount());
            orgObjectSummaryReportEntry.setSubFundExpenditureAmountChange(subFundExpenditureAmountChange);
            orgObjectSummaryReportEntry.setSubFundExpenditurePercentChange(BudgetConstructionReportHelper.calculatePercent(subFundExpenditureAmountChange, subFundTotal.getSubFundExpenditureFinancialBeginningBalanceLineAmount()));
            KualiInteger subFundDifferenceFinancialBeginningBalanceLineAmount = subFundTotal.getSubFundRevenueFinancialBeginningBalanceLineAmount().subtract(subFundTotal.getSubFundExpenditureFinancialBeginningBalanceLineAmount());
            KualiInteger subFundDifferenceAccountLineAnnualBalanceAmount = subFundTotal.getSubFundRevenueAccountLineAnnualBalanceAmount().subtract(subFundTotal.getSubFundExpenditureAccountLineAnnualBalanceAmount());
            orgObjectSummaryReportEntry.setSubFundDifferenceFinancialBeginningBalanceLineAmount(subFundDifferenceFinancialBeginningBalanceLineAmount);
            orgObjectSummaryReportEntry.setSubFundDifferenceAccountLineAnnualBalanceAmount(subFundDifferenceAccountLineAnnualBalanceAmount);
            orgObjectSummaryReportEntry.setSubFundDifferenceFinancialBeginningBalanceLineAmount(subFundDifferenceFinancialBeginningBalanceLineAmount);
            orgObjectSummaryReportEntry.setSubFundDifferenceAccountLineAnnualBalanceAmount(subFundDifferenceAccountLineAnnualBalanceAmount);
            KualiInteger subFundDifferenceAmountChange = subFundDifferenceAccountLineAnnualBalanceAmount.subtract(subFundDifferenceFinancialBeginningBalanceLineAmount);
            orgObjectSummaryReportEntry.setSubFundDifferenceAmountChange(subFundDifferenceAmountChange);
            orgObjectSummaryReportEntry.setSubFundDifferencePercentChange(BudgetConstructionReportHelper.calculatePercent(subFundDifferenceAmountChange, subFundDifferenceFinancialBeginningBalanceLineAmount));
        }
    }

    protected List calculateObjectTotal(List<BudgetConstructionAccountBalance> bcosList, List<BudgetConstructionAccountBalance> simpleList) {
        BigDecimal totalObjectPositionCsfLeaveFteQuantity = BigDecimal.ZERO;
        BigDecimal totalObjectPositionFullTimeEquivalencyQuantity = BigDecimal.ZERO;
        KualiInteger totalObjectFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
        BigDecimal totalObjectAppointmentRequestedCsfFteQuantity = BigDecimal.ZERO;
        BigDecimal totalObjectAppointmentRequestedFteQuantity = BigDecimal.ZERO;
        KualiInteger totalObjectAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        ArrayList<BudgetConstructionOrgAccountObjectDetailReportTotal> returnList = new ArrayList<BudgetConstructionOrgAccountObjectDetailReportTotal>();
        for (BudgetConstructionAccountBalance simpleBcosEntry : simpleList) {
            BudgetConstructionOrgAccountObjectDetailReportTotal bcObjectTotal = new BudgetConstructionOrgAccountObjectDetailReportTotal();
            for (BudgetConstructionAccountBalance bcosListEntry : bcosList) {
                if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)simpleBcosEntry, (BusinessObject)bcosListEntry, this.fieldsForObject())) continue;
                totalObjectFinancialBeginningBalanceLineAmount = totalObjectFinancialBeginningBalanceLineAmount.add(bcosListEntry.getFinancialBeginningBalanceLineAmount());
                totalObjectAccountLineAnnualBalanceAmount = totalObjectAccountLineAnnualBalanceAmount.add(bcosListEntry.getAccountLineAnnualBalanceAmount());
                totalObjectPositionCsfLeaveFteQuantity = totalObjectPositionCsfLeaveFteQuantity.add(bcosListEntry.getPositionCsfLeaveFteQuantity());
                totalObjectPositionFullTimeEquivalencyQuantity = totalObjectPositionFullTimeEquivalencyQuantity.add(bcosListEntry.getPositionFullTimeEquivalencyQuantity());
                totalObjectAppointmentRequestedCsfFteQuantity = totalObjectAppointmentRequestedCsfFteQuantity.add(bcosListEntry.getAppointmentRequestedCsfFteQuantity());
                totalObjectAppointmentRequestedFteQuantity = totalObjectAppointmentRequestedFteQuantity.add(bcosListEntry.getAppointmentRequestedFteQuantity());
            }
            bcObjectTotal.setBudgetConstructionAccountBalance(simpleBcosEntry);
            bcObjectTotal.setTotalObjectPositionCsfLeaveFteQuantity(totalObjectPositionCsfLeaveFteQuantity);
            bcObjectTotal.setTotalObjectPositionFullTimeEquivalencyQuantity(totalObjectPositionFullTimeEquivalencyQuantity);
            bcObjectTotal.setTotalObjectFinancialBeginningBalanceLineAmount(totalObjectFinancialBeginningBalanceLineAmount);
            bcObjectTotal.setTotalObjectAppointmentRequestedCsfFteQuantity(totalObjectAppointmentRequestedCsfFteQuantity);
            bcObjectTotal.setTotalObjectAppointmentRequestedFteQuantity(totalObjectAppointmentRequestedFteQuantity);
            bcObjectTotal.setTotalObjectAccountLineAnnualBalanceAmount(totalObjectAccountLineAnnualBalanceAmount);
            returnList.add(bcObjectTotal);
            totalObjectPositionCsfLeaveFteQuantity = BigDecimal.ZERO;
            totalObjectPositionFullTimeEquivalencyQuantity = BigDecimal.ZERO;
            totalObjectFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
            totalObjectAppointmentRequestedCsfFteQuantity = BigDecimal.ZERO;
            totalObjectAppointmentRequestedFteQuantity = BigDecimal.ZERO;
            totalObjectAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        }
        return returnList;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected List calculateLevelTotal(List<BudgetConstructionAccountBalance> bcosList, List<BudgetConstructionAccountBalance> simpleList) {
        BigDecimal totalLevelPositionCsfLeaveFteQuantity = BigDecimal.ZERO;
        BigDecimal totalLevelPositionFullTimeEquivalencyQuantity = BigDecimal.ZERO;
        KualiInteger totalLevelFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
        BigDecimal totalLevelAppointmentRequestedCsfFteQuantity = BigDecimal.ZERO;
        BigDecimal totalLevelAppointmentRequestedFteQuantity = BigDecimal.ZERO;
        KualiInteger totalLevelAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        ArrayList<BudgetConstructionOrgAccountObjectDetailReportTotal> returnList = new ArrayList<BudgetConstructionOrgAccountObjectDetailReportTotal>();
        for (BudgetConstructionAccountBalance simpleBcosEntry : simpleList) {
            BudgetConstructionOrgAccountObjectDetailReportTotal bcObjectTotal = new BudgetConstructionOrgAccountObjectDetailReportTotal();
            for (BudgetConstructionAccountBalance bcosListEntry : bcosList) {
                if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)simpleBcosEntry, (BusinessObject)bcosListEntry, this.fieldsForLevel())) continue;
                totalLevelFinancialBeginningBalanceLineAmount = totalLevelFinancialBeginningBalanceLineAmount.add(bcosListEntry.getFinancialBeginningBalanceLineAmount());
                totalLevelAccountLineAnnualBalanceAmount = totalLevelAccountLineAnnualBalanceAmount.add(bcosListEntry.getAccountLineAnnualBalanceAmount());
                totalLevelPositionCsfLeaveFteQuantity = totalLevelPositionCsfLeaveFteQuantity.add(bcosListEntry.getPositionCsfLeaveFteQuantity());
                totalLevelPositionFullTimeEquivalencyQuantity = totalLevelPositionFullTimeEquivalencyQuantity.add(bcosListEntry.getPositionFullTimeEquivalencyQuantity());
                totalLevelAppointmentRequestedCsfFteQuantity = totalLevelAppointmentRequestedCsfFteQuantity.add(bcosListEntry.getAppointmentRequestedCsfFteQuantity());
                totalLevelAppointmentRequestedFteQuantity = totalLevelAppointmentRequestedFteQuantity.add(bcosListEntry.getAppointmentRequestedFteQuantity());
            }
            bcObjectTotal.setBudgetConstructionAccountBalance(simpleBcosEntry);
            bcObjectTotal.setTotalLevelPositionCsfLeaveFteQuantity(totalLevelPositionCsfLeaveFteQuantity);
            bcObjectTotal.setTotalLevelPositionFullTimeEquivalencyQuantity(totalLevelPositionFullTimeEquivalencyQuantity);
            bcObjectTotal.setTotalLevelFinancialBeginningBalanceLineAmount(totalLevelFinancialBeginningBalanceLineAmount);
            bcObjectTotal.setTotalLevelAppointmentRequestedCsfFteQuantity(totalLevelAppointmentRequestedCsfFteQuantity);
            bcObjectTotal.setTotalLevelAppointmentRequestedFteQuantity(totalLevelAppointmentRequestedFteQuantity);
            bcObjectTotal.setTotalLevelAccountLineAnnualBalanceAmount(totalLevelAccountLineAnnualBalanceAmount);
            returnList.add(bcObjectTotal);
            totalLevelPositionCsfLeaveFteQuantity = BigDecimal.ZERO;
            totalLevelPositionFullTimeEquivalencyQuantity = BigDecimal.ZERO;
            totalLevelFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
            totalLevelAppointmentRequestedCsfFteQuantity = BigDecimal.ZERO;
            totalLevelAppointmentRequestedFteQuantity = BigDecimal.ZERO;
            totalLevelAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        }
        return returnList;
    }

    protected List calculateGexpAndTypeTotal(List<BudgetConstructionAccountBalance> bcabList, List<BudgetConstructionAccountBalance> simpleList) {
        KualiInteger grossFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
        KualiInteger grossAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        BigDecimal typePositionCsfLeaveFteQuantity = BigDecimal.ZERO;
        BigDecimal typePositionFullTimeEquivalencyQuantity = BigDecimal.ZERO;
        KualiInteger typeFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
        BigDecimal typeAppointmentRequestedCsfFteQuantity = BigDecimal.ZERO;
        BigDecimal typeAppointmentRequestedFteQuantity = BigDecimal.ZERO;
        KualiInteger typeAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        ArrayList<BudgetConstructionOrgAccountObjectDetailReportTotal> returnList = new ArrayList<BudgetConstructionOrgAccountObjectDetailReportTotal>();
        for (BudgetConstructionAccountBalance simpleBcosEntry : simpleList) {
            BudgetConstructionOrgAccountObjectDetailReportTotal bcObjectTotal = new BudgetConstructionOrgAccountObjectDetailReportTotal();
            for (BudgetConstructionAccountBalance bcabListEntry : bcabList) {
                if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)simpleBcosEntry, (BusinessObject)bcabListEntry, this.fieldsForGexpAndType())) continue;
                typeFinancialBeginningBalanceLineAmount = typeFinancialBeginningBalanceLineAmount.add(bcabListEntry.getFinancialBeginningBalanceLineAmount());
                typeAccountLineAnnualBalanceAmount = typeAccountLineAnnualBalanceAmount.add(bcabListEntry.getAccountLineAnnualBalanceAmount());
                typePositionCsfLeaveFteQuantity = typePositionCsfLeaveFteQuantity.add(bcabListEntry.getPositionCsfLeaveFteQuantity());
                typePositionFullTimeEquivalencyQuantity = typePositionFullTimeEquivalencyQuantity.add(bcabListEntry.getPositionFullTimeEquivalencyQuantity());
                typeAppointmentRequestedCsfFteQuantity = typeAppointmentRequestedCsfFteQuantity.add(bcabListEntry.getAppointmentRequestedCsfFteQuantity());
                typeAppointmentRequestedFteQuantity = typeAppointmentRequestedFteQuantity.add(bcabListEntry.getAppointmentRequestedFteQuantity());
                if (!bcabListEntry.getIncomeExpenseCode().equals("B") || bcabListEntry.getFinancialObjectLevelCode().equals("CORI") || bcabListEntry.getFinancialObjectLevelCode().equals("TRIN")) continue;
                grossFinancialBeginningBalanceLineAmount = grossFinancialBeginningBalanceLineAmount.add(bcabListEntry.getFinancialBeginningBalanceLineAmount());
                grossAccountLineAnnualBalanceAmount = grossAccountLineAnnualBalanceAmount.add(bcabListEntry.getAccountLineAnnualBalanceAmount());
            }
            bcObjectTotal.setBudgetConstructionAccountBalance(simpleBcosEntry);
            bcObjectTotal.setGrossFinancialBeginningBalanceLineAmount(grossFinancialBeginningBalanceLineAmount);
            bcObjectTotal.setGrossAccountLineAnnualBalanceAmount(grossAccountLineAnnualBalanceAmount);
            bcObjectTotal.setTypePositionCsfLeaveFteQuantity(typePositionCsfLeaveFteQuantity);
            bcObjectTotal.setTypePositionFullTimeEquivalencyQuantity(typePositionFullTimeEquivalencyQuantity);
            bcObjectTotal.setTypeFinancialBeginningBalanceLineAmount(typeFinancialBeginningBalanceLineAmount);
            bcObjectTotal.setTypeAppointmentRequestedCsfFteQuantity(typeAppointmentRequestedCsfFteQuantity);
            bcObjectTotal.setTypeAppointmentRequestedFteQuantity(typeAppointmentRequestedFteQuantity);
            bcObjectTotal.setTypeAccountLineAnnualBalanceAmount(typeAccountLineAnnualBalanceAmount);
            returnList.add(bcObjectTotal);
            grossFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
            grossAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
            typePositionCsfLeaveFteQuantity = BigDecimal.ZERO;
            typePositionFullTimeEquivalencyQuantity = BigDecimal.ZERO;
            typeFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
            typeAppointmentRequestedCsfFteQuantity = BigDecimal.ZERO;
            typeAppointmentRequestedFteQuantity = BigDecimal.ZERO;
            typeAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        }
        return returnList;
    }

    protected List calculateAccountTotal(List<BudgetConstructionAccountBalance> bcabList, List<BudgetConstructionAccountBalance> simpleList) {
        BigDecimal accountPositionCsfLeaveFteQuantity = BigDecimal.ZERO;
        BigDecimal accountPositionFullTimeEquivalencyQuantity = BigDecimal.ZERO;
        BigDecimal accountAppointmentRequestedCsfFteQuantity = BigDecimal.ZERO;
        BigDecimal accountAppointmentRequestedFteQuantity = BigDecimal.ZERO;
        KualiInteger accountRevenueFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
        KualiInteger accountRevenueAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        KualiInteger accountTrnfrInFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
        KualiInteger accountTrnfrInAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        KualiInteger accountExpenditureFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
        KualiInteger accountExpenditureAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        ArrayList<BudgetConstructionOrgAccountObjectDetailReportTotal> returnList = new ArrayList<BudgetConstructionOrgAccountObjectDetailReportTotal>();
        for (BudgetConstructionAccountBalance simpleBcosEntry : simpleList) {
            BudgetConstructionOrgAccountObjectDetailReportTotal bcObjectTotal = new BudgetConstructionOrgAccountObjectDetailReportTotal();
            for (BudgetConstructionAccountBalance bcabListEntry : bcabList) {
                if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)simpleBcosEntry, (BusinessObject)bcabListEntry, this.fieldsForAccountTotal())) continue;
                accountPositionCsfLeaveFteQuantity = accountPositionCsfLeaveFteQuantity.add(bcabListEntry.getPositionCsfLeaveFteQuantity());
                accountPositionFullTimeEquivalencyQuantity = accountPositionFullTimeEquivalencyQuantity.add(bcabListEntry.getPositionFullTimeEquivalencyQuantity());
                accountAppointmentRequestedCsfFteQuantity = accountAppointmentRequestedCsfFteQuantity.add(bcabListEntry.getAppointmentRequestedCsfFteQuantity());
                accountAppointmentRequestedFteQuantity = accountAppointmentRequestedFteQuantity.add(bcabListEntry.getAppointmentRequestedFteQuantity());
                if (bcabListEntry.getIncomeExpenseCode().equals("A")) {
                    accountRevenueFinancialBeginningBalanceLineAmount = accountRevenueFinancialBeginningBalanceLineAmount.add(bcabListEntry.getFinancialBeginningBalanceLineAmount());
                    accountRevenueAccountLineAnnualBalanceAmount = accountRevenueAccountLineAnnualBalanceAmount.add(bcabListEntry.getAccountLineAnnualBalanceAmount());
                } else {
                    accountExpenditureFinancialBeginningBalanceLineAmount = accountExpenditureFinancialBeginningBalanceLineAmount.add(bcabListEntry.getFinancialBeginningBalanceLineAmount());
                    accountExpenditureAccountLineAnnualBalanceAmount = accountExpenditureAccountLineAnnualBalanceAmount.add(bcabListEntry.getAccountLineAnnualBalanceAmount());
                }
                if (!bcabListEntry.getIncomeExpenseCode().equals("B") || !bcabListEntry.getFinancialObjectLevelCode().equals("CORI") && !bcabListEntry.getFinancialObjectLevelCode().equals("TRIN")) continue;
                accountTrnfrInFinancialBeginningBalanceLineAmount = accountTrnfrInFinancialBeginningBalanceLineAmount.add(bcabListEntry.getFinancialBeginningBalanceLineAmount());
                accountTrnfrInAccountLineAnnualBalanceAmount = accountTrnfrInAccountLineAnnualBalanceAmount.add(bcabListEntry.getAccountLineAnnualBalanceAmount());
            }
            bcObjectTotal.setBudgetConstructionAccountBalance(simpleBcosEntry);
            bcObjectTotal.setAccountPositionCsfLeaveFteQuantity(accountPositionCsfLeaveFteQuantity);
            bcObjectTotal.setAccountPositionFullTimeEquivalencyQuantity(accountPositionFullTimeEquivalencyQuantity);
            bcObjectTotal.setAccountAppointmentRequestedCsfFteQuantity(accountAppointmentRequestedCsfFteQuantity);
            bcObjectTotal.setAccountAppointmentRequestedFteQuantity(accountAppointmentRequestedFteQuantity);
            bcObjectTotal.setAccountRevenueFinancialBeginningBalanceLineAmount(accountRevenueFinancialBeginningBalanceLineAmount);
            bcObjectTotal.setAccountRevenueAccountLineAnnualBalanceAmount(accountRevenueAccountLineAnnualBalanceAmount);
            bcObjectTotal.setAccountTrnfrInFinancialBeginningBalanceLineAmount(accountTrnfrInFinancialBeginningBalanceLineAmount);
            bcObjectTotal.setAccountTrnfrInAccountLineAnnualBalanceAmount(accountTrnfrInAccountLineAnnualBalanceAmount);
            bcObjectTotal.setAccountExpenditureFinancialBeginningBalanceLineAmount(accountExpenditureFinancialBeginningBalanceLineAmount);
            bcObjectTotal.setAccountExpenditureAccountLineAnnualBalanceAmount(accountExpenditureAccountLineAnnualBalanceAmount);
            returnList.add(bcObjectTotal);
            accountPositionCsfLeaveFteQuantity = BigDecimal.ZERO;
            accountPositionFullTimeEquivalencyQuantity = BigDecimal.ZERO;
            accountAppointmentRequestedCsfFteQuantity = BigDecimal.ZERO;
            accountAppointmentRequestedFteQuantity = BigDecimal.ZERO;
            accountRevenueFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
            accountRevenueAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
            accountTrnfrInFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
            accountTrnfrInAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
            accountExpenditureFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
            accountExpenditureAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        }
        return returnList;
    }

    protected List calculateSubFundTotal(List<BudgetConstructionAccountBalance> bcabList, List<BudgetConstructionAccountBalance> simpleList) {
        BigDecimal subFundPositionCsfLeaveFteQuantity = BigDecimal.ZERO;
        BigDecimal subFundPositionFullTimeEquivalencyQuantity = BigDecimal.ZERO;
        BigDecimal subFundAppointmentRequestedCsfFteQuantity = BigDecimal.ZERO;
        BigDecimal subFundAppointmentRequestedFteQuantity = BigDecimal.ZERO;
        KualiInteger subFundRevenueFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
        KualiInteger subFundRevenueAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        KualiInteger subFundTrnfrInFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
        KualiInteger subFundTrnfrInAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        KualiInteger subFundExpenditureFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
        KualiInteger subFundExpenditureAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        ArrayList<BudgetConstructionOrgAccountObjectDetailReportTotal> returnList = new ArrayList<BudgetConstructionOrgAccountObjectDetailReportTotal>();
        for (BudgetConstructionAccountBalance simpleBcosEntry : simpleList) {
            BudgetConstructionOrgAccountObjectDetailReportTotal bcObjectTotal = new BudgetConstructionOrgAccountObjectDetailReportTotal();
            for (BudgetConstructionAccountBalance bcabListEntry : bcabList) {
                if (!BudgetConstructionReportHelper.isSameEntry((BusinessObject)simpleBcosEntry, (BusinessObject)bcabListEntry, this.fieldsForSubFundTotal())) continue;
                subFundPositionCsfLeaveFteQuantity = subFundPositionCsfLeaveFteQuantity.add(bcabListEntry.getPositionCsfLeaveFteQuantity());
                subFundPositionFullTimeEquivalencyQuantity = subFundPositionFullTimeEquivalencyQuantity.add(bcabListEntry.getPositionFullTimeEquivalencyQuantity());
                subFundAppointmentRequestedCsfFteQuantity = subFundAppointmentRequestedCsfFteQuantity.add(bcabListEntry.getAppointmentRequestedCsfFteQuantity());
                subFundAppointmentRequestedFteQuantity = subFundAppointmentRequestedFteQuantity.add(bcabListEntry.getAppointmentRequestedFteQuantity());
                if (bcabListEntry.getIncomeExpenseCode().equals("A")) {
                    subFundRevenueFinancialBeginningBalanceLineAmount = subFundRevenueFinancialBeginningBalanceLineAmount.add(bcabListEntry.getFinancialBeginningBalanceLineAmount());
                    subFundRevenueAccountLineAnnualBalanceAmount = subFundRevenueAccountLineAnnualBalanceAmount.add(bcabListEntry.getAccountLineAnnualBalanceAmount());
                } else {
                    subFundExpenditureFinancialBeginningBalanceLineAmount = subFundExpenditureFinancialBeginningBalanceLineAmount.add(bcabListEntry.getFinancialBeginningBalanceLineAmount());
                    subFundExpenditureAccountLineAnnualBalanceAmount = subFundExpenditureAccountLineAnnualBalanceAmount.add(bcabListEntry.getAccountLineAnnualBalanceAmount());
                }
                if (!bcabListEntry.getIncomeExpenseCode().equals("B") || !bcabListEntry.getFinancialObjectLevelCode().equals("CORI") && !bcabListEntry.getFinancialObjectLevelCode().equals("TRIN")) continue;
                subFundTrnfrInFinancialBeginningBalanceLineAmount = subFundTrnfrInFinancialBeginningBalanceLineAmount.add(bcabListEntry.getFinancialBeginningBalanceLineAmount());
                subFundTrnfrInAccountLineAnnualBalanceAmount = subFundTrnfrInAccountLineAnnualBalanceAmount.add(bcabListEntry.getAccountLineAnnualBalanceAmount());
            }
            bcObjectTotal.setBudgetConstructionAccountBalance(simpleBcosEntry);
            bcObjectTotal.setSubFundPositionCsfLeaveFteQuantity(subFundPositionCsfLeaveFteQuantity);
            bcObjectTotal.setSubFundPositionFullTimeEquivalencyQuantity(subFundPositionFullTimeEquivalencyQuantity);
            bcObjectTotal.setSubFundAppointmentRequestedCsfFteQuantity(subFundAppointmentRequestedCsfFteQuantity);
            bcObjectTotal.setSubFundAppointmentRequestedFteQuantity(subFundAppointmentRequestedFteQuantity);
            bcObjectTotal.setSubFundRevenueFinancialBeginningBalanceLineAmount(subFundRevenueFinancialBeginningBalanceLineAmount);
            bcObjectTotal.setSubFundRevenueAccountLineAnnualBalanceAmount(subFundRevenueAccountLineAnnualBalanceAmount);
            bcObjectTotal.setSubFundTrnfrInFinancialBeginningBalanceLineAmount(subFundTrnfrInFinancialBeginningBalanceLineAmount);
            bcObjectTotal.setSubFundTrnfrInAccountLineAnnualBalanceAmount(subFundTrnfrInAccountLineAnnualBalanceAmount);
            bcObjectTotal.setSubFundExpenditureFinancialBeginningBalanceLineAmount(subFundExpenditureFinancialBeginningBalanceLineAmount);
            bcObjectTotal.setSubFundExpenditureAccountLineAnnualBalanceAmount(subFundExpenditureAccountLineAnnualBalanceAmount);
            returnList.add(bcObjectTotal);
            subFundPositionCsfLeaveFteQuantity = BigDecimal.ZERO;
            subFundPositionFullTimeEquivalencyQuantity = BigDecimal.ZERO;
            subFundAppointmentRequestedCsfFteQuantity = BigDecimal.ZERO;
            subFundAppointmentRequestedFteQuantity = BigDecimal.ZERO;
            subFundRevenueFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
            subFundRevenueAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
            subFundTrnfrInFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
            subFundTrnfrInAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
            subFundExpenditureFinancialBeginningBalanceLineAmount = KualiInteger.ZERO;
            subFundExpenditureAccountLineAnnualBalanceAmount = KualiInteger.ZERO;
        }
        return returnList;
    }

    protected List<String> fieldsForObject() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.addAll(this.fieldsForLevel());
        fieldList.add("financialObjectCode");
        return fieldList;
    }

    protected List<String> fieldsForLevel() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.addAll(this.fieldsForGexpAndType());
        fieldList.add("financialLevelSortCode");
        return fieldList;
    }

    protected List<String> fieldsForGexpAndType() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.addAll(this.fieldsForAccountTotal());
        fieldList.add("incomeExpenseCode");
        return fieldList;
    }

    protected List<String> fieldsForAccountTotal() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("chartOfAccountsCode");
        fieldList.add("accountNumber");
        fieldList.add("subAccountNumber");
        return fieldList;
    }

    protected List<String> fieldsForSubFundTotal() {
        ArrayList<String> fieldList = new ArrayList<String>();
        fieldList.add("organizationChartOfAccountsCode");
        fieldList.add("organizationCode");
        fieldList.add("subFundGroupCode");
        return fieldList;
    }

    public List<String> buildOrderByList() {
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add("organizationChartOfAccountsCode");
        returnList.add("organizationCode");
        returnList.add("subFundGroupCode");
        returnList.add("universityFiscalYear");
        returnList.add("chartOfAccountsCode");
        returnList.add("accountNumber");
        returnList.add("subAccountNumber");
        returnList.add("incomeExpenseCode");
        returnList.add("financialConsolidationSortCode");
        returnList.add("financialLevelSortCode");
        returnList.add("financialObjectCode");
        returnList.add("financialSubObjectCode");
        return returnList;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public ConfigurationService getConfigurationService() {
        return this.kualiConfigurationService;
    }

    public void setBudgetConstructionAccountObjectDetailReportDao(BudgetConstructionAccountObjectDetailReportDao budgetConstructionAccountObjectDetailReportDao) {
        this.budgetConstructionAccountObjectDetailReportDao = budgetConstructionAccountObjectDetailReportDao;
    }

    public void setBudgetConstructionOrganizationReportsService(BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService) {
        this.budgetConstructionOrganizationReportsService = budgetConstructionOrganizationReportsService;
    }

    public PersistenceService getPersistenceServiceOjb() {
        return this.persistenceServiceOjb;
    }

    public void setPersistenceServiceOjb(PersistenceService persistenceServiceOjb) {
        this.persistenceServiceOjb = persistenceServiceOjb;
    }
}

