/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrgList2PLGReport;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionTwoPlugListMove;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionList2PLGReportDao;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionList2PLGReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionOrganizationReportsService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BudgetConstructionList2PLGReportServiceImpl
implements BudgetConstructionList2PLGReportService {
    protected BudgetConstructionList2PLGReportDao budgetConstructionList2PLGReportDao;
    protected BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService;
    protected ConfigurationService kualiConfigurationService;
    protected BusinessObjectService businessObjectService;
    protected PersistenceService persistenceServiceOjb;

    @Override
    public void updateList2PLGReport(String principalName, Integer universityFiscalYear) {
        this.budgetConstructionList2PLGReportDao.updateList2PLGReportsTable(principalName);
    }

    @Override
    public Collection<BudgetConstructionOrgList2PLGReport> buildReports(Integer universityFiscalYear, String principalName) {
        ArrayList<BudgetConstructionOrgList2PLGReport> reportSet = new ArrayList<BudgetConstructionOrgList2PLGReport>();
        this.persistenceServiceOjb.clearCache();
        HashMap<String, String> searchCriteria = new HashMap<String, String>();
        searchCriteria.put("principalId", principalName);
        List<String> orderList = this.buildOrderByList();
        List twoPlugList = this.budgetConstructionOrganizationReportsService.getBySearchCriteriaOrderByList(BudgetConstructionTwoPlugListMove.class, searchCriteria, orderList);
        for (BudgetConstructionTwoPlugListMove orgList2PLGEntry : twoPlugList) {
            BudgetConstructionOrgList2PLGReport orgList2PLGReportEntry = new BudgetConstructionOrgList2PLGReport();
            this.buildReportsHeader(universityFiscalYear, orgList2PLGReportEntry, orgList2PLGEntry);
            this.buildReportsBody(orgList2PLGReportEntry, orgList2PLGEntry);
            reportSet.add(orgList2PLGReportEntry);
        }
        return reportSet;
    }

    public void buildReportsHeader(Integer universityFiscalYear, BudgetConstructionOrgList2PLGReport orgList2PLGReportEntry, BudgetConstructionTwoPlugListMove twoPlugListMoveEntry) {
        String orgChartDesc = twoPlugListMoveEntry.getOrganizationChartOfAccounts().getFinChartOfAccountDescription();
        String chartDesc = twoPlugListMoveEntry.getChartOfAccounts().getFinChartOfAccountDescription();
        String orgName = twoPlugListMoveEntry.getOrganization().getOrganizationName();
        String finChartDesc = twoPlugListMoveEntry.getChartOfAccounts().getReportsToChartOfAccounts().getFinChartOfAccountDescription();
        Integer prevFiscalyear = universityFiscalYear - 1;
        orgList2PLGReportEntry.setFiscalYear(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4));
        orgList2PLGReportEntry.setOrgChartOfAccountsCode(twoPlugListMoveEntry.getOrganizationChartOfAccountsCode());
        if (orgChartDesc == null) {
            orgList2PLGReportEntry.setOrgChartOfAccountDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription"));
        } else {
            orgList2PLGReportEntry.setOrgChartOfAccountDescription(orgChartDesc);
        }
        orgList2PLGReportEntry.setOrganizationCode(twoPlugListMoveEntry.getOrganizationCode());
        if (orgName == null) {
            orgList2PLGReportEntry.setOrganizationName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingOrganizationName"));
        } else {
            orgList2PLGReportEntry.setOrganizationName(orgName);
        }
        orgList2PLGReportEntry.setChartOfAccountsCode(twoPlugListMoveEntry.getChartOfAccountsCode());
        if (chartDesc == null) {
            orgList2PLGReportEntry.setChartOfAccountDescription(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingChartDescription"));
        } else {
            orgList2PLGReportEntry.setChartOfAccountDescription(chartDesc);
        }
        Integer prevPrevFiscalyear = prevFiscalyear - 1;
        orgList2PLGReportEntry.setReqFy(prevFiscalyear.toString() + "-" + universityFiscalYear.toString().substring(2, 4));
    }

    public void buildReportsBody(BudgetConstructionOrgList2PLGReport orgList2PLGReportEntry, BudgetConstructionTwoPlugListMove twoPlugListMoveEntry) {
        orgList2PLGReportEntry.setAccountNumber(twoPlugListMoveEntry.getAccountNumber());
        orgList2PLGReportEntry.setSubAccountNumber(twoPlugListMoveEntry.getSubAccountNumber());
        if (twoPlugListMoveEntry.getSubAccountNumber().equals(KFSConstants.getDashSubAccountNumber())) {
            if (twoPlugListMoveEntry.getAccount().getAccountName() == null) {
                orgList2PLGReportEntry.setAccountSubAccountName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingAccountDescription"));
            } else {
                orgList2PLGReportEntry.setAccountSubAccountName(twoPlugListMoveEntry.getAccount().getAccountName());
            }
        } else {
            try {
                if (twoPlugListMoveEntry.getSubAccount().getSubAccountName() == null) {
                    orgList2PLGReportEntry.setAccountSubAccountName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingSubAccountDescription"));
                } else {
                    orgList2PLGReportEntry.setAccountSubAccountName(twoPlugListMoveEntry.getSubAccount().getSubAccountName());
                }
            }
            catch (PersistenceBrokerException e) {
                orgList2PLGReportEntry.setAccountSubAccountName(this.kualiConfigurationService.getPropertyValueAsString("error.budget.report.gettingSubAccountDescription"));
            }
        }
        orgList2PLGReportEntry.setReqAmount(new Integer(twoPlugListMoveEntry.getAccountLineAnnualBalanceAmount().intValue()));
    }

    public List<String> buildOrderByList() {
        ArrayList<String> returnList = new ArrayList<String>();
        returnList.add("organizationChartOfAccountsCode");
        returnList.add("organizationCode");
        returnList.add("chartOfAccountsCode");
        returnList.add("accountNumber");
        returnList.add("subAccountNumber");
        return returnList;
    }

    public void setBudgetConstructionList2PLGReportDao(BudgetConstructionList2PLGReportDao budgetConstructionList2PLGReportDao) {
        this.budgetConstructionList2PLGReportDao = budgetConstructionList2PLGReportDao;
    }

    public void setBudgetConstructionOrganizationReportsService(BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService) {
        this.budgetConstructionOrganizationReportsService = budgetConstructionOrganizationReportsService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public PersistenceService getPersistenceServiceOjb() {
        return this.persistenceServiceOjb;
    }

    public void setPersistenceServiceOjb(PersistenceService persistenceServiceOjb) {
        this.persistenceServiceOjb = persistenceServiceOjb;
    }
}

