/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionOrganizationReports;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPullup;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetConstructionDao;
import org.kuali.kfs.module.bc.document.dataaccess.BudgetPullupDao;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionOrganizationReportsService;
import org.kuali.kfs.module.bc.document.service.BudgetOrganizationTreeService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class BudgetOrganizationTreeServiceImpl
implements BudgetOrganizationTreeService {
    private static Logger LOG = Logger.getLogger(BudgetOrganizationTreeServiceImpl.class);
    protected BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService;
    protected BusinessObjectService businessObjectService;
    protected BudgetConstructionDao budgetConstructionDao;
    protected BudgetPullupDao budgetPullupDao;
    protected PersistenceService persistenceServiceOjb;
    protected static final int MAXLEVEL = 50;
    private int curLevel;

    @Override
    public void buildPullup(String principalName, String chartOfAccountsCode, String organizationCode) {
        this.cleanPullup(principalName);
        BudgetConstructionOrganizationReports bcOrgRpts = this.budgetConstructionOrganizationReportsService.getByPrimaryId(chartOfAccountsCode, organizationCode);
        if (bcOrgRpts != null && bcOrgRpts.getOrganization().isActive()) {
            this.curLevel = 0;
            this.buildSubTree(principalName, bcOrgRpts, this.curLevel);
        }
    }

    protected void buildSubTree(String principalName, BudgetConstructionOrganizationReports bcOrgRpts, int curLevel) {
        ++curLevel;
        BudgetConstructionPullup bcPullup = new BudgetConstructionPullup();
        bcPullup.setPrincipalId(principalName);
        bcPullup.setChartOfAccountsCode(bcOrgRpts.getChartOfAccountsCode());
        bcPullup.setOrganizationCode(bcOrgRpts.getOrganizationCode());
        bcPullup.setReportsToChartOfAccountsCode(bcOrgRpts.getReportsToChartOfAccountsCode());
        bcPullup.setReportsToOrganizationCode(bcOrgRpts.getReportsToOrganizationCode());
        bcPullup.setPullFlag(new Integer(0));
        this.businessObjectService.save((PersistableBusinessObject)bcPullup);
        if (curLevel <= 50) {
            List childOrgs = this.budgetConstructionOrganizationReportsService.getActiveChildOrgs(bcOrgRpts.getChartOfAccountsCode(), bcOrgRpts.getOrganizationCode());
            if (childOrgs.size() > 0) {
                for (BudgetConstructionOrganizationReports bcOrg : childOrgs) {
                    this.buildSubTree(principalName, bcOrg, curLevel);
                }
            }
        } else {
            LOG.warn((Object)String.format("\n%s/%s reports to organization more than maxlevel of %d", bcOrgRpts.getChartOfAccountsCode(), bcOrgRpts.getOrganizationCode(), 50));
        }
    }

    @Override
    public void buildPullupSql(String principalName, String chartOfAccountsCode, String organizationCode) {
        this.cleanPullup(principalName);
        BudgetConstructionOrganizationReports bcOrgRpts = this.budgetConstructionOrganizationReportsService.getByPrimaryId(chartOfAccountsCode, organizationCode);
        if (bcOrgRpts != null && bcOrgRpts.getOrganization().isActive()) {
            this.curLevel = 0;
            this.buildSubTreeSql(principalName, bcOrgRpts, this.curLevel);
        }
    }

    protected void buildSubTreeSql(String principalName, BudgetConstructionOrganizationReports bcOrgRpts, int curLevel) {
        this.budgetPullupDao.buildSubTree(principalName, bcOrgRpts.getChartOfAccountsCode(), bcOrgRpts.getOrganizationCode(), ++curLevel);
        this.persistenceServiceOjb.clearCache();
    }

    @Override
    public void cleanPullup(String principalName) {
        this.budgetPullupDao.cleanGeneralLedgerObjectSummaryTable(principalName);
        this.persistenceServiceOjb.clearCache();
    }

    @Override
    public List<BudgetConstructionPullup> getPullupChildOrgs(String principalId, String chartOfAccountsCode, String organizationCode) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new IllegalArgumentException("String parameter principalId was null or blank.");
        }
        if (StringUtils.isBlank((String)chartOfAccountsCode)) {
            throw new IllegalArgumentException("String parameter chartOfAccountsCode was null or blank.");
        }
        if (StringUtils.isBlank((String)organizationCode)) {
            throw new IllegalArgumentException("String parameter organizationCode was null or blank.");
        }
        return this.budgetConstructionDao.getBudgetConstructionPullupChildOrgs(principalId, chartOfAccountsCode, organizationCode);
    }

    @Override
    public void resetPullFlag(String principalId) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new IllegalArgumentException("String parameter principalId was null or blank.");
        }
        List<BudgetConstructionPullup> results = this.budgetConstructionDao.getBudgetConstructionPullupFlagSetByUserId(principalId);
        if (!results.isEmpty()) {
            for (BudgetConstructionPullup selOrg : results) {
                selOrg.setPullFlag(BCConstants.OrgSelControlOption.NO.getKey());
            }
            this.businessObjectService.save(results);
        }
    }

    @Override
    public List<BudgetConstructionPullup> getSelectedOrgs(String principalId) {
        if (StringUtils.isBlank((String)principalId)) {
            throw new IllegalArgumentException("String parameter principalId was null or blank.");
        }
        return this.budgetConstructionDao.getBudgetConstructionPullupFlagSetByUserId(principalId);
    }

    public BudgetConstructionOrganizationReportsService getBudgetConstructionOrganizationReportsService() {
        return this.budgetConstructionOrganizationReportsService;
    }

    public void setBudgetConstructionOrganizationReportsService(BudgetConstructionOrganizationReportsService budgetConstructionOrganizationReportsService) {
        this.budgetConstructionOrganizationReportsService = budgetConstructionOrganizationReportsService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public BudgetConstructionDao getBudgetConstructionDao() {
        return this.budgetConstructionDao;
    }

    public void setBudgetConstructionDao(BudgetConstructionDao budgetConstructionDao) {
        this.budgetConstructionDao = budgetConstructionDao;
    }

    public BudgetPullupDao getBudgetPullupDao() {
        return this.budgetPullupDao;
    }

    public void setBudgetPullupDao(BudgetPullupDao budgetPullupDao) {
        this.budgetPullupDao = budgetPullupDao;
    }

    public PersistenceService getPersistenceServiceOjb() {
        return this.persistenceServiceOjb;
    }

    public void setPersistenceServiceOjb(PersistenceService persistenceServiceOjb) {
        this.persistenceServiceOjb = persistenceServiceOjb;
    }
}

