/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.integration.ld.LaborModuleService;
import org.kuali.kfs.kns.document.authorization.TransactionalDocumentAuthorizer;
import org.kuali.kfs.kns.service.DocumentHelperService;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAppointmentFundingReason;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAppointmentFundingReasonCode;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionCalculatedSalaryFoundationTracker;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionHeader;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionPosition;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionGeneralLedger;
import org.kuali.kfs.module.bc.businessobject.SalarySettingExpansion;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.service.BenefitsCalculationService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionProcessorService;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.LockService;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;
import org.kuali.kfs.module.bc.util.SalarySettingCalculator;
import org.kuali.kfs.module.bc.util.SalarySettingFieldsHolder;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SalarySettingServiceImpl
implements SalarySettingService {
    private static final Logger LOG = Logger.getLogger(SalarySettingServiceImpl.class);
    protected ConfigurationService kualiConfigurationService;
    protected BusinessObjectService businessObjectService;
    protected LaborModuleService laborModuleService;
    protected BudgetDocumentService budgetDocumentService;
    protected BenefitsCalculationService benefitsCalculationService;
    protected OptionsService optionsService;
    protected LockService lockService;
    protected DocumentHelperService documentHelperService;
    protected DocumentService documentService;
    protected BudgetConstructionProcessorService budgetConstructionProcessorService;

    @Override
    public boolean isSalarySettingDisabled() {
        return false;
    }

    @Override
    public BigDecimal calculateHourlyPayRate(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"calculateHourlyPayRate() start");
        KualiInteger requestedAmount = appointmentFunding.getAppointmentRequestedAmount();
        BigDecimal fteQuantity = this.calculateFteQuantityFromAppointmentFunding(appointmentFunding);
        BigDecimal annualWorkingHours = BigDecimal.valueOf(BudgetParameterFinder.getAnnualWorkingHours().intValue());
        BigDecimal totalPayHoursForYear = fteQuantity.multiply(annualWorkingHours);
        BigDecimal hourlyPayRate = BigDecimal.ZERO;
        if (totalPayHoursForYear.compareTo(BigDecimal.ZERO) != 0) {
            hourlyPayRate = requestedAmount.divide(totalPayHoursForYear).setScale(2, 4);
        }
        return hourlyPayRate;
    }

    @Override
    public KualiInteger calculateAnnualPayAmount(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"calculateAnnualPayAmount() start");
        KualiInteger annualPayAmount = KualiInteger.ZERO;
        BigDecimal hourlyPayRate = appointmentFunding.getAppointmentRequestedPayRate();
        BigDecimal fteQuantity = this.calculateFteQuantityFromAppointmentFunding(appointmentFunding);
        if (fteQuantity.compareTo(BigDecimal.ZERO) == 0) {
            annualPayAmount = appointmentFunding.getAppointmentRequestedAmount();
        } else {
            BigDecimal annualWorkingHours = BigDecimal.valueOf(BudgetParameterFinder.getAnnualWorkingHours().intValue());
            BigDecimal totalPayHoursForYear = fteQuantity.multiply(annualWorkingHours);
            annualPayAmount = new KualiInteger(hourlyPayRate.multiply(totalPayHoursForYear));
        }
        return annualPayAmount;
    }

    @Override
    public void normalizePayRateAndAmount(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"normalizePayRateAndAmount() start");
        BigDecimal currentHourlyPayRate = appointmentFunding.getAppointmentRequestedPayRate();
        if (currentHourlyPayRate != null && !currentHourlyPayRate.equals(BigDecimal.ZERO)) {
            KualiInteger annualPayAmount = this.calculateAnnualPayAmount(appointmentFunding);
            appointmentFunding.setAppointmentRequestedAmount(annualPayAmount);
        } else {
            KualiInteger currentAnnualPayAmount = appointmentFunding.getAppointmentRequestedAmount();
            if (currentAnnualPayAmount != null && currentAnnualPayAmount.isNonZero()) {
                BigDecimal hourlyPayRate = this.calculateHourlyPayRate(appointmentFunding);
                appointmentFunding.setAppointmentRequestedPayRate(hourlyPayRate);
            }
            if ((currentHourlyPayRate = appointmentFunding.getAppointmentRequestedPayRate()) != null) {
                KualiInteger annualPayAmount = this.calculateAnnualPayAmount(appointmentFunding);
                appointmentFunding.setAppointmentRequestedAmount(annualPayAmount);
            } else {
                appointmentFunding.setAppointmentRequestedPayRate(BigDecimal.ZERO);
            }
        }
    }

    @Override
    public BigDecimal calculateFteQuantityFromAppointmentFunding(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"calculateFteQuantity() start");
        BudgetConstructionPosition position = appointmentFunding.getBudgetConstructionPosition();
        if (ObjectUtils.isNull((Object)position)) {
            return BigDecimal.ZERO;
        }
        Integer payMonth = position.getIuPayMonths();
        Integer fundingMonth = appointmentFunding.getAppointmentFundingMonth();
        BigDecimal requestedTimePercent = appointmentFunding.getAppointmentRequestedTimePercent();
        return this.calculateFteQuantity(payMonth, fundingMonth, requestedTimePercent);
    }

    @Override
    public BigDecimal calculateFteQuantity(Integer payMonth, Integer fundingMonth, BigDecimal requestedTimePercent) {
        LOG.debug((Object)"calculateFteQuantity() start");
        if (payMonth == null || fundingMonth == null || requestedTimePercent == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal payMonthAsDecimal = BigDecimal.valueOf(payMonth.intValue());
        BigDecimal fundingMonthAsDecimal = BigDecimal.valueOf(fundingMonth.intValue());
        BigDecimal fundingMonthPercent = fundingMonthAsDecimal.divide(payMonthAsDecimal, 5, 4);
        BigDecimal fteQuantity = requestedTimePercent.multiply(fundingMonthPercent).divide(KFSConstants.ONE_HUNDRED.bigDecimalValue());
        return fteQuantity.setScale(5, 4);
    }

    @Override
    public BigDecimal calculateCSFFteQuantityFromAppointmentFunding(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"calculateCSFFteQuantity() start");
        BudgetConstructionPosition position = appointmentFunding.getBudgetConstructionPosition();
        if (position == null) {
            return BigDecimal.ZERO;
        }
        Integer payMonth = position.getIuPayMonths();
        Integer normalWorkMonth = position.getIuNormalWorkMonths();
        BigDecimal requestedCSFTimePercent = appointmentFunding.getAppointmentRequestedCsfTimePercent();
        return this.calculateCSFFteQuantity(payMonth, normalWorkMonth, requestedCSFTimePercent);
    }

    @Override
    public BigDecimal calculateCSFFteQuantity(Integer payMonth, Integer normalWorkMonth, BigDecimal requestedCSFTimePercent) {
        LOG.debug((Object)"calculateCSFFteQuantity() start");
        if (payMonth == null || normalWorkMonth == null || requestedCSFTimePercent == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal payMonthAsDecimal = BigDecimal.valueOf(payMonth.intValue());
        BigDecimal normalMonthAsDecimal = BigDecimal.valueOf(normalWorkMonth.intValue());
        BigDecimal fundingMonthPercent = normalMonthAsDecimal.divide(payMonthAsDecimal, 5, 4);
        BigDecimal fteQuantity = requestedCSFTimePercent.multiply(fundingMonthPercent).divide(KFSConstants.ONE_HUNDRED.bigDecimalValue());
        return fteQuantity.setScale(5, 4);
    }

    @Override
    public boolean isHourlyPaid(PendingBudgetConstructionGeneralLedger pendingBudgetConstructionGeneralLedger) {
        LOG.debug((Object)"isHourlyPaid() start");
        Integer fiscalYear = pendingBudgetConstructionGeneralLedger.getUniversityFiscalYear();
        String chartOfAccountsCode = pendingBudgetConstructionGeneralLedger.getChartOfAccountsCode();
        String objectCode = pendingBudgetConstructionGeneralLedger.getFinancialObjectCode();
        return this.isHourlyPaidObject(fiscalYear, chartOfAccountsCode, objectCode);
    }

    @Override
    public boolean isHourlyPaid(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"isHourlyPaid() start");
        Integer fiscalYear = appointmentFunding.getUniversityFiscalYear();
        String chartOfAccountsCode = appointmentFunding.getChartOfAccountsCode();
        String objectCode = appointmentFunding.getFinancialObjectCode();
        return this.isHourlyPaidObject(fiscalYear, chartOfAccountsCode, objectCode);
    }

    @Override
    public boolean isHourlyPaidObject(Integer fiscalYear, String chartOfAccountsCode, String objectCode) {
        LOG.debug((Object)"isHourlyPaid() start");
        LaborLedgerObject laborLedgerObject = this.laborModuleService.retrieveLaborLedgerObject(fiscalYear, chartOfAccountsCode, objectCode);
        if (laborLedgerObject == null) {
            return false;
        }
        return BudgetParameterFinder.getBiweeklyPayTypeCodes().contains(laborLedgerObject.getFinancialObjectPayTypeCode());
    }

    @Override
    public boolean canBeVacant(List<PendingBudgetConstructionAppointmentFunding> appointmentFundings, PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"canBeVacant(List, PendingBudgetConstructionAppointmentFunding) start");
        if (!this.canBeVacant(appointmentFunding)) {
            return false;
        }
        return this.findVacantAppointmentFunding(appointmentFundings, appointmentFunding) == null;
    }

    @Override
    public PendingBudgetConstructionAppointmentFunding findVacantAppointmentFunding(List<PendingBudgetConstructionAppointmentFunding> appointmentFundings, PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"findVacantAppointmentFunding() start");
        PendingBudgetConstructionAppointmentFunding vacantAppointmentFunding = this.createVacantAppointmentFunding(appointmentFunding);
        return this.findAppointmentFunding(appointmentFundings, vacantAppointmentFunding);
    }

    @Override
    public PendingBudgetConstructionAppointmentFunding findAppointmentFunding(List<PendingBudgetConstructionAppointmentFunding> appointmentFundings, PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"findAppointmentFunding() start");
        Map<String, Object> keyFieldValues = appointmentFunding.getValuesMap();
        ArrayList<String> keyFields = new ArrayList<String>();
        keyFields.addAll(keyFieldValues.keySet());
        for (PendingBudgetConstructionAppointmentFunding fundingLine : appointmentFundings) {
            if (!ObjectUtil.equals((Object)((Object)fundingLine), (Object)((Object)appointmentFunding), keyFields)) continue;
            return fundingLine;
        }
        return null;
    }

    @Override
    public boolean canBeVacant(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"canBeVacant() start");
        if (appointmentFunding.isNewLineIndicator()) {
            return false;
        }
        if (appointmentFunding.isAppointmentFundingDeleteIndicator()) {
            return false;
        }
        String emplid = appointmentFunding.getEmplid();
        if ("VACANT".equals(emplid)) {
            return false;
        }
        BudgetConstructionPosition position = appointmentFunding.getBudgetConstructionPosition();
        if (position == null || !position.isBudgetedPosition() || !position.isEffective()) {
            return false;
        }
        boolean hasBeenVacated = this.hasBeenVacated(appointmentFunding);
        return !hasBeenVacated;
    }

    @Override
    public PendingBudgetConstructionAppointmentFunding vacateAppointmentFunding(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"vacateAppointmentFunding() start");
        PendingBudgetConstructionAppointmentFunding vacantAppointmentFunding = this.createVacantAppointmentFunding(appointmentFunding);
        this.markAsDelete(appointmentFunding);
        return vacantAppointmentFunding;
    }

    @Override
    public PendingBudgetConstructionAppointmentFunding vacateAppointmentFunding(List<PendingBudgetConstructionAppointmentFunding> appointmentFundings, PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        PendingBudgetConstructionAppointmentFunding vacantAppointmentFunding = this.vacateAppointmentFunding(appointmentFunding);
        if (vacantAppointmentFunding != null) {
            appointmentFundings.add(vacantAppointmentFunding);
        }
        return vacantAppointmentFunding;
    }

    @Override
    public void purgeAppointmentFundings(List<PendingBudgetConstructionAppointmentFunding> purgedAppointmentFundings) {
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : purgedAppointmentFundings) {
            if (appointmentFunding.isNewLineIndicator()) continue;
            this.businessObjectService.delete((PersistableBusinessObject)appointmentFunding);
        }
    }

    @Override
    public void adjustRequestedSalaryByAmount(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"adjustRequestedSalaryByAmount() start");
        int inputAdjustmentAmount = appointmentFunding.getAdjustmentAmount().intValue();
        KualiInteger adjustmentAmount = new KualiInteger((long)inputAdjustmentAmount);
        KualiInteger csfAmount = this.getCsfAmount(appointmentFunding);
        KualiInteger appointmentRequestedAmount = csfAmount.add(adjustmentAmount);
        appointmentFunding.setAppointmentRequestedAmount(appointmentRequestedAmount);
        if (appointmentFunding.isHourlyPaid()) {
            appointmentFunding.setAppointmentRequestedPayRate(BigDecimal.ZERO);
            this.normalizePayRateAndAmount(appointmentFunding);
        }
    }

    @Override
    public void adjustRequestedSalaryByPercent(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        LOG.debug((Object)"adjustRequestedSalaryByPercent() start");
        KualiInteger csfAmount = this.getCsfAmount(appointmentFunding);
        if (csfAmount.isNonZero()) {
            KualiDecimal percent = appointmentFunding.getAdjustmentAmount();
            BigDecimal adjustedAmount = csfAmount.multiply(percent).divide(KFSConstants.ONE_HUNDRED);
            KualiInteger appointmentRequestedAmount = new KualiInteger(adjustedAmount).add(csfAmount);
            appointmentFunding.setAppointmentRequestedAmount(appointmentRequestedAmount);
        }
        if (appointmentFunding.isHourlyPaid()) {
            appointmentFunding.setAppointmentRequestedPayRate(BigDecimal.ZERO);
            this.normalizePayRateAndAmount(appointmentFunding);
        }
    }

    @Override
    public void saveSalarySetting(SalarySettingExpansion salarySettingExpansion) {
        LOG.debug((Object)"saveSalarySetting() start");
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = salarySettingExpansion.getPendingBudgetConstructionAppointmentFunding();
        this.resetDeletedFundingLines(appointmentFundings);
        this.updateAppointmentFundingsBeforeSaving(appointmentFundings);
        KualiInteger requestedAmountTotal = SalarySettingCalculator.getAppointmentRequestedAmountTotal(appointmentFundings);
        KualiInteger changes = KualiInteger.ZERO;
        if (requestedAmountTotal != null) {
            KualiInteger annualBalanceAmount = salarySettingExpansion.getAccountLineAnnualBalanceAmount();
            changes = annualBalanceAmount != null ? requestedAmountTotal.subtract(annualBalanceAmount) : requestedAmountTotal;
        }
        salarySettingExpansion.setAccountLineAnnualBalanceAmount(requestedAmountTotal);
        this.businessObjectService.save((PersistableBusinessObject)salarySettingExpansion);
        Boolean wasSalarySettingExpansionBCAFEmpty = salarySettingExpansion.getPendingBudgetConstructionAppointmentFunding().isEmpty();
        if (wasSalarySettingExpansionBCAFEmpty.booleanValue()) {
            appointmentFundings.add(this.createPseudoAppointmentFundingLine(salarySettingExpansion));
        }
        if (changes.isNonZero()) {
            this.budgetDocumentService.updatePendingBudgetGeneralLedgerPlug(appointmentFundings.get(0), changes.negated());
        }
    }

    @Override
    public void savePBGLSalarySetting(SalarySettingExpansion salarySettingExpansion) {
        Boolean wasSalarySettingExpansionBCAFEmpty;
        LOG.debug((Object)"savePBGLSalarySetting() start");
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = salarySettingExpansion.getPendingBudgetConstructionAppointmentFunding();
        KualiInteger requestedAmountTotal = SalarySettingCalculator.getAppointmentRequestedAmountTotal(appointmentFundings);
        KualiInteger changes = KualiInteger.ZERO;
        if (requestedAmountTotal != null) {
            KualiInteger annualBalanceAmount = salarySettingExpansion.getAccountLineAnnualBalanceAmount();
            KualiInteger kualiInteger = changes = annualBalanceAmount != null ? requestedAmountTotal.subtract(annualBalanceAmount) : requestedAmountTotal;
        }
        if ((wasSalarySettingExpansionBCAFEmpty = Boolean.valueOf(salarySettingExpansion.getPendingBudgetConstructionAppointmentFunding().isEmpty())).booleanValue()) {
            appointmentFundings.add(this.createPseudoAppointmentFundingLine(salarySettingExpansion));
        }
        if (salarySettingExpansion.getVersionNumber() != null || !wasSalarySettingExpansionBCAFEmpty.booleanValue()) {
            this.budgetDocumentService.updatePendingBudgetGeneralLedger(appointmentFundings.get(0), changes);
        }
        if (changes.isNonZero()) {
            this.budgetDocumentService.updatePendingBudgetGeneralLedgerPlug(appointmentFundings.get(0), changes.negated());
        }
    }

    @Override
    public void saveSalarySetting(List<PendingBudgetConstructionAppointmentFunding> appointmentFundings, Boolean isSalarySettingByIncumbent) {
        this.saveAppointmentFundings(appointmentFundings);
        HashSet<SalarySettingExpansion> salarySettingExpansionSet = new HashSet<SalarySettingExpansion>();
        HashSet<SalarySettingExpansion> purgedSseSet = new HashSet<SalarySettingExpansion>();
        HashSet<SalarySettingExpansion> unpurgedSseSet = new HashSet<SalarySettingExpansion>();
        HashSet<BudgetConstructionPosition> purgedBPOSNSet = new HashSet<BudgetConstructionPosition>();
        HashSet<BudgetConstructionPosition> unpurgedBPOSNSet = new HashSet<BudgetConstructionPosition>();
        for (PendingBudgetConstructionAppointmentFunding fundingLine : appointmentFundings) {
            SalarySettingExpansion salarySettingExpansion = this.retriveSalarySalarySettingExpansion(fundingLine);
            if (salarySettingExpansion != null) {
                salarySettingExpansionSet.add(salarySettingExpansion);
            } else {
                salarySettingExpansion = new SalarySettingExpansion();
                salarySettingExpansion.setUniversityFiscalYear(fundingLine.getUniversityFiscalYear());
                salarySettingExpansion.setChartOfAccountsCode(fundingLine.getChartOfAccountsCode());
                salarySettingExpansion.setAccountNumber(fundingLine.getAccountNumber());
                salarySettingExpansion.setSubAccountNumber(fundingLine.getSubAccountNumber());
                salarySettingExpansion.setFinancialObjectCode(fundingLine.getFinancialObjectCode());
                salarySettingExpansion.setFinancialSubObjectCode(fundingLine.getFinancialSubObjectCode());
                salarySettingExpansion.setFinancialBalanceTypeCode(this.optionsService.getOptions(fundingLine.getUniversityFiscalYear()).getBaseBudgetFinancialBalanceTypeCd());
                salarySettingExpansion.setFinancialObjectTypeCode(this.optionsService.getOptions(fundingLine.getUniversityFiscalYear()).getFinObjTypeExpenditureexpCd());
                salarySettingExpansion.setAccountLineAnnualBalanceAmount(KualiInteger.ZERO);
                salarySettingExpansion.setFinancialBeginningBalanceLineAmount(KualiInteger.ZERO);
                if (!salarySettingExpansionSet.contains(salarySettingExpansion)) {
                    List<PendingBudgetConstructionAppointmentFunding> bcafRows = this.retrievePendingBudgetConstructionAppointmentFundings(salarySettingExpansion);
                    salarySettingExpansion.getPendingBudgetConstructionAppointmentFunding().addAll(bcafRows);
                    salarySettingExpansionSet.add(salarySettingExpansion);
                }
            }
            if (fundingLine.isPurged()) {
                purgedSseSet.add(salarySettingExpansion);
            } else {
                unpurgedSseSet.add(salarySettingExpansion);
            }
            if (!isSalarySettingByIncumbent.booleanValue()) continue;
            BudgetConstructionPosition budgetConstructionPosition = fundingLine.getBudgetConstructionPosition();
            if (fundingLine.isPurged()) {
                purgedBPOSNSet.add(budgetConstructionPosition);
                continue;
            }
            unpurgedBPOSNSet.add(budgetConstructionPosition);
        }
        purgedSseSet.removeAll(unpurgedSseSet);
        if (isSalarySettingByIncumbent.booleanValue()) {
            purgedBPOSNSet.removeAll(unpurgedBPOSNSet);
        }
        for (SalarySettingExpansion salarySettingExpansion : salarySettingExpansionSet) {
            this.savePBGLSalarySetting(salarySettingExpansion);
        }
        for (SalarySettingExpansion salarySettingExpansion : purgedSseSet) {
            String chartOfAccountsCode = salarySettingExpansion.getChartOfAccountsCode();
            String accountNumber = salarySettingExpansion.getAccountNumber();
            String subAccountNumber = salarySettingExpansion.getSubAccountNumber();
            Integer fiscalYear = salarySettingExpansion.getUniversityFiscalYear();
            String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
            this.lockService.unlockFunding(chartOfAccountsCode, accountNumber, subAccountNumber, fiscalYear, principalId);
        }
        for (BudgetConstructionPosition budgetConstructionPosition : purgedBPOSNSet) {
            Person person = GlobalVariables.getUserSession().getPerson();
            this.lockService.unlockPostion(budgetConstructionPosition, person);
        }
    }

    @Override
    public void saveAppointmentFundings(List<PendingBudgetConstructionAppointmentFunding> appointmentFundings) {
        LOG.debug((Object)"saveAppointmentFundings() start");
        ArrayList<PendingBudgetConstructionAppointmentFunding> purgedAppointmentFundings = new ArrayList<PendingBudgetConstructionAppointmentFunding>();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : appointmentFundings) {
            if (!appointmentFunding.isPurged()) continue;
            purgedAppointmentFundings.add(appointmentFunding);
        }
        this.purgeAppointmentFundings(purgedAppointmentFundings);
        ArrayList<PendingBudgetConstructionAppointmentFunding> savableAppointmentFundings = new ArrayList<PendingBudgetConstructionAppointmentFunding>(appointmentFundings);
        savableAppointmentFundings.removeAll(purgedAppointmentFundings);
        this.resetDeletedFundingLines(appointmentFundings);
        this.updateAppointmentFundingsBeforeSaving(savableAppointmentFundings);
        for (PendingBudgetConstructionAppointmentFunding savableAppointmentFunding : savableAppointmentFundings) {
            this.businessObjectService.save((PersistableBusinessObject)savableAppointmentFunding);
        }
    }

    @Override
    public SalarySettingExpansion retriveSalarySalarySettingExpansion(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        BudgetConstructionHeader budgetDocument = this.budgetDocumentService.getBudgetConstructionHeader(appointmentFunding);
        Map fieldValues = ObjectUtil.buildPropertyMap((Object)((Object)appointmentFunding), SalarySettingExpansion.getPrimaryKeyFields());
        fieldValues.put("documentNumber", budgetDocument.getDocumentNumber());
        return (SalarySettingExpansion)this.businessObjectService.findByPrimaryKey(SalarySettingExpansion.class, fieldValues);
    }

    @Override
    public List<PendingBudgetConstructionAppointmentFunding> retrievePendingBudgetConstructionAppointmentFundings(SalarySettingExpansion salarySettingExpansion) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("universityFiscalYear", salarySettingExpansion.getUniversityFiscalYear());
        fieldValues.put("chartOfAccountsCode", salarySettingExpansion.getChartOfAccountsCode());
        fieldValues.put("accountNumber", salarySettingExpansion.getAccountNumber());
        fieldValues.put("subAccountNumber", salarySettingExpansion.getSubAccountNumber());
        fieldValues.put("financialObjectCode", salarySettingExpansion.getFinancialObjectCode());
        fieldValues.put("financialSubObjectCode", salarySettingExpansion.getFinancialSubObjectCode());
        return (List)this.businessObjectService.findMatching(PendingBudgetConstructionAppointmentFunding.class, fieldValues);
    }

    @Override
    public void resetAppointmentFunding(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        appointmentFunding.setAppointmentRequestedAmount(KualiInteger.ZERO);
        appointmentFunding.setAppointmentRequestedTimePercent(BigDecimal.ZERO);
        appointmentFunding.setAppointmentRequestedPayRate(BigDecimal.ZERO);
        appointmentFunding.setAppointmentRequestedFteQuantity(BigDecimal.ZERO);
        appointmentFunding.setAppointmentRequestedCsfAmount(KualiInteger.ZERO);
        appointmentFunding.setAppointmentRequestedCsfFteQuantity(BigDecimal.ZERO);
        appointmentFunding.setAppointmentRequestedCsfTimePercent(BigDecimal.ZERO);
        appointmentFunding.setAppointmentTotalIntendedAmount(KualiInteger.ZERO);
        appointmentFunding.setAppointmentTotalIntendedFteQuantity(BigDecimal.ZERO);
        appointmentFunding.setAppointmentFundingDurationCode(BCConstants.AppointmentFundingDurationCodes.NONE.durationCode);
        appointmentFunding.setPositionObjectChangeIndicator(false);
        appointmentFunding.setPositionSalaryChangeIndicator(false);
    }

    @Override
    public void markAsDelete(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        this.resetAppointmentFunding(appointmentFunding);
        appointmentFunding.setAppointmentFundingDeleteIndicator(true);
    }

    @Override
    public void revert(List<PendingBudgetConstructionAppointmentFunding> appointmentFundings, PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        PendingBudgetConstructionAppointmentFunding vacantFunding = this.findVacantAppointmentFunding(appointmentFundings, appointmentFunding);
        if (vacantFunding != null) {
            appointmentFundings.remove((Object)vacantFunding);
        }
        PendingBudgetConstructionAppointmentFunding newAppointmentFunding = (PendingBudgetConstructionAppointmentFunding)this.businessObjectService.retrieve((PersistableBusinessObject)appointmentFunding);
        appointmentFundings.add(newAppointmentFunding);
        appointmentFundings.remove((Object)appointmentFunding);
    }

    @Override
    public boolean updateAccessOfAppointmentFunding(PendingBudgetConstructionAppointmentFunding appointmentFunding, SalarySettingFieldsHolder salarySettingFieldsHolder, boolean budgetByObjectMode, boolean hasDocumentEditAccess, Person person) {
        String budgetChartOfAccountsCode = salarySettingFieldsHolder.getChartOfAccountsCode();
        String budgetAccountNumber = salarySettingFieldsHolder.getAccountNumber();
        String budgetSubAccountNumber = salarySettingFieldsHolder.getSubAccountNumber();
        String budgetObjectCode = salarySettingFieldsHolder.getFinancialObjectCode();
        String budgetSubObjectCode = salarySettingFieldsHolder.getFinancialSubObjectCode();
        String chartOfAccountsCode = appointmentFunding.getChartOfAccountsCode();
        String accountNumber = appointmentFunding.getAccountNumber();
        String subAccountNumber = appointmentFunding.getSubAccountNumber();
        String objectCode = appointmentFunding.getFinancialObjectCode();
        String subObjectCode = appointmentFunding.getFinancialSubObjectCode();
        if (budgetByObjectMode && StringUtils.equals((String)chartOfAccountsCode, (String)budgetChartOfAccountsCode) && StringUtils.equals((String)accountNumber, (String)budgetAccountNumber) && StringUtils.equals((String)subAccountNumber, (String)budgetSubAccountNumber)) {
            appointmentFunding.setDisplayOnlyMode(!hasDocumentEditAccess);
            return true;
        }
        boolean isUpdatedByUserLevel = this.updateAccessOfAppointmentFundingByUserLevel(appointmentFunding, person);
        return isUpdatedByUserLevel;
    }

    @Override
    public boolean updateAccessOfAppointmentFundingByUserLevel(PendingBudgetConstructionAppointmentFunding appointmentFunding, Person user) {
        BudgetConstructionDocument document;
        BudgetConstructionHeader budgetConstructionHeader = this.budgetDocumentService.getBudgetConstructionHeader(appointmentFunding);
        if (budgetConstructionHeader == null) {
            return false;
        }
        try {
            document = (BudgetConstructionDocument)this.documentService.getByDocumentHeaderId(budgetConstructionHeader.getDocumentNumber());
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Fail to retrieve budget document for doc id " + budgetConstructionHeader.getDocumentNumber());
        }
        TransactionalDocumentAuthorizer documentAuthorizer = (TransactionalDocumentAuthorizer)this.getDocumentHelperService().getDocumentAuthorizer((Document)document);
        boolean hasEditAccess = documentAuthorizer.isAuthorized((BusinessObject)document, "KFS-BC", "Edit Appointment Funding", user.getPrincipalId());
        appointmentFunding.setDisplayOnlyMode(!hasEditAccess);
        boolean hasViewAmountsAccess = documentAuthorizer.isAuthorized((BusinessObject)document, "KFS-BC", "View Appointment Funding Amounts", user.getPrincipalId());
        appointmentFunding.setExcludedFromTotal(!hasViewAmountsAccess);
        return true;
    }

    @Override
    public void updateAppointmentFundingsBeforeSaving(List<PendingBudgetConstructionAppointmentFunding> appointmentFundings) {
        LOG.debug((Object)"updateDerivedInformationForAppointmentFundings() start");
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : appointmentFundings) {
            this.recalculateDerivedInformation(appointmentFunding);
            appointmentFunding.setNewLineIndicator(false);
        }
    }

    @Override
    public void recalculateDerivedInformation(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        this.preprocessFundingReason(appointmentFunding);
        this.preprocessLeaveRequest(appointmentFunding);
        boolean isHourlyPaid = this.isHourlyPaid(appointmentFunding);
        appointmentFunding.setHourlyPaid(isHourlyPaid);
        if (appointmentFunding.isHourlyPaid()) {
            this.normalizePayRateAndAmount(appointmentFunding);
        } else {
            appointmentFunding.setAppointmentRequestedPayRate(BigDecimal.ZERO);
        }
        BigDecimal requestedFteQuantity = this.calculateFteQuantityFromAppointmentFunding(appointmentFunding);
        appointmentFunding.setAppointmentRequestedFteQuantity(requestedFteQuantity);
        if (!appointmentFunding.getAppointmentFundingDurationCode().equals(BCConstants.AppointmentFundingDurationCodes.NONE.durationCode)) {
            BigDecimal requestedCSFFteQuantity = this.calculateCSFFteQuantityFromAppointmentFunding(appointmentFunding);
            appointmentFunding.setAppointmentRequestedCsfFteQuantity(requestedCSFFteQuantity);
        }
    }

    protected void resetDeletedFundingLines(List<PendingBudgetConstructionAppointmentFunding> pendingBudgetConstructionAppointmentFunding) {
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : pendingBudgetConstructionAppointmentFunding) {
            if (!appointmentFunding.isAppointmentFundingDeleteIndicator() || appointmentFunding.isPersistedDeleteIndicator()) continue;
            this.markAsDelete(appointmentFunding);
            List<BudgetConstructionAppointmentFundingReason> reasons = appointmentFunding.getBudgetConstructionAppointmentFundingReason();
            if (reasons != null) {
                reasons.clear();
            }
            appointmentFunding.setPersistedDeleteIndicator(true);
        }
    }

    protected KualiInteger getCsfAmount(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        if (appointmentFunding == null) {
            return KualiInteger.ZERO;
        }
        BudgetConstructionCalculatedSalaryFoundationTracker csfTracker = appointmentFunding.getEffectiveCSFTracker();
        if (csfTracker == null) {
            return KualiInteger.ZERO;
        }
        return csfTracker.getCsfAmount();
    }

    protected boolean hasBeenVacated(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        Map<String, Object> keyFieldValues = appointmentFunding.getValuesMap();
        keyFieldValues.put("emplid", "VACANT");
        return this.businessObjectService.countMatching(PendingBudgetConstructionAppointmentFunding.class, keyFieldValues) > 0;
    }

    protected PendingBudgetConstructionAppointmentFunding createVacantAppointmentFunding(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        PendingBudgetConstructionAppointmentFunding vacantAppointmentFunding = new PendingBudgetConstructionAppointmentFunding();
        ObjectUtil.buildObjectWithoutReferenceFields((Object)((Object)vacantAppointmentFunding), (Object)((Object)appointmentFunding));
        vacantAppointmentFunding.setEmplid("VACANT");
        vacantAppointmentFunding.setAppointmentFundingDeleteIndicator(false);
        vacantAppointmentFunding.setPersistedDeleteIndicator(false);
        vacantAppointmentFunding.setVersionNumber(null);
        vacantAppointmentFunding.setNewLineIndicator(true);
        return vacantAppointmentFunding;
    }

    protected PendingBudgetConstructionAppointmentFunding createPseudoAppointmentFundingLine(SalarySettingExpansion salarySettingExpansion) {
        PendingBudgetConstructionAppointmentFunding pseudoAppointmentFunding = new PendingBudgetConstructionAppointmentFunding();
        pseudoAppointmentFunding.setUniversityFiscalYear(salarySettingExpansion.getUniversityFiscalYear());
        pseudoAppointmentFunding.setChartOfAccountsCode(salarySettingExpansion.getChartOfAccountsCode());
        pseudoAppointmentFunding.setAccountNumber(salarySettingExpansion.getAccountNumber());
        pseudoAppointmentFunding.setSubAccountNumber(salarySettingExpansion.getSubAccountNumber());
        pseudoAppointmentFunding.setFinancialObjectCode(salarySettingExpansion.getFinancialObjectCode());
        pseudoAppointmentFunding.setFinancialSubObjectCode(salarySettingExpansion.getFinancialSubObjectCode());
        pseudoAppointmentFunding.setAppointmentFundingDeleteIndicator(false);
        pseudoAppointmentFunding.setAppointmentRequestedAmount(KualiInteger.ZERO);
        pseudoAppointmentFunding.refreshReferenceObject("account");
        return pseudoAppointmentFunding;
    }

    public void preprocessFundingReason(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        List<BudgetConstructionAppointmentFundingReason> fundingReasons = appointmentFunding.getBudgetConstructionAppointmentFundingReason();
        if (!fundingReasons.isEmpty() && StringUtils.isBlank((String)fundingReasons.get(0).getAppointmentFundingReasonCode())) {
            fundingReasons.clear();
        }
    }

    public void preprocessLeaveRequest(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        String durationCode = appointmentFunding.getAppointmentFundingDurationCode();
        if (StringUtils.isEmpty((String)durationCode) || StringUtils.equals((String)durationCode, (String)BCConstants.AppointmentFundingDurationCodes.NONE.durationCode)) {
            appointmentFunding.setAppointmentRequestedCsfAmount(KualiInteger.ZERO);
            appointmentFunding.setAppointmentRequestedCsfFteQuantity(BigDecimal.ZERO);
            appointmentFunding.setAppointmentRequestedCsfTimePercent(BigDecimal.ZERO);
        }
    }

    @Override
    public boolean hasExistingFundingReason(BudgetConstructionAppointmentFundingReasonCode budgetConstructionAppointmentFundingReasonCode) {
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("appointmentFundingReasonCode", budgetConstructionAppointmentFundingReasonCode.getAppointmentFundingReasonCode());
        return this.businessObjectService.countMatching(BudgetConstructionAppointmentFundingReason.class, queryMap) > 0;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setLaborModuleService(LaborModuleService laborModuleService) {
        this.laborModuleService = laborModuleService;
    }

    public void setBudgetDocumentService(BudgetDocumentService budgetDocumentService) {
        this.budgetDocumentService = budgetDocumentService;
    }

    public void setBenefitsCalculationService(BenefitsCalculationService benefitsCalculationService) {
        this.benefitsCalculationService = benefitsCalculationService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public DocumentHelperService getDocumentHelperService() {
        if (this.documentHelperService == null) {
            this.documentHelperService = (DocumentHelperService)SpringContext.getBean(DocumentHelperService.class);
        }
        return this.documentHelperService;
    }

    public void setDocumentHelperService(DocumentHelperService documentHelperService) {
        this.documentHelperService = documentHelperService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setBudgetConstructionProcessorService(BudgetConstructionProcessorService budgetConstructionProcessorService) {
        this.budgetConstructionProcessorService = budgetConstructionProcessorService;
    }
}

