/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.service.BusinessObjectDictionaryService;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.LockService;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.module.bc.document.validation.event.AddAppointmentFundingEvent;
import org.kuali.kfs.module.bc.document.validation.event.SaveSalarySettingEvent;
import org.kuali.kfs.module.bc.document.web.struts.DetailSalarySettingForm;
import org.kuali.kfs.module.bc.document.web.struts.IncumbentSalarySettingForm;
import org.kuali.kfs.module.bc.document.web.struts.PositionSalarySettingForm;
import org.kuali.kfs.module.bc.document.web.struts.SalarySettingBaseAction;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public abstract class DetailSalarySettingAction
extends SalarySettingBaseAction {
    private static final Logger LOG = Logger.getLogger(DetailSalarySettingAction.class);
    private SalarySettingService salarySettingService = (SalarySettingService)SpringContext.getBean(SalarySettingService.class);
    private BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
    private Person currentUser = GlobalVariables.getUserSession().getPerson();

    @Override
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward executeAction = null;
        try {
            executeAction = super.execute(mapping, form, request, response);
        }
        catch (Exception e) {
            DetailSalarySettingForm salarySettingForm = (DetailSalarySettingForm)form;
            if (!salarySettingForm.isViewOnlyEntry()) {
                salarySettingForm.releaseTransactionLocks();
                salarySettingForm.releasePositionAndFundingLocks();
            }
            LOG.fatal((Object)"Unexpected errors occurred.", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
        return executeAction;
    }

    @Override
    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DetailSalarySettingForm salarySettingForm = (DetailSalarySettingForm)form;
        String buttonClicked = request.getParameter("buttonClicked");
        boolean isClose = StringUtils.equals((String)"0", (String)buttonClicked) || StringUtils.equals((String)"1", (String)buttonClicked);
        ActionForward closeActionForward = salarySettingForm.isViewOnlyEntry() || salarySettingForm.isSalarySettingClosed() ? this.returnAfterClose(salarySettingForm, mapping, request, response) : super.close(mapping, (ActionForm)salarySettingForm, request, response);
        if (isClose && !salarySettingForm.isViewOnlyEntry() && salarySettingForm.isSalarySettingClosed()) {
            salarySettingForm.releasePositionAndFundingLocks();
            if (form instanceof PositionSalarySettingForm) {
                this.unlockPositionOnly((PositionSalarySettingForm)form);
            }
        }
        return closeActionForward;
    }

    @Override
    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        DetailSalarySettingForm salarySettingForm = (DetailSalarySettingForm)form;
        String refreshCaller = request.getParameter("refreshCaller");
        if (refreshCaller != null && refreshCaller.endsWith("Lookupable")) {
            PositionSalarySettingForm ssPosForm;
            if (!salarySettingForm.getNewBCAFLine().getUniversityFiscalYear().equals(salarySettingForm.getUniversityFiscalYear())) {
                salarySettingForm.getNewBCAFLine().setUniversityFiscalYear(salarySettingForm.getUniversityFiscalYear());
            }
            if (salarySettingForm instanceof PositionSalarySettingForm && !(ssPosForm = (PositionSalarySettingForm)salarySettingForm).getNewBCAFLine().getFinancialObjectCode().equals(ssPosForm.getBudgetConstructionPosition().getIuDefaultObjectCode())) {
                ssPosForm.getNewBCAFLine().setFinancialObjectCode(ssPosForm.getBudgetConstructionPosition().getIuDefaultObjectCode());
            }
            salarySettingForm.refreshBCAFLine(salarySettingForm.getNewBCAFLine());
        }
        return mapping.findForward("basic");
    }

    @Override
    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DetailSalarySettingForm salarySettingForm = (DetailSalarySettingForm)form;
        List<PendingBudgetConstructionAppointmentFunding> savableAppointmentFundings = salarySettingForm.getSavableAppointmentFundings();
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = salarySettingForm.getAppointmentFundings();
        if (savableAppointmentFundings == null || savableAppointmentFundings.isEmpty()) {
            KNSGlobalVariables.getMessageList().add("message.budget.salarySettingSaved", new String[0]);
            return mapping.findForward("basic");
        }
        MessageMap errorMap = GlobalVariables.getMessageMap();
        for (PendingBudgetConstructionAppointmentFunding savableFunding : savableAppointmentFundings) {
            String errorKeyPrefix = this.getErrorKeyPrefixOfAppointmentFundingLine(appointmentFundings, savableFunding);
            BudgetConstructionDocument document = this.budgetDocumentService.getBudgetConstructionDocument(savableFunding);
            if (document == null) {
                errorMap.putError(errorKeyPrefix, "error.budget.budgetDocumentNotFound", new String[]{savableFunding.getAppointmentFundingString()});
                return mapping.findForward("basic");
            }
            if (savableFunding.isPurged() || savableFunding.isAppointmentFundingDeleteIndicator()) continue;
            this.salarySettingService.recalculateDerivedInformation(savableFunding);
            boolean isValid = this.invokeRules((KualiDocumentEvent)new SaveSalarySettingEvent("", errorKeyPrefix, document, savableFunding, this.getSynchronizationCheckType()));
            if (isValid) continue;
            return mapping.findForward("basic");
        }
        boolean transactionLocked = salarySettingForm.acquireTransactionLocks(GlobalVariables.getMessageMap());
        if (!transactionLocked) {
            return mapping.findForward("basic");
        }
        if (form instanceof IncumbentSalarySettingForm) {
            this.salarySettingService.saveSalarySetting(savableAppointmentFundings, Boolean.TRUE);
        } else {
            this.salarySettingService.saveSalarySetting(savableAppointmentFundings, Boolean.FALSE);
        }
        salarySettingForm.releaseTransactionLocks();
        this.clearPurgedAppointmentFundings(appointmentFundings);
        KNSGlobalVariables.getMessageList().add("message.budget.salarySettingSaved", new String[0]);
        return mapping.findForward("basic");
    }

    public ActionForward addAppointmentFundingLine(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DetailSalarySettingForm salarySettingForm = (DetailSalarySettingForm)form;
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = salarySettingForm.getAppointmentFundings();
        PendingBudgetConstructionAppointmentFunding newAppointmentFunding = salarySettingForm.getNewBCAFLine();
        ((BusinessObjectDictionaryService)SpringContext.getBean(BusinessObjectDictionaryService.class)).performForceUppercase((BusinessObject)newAppointmentFunding);
        salarySettingForm.refreshBCAFLine(newAppointmentFunding);
        PendingBudgetConstructionAppointmentFunding workingAppointmentFunding = new PendingBudgetConstructionAppointmentFunding();
        ObjectUtil.buildObject((Object)((Object)workingAppointmentFunding), (Object)((Object)newAppointmentFunding));
        this.applyDefaultValuesIfEmpty(workingAppointmentFunding);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        BudgetConstructionDocument document = this.budgetDocumentService.getBudgetConstructionDocument(workingAppointmentFunding);
        if (document == null) {
            errorMap.putError("newBCAFLine", "error.budget.budgetDocumentNotFound", new String[]{workingAppointmentFunding.getAppointmentFundingString()});
            return mapping.findForward("basic");
        }
        String emplid = workingAppointmentFunding.getEmplid();
        if (StringUtils.isNotEmpty((String)emplid) && StringUtils.equals((String)emplid, (String)"VACANT")) {
            workingAppointmentFunding.setAppointmentFundingDurationCode(BCConstants.AppointmentFundingDurationCodes.NONE.durationCode);
        }
        this.salarySettingService.recalculateDerivedInformation(workingAppointmentFunding);
        AddAppointmentFundingEvent addAppointmentFundingEvent = new AddAppointmentFundingEvent("", "newBCAFLine", document, appointmentFundings, workingAppointmentFunding, this.getSynchronizationCheckType());
        boolean isValid = this.invokeRules((KualiDocumentEvent)addAppointmentFundingEvent);
        if (!isValid) {
            return mapping.findForward("basic");
        }
        boolean vacatable = this.salarySettingService.canBeVacant(appointmentFundings, workingAppointmentFunding);
        workingAppointmentFunding.setVacatable(vacatable);
        Integer fiscalYear = workingAppointmentFunding.getUniversityFiscalYear();
        String chartCode = workingAppointmentFunding.getChartOfAccountsCode();
        String objectCode = workingAppointmentFunding.getFinancialObjectCode();
        boolean hourlyPaid = this.salarySettingService.isHourlyPaidObject(fiscalYear, chartCode, objectCode);
        workingAppointmentFunding.setHourlyPaid(hourlyPaid);
        boolean accessModeUpdated = salarySettingForm.updateAccessMode(workingAppointmentFunding, errorMap);
        if (!accessModeUpdated) {
            return mapping.findForward("basic");
        }
        if (workingAppointmentFunding.isDisplayOnlyMode()) {
            errorMap.putError("newBCAFLine", "error.budget.noSalarySettingPermission", new String[]{workingAppointmentFunding.getAppointmentFundingString()});
            return mapping.findForward("basic");
        }
        boolean gotLocks = salarySettingForm.acquirePositionAndFundingLocks(workingAppointmentFunding, errorMap);
        if (!gotLocks) {
            return mapping.findForward("basic");
        }
        appointmentFundings.add(workingAppointmentFunding);
        salarySettingForm.setNewBCAFLine(salarySettingForm.createNewAppointmentFundingLine());
        return mapping.findForward("basic");
    }

    protected boolean hasFundingLineInvolvedLeave(List<PendingBudgetConstructionAppointmentFunding> activeAppointmentFundings) {
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : activeAppointmentFundings) {
            String leaveDurationCode = appointmentFunding.getAppointmentFundingDurationCode();
            if (StringUtils.equals((String)leaveDurationCode, (String)BCConstants.AppointmentFundingDurationCodes.NONE.durationCode)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasFundingLineInvolvedLeaveWithoutPay(List<PendingBudgetConstructionAppointmentFunding> activeAppointmentFundings) {
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : activeAppointmentFundings) {
            String leaveDurationCode = appointmentFunding.getAppointmentFundingDurationCode();
            if (!StringUtils.equals((String)leaveDurationCode, (String)BCConstants.AppointmentFundingDurationCodes.LWPA.durationCode) && !StringUtils.equals((String)leaveDurationCode, (String)BCConstants.AppointmentFundingDurationCodes.LWPF.durationCode)) continue;
            return true;
        }
        return false;
    }

    protected void applyDefaultValuesIfEmpty(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        if (StringUtils.isBlank((String)appointmentFunding.getSubAccountNumber())) {
            appointmentFunding.setSubAccountNumber(KFSConstants.getDashSubAccountNumber());
        }
        if (StringUtils.isBlank((String)appointmentFunding.getFinancialSubObjectCode())) {
            appointmentFunding.setFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
        }
        if (appointmentFunding.getAppointmentTotalIntendedAmount() == null) {
            appointmentFunding.setAppointmentTotalIntendedAmount(KualiInteger.ZERO);
            appointmentFunding.setAppointmentTotalIntendedFteQuantity(BigDecimal.ZERO);
        }
        if (appointmentFunding.getAppointmentTotalIntendedFteQuantity() == null) {
            appointmentFunding.setAppointmentTotalIntendedFteQuantity(BigDecimal.ZERO);
        }
    }

    protected void clearPurgedAppointmentFundings(List<PendingBudgetConstructionAppointmentFunding> appointmentFundings) {
        ArrayList<PendingBudgetConstructionAppointmentFunding> purgedAppointmentFundings = new ArrayList<PendingBudgetConstructionAppointmentFunding>();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : appointmentFundings) {
            if (!appointmentFunding.isPurged()) continue;
            purgedAppointmentFundings.add(appointmentFunding);
        }
        appointmentFundings.removeAll(purgedAppointmentFundings);
    }

    protected void unlockPositionOnly(PositionSalarySettingForm positionSalarySettingForm) {
        Integer universityFiscalYear = positionSalarySettingForm.getBudgetConstructionPosition().getUniversityFiscalYear();
        String positionNumber = positionSalarySettingForm.getBudgetConstructionPosition().getPositionNumber();
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        ((LockService)SpringContext.getBean(LockService.class)).unlockPosition(positionNumber, universityFiscalYear, principalId);
    }

    public abstract BCConstants.SynchronizationCheckType getSynchronizationCheckType();
}

