/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.bc.BudgetConstructionReportMode;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionAccountMonthlyDetailReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionAccountSalaryDetailReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionDocumentAccountObjectDetailReportService;
import org.kuali.kfs.module.bc.document.service.BudgetConstructionReportsServiceHelper;
import org.kuali.kfs.module.bc.document.web.struts.BudgetExpansionAction;
import org.kuali.kfs.module.bc.document.web.struts.ReportRunnerForm;
import org.kuali.kfs.module.bc.util.BudgetUrlUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.ReportGenerationService;

public class ReportRunnerAction
extends BudgetExpansionAction {
    public ActionForward loadExpansionScreen(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportRunnerForm reportRunnerForm = (ReportRunnerForm)form;
        return mapping.findForward("basic");
    }

    public ActionForward performReportDump(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ReportRunnerForm reportRunnerForm = (ReportRunnerForm)form;
        String principalName = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        int selectIndex = this.getSelectedLine(request);
        String reportModeName = reportRunnerForm.getBudgetConstructionDocumentReportModes().get(selectIndex).getReportModeName();
        Collection<Object> reportSet = new ArrayList();
        String jasperFileName = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        switch (selectIndex) {
            case 0: {
                jasperFileName = "BudgetAccountObjectDetail";
                ((BudgetConstructionDocumentAccountObjectDetailReportService)SpringContext.getBean(BudgetConstructionDocumentAccountObjectDetailReportService.class)).updateDocumentAccountObjectDetailReportTable(principalName, reportRunnerForm.getDocumentNumber(), reportRunnerForm.getUniversityFiscalYear(), reportRunnerForm.getChartOfAccountsCode(), reportRunnerForm.getAccountNumber(), reportRunnerForm.getSubAccountNumber());
                reportSet = ((BudgetConstructionDocumentAccountObjectDetailReportService)SpringContext.getBean(BudgetConstructionDocumentAccountObjectDetailReportService.class)).buildReports(principalName);
                break;
            }
            case 1: {
                jasperFileName = "BudgetAccountSalaryDetail";
                reportSet = ((BudgetConstructionAccountSalaryDetailReportService)SpringContext.getBean(BudgetConstructionAccountSalaryDetailReportService.class)).buildReports(reportRunnerForm.getUniversityFiscalYear(), reportRunnerForm.getChartOfAccountsCode(), reportRunnerForm.getAccountNumber(), reportRunnerForm.getSubAccountNumber());
                break;
            }
            case 2: {
                jasperFileName = "BudgetAccountMonthlyDetail";
                reportSet = ((BudgetConstructionAccountMonthlyDetailReportService)SpringContext.getBean(BudgetConstructionAccountMonthlyDetailReportService.class)).buildReports(reportRunnerForm.getDocumentNumber(), reportRunnerForm.getUniversityFiscalYear(), reportRunnerForm.getChartOfAccountsCode(), reportRunnerForm.getAccountNumber(), reportRunnerForm.getSubAccountNumber());
                break;
            }
            case 3: {
                return new ActionForward(this.buildReportExportForwardURL(reportRunnerForm, mapping, BudgetConstructionReportMode.ACCOUNT_EXPORT.reportModeName), true);
            }
            case 4: {
                return new ActionForward(this.buildReportExportForwardURL(reportRunnerForm, mapping, BudgetConstructionReportMode.FUNDING_EXPORT.reportModeName), true);
            }
            case 5: {
                return new ActionForward(this.buildReportExportForwardURL(reportRunnerForm, mapping, BudgetConstructionReportMode.MONTHLY_EXPORT.reportModeName), true);
            }
        }
        if (reportSet.isEmpty()) {
            ArrayList<String> messageList = new ArrayList<String>();
            messageList.add("No data found.");
            ((BudgetConstructionReportsServiceHelper)SpringContext.getBean(BudgetConstructionReportsServiceHelper.class)).generatePdf(messageList, baos);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)(jasperFileName + ".pdf"));
        } else {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("org/kuali/kfs/module/bc/report/BudgetOrgReport", Locale.getDefault());
            HashMap<String, ResourceBundle> reportData = new HashMap<String, ResourceBundle>();
            reportData.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
            ((ReportGenerationService)SpringContext.getBean(ReportGenerationService.class)).generateReportToOutputStream(reportData, reportSet, "org/kuali/kfs/module/bc/report/" + jasperFileName, (OutputStream)baos);
            WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/pdf", (ByteArrayOutputStream)baos, (String)(jasperFileName + ".pdf"));
        }
        return null;
    }

    private String buildReportExportForwardURL(ReportRunnerForm reportRunnerForm, ActionMapping mapping, String documentReportMode) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("chartOfAccountsCode", reportRunnerForm.getChartOfAccountsCode());
        parameters.put("accountNumber", reportRunnerForm.getAccountNumber());
        parameters.put("subAccountNumber", reportRunnerForm.getSubAccountNumber());
        parameters.put("reportMode", documentReportMode);
        parameters.put("orgReport", "false");
        return BudgetUrlUtil.buildBudgetUrl(mapping, reportRunnerForm, "budgetReportExport.do", parameters);
    }
}

