/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.document.web.struts;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionAppointmentFundingReason;
import org.kuali.kfs.module.bc.businessobject.PendingBudgetConstructionAppointmentFunding;
import org.kuali.kfs.module.bc.document.service.BudgetDocumentService;
import org.kuali.kfs.module.bc.document.service.SalarySettingService;
import org.kuali.kfs.module.bc.document.web.struts.BudgetExpansionForm;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;
import org.kuali.kfs.module.bc.util.SalarySettingCalculator;
import org.kuali.kfs.module.bc.util.SalarySettingFieldsHolder;
import org.kuali.kfs.sys.DynamicCollectionComparator;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.KualiInteger;
import org.kuali.rice.kim.api.identity.Person;

public abstract class SalarySettingBaseForm
extends BudgetExpansionForm {
    private static final Logger LOG = Logger.getLogger(SalarySettingBaseForm.class);
    private String documentNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private String subAccountNumber;
    private String financialObjectCode;
    private String financialSubObjectCode;
    private String financialBalanceTypeCode;
    private String financialObjectTypeCode;
    private SalarySettingFieldsHolder salarySettingFieldsHolder;
    private boolean hideAdjustmentMeasurement = true;
    private String adjustmentMeasurement;
    private KualiDecimal adjustmentAmount;
    private boolean hideDetails = false;
    private boolean budgetByAccountMode;
    private boolean singleAccountMode;
    private boolean salarySettingClosed;
    private SalarySettingService salarySettingService = (SalarySettingService)SpringContext.getBean(SalarySettingService.class);
    private BudgetDocumentService budgetDocumentService = (BudgetDocumentService)SpringContext.getBean(BudgetDocumentService.class);
    private Person person = GlobalVariables.getUserSession().getPerson();
    protected String dashSubAccountNumber;
    protected String dashFinancialSubObjectCode;

    public SalarySettingBaseForm() {
        this.setDashFinancialSubObjectCode(KFSConstants.getDashFinancialSubObjectCode());
        this.setDashSubAccountNumber(KFSConstants.getDashSubAccountNumber());
    }

    public abstract String getRefreshCallerName();

    public abstract Map<String, Object> getKeyMapOfSalarySettingItem();

    public void populateBCAFLines() {
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = this.getAppointmentFundings();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : appointmentFundings) {
            this.refreshBCAFLine(appointmentFunding);
        }
    }

    public boolean postProcessBCAFLines() {
        this.populateBCAFLines();
        List<PendingBudgetConstructionAppointmentFunding> appointmentFundings = this.getAppointmentFundings();
        for (PendingBudgetConstructionAppointmentFunding appointmentFunding : appointmentFundings) {
            Integer fiscalYear = appointmentFunding.getUniversityFiscalYear();
            String chartCode = appointmentFunding.getChartOfAccountsCode();
            String objectCode = appointmentFunding.getFinancialObjectCode();
            boolean vacatable = this.salarySettingService.canBeVacant(appointmentFundings, appointmentFunding);
            appointmentFunding.setVacatable(vacatable);
            boolean budgetable = this.budgetDocumentService.isAssociatedWithBudgetableDocument(appointmentFunding);
            appointmentFunding.setBudgetable(budgetable);
            boolean hourlyPaid = this.salarySettingService.isHourlyPaidObject(fiscalYear, chartCode, objectCode);
            appointmentFunding.setHourlyPaid(hourlyPaid);
        }
        DynamicCollectionComparator.sort(appointmentFundings, (String[])new String[]{"positionNumber", "emplid"});
        return true;
    }

    public void refreshBCAFLine(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        appointmentFunding.refreshNonUpdateableReferences();
        ObjectUtils.materializeObjects(appointmentFunding.getBudgetConstructionAppointmentFundingReason());
        appointmentFunding.refreshReferenceObject("account");
        appointmentFunding.refreshReferenceObject("subAccount");
        appointmentFunding.refreshReferenceObject("bcnCalculatedSalaryFoundationTracker");
        this.applyDefaultReasonAmountIfEmpty(appointmentFunding);
        this.applyDefaultTotalIntendedAmountIfEmpty(appointmentFunding);
    }

    public void applyDefaultReasonAmountIfEmpty(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        if (!appointmentFunding.getBudgetConstructionAppointmentFundingReason().isEmpty()) {
            BudgetConstructionAppointmentFundingReason afReason = appointmentFunding.getBudgetConstructionAppointmentFundingReason().get(0);
            if (ObjectUtils.isNotNull((Object)((Object)afReason))) {
                if (afReason.getAppointmentFundingReasonAmount() == null) {
                    afReason.setAppointmentFundingReasonAmount(KualiInteger.ZERO);
                }
                if (afReason.getAppointmentFundingReasonCode() != null) {
                    afReason.refreshReferenceObject("appointmentFundingReason");
                }
            }
        } else {
            appointmentFunding.getBudgetConstructionAppointmentFundingReason().add(new BudgetConstructionAppointmentFundingReason());
        }
    }

    public void applyDefaultTotalIntendedAmountIfEmpty(PendingBudgetConstructionAppointmentFunding appointmentFunding) {
        if (appointmentFunding.getAppointmentTotalIntendedAmount() == null) {
            appointmentFunding.setAppointmentTotalIntendedAmount(KualiInteger.ZERO);
        }
        if (appointmentFunding.getAppointmentTotalIntendedFteQuantity() == null) {
            appointmentFunding.setAppointmentTotalIntendedFteQuantity(BigDecimal.ZERO);
        }
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getSubAccountNumber() {
        return this.subAccountNumber;
    }

    public void setSubAccountNumber(String subAccountNumber) {
        this.subAccountNumber = subAccountNumber;
    }

    public String getFinancialObjectCode() {
        return this.financialObjectCode;
    }

    public void setFinancialObjectCode(String financialObjectCode) {
        this.financialObjectCode = financialObjectCode;
    }

    public String getFinancialSubObjectCode() {
        return this.financialSubObjectCode;
    }

    public void setFinancialSubObjectCode(String financialSubObjectCode) {
        this.financialSubObjectCode = financialSubObjectCode;
    }

    public String getFinancialBalanceTypeCode() {
        return this.financialBalanceTypeCode;
    }

    public void setFinancialBalanceTypeCode(String financialBalanceTypeCode) {
        this.financialBalanceTypeCode = financialBalanceTypeCode;
    }

    public String getFinancialObjectTypeCode() {
        return this.financialObjectTypeCode;
    }

    public void setFinancialObjectTypeCode(String financialObjectTypeCode) {
        this.financialObjectTypeCode = financialObjectTypeCode;
    }

    public boolean isHideAdjustmentMeasurement() {
        return this.hideAdjustmentMeasurement;
    }

    public void setHideAdjustmentMeasurement(boolean hideAdjustmentMeasurement) {
        this.hideAdjustmentMeasurement = hideAdjustmentMeasurement;
    }

    public String getAdjustmentMeasurement() {
        return this.adjustmentMeasurement;
    }

    public void setAdjustmentMeasurement(String adjustmentMeasurement) {
        this.adjustmentMeasurement = adjustmentMeasurement;
    }

    public KualiDecimal getAdjustmentAmount() {
        return this.adjustmentAmount;
    }

    public void setAdjustmentAmount(KualiDecimal adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
    }

    public boolean isHideDetails() {
        return this.hideDetails;
    }

    public void setHideDetails(boolean hideDetails) {
        this.hideDetails = hideDetails;
    }

    public boolean isBudgetByAccountMode() {
        return this.budgetByAccountMode;
    }

    public void setBudgetByAccountMode(boolean budgetByAccountMode) {
        this.budgetByAccountMode = budgetByAccountMode;
    }

    public boolean isSingleAccountMode() {
        return this.singleAccountMode;
    }

    public void setSingleAccountMode(boolean singleAccountMode) {
        this.singleAccountMode = singleAccountMode;
    }

    public abstract List<PendingBudgetConstructionAppointmentFunding> getAppointmentFundings();

    public KualiInteger getAppointmentRequestedCsfAmountTotal() {
        return SalarySettingCalculator.getAppointmentRequestedCsfAmountTotal(this.getEffectivePendingBudgetConstructionAppointmentFunding());
    }

    public BigDecimal getAppointmentRequestedCsfTimePercentTotal() {
        return SalarySettingCalculator.getAppointmentRequestedCsfTimePercentTotal(this.getAppointmentFundings());
    }

    public BigDecimal getAppointmentRequestedCsfStandardHoursTotal() {
        return SalarySettingCalculator.getAppointmentRequestedCsfStandardHoursTotal(this.getAppointmentFundings());
    }

    public BigDecimal getAppointmentRequestedCsfFteQuantityTotal() {
        return SalarySettingCalculator.getAppointmentRequestedCsfFteQuantityTotal(this.getAppointmentFundings());
    }

    public KualiInteger getAppointmentRequestedAmountTotal() {
        return SalarySettingCalculator.getAppointmentRequestedAmountTotal(this.getEffectivePendingBudgetConstructionAppointmentFunding());
    }

    public BigDecimal getAppointmentRequestedTimePercentTotal() {
        return SalarySettingCalculator.getAppointmentRequestedTimePercentTotal(this.getAppointmentFundings());
    }

    public BigDecimal getAppointmentRequestedStandardHoursTotal() {
        return SalarySettingCalculator.getAppointmentRequestedStandardHoursTotal(this.getAppointmentFundings());
    }

    public BigDecimal getAppointmentRequestedFteQuantityTotal() {
        return SalarySettingCalculator.getAppointmentRequestedFteQuantityTotal(this.getAppointmentFundings());
    }

    public KualiInteger getCsfAmountTotal() {
        return SalarySettingCalculator.getCsfAmountTotal(this.getEffectivePendingBudgetConstructionAppointmentFunding());
    }

    public BigDecimal getCsfTimePercentTotal() {
        return SalarySettingCalculator.getCsfTimePercentTotal(this.getAppointmentFundings());
    }

    public BigDecimal getCsfStandardHoursTotal() {
        return SalarySettingCalculator.getCsfStandardHoursTotal(this.getAppointmentFundings());
    }

    public BigDecimal getCsfFullTimeEmploymentQuantityTotal() {
        return SalarySettingCalculator.getCsfFullTimeEmploymentQuantityTotal(this.getAppointmentFundings());
    }

    public KualiDecimal getPercentChangeTotal() {
        KualiInteger csfAmountTotal = this.getCsfAmountTotal();
        KualiInteger requestedAmountTotal = this.getAppointmentRequestedAmountTotal();
        return SalarySettingCalculator.getPercentChange(csfAmountTotal, requestedAmountTotal);
    }

    public List<PendingBudgetConstructionAppointmentFunding> getEffectivePendingBudgetConstructionAppointmentFunding() {
        return SalarySettingCalculator.getEffectiveAppointmentFundings(this.getAppointmentFundings());
    }

    public SalarySettingFieldsHolder getSalarySettingFieldsHolder() {
        if (this.salarySettingFieldsHolder == null) {
            this.salarySettingFieldsHolder = new SalarySettingFieldsHolder();
            ObjectUtil.buildObject((Object)this.salarySettingFieldsHolder, (Object)((Object)this));
        }
        return this.salarySettingFieldsHolder;
    }

    public Person getPerson() {
        return this.person;
    }

    public boolean isSalarySettingClosed() {
        return this.salarySettingClosed;
    }

    public void setSalarySettingClosed(boolean salarySettingClosed) {
        this.salarySettingClosed = salarySettingClosed;
    }

    public boolean isViewOnlyEntry() {
        return this.isSystemViewOnly();
    }

    public boolean isPayrollIncumbentFeedIndictor() {
        return BudgetParameterFinder.getPayrollIncumbentFeedIndictor();
    }

    public boolean isPayrollPositionFeedIndicator() {
        return BudgetParameterFinder.getPayrollPositionFeedIndicator();
    }

    public String getDashSubAccountNumber() {
        return this.dashSubAccountNumber;
    }

    public void setDashSubAccountNumber(String dashSubAccountNumber) {
        this.dashSubAccountNumber = dashSubAccountNumber;
    }

    public String getDashFinancialSubObjectCode() {
        return this.dashFinancialSubObjectCode;
    }

    public void setDashFinancialSubObjectCode(String dashFinancialSubObjectCode) {
        this.dashFinancialSubObjectCode = dashFinancialSubObjectCode;
    }
}

