/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.service.impl;

import org.apache.commons.lang.StringUtils;
import org.kuali.kfs.module.bc.BCConstants;
import org.kuali.kfs.module.bc.businessobject.BudgetConstructionIntendedIncumbent;
import org.kuali.kfs.module.bc.businessobject.Incumbent;
import org.kuali.kfs.module.bc.businessobject.Position;
import org.kuali.kfs.module.bc.dataaccess.HumanResourcesPayrollDao;
import org.kuali.kfs.module.bc.exception.IncumbentNotFoundException;
import org.kuali.kfs.module.bc.exception.PositionNotFoundException;
import org.kuali.kfs.module.bc.service.HumanResourcesPayrollService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.NonTransactional;
import org.kuali.rice.kim.api.identity.PersonService;
import org.springframework.transaction.annotation.Transactional;

public class HumanResourcesPayrollServiceImpl
implements HumanResourcesPayrollService {
    HumanResourcesPayrollDao humanResourcesPayrollDao;
    private PersonService personService;

    @Override
    @NonTransactional
    public boolean validatePositionUnionCode(String positionUnionCode) {
        return true;
    }

    @Override
    @Transactional
    public Position getPosition(Integer universityFiscalYear, String positionNumber) throws PositionNotFoundException {
        Position position = this.humanResourcesPayrollDao.getPosition(universityFiscalYear, positionNumber);
        if (position == null) {
            throw new PositionNotFoundException(universityFiscalYear, positionNumber);
        }
        return position;
    }

    @Override
    @Transactional
    public Incumbent getIncumbent(String emplid) throws IncumbentNotFoundException {
        String name = ((FinancialSystemUserService)SpringContext.getBean(FinancialSystemUserService.class)).getPersonNameByEmployeeId(emplid);
        if (!StringUtils.isEmpty((String)name)) {
            BudgetConstructionIntendedIncumbent incumbent = new BudgetConstructionIntendedIncumbent();
            incumbent.setEmplid(emplid);
            incumbent.setName(name);
            return incumbent;
        }
        throw new IncumbentNotFoundException(emplid);
    }

    @Override
    @Transactional
    public boolean isActiveJob(String emplid, String positionNumber, Integer fiscalYear, BCConstants.SynchronizationCheckType synchronizationCheckType) {
        return true;
    }

    @NonTransactional
    public void setHumanResourcesPayrollDao(HumanResourcesPayrollDao humanResourcesPayrollDao) {
        this.humanResourcesPayrollDao = humanResourcesPayrollDao;
    }

    protected PersonService getPersonService() {
        if (this.personService == null) {
            this.personService = (PersonService)SpringContext.getBean(PersonService.class);
        }
        return this.personService;
    }
}

