/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.bc.util;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.bc.document.BudgetConstructionDocument;
import org.kuali.kfs.module.bc.util.BudgetParameterFinder;
import org.kuali.kfs.sys.context.SpringContext;

public class BudgetConstructionUtils {
    private static ParameterService parameterService = (ParameterService)SpringContext.getBean(ParameterService.class);
    private static Logger LOG = Logger.getLogger(BudgetConstructionUtils.class);

    public static String getExpenditureINList() {
        if (!parameterService.parameterExists(BudgetConstructionDocument.class, "EXPENDITURE_OBJECT_TYPES").booleanValue()) {
            LOG.warn((Object)String.format("\n***Budget Construction Application Error***\nSQL will not be valid\nparameter %s does not exist\n", "EXPENDITURE_OBJECT_TYPES"));
            IllegalArgumentException ioex = new IllegalArgumentException("parameter EXPENDITURE_OBJECT_TYPES does not exist");
            throw ioex;
        }
        Collection<String> expenditureObjectTypes = BudgetParameterFinder.getExpenditureObjectTypes();
        if (expenditureObjectTypes.isEmpty()) {
            LOG.warn((Object)String.format("\n***Budget Construction Application Error***\nSQL will not be valid\nparameter %s is empty\n", "EXPENDITURE_OBJECT_TYPES"));
            IllegalArgumentException bfex = new IllegalArgumentException("parameter EXPENDITURE_OBJECT_TYPES is empty");
            throw bfex;
        }
        return BudgetConstructionUtils.inString(expenditureObjectTypes);
    }

    public static String getRevenueINList() {
        if (!parameterService.parameterExists(BudgetConstructionDocument.class, "REVENUE_OBJECT_TYPES").booleanValue()) {
            LOG.warn((Object)String.format("\n***Budget Construction Application Error***\nSQL will not be valid\nparameter %s does not exist\n", "REVENUE_OBJECT_TYPES"));
            IllegalArgumentException ioex = new IllegalArgumentException("parameter REVENUE_OBJECT_TYPES does not exist");
            throw ioex;
        }
        Collection<String> revenueObjectTypes = BudgetParameterFinder.getRevenueObjectTypes();
        if (revenueObjectTypes.isEmpty()) {
            LOG.warn((Object)String.format("\n***Budget Construction Application Error***\nSQL will not be valid\nparameter %s is empty\n", "REVENUE_OBJECT_TYPES"));
            IllegalArgumentException bfex = new IllegalArgumentException("parameter REVENUE_OBJECT_TYPES is empty");
            throw bfex;
        }
        return BudgetConstructionUtils.inString(revenueObjectTypes);
    }

    protected static String inString(Integer parameterCount) {
        if (parameterCount == 0) {
            return new String("('')");
        }
        StringBuilder sb = new StringBuilder(20);
        sb = sb.append("(?");
        for (int i = 1; i < parameterCount; ++i) {
            sb.append(",?");
        }
        sb.append(")");
        return sb.toString();
    }

    protected static String inString(Collection<String> inListValues) {
        if (inListValues.isEmpty()) {
            return "";
        }
        StringBuilder inBuilder = new StringBuilder(150);
        inBuilder.append("('");
        boolean isFirst = true;
        for (String val : inListValues) {
            if (isFirst) {
                isFirst = false;
            } else {
                inBuilder.append("','");
            }
            inBuilder.append(val);
        }
        inBuilder.append("')");
        return inBuilder.toString();
    }
}

