/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.businessobject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;

@Execution(value=ExecutionMode.SAME_THREAD)
public class AwardTest {
    private static final String FIRST_ACCOUNT_NUMBER = "0211821";
    private static final String SECOND_ACCOUNT_NUMBER = "0211822";
    private static final String CHART_OF_ACCOUNTS_CODE = "BL";
    private Award cut;
    private AwardProjectDirector awardProjectDirector;
    private AwardProjectDirector awardProjectDirectorForList;
    private List<AwardProjectDirector> awardProjectDirectors;

    @Before
    public void setUp() {
        this.cut = new Award();
        this.awardProjectDirector = new AwardProjectDirector();
        this.awardProjectDirectors = new ArrayList<AwardProjectDirector>();
        this.awardProjectDirectorForList = new AwardProjectDirector();
        this.awardProjectDirectors.add(this.awardProjectDirectorForList);
    }

    @Test
    public void getAwardPrimaryProjectDirector_nullField_noProjectDirectorsInList() {
        Assert.assertNull((Object)this.cut.getAwardPrimaryProjectDirector());
    }

    @Test
    public void getAwardPrimaryProjectDirector_nullField_noPrimaryProjectDirectorInList() {
        this.cut.setAwardProjectDirectors(this.awardProjectDirectors);
        Assert.assertNull((Object)this.cut.getAwardPrimaryProjectDirector());
    }

    @Test
    public void getAwardPrimaryProjectDirector_nullField_hasPrimaryProjectDirectorInList() {
        this.awardProjectDirectorForList.setAwardPrimaryProjectDirectorIndicator(true);
        this.cut.setAwardProjectDirectors(this.awardProjectDirectors);
        Assert.assertEquals((Object)this.awardProjectDirectorForList, (Object)this.cut.getAwardPrimaryProjectDirector());
    }

    @Test
    public void getAwardPrimaryProjectDirector_setField_noProjectDirectorsInList() {
        this.cut.setAwardPrimaryProjectDirector(this.awardProjectDirector);
        Assert.assertEquals((Object)this.awardProjectDirector, (Object)this.cut.getAwardPrimaryProjectDirector());
    }

    @Test
    public void getAwardPrimaryProjectDirector_setField_noPrimaryProjectDirectorInList() {
        this.cut.setAwardPrimaryProjectDirector(this.awardProjectDirector);
        this.cut.setAwardProjectDirectors(this.awardProjectDirectors);
        Assert.assertEquals((Object)this.awardProjectDirector, (Object)this.cut.getAwardPrimaryProjectDirector());
    }

    @Test
    public void getAwardPrimaryProjectDirector_setField_hasPrimaryProjectDirectorInList() {
        this.cut.setAwardPrimaryProjectDirector(this.awardProjectDirector);
        this.awardProjectDirectorForList.setAwardPrimaryProjectDirectorIndicator(true);
        this.cut.setAwardProjectDirectors(this.awardProjectDirectors);
        Assert.assertEquals((Object)this.awardProjectDirectorForList, (Object)this.cut.getAwardPrimaryProjectDirector());
    }

    @Test
    public void getActiveAwardAccounts_noAwardAccounts() {
        List activeAwardAccounts = this.cut.getActiveAwardAccounts();
        Assert.assertEquals((long)0L, (long)activeAwardAccounts.size());
    }

    @Test
    public void getActiveAwardAccounts_TwoAwardAccounts_OneActive() {
        this.cut.setAwardAccounts(this.setupAwardAccounts(false, true));
        List activeAwardAccounts = this.cut.getActiveAwardAccounts();
        Assert.assertEquals((long)1L, (long)activeAwardAccounts.size());
        Assert.assertEquals((Object)SECOND_ACCOUNT_NUMBER, (Object)((ContractsAndGrantsBillingAwardAccount)activeAwardAccounts.get(0)).getAccountNumber());
    }

    @Test
    public void getActiveAwardAccounts_TwoAwardAccounts_BothActive() {
        this.cut.setAwardAccounts(this.setupAwardAccounts(true, true));
        List activeAwardAccounts = this.cut.getActiveAwardAccounts();
        Assert.assertEquals((long)2L, (long)activeAwardAccounts.size());
        Assert.assertEquals((Object)FIRST_ACCOUNT_NUMBER, (Object)((ContractsAndGrantsBillingAwardAccount)activeAwardAccounts.get(0)).getAccountNumber());
        Assert.assertEquals((Object)SECOND_ACCOUNT_NUMBER, (Object)((ContractsAndGrantsBillingAwardAccount)activeAwardAccounts.get(1)).getAccountNumber());
    }

    @Test
    public void getActiveAwardAccounts_TwoAwardAccounts_BothInactive() {
        this.cut.setAwardAccounts(this.setupAwardAccounts(false, false));
        List activeAwardAccounts = this.cut.getActiveAwardAccounts();
        Assert.assertEquals((long)0L, (long)activeAwardAccounts.size());
    }

    @Test
    public void getActiveAwardAccounts_TwoAwardAccounts_BothActive_OneSelectedAccounts() {
        this.cut.setAwardAccounts(this.setupAwardAccounts(true, true));
        this.cut.setSelectedAccounts(Collections.singletonList("BL0211822"));
        List activeAwardAccounts = this.cut.getActiveAwardAccounts();
        Assert.assertEquals((long)1L, (long)activeAwardAccounts.size());
        Assert.assertEquals((Object)SECOND_ACCOUNT_NUMBER, (Object)((ContractsAndGrantsBillingAwardAccount)activeAwardAccounts.get(0)).getAccountNumber());
    }

    @Test
    public void getActiveAwardAccounts_TwoAwardAccounts_BothActive_BothSelectedAccounts() {
        this.cut.setAwardAccounts(this.setupAwardAccounts(true, true));
        this.cut.setSelectedAccounts(Arrays.asList("BL0211821", "BL0211822"));
        List activeAwardAccounts = this.cut.getActiveAwardAccounts();
        Assert.assertEquals((long)2L, (long)activeAwardAccounts.size());
        Assert.assertEquals((Object)FIRST_ACCOUNT_NUMBER, (Object)((ContractsAndGrantsBillingAwardAccount)activeAwardAccounts.get(0)).getAccountNumber());
        Assert.assertEquals((Object)SECOND_ACCOUNT_NUMBER, (Object)((ContractsAndGrantsBillingAwardAccount)activeAwardAccounts.get(1)).getAccountNumber());
    }

    private List<AwardAccount> setupAwardAccounts(boolean firstActive, boolean secondActive) {
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        awardAccounts.add(this.setupAwardAccount(FIRST_ACCOUNT_NUMBER, firstActive));
        awardAccounts.add(this.setupAwardAccount(SECOND_ACCOUNT_NUMBER, secondActive));
        return awardAccounts;
    }

    private AwardAccount setupAwardAccount(String accountNumber, boolean active) {
        AwardAccount awardAccount = new AwardAccount();
        awardAccount.setChartOfAccountsCode(CHART_OF_ACCOUNTS_CODE);
        awardAccount.setAccountNumber(accountNumber);
        awardAccount.setActive(active);
        return awardAccount;
    }
}

