/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.cg.document.validation.impl;

import java.sql.Date;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.runner.RunWith;
import org.kuali.kfs.datadictionary.legacy.DataDictionaryService;
import org.kuali.kfs.kim.impl.identity.PersonImpl;
import org.kuali.kfs.krad.rules.DocumentRuleBase;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.cg.businessobject.Agency;
import org.kuali.kfs.module.cg.businessobject.AgencyAddress;
import org.kuali.kfs.module.cg.businessobject.Award;
import org.kuali.kfs.module.cg.businessobject.AwardAccount;
import org.kuali.kfs.module.cg.businessobject.AwardFundManager;
import org.kuali.kfs.module.cg.businessobject.AwardProjectDirector;
import org.kuali.kfs.module.cg.document.validation.impl.CGMaintenanceDocumentRuleBase;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.util.AutoPopulatingList;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={KimApiServiceLocator.class})
@Execution(value=ExecutionMode.SAME_THREAD)
public class CGMaintenanceDocumentRuleBaseTest {
    private static final String AGENCY_NUMBER = "55076";
    private CGMaintenanceDocumentRuleBase cut;
    @Mock
    private Award award;
    @Mock
    private DataDictionaryService dataDictionarySvcMock;
    @Mock
    private IdentityService identitySvcMock;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.identitySvcMock.getEntityByPrincipalId("wklykins")).thenReturn((Object)Entity.Builder.create().build());
        PowerMockito.mockStatic(KimApiServiceLocator.class, (Class[])new Class[0]);
        Mockito.when((Object)KimApiServiceLocator.getIdentityService()).thenReturn((Object)this.identitySvcMock);
        this.cut = new CGMaintenanceDocumentRuleBase();
        DocumentRuleBase.setDataDictionaryService((DataDictionaryService)this.dataDictionarySvcMock);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @After
    public void tearDown() {
        DocumentRuleBase.setDataDictionaryService(null);
        GlobalVariables.getMessageMap().clearErrorMessages();
    }

    @Test
    public void checkEndAfterBegin() {
        Date begin = new Date(11111L);
        Date end = new Date(11115L);
        Assert.assertFalse((boolean)this.cut.checkEndAfterBegin(begin, begin, ""));
        Assert.assertTrue((boolean)this.cut.checkEndAfterBegin(begin, end, ""));
    }

    @Test
    public void checkPrimary() {
        ArrayList<AgencyAddress> agencyAddresses = new ArrayList<AgencyAddress>();
        AgencyAddress agencyAddress = new AgencyAddress();
        agencyAddress.setCustomerAddressTypeCode("P");
        agencyAddresses.add(agencyAddress);
        Assert.assertTrue((boolean)this.cut.checkPrimary(agencyAddresses, AgencyAddress.class, "agencyAddresses", Agency.class));
    }

    @Test
    public void checkProjectDirectorsExist_AwardProjectDirectors() {
        ArrayList<AwardProjectDirector> awardProjectDirectors = new ArrayList<AwardProjectDirector>();
        AwardProjectDirector awardProjectDirector = new AwardProjectDirector();
        awardProjectDirector.setPrincipalId("wklykins");
        awardProjectDirectors.add(awardProjectDirector);
        Assert.assertTrue((boolean)this.cut.checkProjectDirectorsExist(awardProjectDirectors, AwardProjectDirector.class, "awardProjectDirectors"));
    }

    @Test
    public void checkProjectDirectorsExist_AwardAccounts() {
        ArrayList<AwardAccount> awardAccounts = new ArrayList<AwardAccount>();
        AwardAccount awardAccount = new AwardAccount();
        awardAccount.setPrincipalId("wklykins");
        awardAccounts.add(awardAccount);
        Assert.assertTrue((boolean)this.cut.checkProjectDirectorsExist(awardAccounts, AwardAccount.class, "awardAccounts"));
    }

    @Test
    public void checkFundManagersExist() {
        ArrayList<AwardFundManager> awardFundManagers = new ArrayList<AwardFundManager>();
        AwardFundManager awardFundManager = new AwardFundManager();
        awardFundManager.setPrincipalId("wklykins");
        awardFundManagers.add(awardFundManager);
        Assert.assertTrue((boolean)this.cut.checkFundManagersExist(awardFundManagers, "awardFundManagers"));
    }

    @Test
    public void checkProjectDirectorsStatuses() {
        ArrayList<AwardProjectDirector> awardProjectDirectors = new ArrayList<AwardProjectDirector>();
        PersonImpl projectDirectorMock = (PersonImpl)Mockito.mock(PersonImpl.class);
        Mockito.when((Object)projectDirectorMock.getEmployeeStatusCode()).thenReturn((Object)"A");
        AwardProjectDirector awardProjectDirectorMock = (AwardProjectDirector)Mockito.mock(AwardProjectDirector.class);
        Mockito.when((Object)awardProjectDirectorMock.getProjectDirector()).thenReturn((Object)projectDirectorMock);
        awardProjectDirectors.add(awardProjectDirectorMock);
        Assert.assertTrue((boolean)this.cut.checkProjectDirectorsStatuses(awardProjectDirectors, AwardProjectDirector.class, "awardProjectDirectors"));
    }

    @Test
    public void checkFederalPassThrough() {
        Assert.assertTrue((boolean)this.cut.checkFederalPassThrough(this.award.getFederalPassThroughIndicator(), this.award.getAgency(), this.award.getFederalPassThroughAgencyNumber(), Award.class, "federalPassThroughIndicator"));
    }

    @Test
    public void checkAgencyNotEqualToFederalPassThroughAgency() {
        Mockito.when((Object)this.award.getAgency()).thenReturn((Object)((Agency)Mockito.mock(Agency.class)));
        Assert.assertTrue((boolean)this.cut.checkAgencyNotEqualToFederalPassThroughAgency(this.award.getAgency(), this.award.getFederalPassThroughAgency(), "agencyNumber", "federalPassThroughAgencyNumber"));
    }

    @Test
    public void testCheckAgencyNotEqualToFederalPassThroughAgency_Equal_INVALID() {
        Agency agency = new Agency();
        agency.setAgencyNumber(AGENCY_NUMBER);
        Agency federalPassThroughAgency = new Agency();
        federalPassThroughAgency.setAgencyNumber(AGENCY_NUMBER);
        Assert.assertFalse((boolean)this.cut.checkAgencyNotEqualToFederalPassThroughAgency(agency, federalPassThroughAgency, "agencyNumber", "federalPassThroughAgencyNumber"));
        Assert.assertEquals((long)2L, (long)GlobalVariables.getMessageMap().getErrorCount());
        ErrorMessage errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.agencyNumber")).get(0);
        Assert.assertEquals((Object)"error.cg.agencyEqualsFederalPassThroughAgency", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
        errorMessage = (ErrorMessage)((AutoPopulatingList)GlobalVariables.getMessageMap().getErrorMessages().get("document.newMaintainableObject.federalPassThroughAgencyNumber")).get(0);
        Assert.assertEquals((Object)"error.cg.federalPassThroughAgencyEqualsAgency", (Object)errorMessage.getErrorKey());
        Assert.assertEquals((long)0L, (long)errorMessage.getMessageParameters().length);
    }

    @Test
    public void testCheckAgencyNotEqualToFederalPassThroughAgency_NotEqual_VALID() {
        Agency agency = new Agency();
        agency.setAgencyNumber(AGENCY_NUMBER);
        Agency federalPassThroughAgency = new Agency();
        federalPassThroughAgency.setAgencyNumber("1");
        Assert.assertTrue((boolean)this.cut.checkAgencyNotEqualToFederalPassThroughAgency(agency, federalPassThroughAgency, "agencyNumber", "federalPassThroughAgencyNumber"));
        Assert.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }
}

