/**
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2018 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.kns.datadictionary;

import org.kuali.kfs.kns.document.authorization.DocumentAuthorizer;
import org.kuali.kfs.kns.document.authorization.DocumentPresentationController;
import org.kuali.kfs.kns.rule.PromptBeforeValidation;
import org.kuali.kfs.kns.web.derivedvaluesetter.DerivedValuesSetter;
import org.kuali.kfs.krad.datadictionary.DataDictionaryEntry;
import org.kuali.kfs.krad.datadictionary.ReferenceDefinition;
import org.kuali.kfs.krad.datadictionary.WorkflowAttributes;
import org.kuali.kfs.krad.datadictionary.WorkflowProperties;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.keyvalues.KeyValuesFinder;
import org.kuali.kfs.krad.rules.rule.BusinessRule;
import org.springframework.beans.factory.InitializingBean;

import java.io.Serializable;
import java.util.List;

@Deprecated
public interface KNSDocumentEntry extends DataDictionaryEntry, Serializable, InitializingBean {

    Class<? extends Document> getDocumentClass();

    void setDocumentClass(Class<? extends Document> documentClass);

    Class<? extends Document> getBaseDocumentClass();

    void setBaseDocumentClass(Class<? extends Document> baseDocumentClass);

    Class<? extends BusinessRule> getBusinessRulesClass();

    void setBusinessRulesClass(Class<? extends BusinessRule> businessRulesClass);

    String getDocumentTypeName();

    void setDocumentTypeName(String documentTypeName);

    boolean getDisplayTopicFieldInNotes();

    void setDisplayTopicFieldInNotes(boolean displayTopicFieldInNotes);

    Class<? extends KeyValuesFinder> getAttachmentTypesValuesFinderClass();

    void setAttachmentTypesValuesFinderClass(Class<? extends KeyValuesFinder> attachmentTypesValuesFinderClass);

    boolean getAllowsCopy();

    void setAllowsCopy(boolean allowsCopy);

    boolean getAllowsNoteAttachments();

    void setAllowsNoteAttachments(boolean allowsNoteAttachments);

    boolean getAllowsNoteFYI();

    void setAllowsNoteFYI(boolean allowsNoteFYI);

    WorkflowProperties getWorkflowProperties();

    void setWorkflowProperties(WorkflowProperties workflowProperties);

    WorkflowAttributes getWorkflowAttributes();

    void setWorkflowAttributes(WorkflowAttributes workflowAttributes);

    List<ReferenceDefinition> getDefaultExistenceChecks();

    void setDefaultExistenceChecks(List<ReferenceDefinition> defaultExistenceChecks);

    boolean isEncryptDocumentDataInPersistentSessionStorage();

    void setEncryptDocumentDataInPersistentSessionStorage(boolean encryptDocumentDataInPersistentSessionStorage);

    List<HeaderNavigation> getHeaderNavigationList();

    List<String> getWebScriptFiles();

    Class<? extends PromptBeforeValidation> getPromptBeforeValidationClass();

    void setPromptBeforeValidationClass(Class<? extends PromptBeforeValidation> preRulesCheckClass);

    void setWebScriptFiles(List<String> webScriptFiles);

    void setHeaderNavigationList(List<HeaderNavigation> headerNavigationList);

    boolean isSessionDocument();

    void setSessionDocument(boolean sessionDocument);

    Class<? extends DerivedValuesSetter> getDerivedValuesSetterClass();

    void setDerivedValuesSetterClass(Class<? extends DerivedValuesSetter> derivedValuesSetter);

    Class<? extends DocumentAuthorizer> getDocumentAuthorizerClass();

    Class<? extends DocumentPresentationController> getDocumentPresentationControllerClass();


}
