/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.gl.businessobject.OriginEntryTestBase;
import org.kuali.kfs.module.ld.batch.LaborScrubberStep;
import org.kuali.kfs.module.ld.batch.service.LaborOriginEntryTestBase;
import org.kuali.kfs.module.ld.batch.service.LaborScrubberService;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.Message;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;

@ConfigureContext
public class LaborScrubberServiceTest
extends LaborOriginEntryTestBase {
    private static Logger LOG = Logger.getLogger(LaborScrubberServiceTest.class);
    private LaborScrubberService laborScrubberService = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.laborScrubberService = (LaborScrubberService)SpringContext.getBean(LaborScrubberService.class);
        this.laborScrubberService.setDateTimeService((DateTimeService)this.dateTimeService);
        this.dateTimeService.setCurrentDate(new Date());
    }

    public void testDemerger() throws Exception {
        String[] inputTransactions = new String[]{"2026BA6044900-----2400---ACEX06BT  PLM01010207     0000100009529----------KUALI TEST DESCRIPTION                  +00000000000003493.50D2008-12-22                                                 2008-12-222008-12-31000168.002007060000149952 001REGS12PAE 11 M001010207                     IU IUBLA", "2009BA6044900-----2400---ACEX06BT  PLM01010207     0000100009529----------KUALI TEST DESCRIPTION                  +00000000000003493.50C2008-12-22                                                 2008-12-222008-12-31000168.002007060000149952 001REGS12PAE 11 M001010207                     IU IUBLA", "2026BA6044900-----2400---ACEX06ST  PLM01010207     0000100009529----------KUALI TEST DESCRIPTION                  +00000000000003493.50C2008-12-22                                                 2008-12-222008-12-31000168.002007060000149952 001REGS12PAE 11 M001010207                     IU IUBLA", "2009BA6044900-----2400---ACEX06ST  PLM01010207     0000100009529----------KUALI TEST DESCRIPTION                  +00000000000003493.50C2008-12-22                                                 2008-12-222008-12-31000168.002007060000149952 001REGS12PAE 11 M001010207                     IU IUBLA"};
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[1]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[2]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[3]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[1]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[2]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[3])};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testValidEntries() throws Exception {
        String[] inputTransactions = new String[]{"2009BA6044900-----2400---ACEX06BT  PLM01010207     0000100009529----------KUALI TEST DESCRIPTION                  +00000000000003493.50D2008-12-22                                                 2008-12-222008-12-31000168.002009060000149952 001REGS12PAE 11 M001010207                     IU IUBLA", "2009BA6044900-----2400---ACEX06BT  PLM01010207     0000200014789----------KUALI TEST DESCRIPTION                  +00000000000003329.27D2008-12-22                                                 2008-12-222008-12-31000082.322009060000649044 000REGS12PAE 16 M001010207                     IU IUBLA", "2009BA6044900-----2400---ACEX06BT  PLM01010207     0000300015213----------KUALI TEST DESCRIPTION                  +00000000000002716.89D2008-12-22                                                 2008-12-222008-12-31000084.862009060000683206 000REGS12PAE 13 M001010207                     IU IUBLA", "2009BA6044900-----2400---ACEX06BT  PLM01010207     0000400017659----------KUALI TEST DESCRIPTION                  +00000000000001620.08D2008-12-22                                                 2008-12-222008-12-31000041.382009060001316908 000REGS12PAE 13 M001010207                     IU IUBLA", "2009BA6044900-----2400---ACEX06BT  PLM01010207     0000500019196----------KUALI TEST DESCRIPTION                  +00000000000005106.15D2008-12-22                                                 2008-12-222008-12-31000104.932009060001368813 000REGS12PAE 19 M001010207                     IU IUBLA", "2009BA6044900-----2400---ACEX06BT  PLM01010207     0000600022120----------KUALI TEST DESCRIPTION                  +00000000000003071.10D2008-12-22                                                 2008-12-222008-12-31000106.752009060001773996 000REGS12PAE 12 M001010207                     IU IUBLA", "2009BA6044900-----2400---ACEX07BT  PLM04013107     0000100009529----------KUALI TEST DESCRIPTION                  +00000000000003493.50D2009-01-25                                                 2009-01-252009-01-31000184.002009070000149952 001REGS12PAE 11 M004013107                     IU IUBLA", "2009BA6044900-----2400---ACEX07BT  PLM04013107     0000200014789----------KUALI TEST DESCRIPTION                  +00000000000003329.27D2009-01-25                                                 2009-01-252009-01-31000090.162009070000649044 000REGS12PAE 16 M004013107                     IU IUBLA", "2009BA6044900-----2400---ACEX07BT  PLM04013107     0000300015213----------KUALI TEST DESCRIPTION                  +00000000000002716.89D2009-01-25                                                 2009-01-252009-01-31000092.942009070000683206 000REGS12PAE 13 M004013107                     IU IUBLA", "2009BA6044900-----2400---ACEX07BT  PLM04013107     0000400017659----------KUALI TEST DESCRIPTION                  +00000000000001620.08D2009-01-25                                                 2009-01-252009-01-31000045.322009070001316908 000REGS12PAE 13 M004013107                     IU IUBLA"};
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[1]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[2]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[3]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[4]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[5]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[6]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[7]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[8]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[9]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[1]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[2]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[3]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[4]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[5]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[6]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[7]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[8]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[9])};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testBlankFiscalYear() throws Exception {
        String[] inputTransactions = new String[]{"    BA6044900-----2400---ACEX06BT  PLBLANKFISC     0000100009529----------KUALI TEST DESCRIPTION                  +00000000000003493.50D2008-12-22                                                 2008-12-222008-12-31000168.002009060000149952 001REGS12PAE 11 M001010207                     IU IUBLA"};
        String expectedOutput = this.testingYear + StringUtils.substring((String)inputTransactions[0], (int)4, (int)29) + this.testingPeriodCode + StringUtils.substring((String)inputTransactions[0], (int)31);
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", expectedOutput)};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testInvalidObjectCode() throws Exception {
        String[] inputTransactions = new String[]{"2000BA6044906-----2400---ACEX06BT  PLCLOSEFISC     0000300015213----------KUALI TEST DESCRIPTION                  +00000000000002716.89D2006-12-22                                                 2006-12-222006-12-31000084.862007060000683206 000REGS12PAE 13 M001010207                     IU IUBLA", "2000BA6044906-----2400---ACEX06BT  PLCLOSEFISC     0000400017659----------KUALI TEST DESCRIPTION                  +00000000000001620.08D2006-12-22                                                 2006-12-222006-12-31000041.382007060001316908 000REGS12PAE 13 M001010207                     IU IUBLA"};
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[1]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[1])};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testInvalidFiscalYear() throws Exception {
        String[] inputTransactions = new String[]{"2026BA6044913-----2400---ACEX06BT  PLINVALFISC     0000500019196----------KUALI TEST DESCRIPTION                  +00000000000005106.15D2006-12-22                                                 2006-12-222006-12-31000104.932007060001368813 000REGS12PAE 19 M001010207                     IU IUBLA", "2026BA6044913-----2400---ACEX06BT  PLINVALFISC     0000600022120----------KUALI TEST DESCRIPTION                  +00000000000003071.10D2006-12-22                                                 2006-12-222006-12-31000106.752007060001773996 000REGS12PAE 12 M001010207                     IU IUBLA"};
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[1]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[1])};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testInvalid() throws Exception {
        String[] inputTransactions = new String[]{"2009  1031400-----2400---ACEX07BT  PLBLANKCHAR     0000100009529----------KUALI TEST DESCRIPTION                  +00000000000003493.50D2009-01-25                                                 2009-01-252009-01-31000184.002009070000149952 001REGS12PAE 11 M004013107                     IU IUBLA", "2009  1031400-----2400---ACEX07BT  PLBLANKCHAR     0000200014789----------KUALI TEST DESCRIPTION                  +00000000000003329.27D2009-01-25                                                 2009-01-252009-01-31000090.162009070000649044 000REGS12PAE 16 M004013107                     IU IUBLA"};
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[1]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[1])};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testInvalidDebitCreditCode() throws Exception {
        String[] inputTransactions = new String[]{"2009BA6044900-----2400---ACEX06BT  PLM01010207     0000100009529----------KUALI TEST DESCRIPTION                  +00000000000003493.50X2008-12-22                                                 2008-12-222008-12-31000168.002009060000149952 001REGS12PAE 11 M001010207                     IU IUBLA", "2009BA6044900-----2400---ACEX06BT  PLM01010207     0000100009529----------KUALI TEST DESCRIPTION                  +00000000000003495.50X2008-12-25                                                 2008-12-222008-12-31000168.002009060000149952 001REGS12PAE 11 M001010207                     IU IUBLA"};
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[1]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[1])};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testA2balanceTypeAcceptClosedFiscalPeriod() throws Exception {
        String[] inputTransactions = new String[]{"2008BL1031400-----5772---A2EX06ST  PLPRENC-07      00002MTFRING ----------KUALI TEST DESCRIPTION                  +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             "};
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[0])};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testValidateAccountWithAllParametersOff() throws Exception {
        TestUtils tu = new TestUtils();
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"ACCOUNTS_NOT_ACCEPTING_FRINGES_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"CONTINUATION_ACCOUNT_LOGIC_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUSPENSE_ACCOUNT_LOGIC_IND", (String)"N");
        String[] inputTransactions = new String[]{"2008BL2131401-----5772---ACEX08ST  PLPRENC-07      00002MTFRING ----------KUALI TEST DESCRIPTION                  +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             "};
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_expaccts", inputTransactions[0])};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testInvalidateAccountWithOnlyContinuationAccountOn() throws Exception {
        TestUtils tu = new TestUtils();
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"ACCOUNTS_NOT_ACCEPTING_FRINGES_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"CONTINUATION_ACCOUNT_LOGIC_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUSPENSE_ACCOUNT_LOGIC_IND", (String)"N");
        String[] inputTransactions = new String[]{"2008BL2131401-----5772---ACEX08ST  PLPRENC-07      00002MTFRING ----------AUTO FR BL2631476KUALI TEST DESCRIPTION +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             "};
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrberr1", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_expaccts", inputTransactions[0])};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testValidateAccountWithOnlyContinuationAccountOn() throws Exception {
        TestUtils tu = new TestUtils();
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"ACCOUNTS_NOT_ACCEPTING_FRINGES_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"CONTINUATION_ACCOUNT_LOGIC_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUSPENSE_ACCOUNT_LOGIC_IND", (String)"N");
        String[] inputTransactions = new String[]{"2008BL2131401-----5772---ACEX08ST  99PRENC-07      00002MTFRING ----------KUALI TEST DESCRIPTION                  +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             "};
        String expectedOutput = "2008BL2331489-----5772---ACEX08ST  99PRENC-07      00002MTFRING ----------AUTO FR BL2131401KUALI TEST DESCRIPTION +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             ";
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", expectedOutput), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_expaccts", expectedOutput)};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testNotSubfundWageExclusion() throws Exception {
        TestUtils tu = new TestUtils();
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"ACCOUNTS_NOT_ACCEPTING_FRINGES_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"CONTINUATION_ACCOUNT_LOGIC_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUSPENSE_ACCOUNT_LOGIC_IND", (String)"Y");
        String[] inputTransactions = new String[]{"2008BL2131401-----5772---ACEX08ST  99PRENC-07      00002MTFRING ----------KUALI TEST DESCRIPTION                  +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             "};
        String expectedOutput = "2008BL2331489-----5772---ACEX08ST  99PRENC-07      00002MTFRING ----------AUTO FR BL2131401KUALI TEST DESCRIPTION +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             ";
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", expectedOutput), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_expaccts", expectedOutput)};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testSubfundWageExclusion() throws Exception {
        TestUtils tu = new TestUtils();
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"ACCOUNTS_NOT_ACCEPTING_FRINGES_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"CONTINUATION_ACCOUNT_LOGIC_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUSPENSE_ACCOUNT_LOGIC_IND", (String)"Y");
        String[] inputTransactions = new String[]{"2008EA6867070-----5772---ACEX08ST  99PRENC-07      00002MTFRING ----------KUALI TEST DESCRIPTION                  +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             "};
        String expectedOutput = "2008UA6812756-----5772---ACEX08ST  99PRENC-07      00002MTFRING ----------KUALI TEST DESCRIPTION                  +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             ";
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", expectedOutput), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_expaccts", expectedOutput)};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testSubfundWageExclusionWithSubfundParameterOff() throws Exception {
        TestUtils tu = new TestUtils();
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"ACCOUNTS_NOT_ACCEPTING_FRINGES_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"CONTINUATION_ACCOUNT_LOGIC_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUSPENSE_ACCOUNT_LOGIC_IND", (String)"Y");
        String[] inputTransactions = new String[]{"2008UA6812756-----5772---ACEX08ST  99PRENC-07      00002MTFRING ----------KUALI TEST DESCRIPTION                  +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             "};
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[0])};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testNonFringeNonAltNonClosed() throws Exception {
        TestUtils tu = new TestUtils();
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"ACCOUNTS_NOT_ACCEPTING_FRINGES_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"CONTINUATION_ACCOUNT_LOGIC_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUSPENSE_ACCOUNT_LOGIC_IND", (String)"Y");
        String[] inputTransactions = new String[]{"2011UA6812757-----2000---ACEX06ST  LDNOWAGE1            00000001----------NO WAGE ACCOUNT                         +00000000000001000.00D2011-09-01                                                 2011-10-232011-08-090000000102011010001537923 01 RGNS12", "2011UA6812757-----5625---ACEX06ST  LDNOWAGE2            00000001----------NO WAGE ACCOUNT                         +00000000000000125.00D2011-09-01                                                 2011-10-232011-08-090000000102011010001537923 01 RGNS12", "2011EA0366595-----5625---ACEX06ST  LDNOFRINGE2          00000001----------NO FRINGE ACCOUNT                       +00000000000003500.00D2011-09-01                                                 2011-10-232011-08-090000000102011010001537923 01 RGNS12"};
        String[] expectedOutput = new String[]{"2011UA6812756-----2000---ACEX06ST  LDNOWAGE1       0000000000001----------NO WAGE ACCOUNT                         +00000000000001000.00D2011-09-01                                                 2011-10-232011-08-09       102011010001537923   1RGNS12", "2011UA6812756-----5625---ACEX06ST  LDNOWAGE2       0000000000001----------NO WAGE ACCOUNT                         +00000000000000125.00D2011-09-01                                                 2011-10-232011-08-09       102011010001537923   1RGNS12", "2011UA6612160-----5625---ACEX06ST  LDNOFRINGE2     0000000000001----------NO FRINGE ACCOUNT                       +00000000000003500.00D2011-09-01                                                 2011-10-232011-08-09       102011010001537923   1RGNS12"};
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[1]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[2]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", expectedOutput[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", expectedOutput[1]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", expectedOutput[2])};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testNonFringeNonAltNonClosedIndicatorWithSuspenseParameterOff() throws Exception {
    }

    public void testNonFringeNonAltNonClosedIndicatorWithFringeParameterOff() throws Exception {
        TestUtils tu = new TestUtils();
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"ACCOUNTS_NOT_ACCEPTING_FRINGES_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"CONTINUATION_ACCOUNT_LOGIC_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUSPENSE_ACCOUNT_LOGIC_IND", (String)"Y");
        String[] inputTransactions = new String[]{"2008BL2631476-----5760---ACEX08ST  99PRENC-07      00002MTFRING ----------KUALI TEST DESCRIPTION                  +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             "};
        String expectedOutput = "2008BL2331489-----5760---ACEX08ST  99PRENC-07      00002MTFRING ----------AUTO FR BL2631476KUALI TEST DESCRIPTION +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             ";
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_expaccts", expectedOutput), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", expectedOutput)};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testClosedAccountWithAllParemetersOff() throws Exception {
        TestUtils tu = new TestUtils();
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"ACCOUNTS_NOT_ACCEPTING_FRINGES_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"CONTINUATION_ACCOUNT_LOGIC_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUSPENSE_ACCOUNT_LOGIC_IND", (String)"N");
        String[] inputTransactions = new String[]{"2008EA6867070-----5760---ACEX08ST  99PRENC-07      00002MTFRING ----------KUALI TEST DESCRIPTION                  +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             "};
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_expaccts", inputTransactions[0])};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    public void testClosedAccountWithAllParemetersOffOnlyContinuationOn() throws Exception {
        TestUtils tu = new TestUtils();
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUB_FUND_GROUPS_NOT_ACCEPTING_WAGES_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"ACCOUNTS_NOT_ACCEPTING_FRINGES_IND", (String)"N");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"CONTINUATION_ACCOUNT_LOGIC_IND", (String)"Y");
        TestUtils.setSystemParameter(LaborScrubberStep.class, (String)"SUSPENSE_ACCOUNT_LOGIC_IND", (String)"N");
        String[] inputTransactions = new String[]{"2008EA6867070-----5760---ACEX08ST  99PRENC-07      00002MTFRING ----------KUALI TEST DESCRIPTION                  +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             "};
        String expectedOutput = "2008EA9567000-----5760---ACEX08ST  99PRENC-07      00002MTFRING ----------AUTO FR EA6867070KUALI TEST DESCRIPTION +00000000000028988.60C2008-12-14                                                D2008-12-14          000000.00200906-----------000             M037113006                             ";
        OriginEntryTestBase.EntryHolder[] outputTransactions = new OriginEntryTestBase.EntryHolder[]{new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_sortscrb", inputTransactions[0]), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_scrbout1", expectedOutput), new OriginEntryTestBase.EntryHolder((OriginEntryTestBase)this, "ld_expaccts", expectedOutput)};
        this.scrub(inputTransactions);
        this.assertOriginEntries(4, outputTransactions);
    }

    private void scrub(String[] inputTransactions) {
        this.clearBatchFiles();
        int count = 1;
        String[] stringArray = inputTransactions;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            LaborOriginEntry entry = new LaborOriginEntry();
            String transaction = stringArray[i];
            List messages = entry.setFromTextFileForBatch(transaction, count);
            if (messages.size() > 0) {
                LOG.warn((Object)("Transaction " + transaction + "could not be parsed correctly"));
                for (Message message : messages) {
                    LOG.warn((Object)message.getMessage());
                }
            }
            ++count;
        }
        this.loadInputTransactions("ld_sortscrb", inputTransactions);
        this.laborScrubberService.scrubEntries();
    }
}

