/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.kfs.gl.businessobject.OriginEntryGroup;
import org.kuali.kfs.gl.web.TestDataGenerator;
import org.kuali.kfs.kns.lookup.LookupableHelperService;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.PersistenceService;
import org.kuali.kfs.module.bc.businessobject.CalculatedSalaryFoundationTracker;
import org.kuali.kfs.module.ld.businessobject.AccountStatusBaseFunds;
import org.kuali.kfs.module.ld.service.LaborInquiryOptionsService;
import org.kuali.kfs.sys.ConfigureContext;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.kfs.sys.TestDataPreparator;
import org.kuali.kfs.sys.businessobject.lookup.LookupableSpringContext;
import org.kuali.kfs.sys.context.KualiTestBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.context.TestUtils;

@ConfigureContext
public class BaseFundsLookupableHelperServiceTest
extends KualiTestBase {
    private BusinessObjectService businessObjectService;
    private LookupableHelperService lookupableHelperService;
    private PersistenceService persistenceService;
    private Properties properties;
    private String fieldNames;
    private String deliminator;
    private OriginEntryGroup groupToPost;
    private Map fieldValues;
    private Map groupFieldValues;
    private int csfNumberOfTestData;
    private int csfExpectedInsertion;
    private int baseFundsNumberOfTestData;
    private int baseFundsExpectedInsertion;

    protected void setUp() throws Exception {
        super.setUp();
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.lookupableHelperService = LookupableSpringContext.getLookupableHelperService((String)"BaseFundsLookupableHelperService");
        this.lookupableHelperService.setBusinessObjectClass(AccountStatusBaseFunds.class);
        HashMap<String, String> keys = new HashMap<String, String>();
        keys.put("accountNumber", "1031400");
        keys.put("universityFiscalYear", TestUtils.getFiscalYearForTesting().toString());
        keys.put("chartOfAccountsCode", "BL");
        this.businessObjectService.deleteMatching(AccountStatusBaseFunds.class, keys);
        this.businessObjectService.deleteMatching(CalculatedSalaryFoundationTracker.class, keys);
    }

    public void testGetSearchResults() throws Exception {
        this.insertBaseFundsRecords();
        this.insertCSFRecords();
        System.out.println("**** RECORDS INSERTED !!!!!");
        String messageFileName = "org/kuali/kfs/module/ld/testdata/message.properties";
        String propertiesFileName = "org/kuali/kfs/module/ld/testdata/accountStatusBaseFunds.properties";
        this.properties = new TestDataGenerator(propertiesFileName, messageFileName).getProperties();
        this.fieldNames = this.properties.getProperty("fieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        this.properties = new TestDataGenerator(propertiesFileName, messageFileName).getProperties();
        AccountStatusBaseFunds accountStatusBaseFunds = new AccountStatusBaseFunds();
        accountStatusBaseFunds.setAccountNumber("1031400");
        accountStatusBaseFunds.setUniversityFiscalYear(TestUtils.getFiscalYearForTesting());
        accountStatusBaseFunds.setChartOfAccountsCode("BL");
        Map<String, String> fieldValues = this.buildFieldValues(accountStatusBaseFunds, this.getLookupFields(false));
        this.getInquiryOptionsService().getConsolidationField((Collection)this.lookupableHelperService.getRows()).setPropertyValue("Detail");
        fieldValues.put("dummyBusinessObject.consolidationOption", "Detail");
        List searchResults = this.lookupableHelperService.getSearchResults(fieldValues);
        for (AccountStatusBaseFunds accountStatusBaseFundsReturn : searchResults) {
            BaseFundsLookupableHelperServiceTest.assertTrue((accountStatusBaseFundsReturn.getAccountNumber().equals(accountStatusBaseFunds.getAccountNumber()) && accountStatusBaseFundsReturn.getUniversityFiscalYear().equals(accountStatusBaseFunds.getUniversityFiscalYear()) && accountStatusBaseFundsReturn.getChartOfAccountsCode().equals(accountStatusBaseFunds.getChartOfAccountsCode()) ? 1 : 0) != 0);
        }
        if (searchResults != null) {
            System.out.println("*** Results Size:" + searchResults.size());
        }
        BaseFundsLookupableHelperServiceTest.assertEquals((int)this.baseFundsExpectedInsertion, (int)searchResults.size());
        String testTarget = "getAccountStatusBaseFunds.";
        System.out.println("****1111");
        List expectedDataList = TestDataPreparator.buildExpectedValueList(AccountStatusBaseFunds.class, (Properties)this.properties, (String)(testTarget + "expected"), (String)this.fieldNames, (String)this.deliminator, (int)this.baseFundsExpectedInsertion);
        for (Object expectedAccountStatusBaseFundsAsObject : expectedDataList) {
            AccountStatusBaseFunds expectedAccountStatusBaseFunds = (AccountStatusBaseFunds)expectedAccountStatusBaseFundsAsObject;
            expectedAccountStatusBaseFunds.setUniversityFiscalYear(TestUtils.getFiscalYearForTesting());
        }
        System.out.println("****2222");
        for (int i = 0; i < searchResults.size(); ++i) {
            accountStatusBaseFunds = (AccountStatusBaseFunds)searchResults.get(i);
            System.out.println("*********DATA:" + accountStatusBaseFunds.toString());
            BaseFundsLookupableHelperServiceTest.assertTrue((boolean)expectedDataList.contains(accountStatusBaseFunds));
        }
        BaseFundsLookupableHelperServiceTest.assertEquals((int)this.baseFundsExpectedInsertion, (int)searchResults.size());
    }

    private Map<String, String> buildFieldValues(AccountStatusBaseFunds accountStatusBaseFunds, List<String> lookupFields) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Map tempFieldValues = ObjectUtil.buildPropertyMap((Object)accountStatusBaseFunds, lookupFields);
        for (String key : tempFieldValues.keySet()) {
            fieldValues.put(key, tempFieldValues.get(key).toString());
        }
        return fieldValues;
    }

    private List<String> getLookupFields(boolean isExtended) {
        ArrayList<String> lookupFields = new ArrayList<String>();
        lookupFields.add("universityFiscalYear");
        lookupFields.add("accountNumber");
        lookupFields.add("chartOfAccountsCode");
        return lookupFields;
    }

    protected void insertCSFRecords() {
        String messageFileName = "org/kuali/kfs/module/ld/testdata/message.properties";
        String propertiesFileName = "org/kuali/kfs/module/ld/testdata/csfTracker.properties";
        this.properties = new TestDataGenerator(propertiesFileName, messageFileName).getProperties();
        this.fieldNames = this.properties.getProperty("fieldNames");
        String documentFieldNames = this.properties.getProperty("fieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        TestDataGenerator testDataGenerator = new TestDataGenerator(propertiesFileName, messageFileName);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.persistenceService = (PersistenceService)SpringContext.getBean(PersistenceService.class);
        int numberOfDocuments = Integer.valueOf(this.properties.getProperty("getCSFTracker.numberOfDocuments"));
        ArrayList<CalculatedSalaryFoundationTracker> inputDataList = new ArrayList<CalculatedSalaryFoundationTracker>();
        for (int i = 1; i <= numberOfDocuments; ++i) {
            String propertyKey = "getCSFTracker.testData" + i;
            CalculatedSalaryFoundationTracker inputData = new CalculatedSalaryFoundationTracker();
            ObjectUtil.populateBusinessObject((Object)inputData, (Properties)this.properties, (String)propertyKey, (String)documentFieldNames, (String)this.deliminator);
            inputData.setUniversityFiscalYear(TestUtils.getFiscalYearForTesting());
            inputDataList.add(inputData);
        }
        String testTarget = "getCSFTracker.";
        this.csfNumberOfTestData = Integer.valueOf(this.properties.getProperty(testTarget + "numberOfDocuments"));
        this.csfExpectedInsertion = Integer.valueOf(this.properties.getProperty(testTarget + "expectedInsertion"));
        this.businessObjectService.save(inputDataList);
    }

    protected void insertBaseFundsRecords() {
        String testTarget = "getAccountStatusBaseFunds.";
        String messageFileName = "org/kuali/kfs/module/ld/testdata/message.properties";
        String propertiesFileName = "org/kuali/kfs/module/ld/testdata/accountStatusBaseFunds.properties";
        this.properties = new TestDataGenerator(propertiesFileName, messageFileName).getProperties();
        this.fieldNames = this.properties.getProperty("fieldNames");
        this.deliminator = this.properties.getProperty("deliminator");
        TestDataGenerator testDataGenerator = new TestDataGenerator(propertiesFileName, messageFileName);
        this.businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        this.persistenceService = (PersistenceService)SpringContext.getBean(PersistenceService.class);
        int numberOfData = Integer.valueOf(this.properties.getProperty(testTarget + "numOfData"));
        ArrayList<AccountStatusBaseFunds> inputDataList = new ArrayList<AccountStatusBaseFunds>();
        for (int i = 1; i <= numberOfData; ++i) {
            AccountStatusBaseFunds inputData = new AccountStatusBaseFunds();
            String propertyKey = testTarget + "testData" + i;
            ObjectUtil.populateBusinessObject((Object)inputData, (Properties)this.properties, (String)propertyKey, (String)this.fieldNames, (String)this.deliminator);
            inputData.setUniversityFiscalYear(TestUtils.getFiscalYearForTesting());
            inputDataList.add(inputData);
        }
        this.baseFundsNumberOfTestData = Integer.valueOf(this.properties.getProperty(testTarget + "numOfData"));
        this.baseFundsExpectedInsertion = Integer.valueOf(this.properties.getProperty(testTarget + "expectedNumOfData"));
        this.businessObjectService.save(inputDataList);
    }

    private LaborInquiryOptionsService getInquiryOptionsService() {
        return (LaborInquiryOptionsService)SpringContext.getBean(LaborInquiryOptionsService.class);
    }
}

