/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.module.ld.batch.service.DetectDocumentsMissingLaborPendingEntriesService;
import org.kuali.kfs.sys.batch.dataaccess.DetectDocumentsMissingPendingEntriesDao;
import org.kuali.kfs.sys.businessobject.DocumentHeaderData;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class DetectDocumentsMissingLaborPendingEntriesServiceImpl
implements DetectDocumentsMissingLaborPendingEntriesService {
    private static Logger LOG = Logger.getLogger(DetectDocumentsMissingLaborPendingEntriesServiceImpl.class);
    protected DetectDocumentsMissingPendingEntriesDao detectDocumentsMissingPendingEntriesDao;
    protected ParameterService parameterService;

    @Override
    public List<DocumentHeaderData> discoverLaborLedgerDocumentsWithoutPendingEntries(Date earliestProcessingDate) {
        LOG.debug((Object)"Running discoverLaborLedgerDocumentsWithoutPendingEntries");
        return this.detectDocumentsMissingPendingEntriesDao.discoverLedgerDocumentsWithoutPendingEntries(earliestProcessingDate, this.getSearchByDocumentTypes());
    }

    protected List<String> getSearchByDocumentTypes() {
        ArrayList<String> searchByDocumentTypes = new ArrayList<String>();
        Collection parameterDocumentTypesValues = this.parameterService.getParameterValuesAsString(KfsParameterConstants.LABOR_BATCH.class, "LEDGER_ENTRY_GENERATING_DOCUMENT_TYPES");
        if (!CollectionUtils.isEmpty((Collection)parameterDocumentTypesValues)) {
            searchByDocumentTypes.addAll(parameterDocumentTypesValues);
        }
        return searchByDocumentTypes;
    }

    public DetectDocumentsMissingPendingEntriesDao getDetectDocumentsMissingPendingEntriesDao() {
        return this.detectDocumentsMissingPendingEntriesDao;
    }

    public void setDetectDocumentsMissingPendingEntriesDao(DetectDocumentsMissingPendingEntriesDao detectDocumentsMissingPendingEntriesDao) {
        this.detectDocumentsMissingPendingEntriesDao = detectDocumentsMissingPendingEntriesDao;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

