/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.gl.businessobject.TransientBalanceInquiryAttributes;
import org.kuali.kfs.integration.ld.LaborLedgerObject;
import org.kuali.kfs.kns.lookup.AbstractLookupableHelperServiceImpl;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.BeanPropertyComparator;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.AccountStatusCurrentFunds;
import org.kuali.kfs.module.ld.businessobject.July1PositionFunding;
import org.kuali.kfs.module.ld.businessobject.LaborObject;
import org.kuali.kfs.module.ld.businessobject.LedgerBalance;
import org.kuali.kfs.module.ld.businessobject.inquiry.CurrentFundsInquirableImpl;
import org.kuali.kfs.module.ld.businessobject.inquiry.PositionDataDetailsInquirableImpl;
import org.kuali.kfs.module.ld.dataaccess.LaborDao;
import org.kuali.kfs.module.ld.service.LaborInquiryOptionsService;
import org.kuali.kfs.sys.ObjectUtil;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class CurrentFundsLookupableHelperServiceImpl
extends AbstractLookupableHelperServiceImpl {
    private static Logger LOG = Logger.getLogger(CurrentFundsLookupableHelperServiceImpl.class);
    private LaborDao laborDao;
    private LaborInquiryOptionsService laborInquiryOptionsService;
    private BusinessObjectService businessObjectService;

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        if ("positionNumber".equals(propertyName)) {
            LedgerBalance balance = (LedgerBalance)bo;
            PositionDataDetailsInquirableImpl positionDataDetailsInquirable = new PositionDataDetailsInquirableImpl();
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(propertyName, balance.getPositionNumber());
            BusinessObject positionData = positionDataDetailsInquirable.getBusinessObject(fieldValues);
            return positionData == null ? new HtmlData.AnchorHtmlData("", "") : positionDataDetailsInquirable.getInquiryUrl(positionData, propertyName);
        }
        return new CurrentFundsInquirableImpl().getInquiryUrl(bo, propertyName);
    }

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        LOG.info((Object)"getSearchResults() - Entry");
        boolean unbounded = false;
        Long actualCountIfTruncated = new Long(0L);
        this.setBackLocation(fieldValues.get("backLocation"));
        this.setDocFormKey(fieldValues.get("docFormKey"));
        String pendingEntryOption = this.laborInquiryOptionsService.getSelectedPendingEntryOption(fieldValues);
        boolean isConsolidated = this.laborInquiryOptionsService.isConsolidationSelected(fieldValues, this.getRows());
        String searchObjectCodeVal = fieldValues.get("financialObjectCode");
        if (StringUtils.isNotBlank((String)searchObjectCodeVal)) {
            HashMap<String, String> objectCodeFieldValues = new HashMap<String, String>();
            objectCodeFieldValues.put("universityFiscalYear", fieldValues.get("universityFiscalYear"));
            objectCodeFieldValues.put("chartOfAccountsCode", fieldValues.get("chartOfAccountsCode"));
            objectCodeFieldValues.put("financialObjectCode", searchObjectCodeVal);
            LaborLedgerObject foundObjectCode = (LaborLedgerObject)this.businessObjectService.findByPrimaryKey(LaborObject.class, objectCodeFieldValues);
            if (foundObjectCode == null) {
                GlobalVariables.getMessageMap().putError("financialObjectCode", "error.labor.invalidLaborObjectCodeError", new String[]{"2"});
                return new CollectionIncomplete(new ArrayList(), actualCountIfTruncated);
            }
        }
        Collection<AccountStatusCurrentFunds> searchResultsCollection = this.buildCurrentFundsCollection(IteratorUtils.toList((Iterator)this.laborDao.getCurrentFunds(fieldValues, isConsolidated)), isConsolidated, pendingEntryOption);
        this.laborInquiryOptionsService.updateCurrentFundsByPendingLedgerEntry(searchResultsCollection, fieldValues, pendingEntryOption, isConsolidated);
        Collection july1PositionFundings = this.laborDao.getJuly1(fieldValues);
        this.updateJuly1BalanceAmount(searchResultsCollection, july1PositionFundings, isConsolidated);
        List searchResults = (List)searchResultsCollection;
        List defaultSortColumns = this.getDefaultSortColumns();
        if (defaultSortColumns.size() > 0) {
            Collections.sort(searchResults, new BeanPropertyComparator(defaultSortColumns, true));
        }
        return new CollectionIncomplete((Collection)searchResults, actualCountIfTruncated);
    }

    private void updateJuly1BalanceAmount(Collection<AccountStatusCurrentFunds> searchResultsCollection, Collection<July1PositionFunding> july1PositionFundings, boolean isConsolidated) {
        for (July1PositionFunding july1PositionFunding : july1PositionFundings) {
            boolean flag = false;
            for (AccountStatusCurrentFunds accountStatus : searchResultsCollection) {
                boolean found = ObjectUtil.equals((Object)((Object)accountStatus), (Object)((Object)july1PositionFunding), accountStatus.getKeyFieldList(isConsolidated));
                if (!found) continue;
                flag = true;
                accountStatus.setJuly1BudgetAmount((KualiDecimal)accountStatus.getJuly1BudgetAmount().add((AbstractKualiDecimal)july1PositionFunding.getJuly1BudgetAmount()));
            }
            if (flag) continue;
            AccountStatusCurrentFunds accountStatus = new AccountStatusCurrentFunds();
            ObjectUtil.buildObject((Object)((Object)accountStatus), (Object)((Object)july1PositionFunding), accountStatus.getKeyFieldList(isConsolidated));
            accountStatus.setJuly1BudgetAmount(july1PositionFunding.getJuly1BudgetAmount());
            accountStatus.setVariance(july1PositionFunding.getJuly1BudgetAmount());
            if (isConsolidated) {
                accountStatus.setSubAccountNumber("*ALL*");
                accountStatus.setFinancialSubObjectCode("*ALL*");
            } else {
                accountStatus.setSubAccountNumber(july1PositionFunding.getSubAccountNumber());
                accountStatus.setSubObjectCode(july1PositionFunding.getSubObjectCode());
            }
            searchResultsCollection.add(accountStatus);
        }
    }

    private Collection<AccountStatusCurrentFunds> buildCurrentFundsCollection(Collection collection, boolean isConsolidated, String pendingEntryOption) {
        Collection<AccountStatusCurrentFunds> retval = null;
        retval = isConsolidated ? this.buildCosolidatedCurrentFundsCollection(collection, pendingEntryOption) : this.buildDetailedCurrentFundsCollection(collection, pendingEntryOption);
        return retval;
    }

    private Collection<AccountStatusCurrentFunds> buildCosolidatedCurrentFundsCollection(Collection collection, String pendingEntryOption) {
        ArrayList<AccountStatusCurrentFunds> retval = new ArrayList<AccountStatusCurrentFunds>();
        for (Object collectionEntry : collection) {
            if (!collectionEntry.getClass().isArray()) continue;
            int i = 0;
            Object[] array = (Object[])collectionEntry;
            AccountStatusCurrentFunds cf = new AccountStatusCurrentFunds();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("element length " + array.length));
            }
            for (Object element : array) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("I found this element " + element));
            }
            if (AccountStatusCurrentFunds.class.isAssignableFrom(this.getBusinessObjectClass())) {
                try {
                    cf = (AccountStatusCurrentFunds)((Object)this.getBusinessObjectClass().newInstance());
                }
                catch (Exception e) {
                    LOG.warn((Object)("Using " + AccountStatusCurrentFunds.class + " for results because I couldn't instantiate the " + this.getBusinessObjectClass()));
                }
            } else {
                LOG.warn((Object)("Using " + AccountStatusCurrentFunds.class + " for results because I couldn't instantiate the " + this.getBusinessObjectClass()));
            }
            cf.setUniversityFiscalYear(new Integer(array[i++].toString()));
            cf.setChartOfAccountsCode(array[i++].toString());
            cf.setAccountNumber(array[i++].toString());
            String subAccountNumber = "*ALL*";
            cf.setSubAccountNumber(subAccountNumber);
            cf.setBalanceTypeCode(array[i++].toString());
            cf.setFinancialObjectCode(array[i++].toString());
            cf.setEmplid(array[i++].toString());
            cf.setPositionNumber(array[i++].toString());
            cf.setFinancialSubObjectCode("*ALL*");
            cf.setObjectTypeCode("*ALL*");
            cf.setAccountLineAnnualBalanceAmount(new KualiDecimal(array[i++].toString()));
            cf.setBeginningBalanceLineAmount(new KualiDecimal(array[i++].toString()));
            cf.setContractsGrantsBeginningBalanceAmount(new KualiDecimal(array[i++].toString()));
            cf.setMonth1Amount(new KualiDecimal(array[i++].toString()));
            cf.setDummyBusinessObject(new TransientBalanceInquiryAttributes());
            cf.getDummyBusinessObject().setPendingEntryOption(pendingEntryOption);
            cf.setOutstandingEncum(this.getOutstandingEncum(cf));
            cf.getDummyBusinessObject().setPendingEntryOption(pendingEntryOption);
            cf.getDummyBusinessObject().setConsolidationOption("Consolidation");
            retval.add(cf);
        }
        return retval;
    }

    private Collection<AccountStatusCurrentFunds> buildDetailedCurrentFundsCollection(Collection collection, String pendingEntryOption) {
        ArrayList<AccountStatusCurrentFunds> retval = new ArrayList<AccountStatusCurrentFunds>();
        for (LedgerBalance balance : collection) {
            AccountStatusCurrentFunds cf = new AccountStatusCurrentFunds();
            ObjectUtil.buildObject((Object)((Object)cf), (Object)((Object)balance));
            cf.setDummyBusinessObject(new TransientBalanceInquiryAttributes());
            cf.getDummyBusinessObject().setPendingEntryOption(pendingEntryOption);
            cf.setOutstandingEncum(this.getOutstandingEncum(cf));
            cf.getDummyBusinessObject().setPendingEntryOption(pendingEntryOption);
            cf.getDummyBusinessObject().setConsolidationOption("Detail");
            retval.add(cf);
        }
        return retval;
    }

    private KualiDecimal getOutstandingEncum(AccountStatusCurrentFunds bo) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("universityFiscalYear", bo.getUniversityFiscalYear().toString());
        fieldValues.put("chartOfAccountsCode", bo.getChartOfAccountsCode());
        fieldValues.put("accountNumber", bo.getAccountNumber());
        if (!bo.getSubAccountNumber().equals("*ALL*")) {
            fieldValues.put("subAccountNumber", bo.getSubAccountNumber());
        }
        fieldValues.put("financialObjectCode", bo.getFinancialObjectCode());
        if (!bo.getFinancialSubObjectCode().equals("*ALL*")) {
            fieldValues.put("financialSubObjectCode", bo.getFinancialSubObjectCode());
        }
        fieldValues.put("financialBalanceTypeCode", "IE");
        fieldValues.put("emplid", bo.getEmplid());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("using " + fieldValues.values()));
            LOG.debug((Object)("using " + fieldValues.keySet()));
        }
        return (KualiDecimal)this.laborDao.getEncumbranceTotal(fieldValues);
    }

    public void setLaborDao(LaborDao laborDao) {
        this.laborDao = laborDao;
    }

    public void setLaborInquiryOptionsService(LaborInquiryOptionsService laborInquiryOptionsService) {
        this.laborInquiryOptionsService = laborInquiryOptionsService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

