/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.service.impl;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LaborLedgerPendingEntry;
import org.kuali.kfs.module.ld.document.service.impl.LaborPendingEntryConverterServiceImpl;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

@RunWith(value=PowerMockRunner.class)
public class LaborPendingEntryConverterServiceImplTest {
    protected LaborPendingEntryConverterServiceImpl laborPendingEntryConverterService;
    protected ParameterService parameterService;
    protected DataDictionaryService dataDictionaryService;

    @Before
    public void setUp() {
        this.parameterService = (ParameterService)EasyMock.createMock(ParameterService.class);
        this.dataDictionaryService = (DataDictionaryService)EasyMock.createMock(DataDictionaryService.class);
        this.laborPendingEntryConverterService = new LaborPendingEntryConverterServiceImpl();
        this.laborPendingEntryConverterService.setParameterService(this.parameterService);
    }

    @Test
    public void testCopySubObjectToBenefitEntriesEnabled() {
        EasyMock.expect((Object)this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.LABOR_DOCUMENT.class, "COPY_SUB_OBJECT_TO_BENEFIT_ENTRIES_IND", Boolean.valueOf(false))).andReturn((Object)true).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.parameterService});
        String subcode = "FOO";
        ExpenseTransferSourceAccountingLine sourceLine = new ExpenseTransferSourceAccountingLine();
        sourceLine.setFinancialSubObjectCode(subcode);
        LaborLedgerPendingEntry pendingEntry = new LaborLedgerPendingEntry();
        Assert.assertNull((Object)pendingEntry.getFinancialSubObjectCode());
        this.laborPendingEntryConverterService.setSubobjectCodeOnBenefitPendingEntry((ExpenseTransferAccountingLine)sourceLine, pendingEntry);
        Assert.assertEquals((Object)subcode, (Object)pendingEntry.getFinancialSubObjectCode());
    }

    @Test
    @PrepareForTest(value={SpringContext.class})
    public void testCopySubObjectToBenefitEntriesDisabled() {
        PowerMock.mockStatic(SpringContext.class);
        EasyMock.expect((Object)SpringContext.getBean(DataDictionaryService.class)).andReturn((Object)this.dataDictionaryService).anyTimes();
        EasyMock.expect((Object)this.parameterService.getParameterValueAsBoolean(KfsParameterConstants.LABOR_DOCUMENT.class, "COPY_SUB_OBJECT_TO_BENEFIT_ENTRIES_IND", Boolean.valueOf(false))).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)this.dataDictionaryService.getAttributeMaxLength(OriginEntryFull.class, "financialSubObjectCode")).andReturn((Object)10).anyTimes();
        PowerMock.replay((Object[])new Object[]{SpringContext.class});
        EasyMock.replay((Object[])new Object[]{this.parameterService, this.dataDictionaryService});
        ExpenseTransferSourceAccountingLine sourceLine = new ExpenseTransferSourceAccountingLine();
        sourceLine.setFinancialSubObjectCode("FOO");
        LaborLedgerPendingEntry pendingEntry = new LaborLedgerPendingEntry();
        Assert.assertNull((Object)pendingEntry.getFinancialSubObjectCode());
        this.laborPendingEntryConverterService.setSubobjectCodeOnBenefitPendingEntry((ExpenseTransferAccountingLine)sourceLine, pendingEntry);
        Assert.assertEquals((Object)KFSConstants.getDashFinancialSubObjectCode(), (Object)pendingEntry.getFinancialSubObjectCode());
    }
}

