/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.coa.businessobject.A21SubAccount;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.SubAccount;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ec.EffortCertificationModuleService;
import org.kuali.kfs.integration.ec.EffortCertificationReport;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferTargetAccountingLine;
import org.kuali.kfs.module.ld.businessobject.LaborObject;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.service.impl.SalaryTransferPeriodValidationServiceImpl;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class SalaryTransferPeriodValidationServiceImplTest {
    private static final int FISCAL_YEAR = 2009;
    private static final String ACCOUNT_NUMBER = "1031400";
    private static final String CHART = "BL";
    private static final String EMPLID = "12345";
    private static final String PERIOD_CODE = "02";
    private static final String REPORT_NUMBER = "1";
    private SalaryTransferPeriodValidationServiceImpl cut;
    @Mock
    private Account accountMock;
    @Mock
    private EffortCertificationModuleService effortCertificationSvcMock;
    @Mock
    private EffortCertificationReport effortCertificationReportMock;
    @Mock
    private ExpenseTransferAccountingLine transferLineMock;
    @Mock
    private ParameterService parameterSvcMock;
    @Mock
    private SalaryExpenseTransferDocument document;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        GlobalVariables.getMessageMap().getErrorMessages().clear();
        Mockito.when((Object)this.document.getEmplid()).thenReturn((Object)EMPLID);
        this.setupAccountAndTransferLineMocks();
        this.setupEffortCertificationSvcMock();
        this.setupReportMock(this.effortCertificationReportMock);
        this.cut = new SalaryTransferPeriodValidationServiceImpl();
        this.cut.setEffortCertificationService(this.effortCertificationSvcMock);
        this.cut.setParameterService(this.parameterSvcMock);
    }

    private void setupAccountAndTransferLineMocks() {
        Mockito.when((Object)this.accountMock.getChartOfAccountsCode()).thenReturn((Object)CHART);
        Mockito.when((Object)this.accountMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)this.transferLineMock.getAccount()).thenReturn((Object)this.accountMock);
        Mockito.when((Object)this.transferLineMock.getChartOfAccountsCode()).thenReturn((Object)CHART);
        Mockito.when((Object)this.transferLineMock.getAccountNumber()).thenReturn((Object)ACCOUNT_NUMBER);
        Mockito.when((Object)this.transferLineMock.getLaborObject()).thenReturn(Mockito.mock(LaborObject.class));
        Mockito.when((Object)this.transferLineMock.getAmount()).thenReturn((Object)new KualiDecimal(100));
        Mockito.when((Object)this.transferLineMock.getPayrollEndDateFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)this.transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn((Object)PERIOD_CODE);
    }

    private void setupEffortCertificationSvcMock() {
        ArrayList<EffortCertificationReport> reportDefinitions = new ArrayList<EffortCertificationReport>();
        reportDefinitions.add(this.effortCertificationReportMock);
        Mockito.when((Object)this.effortCertificationSvcMock.findReportDefinitionsForPeriod(Integer.valueOf(2009), PERIOD_CODE, null)).thenReturn(reportDefinitions);
        Mockito.when((Object)this.effortCertificationSvcMock.getCostShareSubAccountTypeCodes()).thenReturn(Collections.singletonList("CS"));
    }

    private void setupReportMock(EffortCertificationReport effortCertificationReportMock) {
        Mockito.when((Object)effortCertificationReportMock.getUniversityFiscalYear()).thenReturn((Object)2009);
        Mockito.when((Object)effortCertificationReportMock.getEffortCertificationReportNumber()).thenReturn((Object)REPORT_NUMBER);
    }

    @Test
    public void validateTransfers_NoAccountingLines_VALID() {
        Assert.assertTrue((boolean)this.cut.validateTransfers(this.document));
    }

    @Test
    public void validateTransfers_HasAccountingLines_WithoutNecessaryData_VALID() {
        Mockito.when((Object)this.document.getSourceAccountingLines()).thenReturn(Collections.singletonList(Mockito.mock(ExpenseTransferSourceAccountingLine.class)));
        Mockito.when((Object)this.document.getTargetAccountingLines()).thenReturn(Collections.singletonList(Mockito.mock(ExpenseTransferTargetAccountingLine.class)));
        Assert.assertTrue((boolean)this.cut.validateTransfers(this.document));
    }

    @Test
    public void validateTransfers_ClosedEffortCertReport_INVALID() {
        Mockito.when((Object)this.effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"C");
        Mockito.when((Object)this.document.getSourceAccountingLines()).thenReturn(Collections.singletonList(this.transferLineMock));
        Assert.assertFalse((boolean)this.cut.validateTransfers(this.document));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("targetAccountingLines");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.labor.effortReportPeriodClosed", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assert.assertEquals((long)3L, (long)messageParameters.length);
        Assert.assertEquals((Object)"2009-1", (Object)messageParameters[0]);
        Assert.assertEquals((Object)String.valueOf(2009), (Object)messageParameters[1]);
        Assert.assertEquals((Object)PERIOD_CODE, (Object)messageParameters[2]);
    }

    @Test
    public void validateTransfers_OpenEffortCertReport_VALID() {
        Mockito.when((Object)this.effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        Mockito.when((Object)this.document.getSourceAccountingLines()).thenReturn(Collections.singletonList(this.transferLineMock));
        Assert.assertTrue((boolean)this.cut.validateTransfers(this.document));
    }

    @Test
    public void validateTransfers_EmployeeHasReport_NonCostShareSubAccount_VALID() {
        Mockito.when((Object)this.effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        Mockito.when((Object)this.effortCertificationSvcMock.isEmployeeWithOpenCertification(ArgumentMatchers.anyList(), ArgumentMatchers.anyString())).thenReturn(Mockito.mock(EffortCertificationReport.class));
        Mockito.when((Object)this.transferLineMock.getAmount()).thenReturn((Object)KualiDecimal.ZERO);
        Mockito.when((Object)this.document.getSourceAccountingLines()).thenReturn(Collections.singletonList(this.transferLineMock));
        Assert.assertTrue((boolean)this.cut.validateTransfers(this.document));
    }

    @Test
    public void validateTransfers_EmployeeHasReport_CostShareSubAccount_INVALID() {
        Mockito.when((Object)this.effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        EffortCertificationReport anotherEffortCertificationReportMock = (EffortCertificationReport)Mockito.mock(EffortCertificationReport.class);
        this.setupReportMock(anotherEffortCertificationReportMock);
        Mockito.when((Object)this.effortCertificationSvcMock.isEmployeeWithOpenCertification(ArgumentMatchers.anyList(), ArgumentMatchers.anyString())).thenReturn((Object)anotherEffortCertificationReportMock);
        A21SubAccount a21SubAccountMock = (A21SubAccount)Mockito.mock(A21SubAccount.class);
        Mockito.when((Object)a21SubAccountMock.getSubAccountTypeCode()).thenReturn((Object)"CS");
        SubAccount subAccountMock = (SubAccount)Mockito.mock(SubAccount.class);
        Mockito.when((Object)subAccountMock.getA21SubAccount()).thenReturn((Object)a21SubAccountMock);
        Mockito.when((Object)this.transferLineMock.getSubAccount()).thenReturn((Object)subAccountMock);
        Mockito.when((Object)this.document.getSourceAccountingLines()).thenReturn(Collections.singletonList(this.transferLineMock));
        Assert.assertFalse((boolean)this.cut.validateTransfers(this.document));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("targetAccountingLines");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.labor.effortOpenPeriodCostShare", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assert.assertEquals((long)3L, (long)messageParameters.length);
        Assert.assertEquals((Object)"2009-1", (Object)messageParameters[0]);
        Assert.assertEquals((Object)String.valueOf(2009), (Object)messageParameters[1]);
        Assert.assertEquals((Object)PERIOD_CODE, (Object)messageParameters[2]);
    }

    @Test
    public void validateTransfers_NoEmployeeReport_NonFederalCgAccount_FederalOnlyBalancesTrue_VALID() {
        Mockito.when((Object)this.effortCertificationSvcMock.isFederalOnlyBalanceIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.accountMock.isForContractsAndGrants()).thenReturn((Object)true);
        Mockito.when((Object)this.effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        Mockito.when((Object)this.document.getSourceAccountingLines()).thenReturn(Collections.singletonList(this.transferLineMock));
        Assert.assertTrue((boolean)this.cut.validateTransfers(this.document));
    }

    @Test
    public void validateTransfers_NoEmployeeReport_NonFederalCgAccount_FederalOnlyBalancesFalse_INVALID() {
        Mockito.when((Object)this.accountMock.isForContractsAndGrants()).thenReturn((Object)true);
        Mockito.when((Object)this.effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        Mockito.when((Object)this.document.getSourceAccountingLines()).thenReturn(Collections.singletonList(this.transferLineMock));
        Assert.assertFalse((boolean)this.cut.validateTransfers(this.document));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("targetAccountingLines");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.labor.effortOpernPeriodCGAccount", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assert.assertEquals((long)3L, (long)messageParameters.length);
        Assert.assertEquals((Object)"2009-1", (Object)messageParameters[0]);
        Assert.assertEquals((Object)String.valueOf(2009), (Object)messageParameters[1]);
        Assert.assertEquals((Object)PERIOD_CODE, (Object)messageParameters[2]);
    }

    @Test
    public void validateTransfers_NoEmployeeReport_FederaCgAccount_FederalOnlyBalancesTrue_INVALID() {
        Mockito.when((Object)this.effortCertificationSvcMock.isFederalOnlyBalanceIndicator()).thenReturn((Object)true);
        Mockito.when((Object)this.accountMock.isAwardedByFederalAgency(ArgumentMatchers.anyCollection())).thenReturn((Object)true);
        Mockito.when((Object)this.effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        Mockito.when((Object)this.document.getSourceAccountingLines()).thenReturn(Collections.singletonList(this.transferLineMock));
        Assert.assertFalse((boolean)this.cut.validateTransfers(this.document));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("targetAccountingLines");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.labor.effortOpernPeriodCGAccount", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assert.assertEquals((long)3L, (long)messageParameters.length);
        Assert.assertEquals((Object)"2009-1", (Object)messageParameters[0]);
        Assert.assertEquals((Object)String.valueOf(2009), (Object)messageParameters[1]);
        Assert.assertEquals((Object)PERIOD_CODE, (Object)messageParameters[2]);
    }

    @Test
    public void validateTransfers_EmployeeHasReport_NonCostShareSubAccount_OutOfBalance_INVALID() {
        Mockito.when((Object)this.effortCertificationReportMock.getEffortCertificationReportPeriodStatusCode()).thenReturn((Object)"O");
        EffortCertificationReport anotherEffortCertificationReportMock = (EffortCertificationReport)Mockito.mock(EffortCertificationReport.class);
        this.setupReportMock(anotherEffortCertificationReportMock);
        Mockito.when((Object)this.effortCertificationSvcMock.isEmployeeWithOpenCertification(ArgumentMatchers.anyList(), ArgumentMatchers.anyString())).thenReturn((Object)anotherEffortCertificationReportMock);
        Mockito.when((Object)this.document.getSourceAccountingLines()).thenReturn(Collections.singletonList(this.transferLineMock));
        Assert.assertFalse((boolean)this.cut.validateTransfers(this.document));
        Assert.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
        List errorMessages = (List)GlobalVariables.getMessageMap().getErrorMessages().get("sourceAccountingLines");
        Assert.assertEquals((long)1L, (long)errorMessages.size());
        ErrorMessage errorMessage = (ErrorMessage)errorMessages.get(0);
        Assert.assertEquals((Object)"error.labor.effortOpenPeriodAccountNonBalanced", (Object)errorMessage.getErrorKey());
        String[] messageParameters = errorMessage.getMessageParameters();
        Assert.assertEquals((long)3L, (long)messageParameters.length);
        Assert.assertEquals((Object)"2009-1", (Object)messageParameters[0]);
        Assert.assertEquals((Object)String.valueOf(2009), (Object)messageParameters[1]);
        Assert.assertEquals((Object)PERIOD_CODE, (Object)messageParameters[2]);
    }

    @Test
    public void containsNecessaryData_ContainsAllData_VALID() {
        Assert.assertTrue((boolean)this.cut.containsNecessaryData(this.transferLineMock));
    }

    @Test
    public void containsNecessaryData_NoAccount_INVALID() {
        Mockito.when((Object)this.transferLineMock.getAccount()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.containsNecessaryData(this.transferLineMock));
    }

    @Test
    public void containsNecessaryData_NoLaborObject_INVALID() {
        Mockito.when((Object)this.transferLineMock.getLaborObject()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.containsNecessaryData(this.transferLineMock));
    }

    @Test
    public void containsNecessaryData_NoAmount_INVALID() {
        Mockito.when((Object)this.transferLineMock.getAmount()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.containsNecessaryData(this.transferLineMock));
    }

    @Test
    public void containsNecessaryData_NoPayrollEndDateFiscalYear_INVALID() {
        Mockito.when((Object)this.transferLineMock.getPayrollEndDateFiscalYear()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.containsNecessaryData(this.transferLineMock));
    }

    @Test
    public void containsNecessaryData_NoPayrollEndDateFiscalPeriodCode_INVALID() {
        Mockito.when((Object)this.transferLineMock.getPayrollEndDateFiscalPeriodCode()).thenReturn(null);
        Assert.assertFalse((boolean)this.cut.containsNecessaryData(this.transferLineMock));
    }
}

