/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.batch.service.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.gl.batch.dataaccess.ReconciliationDao;
import org.kuali.kfs.gl.batch.service.impl.ColumnReconciliation;
import org.kuali.kfs.gl.batch.service.impl.ReconciliationBlock;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.gl.exception.LoadException;
import org.kuali.kfs.module.ld.batch.service.ReconciliationService;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.sys.Message;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.core.api.util.type.TypeUtils;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ReconciliationServiceImpl
implements ReconciliationService {
    private static final Logger LOG = LogManager.getLogger(ReconciliationServiceImpl.class);
    private ReconciliationDao reconciliationDao;
    private Class<? extends OriginEntryFull> originEntryClass;

    @Override
    public void reconcile(Iterator<LaborOriginEntry> entries, ReconciliationBlock reconBlock, List<Message> errorMessages) {
        List columns = reconBlock.getColumns();
        int numEntriesSuccessfullyLoaded = 0;
        int numEntriesAttemptedToLoad = 1;
        List<JavaAttributeAugmentedColumnReconciliation> javaAttributeNames = this.resolveJavaAttributeNames(columns);
        KualiDecimal[] columnSums = this.createColumnSumsArray(columns.size());
        boolean entriesFullyIterated = false;
        boolean loadExceptionEncountered = false;
        while (!entriesFullyIterated) {
            try {
                while (entries.hasNext()) {
                    ++numEntriesAttemptedToLoad;
                    OriginEntryFull entry = entries.next();
                    for (int c = 0; c < columns.size(); ++c) {
                        KualiDecimal columnValue = KualiDecimal.ZERO;
                        for (int f = 0; f < javaAttributeNames.get(c).size(); ++f) {
                            String javaAttributeName = javaAttributeNames.get(c).getJavaAttributeName(f);
                            Object fieldValue = entry.getFieldValue(javaAttributeName);
                            if (fieldValue == null) continue;
                            if (TypeUtils.isIntegralClass(fieldValue.getClass()) || TypeUtils.isDecimalClass(fieldValue.getClass())) {
                                KualiDecimal castValue = fieldValue instanceof KualiDecimal ? (KualiDecimal)fieldValue : new KualiDecimal(fieldValue.toString());
                                columnValue = (KualiDecimal)columnValue.add((AbstractKualiDecimal)castValue);
                                continue;
                            }
                            throw new LoadException("The value for " + ((ColumnReconciliation)columns.get(c)).getTokenizedFieldNames()[f] + " is not a numeric value.");
                        }
                        columnSums[c] = (KualiDecimal)columnSums[c].add((AbstractKualiDecimal)columnValue);
                    }
                    ++numEntriesSuccessfullyLoaded;
                }
            }
            catch (LoadException e) {
                loadExceptionEncountered = true;
                LOG.error("Line " + numEntriesAttemptedToLoad + " parse error: " + e.getMessage(), (Throwable)e);
                Message newMessage = new Message("Line " + numEntriesAttemptedToLoad + " parse error: " + e.getMessage(), 1);
                errorMessages.add(newMessage);
                ++numEntriesAttemptedToLoad;
                continue;
            }
            catch (Exception e) {
                LOG.error("Error encountered trying to iterate through origin entry iterator", (Throwable)e);
                Message newMessage = new Message(e.getMessage(), 1);
                errorMessages.add(newMessage);
                break;
            }
            entriesFullyIterated = true;
        }
        if (entriesFullyIterated) {
            Message newMessage;
            if (loadExceptionEncountered) {
                LOG.error("Reconciliation check failed because some origin entry lines could not be parsed.");
                newMessage = new Message("Reconciliation check failed because some origin entry lines could not be parsed.", 1);
                errorMessages.add(newMessage);
            } else {
                if (numEntriesSuccessfullyLoaded != reconBlock.getRowCount()) {
                    newMessage = this.generateRowCountMismatchMessage(reconBlock, numEntriesSuccessfullyLoaded);
                    errorMessages.add(newMessage);
                }
                for (int i = 0; i < columns.size(); ++i) {
                    if (columnSums[i].equals((Object)((ColumnReconciliation)columns.get(i)).getDollarAmount())) continue;
                    Message newMessage2 = this.generateColumnSumErrorMessage((ColumnReconciliation)columns.get(i), columnSums[i]);
                    errorMessages.add(newMessage2);
                }
            }
        }
    }

    protected Message generateColumnSumErrorMessage(ColumnReconciliation column, KualiDecimal actualValue) {
        StringBuilder buf = new StringBuilder();
        buf.append("Reconciliation failed for field value(s) \"");
        buf.append(column.getFieldName());
        buf.append("\", expected ");
        buf.append(column.getDollarAmount());
        buf.append(", found value ");
        buf.append(actualValue);
        buf.append(".");
        Message newMessage = new Message(buf.toString(), 1);
        return newMessage;
    }

    protected Message generateRowCountMismatchMessage(ReconciliationBlock block, int actualRowCount) {
        StringBuilder buf = new StringBuilder();
        buf.append("Reconciliation failed because an incorrect number of origin entry rows were successfully parsed.  Expected ");
        buf.append(block.getRowCount());
        buf.append(" row(s), parsed ");
        buf.append(actualRowCount);
        buf.append(" row(s).");
        Message newMessage = new Message(buf.toString(), 1);
        return newMessage;
    }

    protected boolean performSanityChecks(List<ColumnReconciliation> columns, List<JavaAttributeAugmentedColumnReconciliation> javaAttributeNames, KualiDecimal[] columnSums, List<Message> errorMessages) {
        boolean success = true;
        if (javaAttributeNames.size() != columnSums.length || javaAttributeNames.size() != columns.size()) {
            errorMessages.add(new Message("Reconciliation error: Sizes of lists do not match", 1));
            success = false;
        }
        for (int i = 0; i < columns.size(); ++i) {
            if (columns.get(i).getTokenizedFieldNames().length != javaAttributeNames.get(i).size()) {
                errorMessages.add(new Message("Reconciliation error: Error tokenizing column elements.  The number of database fields and java fields do not match.", 1));
                success = false;
            }
            int fieldIdx = 0;
            while (fieldIdx < javaAttributeNames.get(i).size()) {
                if (StringUtils.isBlank((CharSequence)javaAttributeNames.get(i).getJavaAttributeName(fieldIdx))) {
                    errorMessages.add(new Message("Reconciliation error: javaAttributeName is blank for DB column: " + columns.get(i).getTokenizedFieldNames()[fieldIdx], 1));
                    success = false;
                }
                ++i;
            }
        }
        return success;
    }

    protected KualiDecimal[] createColumnSumsArray(int size) {
        KualiDecimal[] array = new KualiDecimal[size];
        for (int i = 0; i < array.length; ++i) {
            array[i] = KualiDecimal.ZERO;
        }
        return array;
    }

    protected List<JavaAttributeAugmentedColumnReconciliation> resolveJavaAttributeNames(List<ColumnReconciliation> columns) {
        ArrayList<JavaAttributeAugmentedColumnReconciliation> attributes = new ArrayList<JavaAttributeAugmentedColumnReconciliation>();
        for (ColumnReconciliation column : columns) {
            JavaAttributeAugmentedColumnReconciliation c = new JavaAttributeAugmentedColumnReconciliation();
            c.setColumnReconciliation(column);
            c.setJavaAttributeNames(this.reconciliationDao.convertDBColumnNamesToJavaName(this.getOriginEntryClass(), column.getTokenizedFieldNames(), true));
            attributes.add(c);
        }
        return attributes;
    }

    protected ReconciliationDao getReconciliationDao() {
        return this.reconciliationDao;
    }

    public void setReconciliationDao(ReconciliationDao reconciliationDao) {
        this.reconciliationDao = reconciliationDao;
    }

    protected Class<? extends OriginEntryFull> getOriginEntryClass() {
        return this.originEntryClass;
    }

    public void setOriginEntryClass(Class<? extends OriginEntryFull> originEntryClass) {
        this.originEntryClass = originEntryClass;
    }

    protected class JavaAttributeAugmentedColumnReconciliation {
        protected ColumnReconciliation columnReconciliation = null;
        protected List<String> javaAttributeNames = null;

        protected JavaAttributeAugmentedColumnReconciliation() {
        }

        protected ColumnReconciliation getColumnReconciliation() {
            return this.columnReconciliation;
        }

        protected void setColumnReconciliation(ColumnReconciliation columnReconciliation) {
            this.columnReconciliation = columnReconciliation;
        }

        protected void setJavaAttributeNames(List<String> javaAttributeNames) {
            this.javaAttributeNames = javaAttributeNames;
        }

        protected String getJavaAttributeName(int index) {
            return this.javaAttributeNames.get(index);
        }

        protected int size() {
            return this.javaAttributeNames.size();
        }
    }
}

