/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.service.impl;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.gl.businessobject.CorrectionChangeGroup;
import org.kuali.kfs.gl.businessobject.OriginEntryFull;
import org.kuali.kfs.gl.businessobject.OriginEntryStatistics;
import org.kuali.kfs.gl.dataaccess.CorrectionChangeDao;
import org.kuali.kfs.gl.dataaccess.CorrectionChangeGroupDao;
import org.kuali.kfs.gl.dataaccess.CorrectionCriteriaDao;
import org.kuali.kfs.gl.document.CorrectionDocumentUtils;
import org.kuali.kfs.gl.document.GeneralLedgerCorrectionProcessDocument;
import org.kuali.kfs.gl.document.service.impl.CorrectionDocumentServiceImpl;
import org.kuali.kfs.gl.document.web.CorrectionDocumentEntryMetadata;
import org.kuali.kfs.gl.report.CorrectionDocumentReport;
import org.kuali.kfs.gl.service.OriginEntryGroupService;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.krad.comparator.NumericStringValueComparator;
import org.kuali.kfs.krad.comparator.StringValueComparator;
import org.kuali.kfs.krad.comparator.TemporalValueComparator;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.module.ld.businessobject.LaborOriginEntry;
import org.kuali.kfs.module.ld.document.LedgerCorrectionDocument;
import org.kuali.kfs.module.ld.document.service.LaborCorrectionDocumentService;
import org.kuali.kfs.module.ld.service.LaborOriginEntryService;
import org.kuali.kfs.module.ld.util.LaborOriginEntryFileIterator;
import org.kuali.kfs.sys.FileUtil;
import org.kuali.kfs.sys.service.DocumentNumberAwareReportWriterService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class LaborCorrectionDocumentServiceImpl
extends CorrectionDocumentServiceImpl
implements LaborCorrectionDocumentService {
    private static Logger LOG = LogManager.getLogger(LaborCorrectionDocumentServiceImpl.class);
    protected OriginEntryGroupService originEntryGroupService;
    private LaborOriginEntryService laborOriginEntryService;
    private String llcpDirectoryName;
    private String batchFileDirectoryName;
    private DocumentDao documentDao;
    private DocumentNumberAwareReportWriterService laborCorrectionDocumentReportWriterService;
    private List<Column> cachedColumns = null;
    protected static final String INPUT_ORIGIN_ENTRIES_FILE_SUFFIX = "-input.txt";
    protected static final String OUTPUT_ORIGIN_ENTRIES_FILE_SUFFIX = "-output.txt";
    protected static final String LLCP_OUTPUT_PREFIX = "llcp_output";
    public static final int UNLIMITED_ABORT_THRESHOLD = -1;

    @Override
    public CorrectionChangeGroup findByDocumentNumberAndCorrectionChangeGroupNumber(String docId, int i) {
        return this.correctionChangeGroupDao.findByDocumentNumberAndCorrectionChangeGroupNumber(docId, Integer.valueOf(i));
    }

    @Override
    public List findByDocumentHeaderIdAndCorrectionGroupNumber(String docId, int i) {
        return this.correctionChangeDao.findByDocumentHeaderIdAndCorrectionGroupNumber(docId, Integer.valueOf(i));
    }

    @Override
    public List findByDocumentNumberAndCorrectionGroupNumber(String docId, int i) {
        return this.correctionCriteriaDao.findByDocumentNumberAndCorrectionGroupNumber(docId, Integer.valueOf(i));
    }

    @Override
    public LedgerCorrectionDocument findByCorrectionDocumentHeaderId(String docId) {
        return (LedgerCorrectionDocument)this.documentDao.findByDocumentHeaderId(LedgerCorrectionDocument.class, docId);
    }

    public void setCorrectionChangeDao(CorrectionChangeDao correctionChangeDao) {
        this.correctionChangeDao = correctionChangeDao;
    }

    public void setCorrectionChangeGroupDao(CorrectionChangeGroupDao correctionChangeGroupDao) {
        this.correctionChangeGroupDao = correctionChangeGroupDao;
    }

    public void setCorrectionCriteriaDao(CorrectionCriteriaDao correctionCriteriaDao) {
        this.correctionCriteriaDao = correctionCriteriaDao;
    }

    public void setDocumentDao(DocumentDao documentDao) {
        this.documentDao = documentDao;
    }

    protected String generateInputOriginEntryFileName(LedgerCorrectionDocument document) {
        String docId = document.getDocumentHeader().getDocumentNumber();
        return this.generateInputOriginEntryFileName(docId);
    }

    protected String generateOutputOriginEntryFileName(LedgerCorrectionDocument document) {
        String docId = document.getDocumentHeader().getDocumentNumber();
        return this.generateOutputOriginEntryFileName(docId);
    }

    protected String generateInputOriginEntryFileName(String docId) {
        return this.getOriginEntryStagingDirectoryPath() + File.separator + docId + INPUT_ORIGIN_ENTRIES_FILE_SUFFIX;
    }

    @Override
    public String generateOutputOriginEntryFileName(String docId) {
        return this.getOriginEntryStagingDirectoryPath() + File.separator + docId + OUTPUT_ORIGIN_ENTRIES_FILE_SUFFIX;
    }

    @Override
    public void persistInputOriginEntriesForInitiatedOrSavedDocument(LedgerCorrectionDocument document, Iterator<LaborOriginEntry> entries) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (!workflowDocument.isInitiated() && !workflowDocument.isSaved()) {
            LOG.error("This method may only be called when the document is in the initiated or saved state.");
        }
        String fullPathUniqueFileName = this.generateInputOriginEntryFileName(document);
        if (LOG.isInfoEnabled()) {
            LOG.info("About to save input labor origin entries for document " + document.getDocumentNumber() + " to file: " + fullPathUniqueFileName);
        }
        this.persistLaborOriginEntries(fullPathUniqueFileName, entries);
    }

    @Override
    public void persistOutputLaborOriginEntriesForInitiatedOrSavedDocument(LedgerCorrectionDocument document, Iterator<LaborOriginEntry> entries) {
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (!workflowDocument.isInitiated() && !workflowDocument.isSaved()) {
            LOG.error("This method may only be called when the document is in the initiated or saved state.");
        }
        String fullPathUniqueFileName = this.generateOutputOriginEntryFileName(document);
        if (LOG.isInfoEnabled()) {
            LOG.info("About to save output labor origin entries for document " + document.getDocumentNumber() + " to file: " + fullPathUniqueFileName);
        }
        this.persistLaborOriginEntries(fullPathUniqueFileName, entries);
    }

    protected void persistLaborOriginEntries(String fullPathUniqueFileName, Iterator<LaborOriginEntry> entries) {
        File fileOut = new File(fullPathUniqueFileName);
        FileOutputStream streamOut = null;
        FilterOutputStream bufferedStreamOut = null;
        try {
            streamOut = new FileOutputStream(fileOut);
            bufferedStreamOut = new BufferedOutputStream(streamOut);
            byte[] newLine = "\n".getBytes();
            while (entries.hasNext()) {
                LaborOriginEntry entry = entries.next();
                bufferedStreamOut.write(entry.getLine().getBytes());
                bufferedStreamOut.write(newLine);
            }
        }
        catch (IOException e) {
            LOG.error("unable to persist labor origin entries to file: " + fullPathUniqueFileName, (Throwable)e);
            throw new RuntimeException("unable to persist origin entries to file.", e);
        }
        finally {
            try {
                bufferedStreamOut.close();
                streamOut.close();
            }
            catch (IOException e) {
                LOG.error("unable to close output streams for file: " + fullPathUniqueFileName, (Throwable)e);
                throw new RuntimeException("unable to close output streams", e);
            }
        }
    }

    protected BufferedOutputStream openEntryOutputStreamForOutputGroup(LedgerCorrectionDocument document) throws IOException {
        String fullPathUniqueFileName = this.generateOutputOriginEntryFileName(document);
        return new BufferedOutputStream(new FileOutputStream(fullPathUniqueFileName));
    }

    @Override
    public void removePersistedInputOriginEntries(LedgerCorrectionDocument document) {
        String fullPathUniqueFileName = this.generateInputOriginEntryFileName(document);
        this.removePersistedOriginEntries(fullPathUniqueFileName);
    }

    @Override
    public void removePersistedOutputOriginEntries(LedgerCorrectionDocument document) {
        String fullPathUniqueFileName = this.generateOutputOriginEntryFileName(document);
        this.removePersistedOriginEntries(fullPathUniqueFileName);
    }

    @Override
    public void removePersistedInputOriginEntries(String docId) {
        this.removePersistedOriginEntries(this.generateInputOriginEntryFileName(docId));
    }

    @Override
    public void removePersistedOutputOriginEntries(String docId) {
        this.removePersistedOriginEntries(this.generateOutputOriginEntryFileName(docId));
    }

    protected void removePersistedOriginEntries(String fullPathUniqueFileName) {
        File fileOut = new File(fullPathUniqueFileName);
        if (fileOut.exists() && fileOut.isFile()) {
            fileOut.delete();
        }
    }

    @Override
    public List<LaborOriginEntry> retrievePersistedInputOriginEntries(LedgerCorrectionDocument document, int abortThreshold) {
        return this.retrievePersistedLaborOriginEntries(this.generateInputOriginEntryFileName(document), abortThreshold);
    }

    @Override
    public List<LaborOriginEntry> retrievePersistedOutputOriginEntries(LedgerCorrectionDocument document, int abortThreshold) {
        return this.retrievePersistedLaborOriginEntries(this.generateOutputOriginEntryFileName(document), abortThreshold);
    }

    protected List<LaborOriginEntry> retrievePersistedLaborOriginEntries(String fullPathUniqueFileName, int abortThreshold) {
        File fileIn;
        if (LOG.isInfoEnabled()) {
            LOG.info("Retrieving Entries from file " + fullPathUniqueFileName);
        }
        if (!(fileIn = new File(fullPathUniqueFileName)).exists()) {
            LOG.error("File " + fullPathUniqueFileName + " does not exist.");
            throw new RuntimeException("File does not exist");
        }
        BufferedReader reader = null;
        FileReader fReader = null;
        ArrayList<LaborOriginEntry> entries = new ArrayList<LaborOriginEntry>();
        int lineNumber = 0;
        try {
            String line;
            fReader = new FileReader(fileIn);
            reader = new BufferedReader(fReader);
            while ((line = reader.readLine()) != null) {
                LaborOriginEntry entry = new LaborOriginEntry();
                entry.setFromTextFileForBatch(line, lineNumber);
                if (abortThreshold != -1 && lineNumber >= abortThreshold) {
                    List<LaborOriginEntry> list = null;
                    return list;
                }
                ++lineNumber;
                entries.add(entry);
            }
        }
        catch (IOException e) {
            LOG.error("retrievePersistedOriginEntries() Error reading file " + fileIn.getAbsolutePath(), (Throwable)e);
            throw new RuntimeException("Error reading file");
        }
        finally {
            try {
                if (fReader != null) {
                    fReader.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                LOG.error("Unable to close file " + fileIn.getAbsolutePath(), (Throwable)e);
                throw new RuntimeException("Error closing file");
            }
        }
        return entries;
    }

    @Override
    public Iterator<LaborOriginEntry> retrievePersistedInputOriginEntriesAsIterator(LedgerCorrectionDocument document) {
        String fullPathUniqueFileName = this.generateInputOriginEntryFileName(document);
        return this.retrievePersistedLaborOriginEntriesAsIterator(fullPathUniqueFileName);
    }

    @Override
    public Iterator<LaborOriginEntry> retrievePersistedOutputOriginEntriesAsIterator(LedgerCorrectionDocument document) {
        String fullPathUniqueFileName = this.generateOutputOriginEntryFileName(document);
        return this.retrievePersistedLaborOriginEntriesAsIterator(fullPathUniqueFileName);
    }

    protected Iterator<LaborOriginEntry> retrievePersistedLaborOriginEntriesAsIterator(String fullPathUniqueFileName) {
        File fileIn;
        if (LOG.isInfoEnabled()) {
            LOG.info("Retrieving Entries from file " + fullPathUniqueFileName);
        }
        if (!(fileIn = new File(fullPathUniqueFileName)).exists()) {
            LOG.error("File " + fullPathUniqueFileName + " does not exist.");
            throw new RuntimeException("File does not exist");
        }
        BufferedReader reader = null;
        FileReader fReader = null;
        try {
            fReader = new FileReader(fileIn);
            reader = new BufferedReader(fReader);
            return new LaborOriginEntryFileIterator(reader);
        }
        catch (IOException e) {
            LOG.error("retrievePersistedOriginEntries() Error opening file " + fileIn.getAbsolutePath(), (Throwable)e);
            throw new RuntimeException("Error opening file");
        }
    }

    @Override
    public boolean areInputOriginEntriesPersisted(LedgerCorrectionDocument document) {
        String fullPathUniqueFileName = this.generateInputOriginEntryFileName(document);
        File file = new File(fullPathUniqueFileName);
        return file.exists();
    }

    @Override
    public boolean areOutputOriginEntriesPersisted(LedgerCorrectionDocument document) {
        String fullPathUniqueFileName = this.generateOutputOriginEntryFileName(document);
        File file = new File(fullPathUniqueFileName);
        return file.exists();
    }

    @Override
    public void writePersistedInputOriginEntriesToStream(LedgerCorrectionDocument document, OutputStream out) throws IOException {
        String fullPathUniqueFileName = this.generateInputOriginEntryFileName(document);
        this.writePersistedOriginEntriesToStream(fullPathUniqueFileName, out);
    }

    @Override
    public void writePersistedOutputOriginEntriesToStream(LedgerCorrectionDocument document, OutputStream out) throws IOException {
        String fullPathUniqueFileName = this.generateOutputOriginEntryFileName(document);
        this.writePersistedOriginEntriesToStream(fullPathUniqueFileName, out);
    }

    protected void writePersistedOriginEntriesToStream(String fullPathUniqueFileName, OutputStream out) throws IOException {
        try (FileInputStream fileIn = new FileInputStream(fullPathUniqueFileName);){
            int bytesRead;
            byte[] buf = new byte[1000];
            while ((bytesRead = fileIn.read(buf)) != -1) {
                out.write(buf, 0, bytesRead);
            }
        }
    }

    @Override
    public void persistOriginEntryGroupsForDocumentSave(LedgerCorrectionDocument document, CorrectionDocumentEntryMetadata correctionDocumentEntryMetadata) {
        OriginEntryStatistics statistics;
        Iterator<LaborOriginEntry> inputGroupEntries;
        if (correctionDocumentEntryMetadata.getAllEntries() == null && !correctionDocumentEntryMetadata.isRestrictedFunctionalityMode()) {
            this.removePersistedInputOriginEntries(document);
            this.removePersistedOutputOriginEntries(document);
            return;
        }
        if (!correctionDocumentEntryMetadata.getDataLoadedFlag() && !correctionDocumentEntryMetadata.isRestrictedFunctionalityMode()) {
            this.removePersistedInputOriginEntries(document);
            this.removePersistedOutputOriginEntries(document);
            return;
        }
        WorkflowDocument workflowDocument = document.getDocumentHeader().getWorkflowDocument();
        if (workflowDocument.isSaved() && (correctionDocumentEntryMetadata.getInputGroupIdFromLastDocumentLoad() == null || !correctionDocumentEntryMetadata.getInputGroupIdFromLastDocumentLoad().equals(document.getCorrectionInputFileName())) || workflowDocument.isInitiated()) {
            File file = new File(document.getCorrectionInputFileName());
            inputGroupEntries = new LaborOriginEntryFileIterator(file);
            this.persistInputOriginEntriesForInitiatedOrSavedDocument(document, inputGroupEntries);
            inputGroupEntries = this.retrievePersistedInputOriginEntriesAsIterator(document);
        } else if (workflowDocument.isSaved() && correctionDocumentEntryMetadata.getInputGroupIdFromLastDocumentLoad().equals(document.getCorrectionInputFileName())) {
            inputGroupEntries = this.retrievePersistedInputOriginEntriesAsIterator(document);
        } else {
            StringBuilder stringBuilder = new StringBuilder().append("Unexpected state while trying to persist/retrieve GLCP origin entries during document save: document status is ");
            workflowDocument.getStatus();
            LOG.error(stringBuilder.append(DocumentStatus.values().toString()).append(" selected input group: ").append(document.getCorrectionInputFileName()).append(" last saved input group: ").append(correctionDocumentEntryMetadata.getInputGroupIdFromLastDocumentLoad()).toString());
            throw new RuntimeException("Error persisting GLCP document origin entries.");
        }
        if ("M".equals(correctionDocumentEntryMetadata.getEditMethod())) {
            ArrayList allEntries = new ArrayList();
            allEntries.addAll(correctionDocumentEntryMetadata.getAllEntries());
            this.persistOutputLaborOriginEntriesForInitiatedOrSavedDocument(document, allEntries.iterator());
            statistics = CorrectionDocumentUtils.getStatistics((Collection)correctionDocumentEntryMetadata.getAllEntries());
        } else {
            if ("C".equals(correctionDocumentEntryMetadata.getEditMethod())) {
                BufferedOutputStream bufferedOutputStream = null;
                try {
                    bufferedOutputStream = this.openEntryOutputStreamForOutputGroup(document);
                    statistics = new OriginEntryStatistics();
                    byte[] newLine = "\n".getBytes();
                    while (inputGroupEntries.hasNext()) {
                        LaborOriginEntry entry = inputGroupEntries.next();
                        if ((entry = (LaborOriginEntry)CorrectionDocumentUtils.applyCriteriaToEntry((OriginEntryFull)entry, (boolean)correctionDocumentEntryMetadata.getMatchCriteriaOnly(), (List)document.getCorrectionChangeGroup())) == null) continue;
                        CorrectionDocumentUtils.updateStatisticsWithEntry((OriginEntryFull)entry, (OriginEntryStatistics)statistics);
                        bufferedOutputStream.write(entry.getLine().getBytes());
                        bufferedOutputStream.write(newLine);
                    }
                }
                catch (IOException e) {
                    LOG.error("Unable to persist persisted output entry", (Throwable)e);
                    throw new RuntimeException("Unable to persist output entry", e);
                }
                finally {
                    if (bufferedOutputStream != null) {
                        try {
                            bufferedOutputStream.close();
                        }
                        catch (IOException e) {
                            LOG.error("Unable to close output stream for persisted output entries", (Throwable)e);
                            throw new RuntimeException("Unable to close output entry file", e);
                        }
                    }
                }
            }
            if ("R".equals(correctionDocumentEntryMetadata.getEditMethod())) {
                this.removePersistedOutputOriginEntries(document);
                statistics = new OriginEntryStatistics();
            } else {
                throw new RuntimeException("Unrecognized edit method: " + correctionDocumentEntryMetadata.getEditMethod());
            }
        }
        CorrectionDocumentUtils.copyStatisticsToDocument((OriginEntryStatistics)statistics, (GeneralLedgerCorrectionProcessDocument)document);
    }

    @Override
    public String createOutputFileForProcessing(String docId, Date today) {
        File outputFile = new File(this.llcpDirectoryName + File.separator + docId + OUTPUT_ORIGIN_ENTRIES_FILE_SUFFIX);
        String newFileName = this.batchFileDirectoryName + File.separator + LLCP_OUTPUT_PREFIX + "." + docId + this.buildFileExtensionWithDate(today);
        File newFile = new File(newFileName);
        try {
            int c;
            FileReader inputFileReader = new FileReader(outputFile);
            FileWriter newFileWriter = new FileWriter(newFile);
            while ((c = inputFileReader.read()) != -1) {
                newFileWriter.write(c);
            }
            inputFileReader.close();
            newFileWriter.close();
            String doneFileName = newFileName.replace(".data", ".done");
            File doneFile = new File(doneFileName);
            if (!doneFile.exists()) {
                doneFile.createNewFile();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return newFileName;
    }

    protected String getOriginEntryStagingDirectoryPath() {
        return this.getLlcpDirectoryName();
    }

    public ConfigurationService getConfigurationService() {
        return this.kualiConfigurationService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setLaborOriginEntryService(LaborOriginEntryService laborOriginEntryService) {
        this.laborOriginEntryService = laborOriginEntryService;
    }

    @Override
    public String getLlcpDirectoryName() {
        return this.llcpDirectoryName;
    }

    public void setLlcpDirectoryName(String llcpDirectoryName) {
        this.llcpDirectoryName = llcpDirectoryName;
        FileUtil.createDirectory((String)llcpDirectoryName);
    }

    public OriginEntryGroupService getOriginEntryGroupService() {
        return this.originEntryGroupService;
    }

    public void setOriginEntryGroupService(OriginEntryGroupService originEntryGroupService) {
        this.originEntryGroupService = originEntryGroupService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Column> getTableRenderColumnMetadata(String docId) {
        LaborCorrectionDocumentServiceImpl laborCorrectionDocumentServiceImpl = this;
        synchronized (laborCorrectionDocumentServiceImpl) {
            if (this.cachedColumns == null) {
                this.cachedColumns = new ArrayList<Column>();
                Column columnToAdd = new Column();
                columnToAdd.setColumnTitle("Fiscal Year");
                columnToAdd.setPropertyName("universityFiscalYear");
                columnToAdd.setValueComparator((Comparator)NumericStringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Chart Code");
                columnToAdd.setPropertyName("chartOfAccountsCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Account Number");
                columnToAdd.setPropertyName("accountNumber");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Sub Account Number");
                columnToAdd.setPropertyName("subAccountNumber");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Object Code");
                columnToAdd.setPropertyName("financialObjectCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Sub Object Code");
                columnToAdd.setPropertyName("financialSubObjectCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Balance Type");
                columnToAdd.setPropertyName("financialBalanceTypeCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Object Type");
                columnToAdd.setPropertyName("financialObjectTypeCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Fiscal Period");
                columnToAdd.setPropertyName("universityFiscalPeriodCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Document Type");
                columnToAdd.setPropertyName("financialDocumentTypeCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Origin Code");
                columnToAdd.setPropertyName("financialSystemOriginationCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Document Number");
                columnToAdd.setPropertyName("documentNumber");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Sequence Number");
                columnToAdd.setValueComparator((Comparator)NumericStringValueComparator.getInstance());
                columnToAdd.setPropertyName("transactionLedgerEntrySequenceNumber");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Position Number");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("positionNumber");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Project Code");
                columnToAdd.setPropertyName("projectCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Description");
                columnToAdd.setPropertyName("transactionLedgerEntryDescription");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Amount");
                columnToAdd.setValueComparator((Comparator)NumericStringValueComparator.getInstance());
                columnToAdd.setPropertyName("transactionLedgerEntryAmount");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Debit Credit Indicator");
                columnToAdd.setPropertyName("transactionDebitCreditCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Transaction Date");
                columnToAdd.setPropertyName("transactionDate");
                columnToAdd.setValueComparator((Comparator)TemporalValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Org Doc Number");
                columnToAdd.setPropertyName("organizationDocumentNumber");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Org Ref ID");
                columnToAdd.setPropertyName("organizationReferenceId");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Ref Doc Type");
                columnToAdd.setPropertyName("referenceFinancialDocumentTypeCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Ref Origin Code");
                columnToAdd.setPropertyName("referenceFinancialSystemOriginationCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Ref Doc Number");
                columnToAdd.setPropertyName("referenceFinancialDocumentNumber");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Reversal Date");
                columnToAdd.setPropertyName("financialDocumentReversalDate");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Enc Update Code");
                columnToAdd.setPropertyName("transactionEncumbranceUpdateCode");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Transaction Posting Date");
                columnToAdd.setValueComparator((Comparator)TemporalValueComparator.getInstance());
                columnToAdd.setPropertyName("transactionPostingDate");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Pay Period End Date");
                columnToAdd.setValueComparator((Comparator)TemporalValueComparator.getInstance());
                columnToAdd.setPropertyName("payPeriodEndDate");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Trn Total Hours");
                columnToAdd.setValueComparator((Comparator)NumericStringValueComparator.getInstance());
                columnToAdd.setPropertyName("transactionTotalHours");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Payroll EndDate Fiscal Year");
                columnToAdd.setValueComparator((Comparator)NumericStringValueComparator.getInstance());
                columnToAdd.setPropertyName("payrollEndDateFiscalYear");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Payroll EndDate Fiscal Period Code");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("payrollEndDateFiscalPeriodCode");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Empl Id");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("emplid");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Empl Record");
                columnToAdd.setValueComparator((Comparator)NumericStringValueComparator.getInstance());
                columnToAdd.setPropertyName("employeeRecord");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Earn Code");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("earnCode");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Pay Group");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("payGroup");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Salary Admin Plan");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("salaryAdministrationPlan");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Grade");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("grade");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Run Id");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("runIdentifier");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Original Chart Code");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("laborLedgerOriginalChartOfAccountsCode");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Original Account Number");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("laborLedgerOriginalAccountNumber");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Original Sub-Account Number");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("laborLedgerOriginalSubAccountNumber");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Original Object Code");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("laborLedgerOriginalFinancialObjectCode");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Original Sub-Object Code");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("laborLedgerOriginalFinancialSubObjectCode");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("Company");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("hrmsCompany");
                this.cachedColumns.add(columnToAdd);
                columnToAdd = new Column();
                columnToAdd.setColumnTitle("SetId");
                columnToAdd.setValueComparator((Comparator)StringValueComparator.getInstance());
                columnToAdd.setPropertyName("setid");
                this.cachedColumns.add(columnToAdd);
                this.cachedColumns = Collections.unmodifiableList(this.cachedColumns);
            }
        }
        return this.cachedColumns;
    }

    @Override
    public void generateCorrectionReport(LedgerCorrectionDocument document) {
        CorrectionDocumentReport correctionReport = new CorrectionDocumentReport();
        correctionReport.generateReport(this.laborCorrectionDocumentReportWriterService, (GeneralLedgerCorrectionProcessDocument)document);
    }

    public void setBatchFileDirectoryName(String batchFileDirectoryName) {
        this.batchFileDirectoryName = batchFileDirectoryName;
    }

    @Override
    public String getBatchFileDirectoryName() {
        return this.batchFileDirectoryName;
    }

    protected DocumentNumberAwareReportWriterService getLaborCorrectionDocumentReportWriterService() {
        return this.laborCorrectionDocumentReportWriterService;
    }

    public void setLaborCorrectionDocumentReportWriterService(DocumentNumberAwareReportWriterService laborCorrectionDocumentReportWriterService) {
        this.laborCorrectionDocumentReportWriterService = laborCorrectionDocumentReportWriterService;
    }

    public String[] findExistingCorrectionOutputFilesForDocument(String documentNumber) {
        return new File(this.batchFileDirectoryName).list(new LlcpFilenameFilter(documentNumber));
    }

    protected static class LlcpFilenameFilter
    implements FilenameFilter {
        String documentNumber;

        public LlcpFilenameFilter(String documentNumber) {
            this.documentNumber = documentNumber;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith("llcp_output." + this.documentNumber);
        }
    }
}

