/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.coa.businessobject.A21SubAccount;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ec.EffortCertificationModuleService;
import org.kuali.kfs.integration.ec.EffortCertificationReport;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferSourceAccountingLine;
import org.kuali.kfs.module.ld.document.SalaryExpenseTransferDocument;
import org.kuali.kfs.module.ld.document.service.SalaryTransferPeriodValidationService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SalaryTransferPeriodValidationServiceImpl
implements SalaryTransferPeriodValidationService {
    private EffortCertificationModuleService effortCertificationService;
    private DocumentService documentService;
    private NoteService noteService;
    private ConfigurationService kualiConfigurationService;
    private ParameterService parameterService;

    @Override
    public boolean validateTransfers(SalaryExpenseTransferDocument document) {
        ArrayList<ExpenseTransferAccountingLine> transferLinesInOpenPeriod = new ArrayList<ExpenseTransferAccountingLine>();
        ArrayList allLines = new ArrayList(document.getSourceAccountingLines());
        allLines.addAll(document.getTargetAccountingLines());
        for (ExpenseTransferAccountingLine transferLine : allLines) {
            if (!this.containsNecessaryData(transferLine)) continue;
            EffortCertificationReport closedReport = this.getClosedReportingPeriod(transferLine);
            if (closedReport != null) {
                this.putError("error.labor.effortReportPeriodClosed", transferLine, closedReport);
                return false;
            }
            EffortCertificationReport openReport = this.getOpenReportingPeriod(transferLine);
            if (openReport == null) continue;
            transferLinesInOpenPeriod.add(transferLine);
        }
        HashMap<String, KualiDecimal> accountPeriodTransfer = new HashMap<String, KualiDecimal>();
        for (ExpenseTransferAccountingLine transferLine : transferLinesInOpenPeriod) {
            EffortCertificationReport emplidReport = this.isEmployeeWithOpenCertification(transferLine, document.getEmplid());
            if (emplidReport != null) {
                if (this.isCostShareSubAccount(transferLine)) {
                    this.putError("error.labor.effortOpenPeriodCostShare", transferLine, emplidReport);
                    return false;
                }
                this.addAccountTransferAmount(accountPeriodTransfer, transferLine, emplidReport);
                continue;
            }
            if (!this.isInvalidCgAccount(transferLine)) continue;
            EffortCertificationReport openReport = this.getOpenReportingPeriod(transferLine);
            this.putError("error.labor.effortOpernPeriodCGAccount", transferLine, openReport);
            return false;
        }
        for (String transferKey : accountPeriodTransfer.keySet()) {
            KualiDecimal transfer = (KualiDecimal)accountPeriodTransfer.get(transferKey);
            if (!transfer.isNonZero()) continue;
            String[] keyFields = StringUtils.split((String)transferKey, (String)",");
            GlobalVariables.getMessageMap().putError("sourceAccountingLines", "error.labor.effortOpenPeriodAccountNonBalanced", new String[]{keyFields[4], keyFields[0], keyFields[1]});
            return false;
        }
        return true;
    }

    protected EffortCertificationReport getClosedReportingPeriod(ExpenseTransferAccountingLine transferLine) {
        List<EffortCertificationReport> effortReports = this.getEffortReportDefinitionsForLine(transferLine);
        for (EffortCertificationReport report : effortReports) {
            if (!"C".equals(report.getEffortCertificationReportPeriodStatusCode())) continue;
            return report;
        }
        return null;
    }

    protected EffortCertificationReport getOpenReportingPeriod(ExpenseTransferAccountingLine transferLine) {
        List<EffortCertificationReport> effortReports = this.getEffortReportDefinitionsForLine(transferLine);
        for (EffortCertificationReport report : effortReports) {
            if (!"O".equals(report.getEffortCertificationReportPeriodStatusCode())) continue;
            return report;
        }
        return null;
    }

    protected List<EffortCertificationReport> getOpenReportDefinitions(List<EffortCertificationReport> effortReports) {
        ArrayList<EffortCertificationReport> openReports = new ArrayList<EffortCertificationReport>();
        for (EffortCertificationReport report : effortReports) {
            if (!"O".equals(report.getEffortCertificationReportPeriodStatusCode())) continue;
            openReports.add(report);
        }
        return openReports;
    }

    protected boolean isCostShareSubAccount(ExpenseTransferAccountingLine transferLine) {
        boolean isCostShare = false;
        if (ObjectUtils.isNotNull((Object)transferLine.getSubAccount()) && ObjectUtils.isNotNull((Object)transferLine.getSubAccount().getA21SubAccount())) {
            A21SubAccount a21SubAccount = transferLine.getSubAccount().getA21SubAccount();
            String subAccountTypeCode = a21SubAccount.getSubAccountTypeCode();
            List costShareSubAccountTypeCodes = this.effortCertificationService.getCostShareSubAccountTypeCodes();
            if (costShareSubAccountTypeCodes.contains(subAccountTypeCode)) {
                isCostShare = true;
            }
        }
        return isCostShare;
    }

    protected EffortCertificationReport isEmployeeWithOpenCertification(ExpenseTransferAccountingLine transferLine, String emplid) {
        List<EffortCertificationReport> effortReports = this.getEffortReportDefinitionsForLine(transferLine);
        List<EffortCertificationReport> openEffortReports = this.getOpenReportDefinitions(effortReports);
        return this.effortCertificationService.isEmployeeWithOpenCertification(openEffortReports, emplid);
    }

    protected void addAccountTransferAmount(Map<String, KualiDecimal> accountPeriodTransfer, ExpenseTransferAccountingLine transferLine, EffortCertificationReport effortReport) {
        String transferKey = StringUtils.join((Object[])new Object[]{transferLine.getPayrollEndDateFiscalYear(), transferLine.getPayrollEndDateFiscalPeriodCode(), transferLine.getChartOfAccountsCode(), transferLine.getAccountNumber(), effortReport.getUniversityFiscalYear() + "-" + effortReport.getEffortCertificationReportNumber()}, (String)",");
        KualiDecimal transferAmount = (KualiDecimal)transferLine.getAmount().abs();
        if (transferLine instanceof ExpenseTransferSourceAccountingLine) {
            transferAmount = (KualiDecimal)transferAmount.negated();
        }
        if (accountPeriodTransfer.containsKey(transferKey)) {
            transferAmount = (KualiDecimal)transferAmount.add((AbstractKualiDecimal)accountPeriodTransfer.get(transferKey));
        }
        accountPeriodTransfer.put(transferKey, transferAmount);
    }

    private boolean isInvalidCgAccount(ExpenseTransferAccountingLine transferLine) {
        if (this.effortCertificationService.isFederalOnlyBalanceIndicator()) {
            return transferLine.getAccount().isAwardedByFederalAgency(this.parameterService.getParameterValuesAsString(KfsParameterConstants.FINANCIAL_SYSTEM_ALL.class, "FEDERAL_AGENCY_TYPE"));
        }
        return transferLine.getAccount().isForContractsAndGrants();
    }

    protected List<EffortCertificationReport> getEffortReportDefinitionsForLine(ExpenseTransferAccountingLine transferLine) {
        Integer payFiscalYear = transferLine.getPayrollEndDateFiscalYear();
        String payFiscalPeriodCode = transferLine.getPayrollEndDateFiscalPeriodCode();
        String positionObjectGroupCode = transferLine.getLaborObject().getPositionObjectGroupCode();
        return this.effortCertificationService.findReportDefinitionsForPeriod(payFiscalYear, payFiscalPeriodCode, positionObjectGroupCode);
    }

    protected boolean containsNecessaryData(ExpenseTransferAccountingLine transferLine) {
        transferLine.refreshNonUpdateableReferences();
        if (ObjectUtils.isNull((Object)transferLine.getAccount()) || ObjectUtils.isNull((Object)((Object)transferLine.getLaborObject())) || ObjectUtils.isNull((Object)transferLine.getAmount())) {
            return false;
        }
        return transferLine.getPayrollEndDateFiscalYear() != null && transferLine.getPayrollEndDateFiscalPeriodCode() != null;
    }

    protected void putError(String errorKey, ExpenseTransferAccountingLine transferLine, EffortCertificationReport report) {
        String errorLines = "targetAccountingLines";
        if (transferLine instanceof ExpenseTransferSourceAccountingLine) {
            errorLines = "sourceAccountingLines";
        }
        String[] errorParameters = new String[]{report.getUniversityFiscalYear() + "-" + report.getEffortCertificationReportNumber(), transferLine.getPayrollEndDateFiscalYear().toString(), transferLine.getPayrollEndDateFiscalPeriodCode()};
        GlobalVariables.getMessageMap().putError(errorLines, errorKey, errorParameters);
    }

    @Override
    public void disapproveSalaryExpenseDocument(SalaryExpenseTransferDocument document) throws Exception {
        String message = this.kualiConfigurationService.getPropertyValueAsString("message.labor.effortAutoDisapprove");
        Note cancelNote = this.documentService.createNoteFromDocument((Document)document, message);
        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName("kfs");
        cancelNote.setAuthorUniversalIdentifier(principal.getPrincipalId());
        this.noteService.save(cancelNote);
        document.addNote(cancelNote);
        this.documentService.disapproveDocument((Document)document, "disapproved - failed effort certification checks");
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setEffortCertificationService(EffortCertificationModuleService effortCertificationService) {
        this.effortCertificationService = effortCertificationService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }
}

