/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ld.document.validation.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ld.businessobject.ExpenseTransferAccountingLine;
import org.kuali.kfs.module.ld.document.LaborExpenseTransferDocumentBase;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class LaborExpenseTransferAccountingLineTotalsMatchByPayFYAndPayPeriodValidation
extends GenericValidation {
    private Document documentForValidation;

    public boolean validate(AttributedDocumentEvent event) {
        List targetLines;
        Document documentForValidation = this.getDocumentForValidation();
        LaborExpenseTransferDocumentBase expenseTransferDocument = (LaborExpenseTransferDocumentBase)documentForValidation;
        List sourceLines = expenseTransferDocument.getSourceAccountingLines();
        if (!this.isAccountingLineTotalsMatchByPayFYAndPayPeriod(sourceLines, targetLines = expenseTransferDocument.getTargetAccountingLines())) {
            GlobalVariables.getMessageMap().putError("sourceAccountingLines", "error.labor.accountingLineTotalsByPayFYPayPeriodMismatch", new String[0]);
            return false;
        }
        return true;
    }

    public boolean isAccountingLineTotalsMatchByPayFYAndPayPeriod(List sourceLines, List targetLines) {
        Map sourceLinesMap = this.sumAccountingLineAmountsByPayFYAndPayPeriod(sourceLines);
        Map targetLinesMap = this.sumAccountingLineAmountsByPayFYAndPayPeriod(targetLines);
        return this.compareAccountingLineTotalsByPayFYAndPayPeriod(sourceLinesMap, targetLinesMap);
    }

    protected Map sumAccountingLineAmountsByPayFYAndPayPeriod(List accountingLines) {
        ExpenseTransferAccountingLine line2 = null;
        KualiDecimal linesAmount = KualiDecimal.ZERO;
        HashMap<String, KualiDecimal> linesMap = new HashMap<String, KualiDecimal>();
        String payFYPeriodKey = null;
        for (ExpenseTransferAccountingLine line2 : accountingLines) {
            linesAmount = KualiDecimal.ZERO;
            payFYPeriodKey = this.createPayFYPeriodKey(line2.getPayrollEndDateFiscalYear(), line2.getPayrollEndDateFiscalPeriodCode());
            if (linesMap.containsKey(payFYPeriodKey)) {
                linesAmount = (KualiDecimal)linesMap.get(payFYPeriodKey);
            }
            linesAmount = (KualiDecimal)linesAmount.add((AbstractKualiDecimal)line2.getAmount());
            linesMap.put(payFYPeriodKey, linesAmount);
        }
        return linesMap;
    }

    protected String createPayFYPeriodKey(Integer payFiscalYear, String payPeriodCode) {
        StringBuffer payFYPeriodKey = new StringBuffer();
        payFYPeriodKey.append(payFiscalYear);
        payFYPeriodKey.append(payPeriodCode);
        return payFYPeriodKey.toString();
    }

    protected boolean compareAccountingLineTotalsByPayFYAndPayPeriod(Map sourceLinesMap, Map targetLinesMap) {
        boolean isValid = true;
        Map.Entry entry = null;
        String currentKey = null;
        KualiDecimal sourceLinesAmount = KualiDecimal.ZERO;
        KualiDecimal targetLinesAmount = KualiDecimal.ZERO;
        Iterator i = sourceLinesMap.entrySet().iterator();
        while (i.hasNext() && isValid) {
            entry = i.next();
            currentKey = (String)entry.getKey();
            sourceLinesAmount = (KualiDecimal)entry.getValue();
            if (targetLinesMap.containsKey(currentKey)) {
                targetLinesAmount = (KualiDecimal)targetLinesMap.get(currentKey);
                if (sourceLinesAmount.compareTo((AbstractKualiDecimal)targetLinesAmount) == 0) continue;
                isValid = false;
                continue;
            }
            isValid = false;
        }
        i = targetLinesMap.entrySet().iterator();
        while (i.hasNext() && isValid) {
            entry = i.next();
            currentKey = (String)entry.getKey();
            targetLinesAmount = (KualiDecimal)entry.getValue();
            if (sourceLinesMap.containsKey(currentKey)) {
                sourceLinesAmount = (KualiDecimal)sourceLinesMap.get(currentKey);
                if (targetLinesAmount.compareTo((AbstractKualiDecimal)sourceLinesAmount) == 0) continue;
                isValid = false;
                continue;
            }
            isValid = false;
        }
        return isValid;
    }

    public Document getDocumentForValidation() {
        return this.documentForValidation;
    }

    public void setDocumentForValidation(Document documentForValidation) {
        this.documentForValidation = documentForValidation;
    }
}

